/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.GrokBuiltinPatterns;
import org.elasticsearch.grok.MatcherWatchdog;
import org.elasticsearch.grok.PatternBank;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public final class GrokProcessor
extends AbstractProcessor {
    public static final String TYPE = "grok";
    public static final String DEFAULT_ECS_COMPATIBILITY_MODE = "disabled";
    private static final String PATTERN_MATCH_KEY = "_ingest._grok_match_index";
    private static final Logger logger = LogManager.getLogger(GrokProcessor.class);
    private final String matchField;
    private final List<String> matchPatterns;
    private final Grok grok;
    private final boolean traceMatch;
    private final boolean ignoreMissing;

    GrokProcessor(String tag, String description, PatternBank patternBank, List<String> matchPatterns, String matchField, boolean traceMatch, boolean ignoreMissing, MatcherWatchdog matcherWatchdog) {
        super(tag, description);
        this.matchField = matchField;
        this.matchPatterns = matchPatterns;
        this.grok = new Grok(patternBank, GrokProcessor.combinePatterns(matchPatterns, traceMatch), matcherWatchdog, arg_0 -> ((Logger)logger).debug(arg_0));
        this.traceMatch = traceMatch;
        this.ignoreMissing = ignoreMissing;
        new Grok(patternBank, GrokProcessor.combinePatterns(matchPatterns, traceMatch), matcherWatchdog, arg_0 -> ((Logger)logger).warn(arg_0)).match("___nomatch___");
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        String fieldValue = ingestDocument.getFieldValue(this.matchField, String.class, this.ignoreMissing);
        if (fieldValue == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (fieldValue == null) {
            throw new IllegalArgumentException("field [" + this.matchField + "] is null, cannot process it.");
        }
        Map<String, Object> matches = this.grok.captures(fieldValue);
        if (matches == null) {
            throw new IllegalArgumentException("Provided Grok expressions do not match field value: [" + fieldValue + "]");
        }
        matches.forEach(ingestDocument::setFieldValue);
        if (this.traceMatch) {
            if (this.matchPatterns.size() > 1) {
                HashMap matchMap = (HashMap)ingestDocument.getFieldValue(PATTERN_MATCH_KEY, Object.class);
                matchMap.keySet().stream().findFirst().ifPresent(index -> ingestDocument.setFieldValue(PATTERN_MATCH_KEY, index));
            } else {
                ingestDocument.setFieldValue(PATTERN_MATCH_KEY, "0");
            }
        }
        return ingestDocument;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    Grok getGrok() {
        return this.grok;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    String getMatchField() {
        return this.matchField;
    }

    List<String> getMatchPatterns() {
        return this.matchPatterns;
    }

    static String combinePatterns(List<String> patterns, boolean traceMatch) {
        Object combinedPattern;
        if (patterns.size() > 1) {
            combinedPattern = "";
            for (int i = 0; i < patterns.size(); ++i) {
                String pattern = patterns.get(i);
                String valueWrap = traceMatch ? "(?<_ingest._grok_match_index." + i + ">" + pattern + ")" : "(?:" + patterns.get(i) + ")";
                combinedPattern = ((String)combinedPattern).equals("") ? valueWrap : (String)combinedPattern + "|" + valueWrap;
            }
        } else {
            combinedPattern = patterns.get(0);
        }
        return combinedPattern;
    }

    public static final class Factory
    implements Processor.Factory {
        private final MatcherWatchdog matcherWatchdog;

        public Factory(MatcherWatchdog matcherWatchdog) {
            this.matcherWatchdog = matcherWatchdog;
        }

        @Override
        public GrokProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws Exception {
            String matchField = ConfigurationUtils.readStringProperty(GrokProcessor.TYPE, processorTag, config, "field");
            List<String> matchPatterns = ConfigurationUtils.readList(GrokProcessor.TYPE, processorTag, config, "patterns");
            boolean traceMatch = ConfigurationUtils.readBooleanProperty(GrokProcessor.TYPE, processorTag, config, "trace_match", false);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty(GrokProcessor.TYPE, processorTag, config, "ignore_missing", false);
            String ecsCompatibility = ConfigurationUtils.readStringProperty(GrokProcessor.TYPE, processorTag, config, "ecs_compatibility", GrokProcessor.DEFAULT_ECS_COMPATIBILITY_MODE);
            if (!GrokBuiltinPatterns.isValidEcsCompatibilityMode(ecsCompatibility)) {
                throw ConfigurationUtils.newConfigurationException(GrokProcessor.TYPE, processorTag, "ecs_compatibility", "unsupported mode '" + ecsCompatibility + "'");
            }
            if (matchPatterns.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException(GrokProcessor.TYPE, processorTag, "patterns", "List of patterns must not be empty");
            }
            Map<String, String> customPatternBank = ConfigurationUtils.readOptionalMap(GrokProcessor.TYPE, processorTag, config, "pattern_definitions");
            try {
                return new GrokProcessor(processorTag, description, GrokBuiltinPatterns.get(ecsCompatibility).extendWith(customPatternBank), matchPatterns, matchField, traceMatch, ignoreMissing, this.matcherWatchdog);
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException(GrokProcessor.TYPE, processorTag, "patterns", "Invalid regex pattern found in: " + matchPatterns + ". " + e.getMessage());
            }
        }
    }
}

