/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.WeekFields;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum DateFormat {
    Iso8601{

        @Override
        Function<String, ZonedDateTime> getFunction(String format, ZoneId timezone, Locale locale) {
            return date -> {
                TemporalAccessor accessor = ISO_8601.parse((String)date);
                return DateFormatters.from(accessor, Locale.ROOT, timezone).withZoneSameInstant(timezone);
            };
        }
    }
    ,
    Unix{

        @Override
        Function<String, ZonedDateTime> getFunction(String format, ZoneId timezone, Locale locale) {
            return date -> Instant.ofEpochMilli((long)(Double.parseDouble(date) * 1000.0)).atZone(timezone);
        }
    }
    ,
    UnixMs{

        @Override
        Function<String, ZonedDateTime> getFunction(String format, ZoneId timezone, Locale locale) {
            return date -> Instant.ofEpochMilli(Long.parseLong(date)).atZone(timezone);
        }
    }
    ,
    Tai64n{

        @Override
        Function<String, ZonedDateTime> getFunction(String format, ZoneId timezone, Locale locale) {
            return date -> Instant.ofEpochMilli(4.parseMillis(date)).atZone(timezone);
        }

        private static long parseMillis(String date) {
            if (date.startsWith("@")) {
                date = date.substring(1);
            }
            long base = Long.parseLong(date.substring(1, 16), 16);
            long rest = Long.parseLong(date.substring(16, 24), 16);
            return base * 1000L - 10000L + rest / 1000000L;
        }
    }
    ,
    Java{
        private final List<ChronoField> FIELDS = Arrays.asList(ChronoField.NANO_OF_SECOND, ChronoField.SECOND_OF_DAY, ChronoField.MINUTE_OF_DAY, ChronoField.HOUR_OF_DAY, ChronoField.DAY_OF_MONTH, ChronoField.MONTH_OF_YEAR);

        @Override
        Function<String, ZonedDateTime> getFunction(String format, ZoneId zoneId, Locale locale) {
            DateFormatter dateFormatter;
            if (format.startsWith("8")) {
                format = format.substring(1);
            }
            DateFormatter formatter = dateFormatter = DateFormatter.forPattern(format).withLocale(locale);
            return text -> {
                TemporalAccessor accessor = formatter.parse((String)text);
                if (!(accessor.isSupported(ChronoField.YEAR) || accessor.isSupported(ChronoField.YEAR_OF_ERA) || accessor.isSupported(WeekFields.of(locale).weekBasedYear()) || accessor.isSupported(ChronoField.INSTANT_SECONDS))) {
                    int year = LocalDate.now(ZoneOffset.UTC).getYear();
                    ZonedDateTime newTime = Instant.EPOCH.atZone(ZoneOffset.UTC).withYear(year);
                    for (ChronoField field : this.FIELDS) {
                        if (!accessor.isSupported(field)) continue;
                        newTime = newTime.with(field, accessor.get(field));
                    }
                    accessor = newTime.withZoneSameLocal(zoneId);
                }
                return DateFormatters.from(accessor, locale, zoneId).withZoneSameInstant(zoneId);
            };
        }
    };

    private static final DateFormatter ISO_8601;

    abstract Function<String, ZonedDateTime> getFunction(String var1, ZoneId var2, Locale var3);

    static DateFormat fromString(String format) {
        return switch (format) {
            case "ISO8601" -> Iso8601;
            case "UNIX" -> Unix;
            case "UNIX_MS" -> UnixMs;
            case "TAI64N" -> Tai64n;
            default -> Java;
        };
    }

    static {
        ISO_8601 = DateFormatter.forPattern("iso8601");
    }
}

