/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.IngestMetric;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record IngestStats(Stats totalStats, List<PipelineStat> pipelineStats, Map<String, List<ProcessorStat>> processorStats) implements Writeable,
ChunkedToXContent
{
    private static final Comparator<PipelineStat> PIPELINE_STAT_COMPARATOR = (p1, p2) -> {
        Stats p2Stats = p2.stats;
        Stats p1Stats = p1.stats;
        int ingestTimeCompare = Long.compare(p2Stats.ingestTimeInMillis, p1Stats.ingestTimeInMillis);
        if (ingestTimeCompare == 0) {
            return Long.compare(p2Stats.ingestCount, p1Stats.ingestCount);
        }
        return ingestTimeCompare;
    };
    public static final IngestStats IDENTITY = new IngestStats(Stats.IDENTITY, List.of(), Map.of());

    public IngestStats {
        pipelineStats = pipelineStats.stream().sorted(PIPELINE_STAT_COMPARATOR).toList();
    }

    public static IngestStats read(StreamInput in) throws IOException {
        Stats stats = new Stats(in);
        int size = in.readVInt();
        ArrayList<PipelineStat> pipelineStats = new ArrayList<PipelineStat>(size);
        Map<String, List<ProcessorStat>> processorStats = Maps.newMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            String pipelineId = in.readString();
            Stats pipelineStat = new Stats(in);
            pipelineStats.add(new PipelineStat(pipelineId, pipelineStat));
            int processorsSize = in.readVInt();
            ArrayList<ProcessorStat> processorStatsPerPipeline = new ArrayList<ProcessorStat>(processorsSize);
            for (int j = 0; j < processorsSize; ++j) {
                String processorName = in.readString();
                String processorType = in.readString();
                Stats processorStat = new Stats(in);
                processorStatsPerPipeline.add(new ProcessorStat(processorName, processorType, processorStat));
            }
            processorStats.put(pipelineId, Collections.unmodifiableList(processorStatsPerPipeline));
        }
        return new IngestStats(stats, pipelineStats, processorStats);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        out.writeVInt(this.pipelineStats.size());
        for (PipelineStat pipelineStat : this.pipelineStats) {
            out.writeString(pipelineStat.pipelineId());
            pipelineStat.stats().writeTo(out);
            List<ProcessorStat> processorStatsForPipeline = this.processorStats.get(pipelineStat.pipelineId());
            if (processorStatsForPipeline == null) {
                out.writeVInt(0);
                continue;
            }
            out.writeCollection(processorStatsForPipeline, (o, processorStat) -> {
                o.writeString(processorStat.name());
                o.writeString(processorStat.type());
                processorStat.stats().writeTo(o);
            });
        }
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        return Iterators.concat(Iterators.single((builder, params) -> {
            builder.startObject("ingest");
            builder.startObject("total");
            this.totalStats.toXContent(builder, params);
            builder.endObject();
            builder.startObject("pipelines");
            return builder;
        }), Iterators.flatMap(this.pipelineStats.iterator(), pipelineStat -> Iterators.concat(Iterators.single((builder, params) -> {
            builder.startObject(pipelineStat.pipelineId());
            pipelineStat.stats().toXContent(builder, params);
            builder.startArray("processors");
            return builder;
        }), Iterators.map(this.processorStats.getOrDefault(pipelineStat.pipelineId(), List.of()).iterator(), processorStat -> (builder, params) -> {
            builder.startObject();
            builder.startObject(processorStat.name());
            builder.field("type", processorStat.type());
            builder.startObject("stats");
            processorStat.stats().toXContent(builder, params);
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }), Iterators.single((builder, params) -> builder.endArray().endObject()))), Iterators.single((builder, params) -> builder.endObject().endObject()));
    }

    public static IngestStats merge(IngestStats first, IngestStats second) {
        return new IngestStats(Stats.merge(first.totalStats, second.totalStats), PipelineStat.merge(first.pipelineStats, second.pipelineStats), IngestStats.merge(first.processorStats, second.processorStats));
    }

    static Map<String, List<ProcessorStat>> merge(Map<String, List<ProcessorStat>> first, Map<String, List<ProcessorStat>> second) {
        HashMap<String, List<ProcessorStat>> totalsPerPipelineProcessor = new HashMap<String, List<ProcessorStat>>();
        first.forEach((pipelineId, stats) -> totalsPerPipelineProcessor.merge((String)pipelineId, (List<ProcessorStat>)stats, ProcessorStat::merge));
        second.forEach((pipelineId, stats) -> totalsPerPipelineProcessor.merge((String)pipelineId, (List<ProcessorStat>)stats, ProcessorStat::merge));
        return totalsPerPipelineProcessor;
    }

    public record Stats(long ingestCount, long ingestTimeInMillis, long ingestCurrent, long ingestFailedCount) implements Writeable,
    ToXContentFragment
    {
        public static final Stats IDENTITY = new Stats(0L, 0L, 0L, 0L);

        public Stats(StreamInput in) throws IOException {
            this(in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.ingestCount);
            out.writeVLong(this.ingestTimeInMillis);
            out.writeVLong(this.ingestCurrent);
            out.writeVLong(this.ingestFailedCount);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("count", this.ingestCount);
            builder.humanReadableField("time_in_millis", "time", new TimeValue(this.ingestTimeInMillis, TimeUnit.MILLISECONDS));
            builder.field("current", this.ingestCurrent);
            builder.field("failed", this.ingestFailedCount);
            return builder;
        }

        static Stats merge(Stats first, Stats second) {
            return new Stats(first.ingestCount + second.ingestCount, first.ingestTimeInMillis + second.ingestTimeInMillis, first.ingestCurrent + second.ingestCurrent, first.ingestFailedCount + second.ingestFailedCount);
        }
    }

    public record PipelineStat(String pipelineId, Stats stats) {
        static List<PipelineStat> merge(List<PipelineStat> first, List<PipelineStat> second) {
            HashMap totalsPerPipeline = new HashMap();
            first.forEach(ps -> totalsPerPipeline.merge(ps.pipelineId, ps.stats, Stats::merge));
            second.forEach(ps -> totalsPerPipeline.merge(ps.pipelineId, ps.stats, Stats::merge));
            return totalsPerPipeline.entrySet().stream().map(v -> new PipelineStat((String)v.getKey(), (Stats)v.getValue())).sorted(PIPELINE_STAT_COMPARATOR).toList();
        }
    }

    public record ProcessorStat(String name, String type, Stats stats) {
        private static List<ProcessorStat> merge(List<ProcessorStat> first, List<ProcessorStat> second) {
            long firstIngestCountTotal = 0L;
            for (ProcessorStat ps : first) {
                firstIngestCountTotal += ps.stats.ingestCount;
            }
            long secondIngestCountTotal = 0L;
            for (ProcessorStat ps : second) {
                secondIngestCountTotal += ps.stats.ingestCount;
            }
            if (firstIngestCountTotal == 0L) {
                return second;
            }
            if (secondIngestCountTotal == 0L) {
                return first;
            }
            if (first.size() == second.size()) {
                boolean match = true;
                ArrayList<ProcessorStat> merged = new ArrayList<ProcessorStat>(first.size());
                for (int i = 0; i < first.size(); ++i) {
                    ProcessorStat ps1 = first.get(i);
                    ProcessorStat ps2 = second.get(i);
                    if (!ps1.name.equals(ps2.name) || !ps1.type.equals(ps2.type)) {
                        match = false;
                        break;
                    }
                    merged.add(new ProcessorStat(ps1.name, ps1.type, Stats.merge(ps1.stats, ps2.stats)));
                }
                if (match) {
                    return merged;
                }
            }
            if (firstIngestCountTotal < secondIngestCountTotal) {
                return first;
            }
            return second;
        }
    }

    static class Builder {
        private Stats totalStats = null;
        private final List<PipelineStat> pipelineStats = new ArrayList<PipelineStat>();
        private final Map<String, List<ProcessorStat>> processorStats = new HashMap<String, List<ProcessorStat>>();

        Builder() {
        }

        Builder addTotalMetrics(IngestMetric totalMetric) {
            assert (this.totalStats == null);
            this.totalStats = totalMetric.createStats();
            return this;
        }

        Builder addPipelineMetrics(String pipelineId, IngestMetric pipelineMetric) {
            this.pipelineStats.add(new PipelineStat(pipelineId, pipelineMetric.createStats()));
            return this;
        }

        Builder addProcessorMetrics(String pipelineId, String processorName, String processorType, IngestMetric metric) {
            this.processorStats.computeIfAbsent(pipelineId, k -> new ArrayList()).add(new ProcessorStat(processorName, processorType, metric.createStats()));
            return this;
        }

        IngestStats build() {
            return new IngestStats(this.totalStats, Collections.unmodifiableList(this.pipelineStats), Collections.unmodifiableMap(this.processorStats));
        }
    }
}

