/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import java.text.ParseException;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.store.Store;

public class StoreFileMetadata
implements Writeable {
    public static final BytesRef UNAVAILABLE_WRITER_UUID = new BytesRef();
    private static final TransportVersion WRITER_UUID_MIN_VERSION = TransportVersions.V_7_16_0;
    private final String name;
    private final long length;
    private final String checksum;
    private final String writtenBy;
    private final BytesRef hash;
    private final BytesRef writerUuid;

    public StoreFileMetadata(String name, long length, String checksum, String writtenBy) {
        this(name, length, checksum, writtenBy, null, UNAVAILABLE_WRITER_UUID);
    }

    public StoreFileMetadata(String name, long length, String checksum, String writtenBy, BytesRef hash, BytesRef writerUuid) {
        assert (StoreFileMetadata.assertValidWrittenBy(writtenBy));
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.length = length;
        this.checksum = Objects.requireNonNull(checksum, "checksum must not be null");
        this.writtenBy = Objects.requireNonNull(writtenBy, "writtenBy must not be null");
        BytesRef bytesRef = this.hash = hash == null ? new BytesRef() : hash;
        assert (writerUuid != null && (writerUuid.length > 0 || writerUuid == UNAVAILABLE_WRITER_UUID));
        this.writerUuid = Objects.requireNonNull(writerUuid, "writerUuid must not be null");
    }

    public StoreFileMetadata(StreamInput in) throws IOException {
        this.name = in.readString();
        this.length = in.readVLong();
        this.checksum = in.readString();
        this.writtenBy = in.readString();
        this.hash = in.readBytesRef();
        this.writerUuid = in.getTransportVersion().onOrAfter(WRITER_UUID_MIN_VERSION) ? StoreFileMetadata.toWriterUuid(in.readBytesRef()) : UNAVAILABLE_WRITER_UUID;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeVLong(this.length);
        out.writeString(this.checksum);
        out.writeString(this.writtenBy);
        out.writeBytesRef(this.hash);
        if (out.getTransportVersion().onOrAfter(WRITER_UUID_MIN_VERSION)) {
            out.writeBytesRef(this.writerUuid);
        }
    }

    public String name() {
        return this.name;
    }

    public long length() {
        return this.length;
    }

    public String checksum() {
        return this.checksum;
    }

    public boolean hashEqualsContents() {
        if ((long)this.hash.length == this.length) {
            try {
                boolean checksumsMatch = Store.digestToString(CodecUtil.retrieveChecksum(new ByteArrayIndexInput("store_file", this.hash.bytes, this.hash.offset, this.hash.length))).equals(this.checksum);
                assert (checksumsMatch) : "Checksums did not match for [" + this + "] which has a hash of [" + this.hash + "]";
                return checksumsMatch;
            }
            catch (Exception e) {
                assert (false) : new AssertionError("Saw exception for hash [" + this.hash + "] but expected it to be Lucene file", e);
                return false;
            }
        }
        return false;
    }

    public boolean isSame(StoreFileMetadata other) {
        if (this.checksum == null || other.checksum == null) {
            return false;
        }
        if (this.hashEqualsContents()) {
            return this.hash.equals(other.hash);
        }
        if (this.writerUuid.length > 0 && other.writerUuid.length > 0) {
            if (!this.writerUuid.equals(other.writerUuid)) {
                return false;
            }
            assert (this.name.equals(other.name) && this.length == other.length && this.checksum.equals(other.checksum)) : this + " vs " + other;
            assert (this.hash.equals(other.hash)) : this + " vs " + other + " with hashes " + this.hash + " vs " + other.hash;
        }
        return this.length == other.length && this.checksum.equals(other.checksum) && this.hash.equals(other.hash);
    }

    public String toString() {
        return "name [" + this.name + "], length [" + this.length + "], checksum [" + this.checksum + "], writtenBy [" + this.writtenBy + "]";
    }

    public String writtenBy() {
        return this.writtenBy;
    }

    public BytesRef hash() {
        return this.hash;
    }

    public BytesRef writerUuid() {
        return this.writerUuid;
    }

    static BytesRef toWriterUuid(BytesRef bytesRef) {
        if (bytesRef.length == 0) {
            return UNAVAILABLE_WRITER_UUID;
        }
        return bytesRef;
    }

    static BytesRef toWriterUuid(@Nullable byte[] id) {
        if (id == null) {
            return UNAVAILABLE_WRITER_UUID;
        }
        assert (id.length > 0);
        return new BytesRef(id);
    }

    private static boolean assertValidWrittenBy(String writtenBy) {
        try {
            Version.parse(writtenBy);
        }
        catch (ParseException e) {
            throw new AssertionError("invalid writtenBy: " + writtenBy, e);
        }
        return true;
    }
}

