/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.NestedDocuments;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.lookup.LeafFieldLookupProvider;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class SearchExecutionContext
extends QueryRewriteContext {
    private final SimilarityService similarityService;
    private final BitsetFilterCache bitsetFilterCache;
    private final BiFunction<MappedFieldType, FieldDataContext, IndexFieldData<?>> indexFieldDataLookup;
    private SearchLookup lookup;
    private final int shardId;
    private final int shardRequestIndex;
    private final IndexSearcher searcher;
    private boolean cacheable = true;
    private final SetOnce<Boolean> frozen = new SetOnce();
    private Set<String> fieldsInIndex = null;
    private final Map<String, Query> namedQueries = new HashMap<String, Query>();
    private NestedScope nestedScope;
    private QueryBuilder aliasFilter;
    private boolean rewriteToNamedQueries = false;
    private final Integer requestSize;

    public SearchExecutionContext(int shardId, int shardRequestIndex, IndexSettings indexSettings, BitsetFilterCache bitsetFilterCache, BiFunction<MappedFieldType, FieldDataContext, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, MappingLookup mappingLookup, SimilarityService similarityService, ScriptCompiler scriptService, XContentParserConfiguration parserConfiguration, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Predicate<String> indexNameMatcher, BooleanSupplier allowExpensiveQueries, ValuesSourceRegistry valuesSourceRegistry, Map<String, Object> runtimeMappings) {
        this(shardId, shardRequestIndex, indexSettings, bitsetFilterCache, indexFieldDataLookup, mapperService, mappingLookup, similarityService, scriptService, parserConfiguration, namedWriteableRegistry, client, searcher, nowInMillis, clusterAlias, indexNameMatcher, allowExpensiveQueries, valuesSourceRegistry, runtimeMappings, null);
    }

    public SearchExecutionContext(int shardId, int shardRequestIndex, IndexSettings indexSettings, BitsetFilterCache bitsetFilterCache, BiFunction<MappedFieldType, FieldDataContext, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, MappingLookup mappingLookup, SimilarityService similarityService, ScriptCompiler scriptService, XContentParserConfiguration parserConfiguration, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Predicate<String> indexNameMatcher, BooleanSupplier allowExpensiveQueries, ValuesSourceRegistry valuesSourceRegistry, Map<String, Object> runtimeMappings, Integer requestSize) {
        this(shardId, shardRequestIndex, indexSettings, bitsetFilterCache, indexFieldDataLookup, mapperService, mappingLookup, similarityService, scriptService, parserConfiguration, namedWriteableRegistry, client, searcher, nowInMillis, indexNameMatcher, new Index(RemoteClusterAware.buildRemoteIndexName(clusterAlias, indexSettings.getIndex().getName()), indexSettings.getIndex().getUUID()), allowExpensiveQueries, valuesSourceRegistry, IndexService.parseRuntimeMappings(runtimeMappings, mapperService, indexSettings, mappingLookup), requestSize);
    }

    public SearchExecutionContext(SearchExecutionContext source) {
        this(source.shardId, source.shardRequestIndex, source.indexSettings, source.bitsetFilterCache, source.indexFieldDataLookup, source.mapperService, source.mappingLookup, source.similarityService, source.scriptService, source.getParserConfig(), source.getWriteableRegistry(), source.client, source.searcher, source.nowInMillis, source.indexNameMatcher, source.getFullyQualifiedIndex(), source.allowExpensiveQueries, source.getValuesSourceRegistry(), source.runtimeMappings, source.requestSize);
    }

    private SearchExecutionContext(int shardId, int shardRequestIndex, IndexSettings indexSettings, BitsetFilterCache bitsetFilterCache, BiFunction<MappedFieldType, FieldDataContext, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, MappingLookup mappingLookup, SimilarityService similarityService, ScriptCompiler scriptService, XContentParserConfiguration parserConfig, NamedWriteableRegistry namedWriteableRegistry, Client client, IndexSearcher searcher, LongSupplier nowInMillis, Predicate<String> indexNameMatcher, Index fullyQualifiedIndex, BooleanSupplier allowExpensiveQueries, ValuesSourceRegistry valuesSourceRegistry, Map<String, MappedFieldType> runtimeMappings, Integer requestSize) {
        super(parserConfig, client, nowInMillis, mapperService, mappingLookup, runtimeMappings, indexSettings, fullyQualifiedIndex, indexNameMatcher, namedWriteableRegistry, valuesSourceRegistry, allowExpensiveQueries, scriptService, null);
        this.shardId = shardId;
        this.shardRequestIndex = shardRequestIndex;
        this.similarityService = similarityService;
        this.bitsetFilterCache = bitsetFilterCache;
        this.indexFieldDataLookup = indexFieldDataLookup;
        this.nestedScope = new NestedScope();
        this.searcher = searcher;
        this.requestSize = requestSize;
    }

    private void reset() {
        this.setAllowUnmappedFields(this.indexSettings.isDefaultAllowUnmappedFields());
        this.lookup = null;
        this.namedQueries.clear();
        this.nestedScope = new NestedScope();
    }

    public void setAliasFilter(QueryBuilder aliasFilter) {
        this.aliasFilter = aliasFilter;
    }

    public QueryBuilder getAliasFilter() {
        return this.aliasFilter;
    }

    public Similarity getSearchSimilarity() {
        return this.similarityService != null ? this.similarityService.similarity(this::fieldType) : null;
    }

    public Similarity getDefaultSimilarity() {
        return this.similarityService != null ? this.similarityService.getDefaultSimilarity() : null;
    }

    public List<String> defaultFields() {
        return this.indexSettings.getDefaultFields();
    }

    public boolean queryStringLenient() {
        return this.indexSettings.isQueryStringLenient();
    }

    public boolean queryStringAnalyzeWildcard() {
        return this.indexSettings.isQueryStringAnalyzeWildcard();
    }

    public boolean queryStringAllowLeadingWildcard() {
        return this.indexSettings.isQueryStringAllowLeadingWildcard();
    }

    public BitSetProducer bitsetFilter(Query filter) {
        return this.bitsetFilterCache.getBitSetProducer(filter);
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType, MappedFieldType.FielddataOperation fielddataOperation) {
        return (IFD)this.indexFieldDataLookup.apply(fieldType, new FieldDataContext(this.getFullyQualifiedIndex().getName(), () -> this.lookup().forkAndTrackFieldReferences(fieldType.name()), this::sourcePath, fielddataOperation));
    }

    public void addNamedQuery(String name, Query query) {
        if (query != null) {
            this.namedQueries.put(name, query);
        }
    }

    public Map<String, Query> copyNamedQueries() {
        return Map.copyOf(this.namedQueries);
    }

    public boolean hasNamedQueries() {
        return !this.namedQueries.isEmpty();
    }

    public ParsedDocument parseDocument(SourceToParse source) throws DocumentParsingException {
        return this.mapperService.documentParser().parseDocument(source, this.mappingLookup);
    }

    public NestedLookup nestedLookup() {
        return this.mappingLookup.nestedLookup();
    }

    public boolean hasMappings() {
        return this.mappingLookup.hasMappings();
    }

    public boolean isFieldMapped(String name) {
        return this.fieldType(name) != null;
    }

    public boolean isMetadataField(String field) {
        return this.mapperService.isMetadataField(field);
    }

    public boolean isMultiField(String field) {
        if (this.runtimeMappings.containsKey(field)) {
            return false;
        }
        return this.mapperService.isMultiField(field);
    }

    public Iterable<MappedFieldType> dimensionFields() {
        ArrayList<MappedFieldType> dimensionFields = new ArrayList<MappedFieldType>();
        for (Mapper mapper : this.mapperService.mappingLookup().fieldMappers()) {
            FieldMapper fieldMapper;
            MappedFieldType fieldType;
            if (!(mapper instanceof FieldMapper) || !(fieldType = (fieldMapper = (FieldMapper)mapper).fieldType()).isDimension()) continue;
            dimensionFields.add(fieldType);
        }
        return dimensionFields;
    }

    public Set<String> sourcePath(String fullName) {
        return this.mappingLookup.sourcePaths(fullName);
    }

    public String parentPath(String field) {
        return this.mappingLookup.parentField(field);
    }

    public boolean isSourceEnabled() {
        return this.mappingLookup.isSourceEnabled();
    }

    public boolean isSourceSynthetic() {
        return this.mappingLookup.isSourceSynthetic();
    }

    public SourceLoader newSourceLoader(boolean forceSyntheticSource) {
        if (forceSyntheticSource) {
            return new SourceLoader.Synthetic(this.mappingLookup.getMapping());
        }
        return this.mappingLookup.newSourceLoader();
    }

    public MappedFieldType buildAnonymousFieldType(String type) {
        MappingParserContext parserContext = this.mapperService.parserContext();
        Mapper.TypeParser typeParser = parserContext.typeParser(type);
        if (typeParser == null) {
            throw new IllegalArgumentException("No mapper found for type [" + type + "]");
        }
        Mapper.Builder builder = typeParser.parse("__anonymous_", Collections.emptyMap(), parserContext);
        Mapper mapper = builder.build(MapperBuilderContext.root(false, false));
        if (mapper instanceof FieldMapper) {
            return ((FieldMapper)mapper).fieldType();
        }
        throw new IllegalArgumentException("Mapper for type [" + type + "] must be a leaf field");
    }

    public Analyzer getIndexAnalyzer(final Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
        return new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            @Override
            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return SearchExecutionContext.this.mappingLookup.indexAnalyzer(fieldName, unindexedFieldAnalyzer);
            }
        };
    }

    public void setAllowedFields(Predicate<String> allowedFields) {
        this.allowedFields = allowedFields;
    }

    public boolean containsBrokenAnalysis(String field) {
        NamedAnalyzer a = this.mappingLookup.indexAnalyzer(field, f -> null);
        return a == null ? false : a.containsBrokenAnalysis();
    }

    public SearchLookup lookup() {
        if (this.lookup == null) {
            SourceProvider sourceProvider = this.isSourceSynthetic() ? SourceProvider.fromSyntheticSource(this.mappingLookup.getMapping()) : SourceProvider.fromStoredFields();
            this.setLookupProviders(sourceProvider, LeafFieldLookupProvider.fromStoredFields());
        }
        return this.lookup;
    }

    public void setLookupProviders(SourceProvider sourceProvider, Function<LeafReaderContext, LeafFieldLookupProvider> fieldLookupProvider) {
        this.lookup = new SearchLookup(this::getFieldType, (fieldType, searchLookup, fielddataOperation) -> this.indexFieldDataLookup.apply((MappedFieldType)fieldType, new FieldDataContext(this.getFullyQualifiedIndex().getName(), (Supplier<SearchLookup>)searchLookup, this::sourcePath, (MappedFieldType.FielddataOperation)((Object)fielddataOperation))), sourceProvider, fieldLookupProvider);
    }

    public NestedScope nestedScope() {
        return this.nestedScope;
    }

    public IndexVersion indexVersionCreated() {
        return this.indexSettings.getIndexVersionCreated();
    }

    public boolean indexSortedOnField(String field) {
        IndexSortConfig indexSortConfig = this.indexSettings.getIndexSortConfig();
        return indexSortConfig.hasPrimarySortOnField(field);
    }

    public ParsedQuery toQuery(QueryBuilder queryBuilder) {
        this.reset();
        try {
            Query query = Rewriteable.rewrite(queryBuilder, this, true).toQuery(this);
            if (query == null) {
                query = Queries.newMatchNoDocsQuery("No query left after rewrite.");
            }
            ParsedQuery parsedQuery = new ParsedQuery(query, this.copyNamedQueries());
            return parsedQuery;
        }
        catch (ParsingException | QueryShardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryShardException((QueryRewriteContext)this, "failed to create query: {}", (Throwable)e, e.getMessage());
        }
        finally {
            this.reset();
        }
    }

    public Index index() {
        return this.indexSettings.getIndex();
    }

    public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> context) {
        assert (this.scriptService != null);
        FactoryType factory = this.scriptService.compile(script, context);
        if (factory instanceof ScriptFactory && !((ScriptFactory)factory).isResultDeterministic()) {
            this.failIfFrozen();
        }
        return factory;
    }

    public final void freezeContext() {
        this.frozen.set(Boolean.TRUE);
    }

    public void disableCache() {
        this.failIfFrozen();
    }

    protected final void failIfFrozen() {
        this.cacheable = false;
        if (this.frozen.get() == Boolean.TRUE) {
            throw new IllegalArgumentException("features that prevent cachability are disabled on this context");
        }
        assert (this.frozen.get() == null) : this.frozen.get();
    }

    @Override
    public void registerAsyncAction(BiConsumer<Client, ActionListener<?>> asyncAction) {
        this.failIfFrozen();
        super.registerAsyncAction(asyncAction);
    }

    @Override
    public void executeAsyncActions(ActionListener listener) {
        this.failIfFrozen();
        super.executeAsyncActions(listener);
    }

    public final boolean isCacheable() {
        return this.cacheable;
    }

    public int getShardId() {
        return this.shardId;
    }

    public int getShardRequestIndex() {
        return this.shardRequestIndex;
    }

    @Override
    public long nowInMillis() {
        this.failIfFrozen();
        return this.nowInMillis.getAsLong();
    }

    public Client getClient() {
        this.failIfFrozen();
        return this.client;
    }

    @Override
    public final SearchExecutionContext convertToSearchExecutionContext() {
        return this;
    }

    public IndexReader getIndexReader() {
        return this.searcher == null ? null : this.searcher.getIndexReader();
    }

    public IndexSearcher searcher() {
        return this.searcher;
    }

    public Integer requestSize() {
        return this.requestSize;
    }

    public boolean fieldExistsInIndex(String fieldname) {
        if (this.searcher == null) {
            return false;
        }
        if (this.fieldsInIndex == null) {
            this.fieldsInIndex = new HashSet<String>();
            for (LeafReaderContext ctx : this.searcher.getIndexReader().leaves()) {
                FieldInfos fis = ctx.reader().getFieldInfos();
                for (FieldInfo fi : fis) {
                    this.fieldsInIndex.add(fi.name);
                }
            }
        }
        return this.fieldsInIndex.contains(fieldname);
    }

    public MappingLookup.CacheKey mappingCacheKey() {
        return this.mappingLookup.cacheKey();
    }

    public NestedDocuments getNestedDocuments() {
        return new NestedDocuments(this.mappingLookup, this.bitsetFilterCache::getBitSetProducer, this.indexVersionCreated());
    }

    public void setRewriteToNamedQueries() {
        this.rewriteToNamedQueries = true;
    }

    public boolean rewriteToNamedQuery() {
        return this.rewriteToNamedQueries;
    }
}

