/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class SortedSetDocValuesSyntheticFieldLoader
implements SourceLoader.SyntheticFieldLoader {
    private static final Logger logger = LogManager.getLogger(SortedSetDocValuesSyntheticFieldLoader.class);
    private final String name;
    private final String simpleName;
    private DocValuesFieldValues docValues = NO_VALUES;
    @Nullable
    private final String storedValuesName;
    private List<Object> storedValues = Collections.emptyList();
    private final IgnoreMalformedStoredValues ignoreMalformedValues;
    private static final DocValuesFieldValues NO_VALUES = new DocValuesFieldValues(){

        @Override
        public int count() {
            return 0;
        }

        @Override
        public void write(XContentBuilder b) {
        }
    };

    public SortedSetDocValuesSyntheticFieldLoader(String name, String simpleName, @Nullable String storedValuesName, boolean loadIgnoreMalformedValues) {
        this.name = name;
        this.simpleName = simpleName;
        this.storedValuesName = storedValuesName;
        this.ignoreMalformedValues = loadIgnoreMalformedValues ? IgnoreMalformedStoredValues.stored(name) : IgnoreMalformedStoredValues.empty();
    }

    @Override
    public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
        if (this.storedValuesName == null) {
            return this.ignoreMalformedValues.storedFieldLoaders();
        }
        return Stream.concat(Stream.of(Map.entry(this.storedValuesName, values -> {
            this.storedValues = values;
        })), this.ignoreMalformedValues.storedFieldLoaders());
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader reader, int[] docIdsInLeaf) throws IOException {
        SortedDocValues singleton;
        SortedSetDocValues dv = DocValues.getSortedSet(reader, this.name);
        if (dv.getValueCount() == 0L) {
            this.docValues = NO_VALUES;
            return null;
        }
        if (docIdsInLeaf != null && docIdsInLeaf.length > 1 && (singleton = DocValues.unwrapSingleton(dv)) != null) {
            SingletonDocValuesLoader loader = this.buildSingletonDocValuesLoader(singleton, docIdsInLeaf);
            this.docValues = loader == null ? NO_VALUES : loader;
            return loader;
        }
        ImmediateDocValuesLoader loader = new ImmediateDocValuesLoader(dv);
        this.docValues = loader;
        return loader;
    }

    @Override
    public boolean hasValue() {
        return this.docValues.count() > 0 || !this.storedValues.isEmpty() || this.ignoreMalformedValues.count() > 0;
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        int total = this.docValues.count() + this.storedValues.size() + this.ignoreMalformedValues.count();
        switch (total) {
            case 0: {
                return;
            }
            case 1: {
                b.field(this.simpleName);
                if (this.docValues.count() > 0) {
                    assert (this.docValues.count() == 1);
                    assert (this.storedValues.isEmpty());
                    assert (this.ignoreMalformedValues.count() == 0);
                    this.docValues.write(b);
                } else if (!this.storedValues.isEmpty()) {
                    assert (this.docValues.count() == 0);
                    assert (this.storedValues.size() == 1);
                    assert (this.ignoreMalformedValues.count() == 0);
                    BytesRef converted = this.convert((BytesRef)this.storedValues.get(0));
                    b.utf8Value(converted.bytes, converted.offset, converted.length);
                    this.storedValues = Collections.emptyList();
                } else {
                    assert (this.docValues.count() == 0);
                    assert (this.storedValues.isEmpty());
                    assert (this.ignoreMalformedValues.count() == 1);
                    this.ignoreMalformedValues.write(b);
                }
                return;
            }
        }
        b.startArray(this.simpleName);
        this.docValues.write(b);
        for (Object v : this.storedValues) {
            BytesRef converted = this.convert((BytesRef)v);
            b.utf8Value(converted.bytes, converted.offset, converted.length);
        }
        this.storedValues = Collections.emptyList();
        this.ignoreMalformedValues.write(b);
        b.endArray();
    }

    private SingletonDocValuesLoader buildSingletonDocValuesLoader(SortedDocValues singleton, int[] docIdsInLeaf) throws IOException {
        int[] ords = new int[docIdsInLeaf.length];
        int found = 0;
        for (int d = 0; d < docIdsInLeaf.length; ++d) {
            if (!singleton.advanceExact(docIdsInLeaf[d])) {
                ords[d] = -1;
                continue;
            }
            ords[d] = singleton.ordValue();
            ++found;
        }
        if (found == 0) {
            return null;
        }
        int[] sortedOrds = (int[])ords.clone();
        Arrays.sort(sortedOrds);
        int unique = 0;
        int prev = -1;
        for (int ord : sortedOrds) {
            if (ord == prev) continue;
            prev = ord;
            ++unique;
        }
        int[] uniqueOrds = new int[unique];
        BytesRef[] converted = new BytesRef[unique];
        unique = 0;
        prev = -1;
        for (int ord : sortedOrds) {
            if (ord == prev) continue;
            prev = ord;
            uniqueOrds[unique] = ord;
            converted[unique] = this.preserve(this.convert(singleton.lookupOrd(ord)));
            ++unique;
        }
        logger.debug("loading [{}] on [{}] docs covering [{}] ords", new Object[]{this.name, docIdsInLeaf.length, uniqueOrds.length});
        return new SingletonDocValuesLoader(docIdsInLeaf, ords, uniqueOrds, converted);
    }

    protected abstract BytesRef convert(BytesRef var1);

    protected abstract BytesRef preserve(BytesRef var1);

    private static interface DocValuesFieldValues {
        public int count();

        public void write(XContentBuilder var1) throws IOException;
    }

    private static class SingletonDocValuesLoader
    implements SourceLoader.SyntheticFieldLoader.DocValuesLoader,
    DocValuesFieldValues {
        private final int[] docIdsInLeaf;
        private final int[] ords;
        private final int[] uniqueOrds;
        private final BytesRef[] converted;
        private int idx = -1;

        private SingletonDocValuesLoader(int[] docIdsInLeaf, int[] ords, int[] uniqueOrds, BytesRef[] converted) {
            this.docIdsInLeaf = docIdsInLeaf;
            this.ords = ords;
            this.uniqueOrds = uniqueOrds;
            this.converted = converted;
        }

        @Override
        public boolean advanceToDoc(int docId) throws IOException {
            ++this.idx;
            if (this.docIdsInLeaf[this.idx] != docId) {
                throw new IllegalArgumentException("expected to be called with [" + this.docIdsInLeaf[this.idx] + "] but was called with " + docId + " instead");
            }
            return this.ords[this.idx] >= 0;
        }

        @Override
        public int count() {
            return this.ords[this.idx] < 0 ? 0 : 1;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (this.ords[this.idx] < 0) {
                return;
            }
            int convertedIdx = Arrays.binarySearch(this.uniqueOrds, this.ords[this.idx]);
            if (convertedIdx < 0) {
                throw new IllegalStateException("received unexpected ord [" + this.ords[this.idx] + "]. Expected " + Arrays.toString(this.uniqueOrds));
            }
            BytesRef c = this.converted[convertedIdx];
            b.utf8Value(c.bytes, c.offset, c.length);
        }
    }

    private class ImmediateDocValuesLoader
    implements SourceLoader.SyntheticFieldLoader.DocValuesLoader,
    DocValuesFieldValues {
        private final SortedSetDocValues dv;
        private boolean hasValue;

        ImmediateDocValuesLoader(SortedSetDocValues dv) {
            this.dv = dv;
        }

        @Override
        public boolean advanceToDoc(int docId) throws IOException {
            this.hasValue = this.dv.advanceExact(docId);
            return this.hasValue;
        }

        @Override
        public int count() {
            return this.hasValue ? this.dv.docValueCount() : 0;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            for (int i = 0; i < this.dv.docValueCount(); ++i) {
                BytesRef c = SortedSetDocValuesSyntheticFieldLoader.this.convert(this.dv.lookupOrd(this.dv.nextOrd()));
                b.utf8Value(c.bytes, c.offset, c.length);
            }
        }
    }
}

