/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import org.apache.lucene.codecs.FlatVectorsFormat;
import org.apache.lucene.codecs.FlatVectorsReader;
import org.apache.lucene.codecs.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.codecs.lucene99.Lucene99ScalarQuantizedVectorsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.elasticsearch.index.codec.vectors.ES814ScalarQuantizedVectorsWriter;

public class ES814ScalarQuantizedVectorsFormat
extends FlatVectorsFormat {
    public static final String QUANTIZED_VECTOR_COMPONENT = "QVEC";
    static final String NAME = "ES814ScalarQuantizedVectorsFormat";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    static final String META_CODEC_NAME = "Lucene99ScalarQuantizedVectorsFormatMeta";
    static final String VECTOR_DATA_CODEC_NAME = "Lucene99ScalarQuantizedVectorsFormatData";
    static final String META_EXTENSION = "vemq";
    static final String VECTOR_DATA_EXTENSION = "veq";
    private static final FlatVectorsFormat rawVectorFormat = new Lucene99FlatVectorsFormat();
    private static final float MINIMUM_CONFIDENCE_INTERVAL = 0.9f;
    private static final float MAXIMUM_CONFIDENCE_INTERVAL = 1.0f;
    public final Float confidenceInterval;

    public ES814ScalarQuantizedVectorsFormat(Float confidenceInterval) {
        if (confidenceInterval != null && (confidenceInterval.floatValue() < 0.9f || confidenceInterval.floatValue() > 1.0f)) {
            throw new IllegalArgumentException("confidenceInterval must be between 0.9 and 1.0; confidenceInterval=" + confidenceInterval);
        }
        this.confidenceInterval = confidenceInterval;
    }

    public String toString() {
        return "ES814ScalarQuantizedVectorsFormat(name=ES814ScalarQuantizedVectorsFormat, confidenceInterval=" + this.confidenceInterval + ", rawVectorFormat=" + rawVectorFormat + ")";
    }

    @Override
    public FlatVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ES814ScalarQuantizedVectorsWriter(state, this.confidenceInterval, rawVectorFormat.fieldsWriter(state));
    }

    @Override
    public FlatVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES814ScalarQuantizedVectorsReader(new Lucene99ScalarQuantizedVectorsReader(state, rawVectorFormat.fieldsReader(state)));
    }

    static class ES814ScalarQuantizedVectorsReader
    extends FlatVectorsReader {
        final FlatVectorsReader reader;

        ES814ScalarQuantizedVectorsReader(FlatVectorsReader reader) {
            this.reader = reader;
        }

        @Override
        public RandomVectorScorer getRandomVectorScorer(String field, float[] target) throws IOException {
            return this.reader.getRandomVectorScorer(field, target);
        }

        @Override
        public RandomVectorScorer getRandomVectorScorer(String field, byte[] target) throws IOException {
            return this.reader.getRandomVectorScorer(field, target);
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.reader.checkIntegrity();
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            return this.reader.getFloatVectorValues(field);
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            return this.reader.getByteVectorValues(field);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public long ramBytesUsed() {
            return this.reader.ramBytesUsed();
        }
    }
}

