/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.Objects;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene90.Lucene90DocValuesFormat;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.codec.bloomfilter.ES87BloomFilterPostingsFormat;
import org.elasticsearch.index.codec.postings.ES812PostingsFormat;
import org.elasticsearch.index.codec.tsdb.ES87TSDBDocValuesFormat;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public class PerFieldFormatSupplier {
    private final MapperService mapperService;
    private final BigArrays bigArrays;
    private final DocValuesFormat docValuesFormat = new Lucene90DocValuesFormat();
    private final KnnVectorsFormat knnVectorsFormat = new Lucene99HnswVectorsFormat();
    private final ES87BloomFilterPostingsFormat bloomFilterPostingsFormat;
    private final ES87TSDBDocValuesFormat tsdbDocValuesFormat;
    private final ES812PostingsFormat es812PostingsFormat;

    public PerFieldFormatSupplier(MapperService mapperService, BigArrays bigArrays) {
        this.mapperService = mapperService;
        this.bigArrays = Objects.requireNonNull(bigArrays);
        this.bloomFilterPostingsFormat = new ES87BloomFilterPostingsFormat(bigArrays, this::internalGetPostingsFormatForField);
        this.tsdbDocValuesFormat = new ES87TSDBDocValuesFormat();
        this.es812PostingsFormat = new ES812PostingsFormat();
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        if (this.useBloomFilter(field)) {
            return this.bloomFilterPostingsFormat;
        }
        return this.internalGetPostingsFormatForField(field);
    }

    private PostingsFormat internalGetPostingsFormatForField(String field) {
        PostingsFormat format;
        if (this.mapperService != null && (format = this.mapperService.mappingLookup().getPostingsFormat(field)) != null) {
            return format;
        }
        return this.es812PostingsFormat;
    }

    boolean useBloomFilter(String field) {
        if (this.mapperService == null) {
            return false;
        }
        IndexSettings indexSettings = this.mapperService.getIndexSettings();
        if (this.mapperService.mappingLookup().isDataStreamTimestampFieldEnabled()) {
            return indexSettings.getMode() == IndexMode.TIME_SERIES && "_id".equals(field) && IndexSettings.BLOOM_FILTER_ID_FIELD_ENABLED_SETTING.get(indexSettings.getSettings()) != false;
        }
        return "_id".equals(field) && IndexSettings.BLOOM_FILTER_ID_FIELD_ENABLED_SETTING.get(indexSettings.getSettings()) != false;
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(String field) {
        Mapper mapper;
        if (this.mapperService != null && (mapper = this.mapperService.mappingLookup().getMapper(field)) instanceof DenseVectorFieldMapper) {
            DenseVectorFieldMapper vectorMapper = (DenseVectorFieldMapper)mapper;
            return vectorMapper.getKnnVectorsFormatForField(this.knnVectorsFormat);
        }
        return this.knnVectorsFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        if (this.useTSDBDocValuesFormat(field)) {
            return this.tsdbDocValuesFormat;
        }
        return this.docValuesFormat;
    }

    boolean useTSDBDocValuesFormat(String field) {
        if (this.excludeFields(field)) {
            return false;
        }
        return this.mapperService != null && this.isTimeSeriesModeIndex() && this.mapperService.getIndexSettings().isES87TSDBCodecEnabled();
    }

    private boolean excludeFields(String fieldName) {
        return fieldName.startsWith("_") && !fieldName.equals("_tsid") && !fieldName.equals("_ts_routing_hash");
    }

    private boolean isTimeSeriesModeIndex() {
        return this.mapperService != null && IndexMode.TIME_SERIES == this.mapperService.getIndexSettings().getMode();
    }
}

