/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public final class BitArray
implements Accountable,
Releasable,
Writeable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BitArray.class);
    private final BigArrays bigArrays;
    private LongArray bits;

    public BitArray(long initialSize, BigArrays bigArrays) {
        this.bigArrays = bigArrays;
        this.bits = bigArrays.newLongArray(BitArray.wordNum(initialSize) + 1L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitArray(BigArrays bigArrays, boolean readOnly, StreamInput in) throws IOException {
        this.bigArrays = bigArrays;
        long numBits = in.readVLong();
        this.bits = bigArrays.newLongArray(BitArray.wordNum(numBits), !readOnly);
        boolean success = false;
        try {
            this.bits.fillWith(in);
            success = true;
        }
        finally {
            if (!success) {
                this.bits.close();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.size());
        this.bits.writeTo(out);
    }

    public void set(long index) {
        long wordNum = BitArray.wordNum(index);
        this.bits = this.bigArrays.grow(this.bits, wordNum + 1L);
        this.bits.set(wordNum, this.bits.get(wordNum) | BitArray.bitmask(index));
    }

    public boolean getAndSet(long index) {
        long wordNum = BitArray.wordNum(index);
        this.bits = this.bigArrays.grow(this.bits, wordNum + 1L);
        long word = this.bits.get(wordNum);
        long bitMask = BitArray.bitmask(index);
        this.bits.set(wordNum, word | bitMask);
        return (word & bitMask) != 0L;
    }

    public void or(BitArray other) {
        this.or(other.bits);
    }

    private void or(LongArray otherArr) {
        long pos = otherArr.size();
        LongArray thisArr = this.bits = this.bigArrays.grow(this.bits, pos + 1L);
        while (--pos >= 0L) {
            thisArr.set(pos, thisArr.get(pos) | otherArr.get(pos));
        }
    }

    public long nextSetBit(long index) {
        long wordNum = BitArray.wordNum(index);
        if (wordNum >= this.bits.size()) {
            return Long.MAX_VALUE;
        }
        long word = this.bits.get(wordNum) >> (int)index;
        if (word != 0L) {
            return index + (long)Long.numberOfTrailingZeros(word);
        }
        while (++wordNum < this.bits.size()) {
            word = this.bits.get(wordNum);
            if (word == 0L) continue;
            return (wordNum << 6) + (long)Long.numberOfTrailingZeros(word);
        }
        return Long.MAX_VALUE;
    }

    public long cardinality() {
        long cardinality = 0L;
        int i = 0;
        while ((long)i < this.bits.size()) {
            cardinality += (long)Long.bitCount(this.bits.get(i));
            ++i;
        }
        return cardinality;
    }

    public void clear(long index) {
        long wordNum = BitArray.wordNum(index);
        if (wordNum >= this.bits.size()) {
            return;
        }
        this.bits.set(wordNum, this.bits.get(wordNum) & (BitArray.bitmask(index) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public boolean get(long index) {
        long wordNum = BitArray.wordNum(index);
        if (wordNum >= this.bits.size()) {
            return false;
        }
        long bitmask = 1L << (int)index;
        return (this.bits.get(wordNum) & bitmask) != 0L;
    }

    public long size() {
        return this.bits.size() * 8L * 8L;
    }

    private static long wordNum(long index) {
        return index >> 6;
    }

    private static long bitmask(long index) {
        return 1L << (int)index;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.bits);
    }

    @Override
    public void close() {
        Releasables.close((Releasable)this.bits);
    }
}

