/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BigLongArray;
import org.elasticsearch.common.util.DoubleArray;

final class BigDoubleArray
extends AbstractBigArray
implements DoubleArray {
    private static final BigDoubleArray ESTIMATOR = new BigDoubleArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    static final VarHandle VH_PLATFORM_NATIVE_DOUBLE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.nativeOrder());
    private byte[][] pages;

    BigDoubleArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(2048, bigArrays, clearOnResize);
        this.size = size;
        this.pages = new byte[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newBytePage(i);
        }
    }

    @Override
    public double get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return VH_PLATFORM_NATIVE_DOUBLE.get(this.pages[pageIndex], indexInPage << 3);
    }

    @Override
    public double set(long index, double value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        byte[] page = this.pages[pageIndex];
        double ret = VH_PLATFORM_NATIVE_DOUBLE.get(page, indexInPage << 3);
        VH_PLATFORM_NATIVE_DOUBLE.set(page, indexInPage << 3, value);
        return ret;
    }

    @Override
    public double increment(long index, double inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        byte[] page = this.pages[pageIndex];
        double newVal = VH_PLATFORM_NATIVE_DOUBLE.get(page, indexInPage << 3) + inc;
        VH_PLATFORM_NATIVE_DOUBLE.set(page, indexInPage << 3, newVal);
        return newVal;
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (byte[][])Arrays.copyOf(this.pages, ArrayUtil.oversize(numPages, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newBytePage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    @Override
    public void fill(long fromIndex, long toIndex, double value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int fromPage = this.pageIndex(fromIndex);
        if (fromPage == (toPage = this.pageIndex(toIndex - 1L))) {
            BigDoubleArray.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value);
        } else {
            BigDoubleArray.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pageSize(), value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                BigDoubleArray.fill(this.pages[i], 0, this.pageSize(), value);
            }
            BigDoubleArray.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value);
        }
    }

    public static void fill(byte[] page, int from, int to, double value) {
        if (from < to) {
            VH_PLATFORM_NATIVE_DOUBLE.set(page, from << 3, value);
            BigDoubleArray.fillBySelfCopy(page, from << 3, to << 3, 8);
        }
    }

    @Override
    public void fillWith(StreamInput in) throws IOException {
        BigLongArray.readPages(in, this.pages);
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        this.set(index, buf, offset, len, this.pages, 3);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        BigLongArray.writePages(out, this.size, this.pages, 8);
    }
}

