/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.List;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.MembersInjector;
import org.elasticsearch.common.inject.SingleMethodInjector;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.InternalContext;

class MembersInjectorImpl<T>
implements MembersInjector<T> {
    private final TypeLiteral<T> typeLiteral;
    private final InjectorImpl injector;
    private final List<SingleMethodInjector> memberInjectors;

    MembersInjectorImpl(InjectorImpl injector, TypeLiteral<T> typeLiteral, List<SingleMethodInjector> memberInjectors) {
        this.injector = injector;
        this.typeLiteral = typeLiteral;
        this.memberInjectors = memberInjectors;
    }

    void injectAndNotify(T instance, Errors errors) throws ErrorsException {
        if (instance == null) {
            return;
        }
        this.injector.callInContext(context -> {
            this.injectMembers(instance, errors, context);
            return null;
        });
    }

    void injectMembers(T t, Errors errors, InternalContext context) {
        int size = this.memberInjectors.size();
        for (int i = 0; i < size; ++i) {
            this.memberInjectors.get(i).inject(errors, context, t);
        }
    }

    public String toString() {
        return "MembersInjector<" + this.typeLiteral + ">";
    }
}

