/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.filesystem;

import java.nio.file.Path;
import java.util.OptionalLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.filesystem.LinuxFileSystemNatives;
import org.elasticsearch.common.filesystem.WindowsFileSystemNatives;

public final class FileSystemNatives {
    private static final Logger logger = LogManager.getLogger(FileSystemNatives.class);
    private static final Provider NOOP_FILE_SYSTEM_NATIVES_PROVIDER = path -> OptionalLong.empty();
    private static final Provider JNA_PROVIDER = FileSystemNatives.loadJnaProvider();

    private static Provider loadJnaProvider() {
        try {
            Class.forName("com.sun.jna.Native");
            if (Constants.WINDOWS) {
                return WindowsFileSystemNatives.getInstance();
            }
            if (Constants.LINUX && Constants.JRE_IS_64BIT) {
                return LinuxFileSystemNatives.getInstance();
            }
        }
        catch (ClassNotFoundException e) {
            logger.warn("JNA not found. FileSystemNatives methods will be disabled.", (Throwable)e);
        }
        catch (LinkageError e) {
            logger.warn("unable to load JNA native support library, FileSystemNatives methods will be disabled.", (Throwable)e);
        }
        return NOOP_FILE_SYSTEM_NATIVES_PROVIDER;
    }

    private FileSystemNatives() {
    }

    public static void init() {
        assert (JNA_PROVIDER != null);
    }

    public static OptionalLong allocatedSizeInBytes(Path path) {
        return JNA_PROVIDER.allocatedSizeInBytes(path);
    }

    @FunctionalInterface
    static interface Provider {
        public OptionalLong allocatedSizeInBytes(Path var1);
    }
}

