/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterInfoSimulator;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceInput;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

public class DesiredBalanceComputer {
    private static final Logger logger = LogManager.getLogger(DesiredBalanceComputer.class);
    private final ThreadPool threadPool;
    private final ShardsAllocator delegateAllocator;
    protected final MeanMetric iterations = new MeanMetric();
    public static final Setting<TimeValue> PROGRESS_LOG_INTERVAL_SETTING = Setting.timeSetting("cluster.routing.allocation.desired_balance.progress_log_interval", TimeValue.timeValueMinutes(1L), TimeValue.ZERO, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private TimeValue progressLogInterval;

    public DesiredBalanceComputer(ClusterSettings clusterSettings, ThreadPool threadPool, ShardsAllocator delegateAllocator) {
        this.threadPool = threadPool;
        this.delegateAllocator = delegateAllocator;
        clusterSettings.initializeAndWatch(PROGRESS_LOG_INTERVAL_SETTING, value -> {
            this.progressLogInterval = value;
        });
    }

    public DesiredBalance compute(DesiredBalance previousDesiredBalance, DesiredBalanceInput desiredBalanceInput, Queue<List<MoveAllocationCommand>> pendingDesiredBalanceMoves, Predicate<DesiredBalanceInput> isFresh) {
        List<MoveAllocationCommand> commands;
        if (logger.isTraceEnabled()) {
            logger.trace("Recomputing desired balance for [{}]: {}, {}, {}, {}", (Object)desiredBalanceInput.index(), (Object)previousDesiredBalance, (Object)desiredBalanceInput.routingAllocation().routingNodes().toString(), (Object)desiredBalanceInput.routingAllocation().clusterInfo().toString(), (Object)desiredBalanceInput.routingAllocation().snapshotShardSizeInfo().toString());
        } else {
            logger.debug("Recomputing desired balance for [{}]", (Object)desiredBalanceInput.index());
        }
        RoutingAllocation routingAllocation = desiredBalanceInput.routingAllocation().mutableCloneForSimulation();
        RoutingNodes routingNodes = routingAllocation.routingNodes();
        Set<String> knownNodeIds = routingNodes.getAllNodeIds();
        RoutingChangesObserver changes = routingAllocation.changes();
        Set<ShardRouting> ignoredShards = DesiredBalanceComputer.getIgnoredShardsWithDiscardedAllocationStatus(desiredBalanceInput.ignoredShards());
        ClusterInfoSimulator clusterInfoSimulator = new ClusterInfoSimulator(routingAllocation);
        if (routingNodes.size() == 0) {
            return new DesiredBalance(desiredBalanceInput.index(), Map.of());
        }
        for (RoutingNode routingNode : routingNodes) {
            for (ShardRouting shardRouting : routingNode) {
                if (!shardRouting.initializing()) continue;
                clusterInfoSimulator.simulateShardStarted(shardRouting);
                routingNodes.startShard(logger, shardRouting, changes, 0L);
            }
        }
        HashSet<ShardId> unassignedPrimaries = new HashSet<ShardId>();
        HashMap<ShardId, ShardRoutings> shardRoutings = new HashMap<ShardId, ShardRoutings>();
        for (Object primary : (Iterator<Map.Entry<ShardId, List<ShardRouting>>>)new boolean[]{true, false}) {
            RoutingNodes.UnassignedShards unassigned = routingNodes.unassigned();
            RoutingNodes.UnassignedShards.UnassignedIterator iterator = unassigned.iterator();
            while (iterator.hasNext()) {
                ShardRouting shardRouting = iterator.next();
                if (shardRouting.primary() != primary) continue;
                String lastAllocatedNodeId = shardRouting.unassignedInfo().getLastAllocatedNodeId();
                if (knownNodeIds.contains(lastAllocatedNodeId) || !ignoredShards.contains(DesiredBalanceComputer.discardAllocationStatus(shardRouting))) {
                    shardRoutings.computeIfAbsent(shardRouting.shardId(), ShardRoutings::new).unassigned().add(shardRouting);
                    continue;
                }
                iterator.removeAndIgnore(UnassignedInfo.AllocationStatus.NO_ATTEMPT, changes);
                if (!shardRouting.primary()) continue;
                unassignedPrimaries.add(shardRouting.shardId());
            }
        }
        for (Map.Entry<ShardId, List<ShardRouting>> assigned : routingNodes.getAssignedShards().entrySet()) {
            shardRoutings.computeIfAbsent(assigned.getKey(), ShardRoutings::new).assigned().addAll((Collection<ShardRouting>)assigned.getValue());
        }
        HashMap<ShardRouting, LinkedList> unassignedShardsToInitialize = new HashMap<ShardRouting, LinkedList>();
        block7: for (Map.Entry entry : shardRoutings.entrySet()) {
            Object shardRouting2;
            ShardId shardId = (ShardId)entry.getKey();
            ShardRoutings routings = (ShardRoutings)entry.getValue();
            TreeMap<String, Iterator<ShardRouting>> shardsToRelocate = new TreeMap<String, Iterator<ShardRouting>>();
            ShardAssignment assignment = previousDesiredBalance.getAssignment(shardId);
            TreeSet<String> targetNodes = assignment != null ? new TreeSet<String>(assignment.nodeIds()) : new TreeSet();
            targetNodes.retainAll(knownNodeIds);
            for (Object shardRouting2 : routings.unassigned()) {
                String lastAllocatedNodeId = ((ShardRouting)shardRouting2).unassignedInfo().getLastAllocatedNodeId();
                if (!knownNodeIds.contains(lastAllocatedNodeId)) continue;
                targetNodes.add(lastAllocatedNodeId);
            }
            for (Object shardRouting2 : routings.assigned()) {
                assert (((ShardRouting)shardRouting2).started());
                if (targetNodes.remove(((ShardRouting)shardRouting2).currentNodeId())) continue;
                ShardRouting previousShard = (ShardRouting)((Object)shardsToRelocate.put(((ShardRouting)shardRouting2).currentNodeId(), (Iterator<ShardRouting>)shardRouting2));
                assert (previousShard == null) : "duplicate shards to relocate: " + shardRouting2 + " vs " + previousShard;
            }
            Iterator<String> targetNodesIterator = targetNodes.iterator();
            block10: for (ShardRouting shardRouting3 : shardsToRelocate.values()) {
                assert (shardRouting3.started());
                while (targetNodesIterator.hasNext()) {
                    String targetNodeId = targetNodesIterator.next();
                    RoutingNode targetNode = routingNodes.node(targetNodeId);
                    if (targetNode == null || routingAllocation.deciders().canAllocate(shardRouting3, targetNode, routingAllocation).type() == Decision.Type.NO) continue;
                    ShardRouting shardToRelocate = routingNodes.relocateShard(shardRouting3, targetNodeId, 0L, changes).v2();
                    clusterInfoSimulator.simulateShardStarted(shardToRelocate);
                    routingNodes.startShard(logger, shardToRelocate, changes, 0L);
                    continue block10;
                }
            }
            shardRouting2 = routings.unassigned().iterator();
            while (shardRouting2.hasNext()) {
                ShardRouting shardRouting3;
                shardRouting3 = shardRouting2.next();
                assert (shardRouting3.unassigned());
                if (!targetNodesIterator.hasNext()) continue block7;
                unassignedShardsToInitialize.computeIfAbsent(shardRouting3, ignored -> new LinkedList()).add(targetNodesIterator.next());
            }
        }
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedPrimaryIterator = routingNodes.unassigned().iterator();
        while (unassignedPrimaryIterator.hasNext()) {
            String nodeId;
            RoutingNode routingNode;
            LinkedList nodeIds;
            ShardRouting shardRouting = unassignedPrimaryIterator.next();
            if (!shardRouting.primary() || (nodeIds = (LinkedList)unassignedShardsToInitialize.get(shardRouting)) == null || nodeIds.isEmpty() || (routingNode = routingNodes.node(nodeId = (String)nodeIds.removeFirst())) == null || routingAllocation.deciders().canAllocate(shardRouting, routingNode, routingAllocation).type() == Decision.Type.NO) continue;
            ShardRouting shardToInitialize = unassignedPrimaryIterator.initialize(nodeId, null, 0L, changes);
            clusterInfoSimulator.simulateShardStarted(shardToInitialize);
            routingNodes.startShard(logger, shardToInitialize, changes, 0L);
        }
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedReplicaIterator = routingNodes.unassigned().iterator();
        while (unassignedReplicaIterator.hasNext()) {
            String nodeId;
            RoutingNode routingNode;
            Object nodeIds;
            ShardRouting shardRouting = unassignedReplicaIterator.next();
            if (unassignedPrimaries.contains(shardRouting.shardId()) || (nodeIds = (LinkedList)unassignedShardsToInitialize.get(shardRouting)) == null || ((AbstractCollection)nodeIds).isEmpty() || (routingNode = routingNodes.node(nodeId = (String)((LinkedList)nodeIds).removeFirst())) == null || routingAllocation.deciders().canAllocate(shardRouting, routingNode, routingAllocation).type() == Decision.Type.NO) continue;
            ShardRouting shardToInitialize = unassignedReplicaIterator.initialize(nodeId, null, 0L, changes);
            clusterInfoSimulator.simulateShardStarted(shardToInitialize);
            routingNodes.startShard(logger, shardToInitialize, changes, 0L);
        }
        while ((commands = pendingDesiredBalanceMoves.poll()) != null) {
            for (MoveAllocationCommand command : commands) {
                try {
                    command.execute(routingAllocation, false);
                }
                catch (RuntimeException e) {
                    logger.debug(() -> "move shard [" + command.index() + ":" + command.shardId() + "] command failed during applying it to the desired balance", (Throwable)e);
                }
            }
        }
        int iterationCountReportInterval = DesiredBalanceComputer.computeIterationCountReportInterval(routingAllocation);
        long timeWarningInterval = this.progressLogInterval.millis();
        long computationStartedTime = this.threadPool.relativeTimeInMillis();
        long nextReportTime = computationStartedTime + timeWarningInterval;
        int i = 0;
        boolean hasChanges = false;
        while (true) {
            boolean reportByIterationCount;
            if (hasChanges) {
                routingNodes.unassigned().resetIgnored();
                RoutingNodes.UnassignedShards.UnassignedIterator iterator = routingNodes.unassigned().iterator();
                while (iterator.hasNext()) {
                    ShardRouting shardRouting = iterator.next();
                    if (!ignoredShards.contains(DesiredBalanceComputer.discardAllocationStatus(shardRouting))) continue;
                    iterator.removeAndIgnore(UnassignedInfo.AllocationStatus.NO_ATTEMPT, changes);
                }
            }
            routingAllocation.setSimulatedClusterInfo(clusterInfoSimulator.getClusterInfo());
            logger.trace("running delegate allocator");
            this.delegateAllocator.allocate(routingAllocation);
            assert (routingNodes.unassigned().isEmpty());
            hasChanges = false;
            for (RoutingNode routingNode : routingNodes) {
                for (ShardRouting shardRouting : routingNode) {
                    if (!shardRouting.initializing()) continue;
                    hasChanges = true;
                    clusterInfoSimulator.simulateShardStarted(shardRouting);
                    routingNodes.startShard(logger, shardRouting, changes, 0L);
                }
            }
            int iterations = ++i;
            long currentTime = this.threadPool.relativeTimeInMillis();
            boolean reportByTime = nextReportTime <= currentTime;
            boolean bl = reportByIterationCount = i % iterationCountReportInterval == 0;
            if (reportByTime || reportByIterationCount) {
                nextReportTime = currentTime + timeWarningInterval;
            }
            if (!hasChanges) {
                logger.debug("Desired balance computation for [{}] converged after [{}] and [{}] iterations", (Object)desiredBalanceInput.index(), (Object)TimeValue.timeValueMillis(currentTime - computationStartedTime).toString(), (Object)i);
                break;
            }
            if (!isFresh.test(desiredBalanceInput)) {
                logger.debug("Desired balance computation for [{}] interrupted after [{}] and [{}] iterations as newer cluster state received. Publishing intermediate desired balance and restarting computation", (Object)desiredBalanceInput.index(), (Object)i, (Object)TimeValue.timeValueMillis(currentTime - computationStartedTime).toString());
                break;
            }
            logger.log(reportByIterationCount || reportByTime ? Level.INFO : (i % 100 == 0 ? Level.DEBUG : Level.TRACE), () -> Strings.format("Desired balance computation for [%d] is still not converged after [%s] and [%d] iterations", desiredBalanceInput.index(), TimeValue.timeValueMillis(currentTime - computationStartedTime).toString(), iterations));
        }
        this.iterations.inc(i);
        Map<ShardId, ShardAssignment> assignments = DesiredBalanceComputer.collectShardAssignments(routingNodes);
        for (ShardRouting shard : routingNodes.unassigned().ignored()) {
            UnassignedInfo info = shard.unassignedInfo();
            assert (info != null && (info.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO || info.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.NO_ATTEMPT || info.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED)) : "Unexpected stats in: " + info;
            if (!hasChanges && info.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED) {
                hasChanges = true;
            }
            int ignored2 = shard.unassignedInfo().getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO ? 0 : 1;
            assignments.compute(shard.shardId(), (key, oldValue) -> oldValue == null ? new ShardAssignment(Set.of(), 1, 1, ignored2) : new ShardAssignment(oldValue.nodeIds(), oldValue.total() + 1, oldValue.unassigned() + 1, oldValue.ignored() + ignored2));
        }
        long lastConvergedIndex = hasChanges ? previousDesiredBalance.lastConvergedIndex() : desiredBalanceInput.index();
        return new DesiredBalance(lastConvergedIndex, assignments);
    }

    private static Map<ShardId, ShardAssignment> collectShardAssignments(RoutingNodes routingNodes) {
        Set<Map.Entry<ShardId, List<ShardRouting>>> entries = routingNodes.getAssignedShards().entrySet();
        assert (entries.stream().flatMap(t -> ((List)t.getValue()).stream()).allMatch(ShardRouting::started)) : routingNodes;
        Map<ShardId, ShardAssignment> res = Maps.newHashMapWithExpectedSize(entries.size());
        for (Map.Entry<ShardId, List<ShardRouting>> shardAndAssignments : entries) {
            res.put(shardAndAssignments.getKey(), ShardAssignment.ofAssignedShards(shardAndAssignments.getValue()));
        }
        return res;
    }

    private static Set<ShardRouting> getIgnoredShardsWithDiscardedAllocationStatus(List<ShardRouting> ignoredShards) {
        return ignoredShards.stream().map(DesiredBalanceComputer::discardAllocationStatus).collect(Collectors.toUnmodifiableSet());
    }

    private static ShardRouting discardAllocationStatus(ShardRouting shardRouting) {
        return shardRouting.updateUnassigned(DesiredBalanceComputer.discardAllocationStatus(shardRouting.unassignedInfo()), shardRouting.recoverySource());
    }

    private static UnassignedInfo discardAllocationStatus(UnassignedInfo info) {
        if (info.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.NO_ATTEMPT) {
            return info;
        }
        return new UnassignedInfo(info.getReason(), info.getMessage(), info.getFailure(), info.getNumFailedAllocations(), info.getUnassignedTimeInNanos(), info.getUnassignedTimeInMillis(), info.isDelayed(), UnassignedInfo.AllocationStatus.NO_ATTEMPT, info.getFailedNodeIds(), info.getLastAllocatedNodeId());
    }

    private static int computeIterationCountReportInterval(RoutingAllocation allocation) {
        int iterations;
        int relativeSize = allocation.metadata().getTotalNumberOfShards();
        for (iterations = 1000; iterations < relativeSize && iterations < 1000000000; iterations *= 10) {
        }
        return iterations;
    }

    private record ShardRoutings(List<ShardRouting> unassigned, List<ShardRouting> assigned) {
        private ShardRoutings(ShardId ignored) {
            this(new ArrayList<ShardRouting>(), new ArrayList<ShardRouting>());
        }
    }
}

