/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.admin.indices.rollover.RolloverInfo;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.DataStreamAutoShardingEvent;
import org.elasticsearch.cluster.metadata.DataStreamGlobalRetention;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public final class DataStream
implements SimpleDiffable<DataStream>,
ToXContentObject,
IndexAbstraction {
    public static final FeatureFlag FAILURE_STORE_FEATURE_FLAG = new FeatureFlag("failure_store");
    public static final TransportVersion ADDED_FAILURE_STORE_TRANSPORT_VERSION = TransportVersions.V_8_12_0;
    public static final TransportVersion ADDED_AUTO_SHARDING_EVENT_VERSION = TransportVersions.DATA_STREAM_AUTO_SHARDING_EVENT;
    public static final String BACKING_INDEX_PREFIX = ".ds-";
    public static final String FAILURE_STORE_PREFIX = ".fs-";
    public static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern("uuuu.MM.dd");
    public static final String TIMESTAMP_FIELD_NAME = "@timestamp";
    public static Comparator<LeafReader> TIMESERIES_LEAF_READERS_SORTER = Comparator.comparingLong(r -> {
        try {
            PointValues points = r.getPointValues(TIMESTAMP_FIELD_NAME);
            if (points != null) {
                byte[] sortValue = points.getMaxPackedValue();
                return LongPoint.decodeDimension(sortValue, 0);
            }
            return Long.MIN_VALUE;
        }
        catch (IOException e) {
            throw new ElasticsearchException("Can't access [@timestamp] field for the index!", (Throwable)e, new Object[0]);
        }
    }).reversed();
    private final LongSupplier timeProvider;
    private final String name;
    private final List<Index> indices;
    private final long generation;
    @Nullable
    private final Map<String, Object> metadata;
    private final boolean hidden;
    private final boolean replicated;
    private final boolean system;
    private final boolean allowCustomRouting;
    @Nullable
    private final IndexMode indexMode;
    @Nullable
    private final DataStreamLifecycle lifecycle;
    private final boolean rolloverOnWrite;
    private final boolean failureStoreEnabled;
    private final List<Index> failureIndices;
    private volatile Set<String> failureStoreLookup;
    @Nullable
    private final DataStreamAutoShardingEvent autoShardingEvent;
    public static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    public static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
    public static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    public static final ParseField GENERATION_FIELD = new ParseField("generation", new String[0]);
    public static final ParseField METADATA_FIELD = new ParseField("_meta", new String[0]);
    public static final ParseField HIDDEN_FIELD = new ParseField("hidden", new String[0]);
    public static final ParseField REPLICATED_FIELD = new ParseField("replicated", new String[0]);
    public static final ParseField SYSTEM_FIELD = new ParseField("system", new String[0]);
    public static final ParseField ALLOW_CUSTOM_ROUTING = new ParseField("allow_custom_routing", new String[0]);
    public static final ParseField INDEX_MODE = new ParseField("index_mode", new String[0]);
    public static final ParseField LIFECYCLE = new ParseField("lifecycle", new String[0]);
    public static final ParseField FAILURE_STORE_FIELD = new ParseField("failure_store", new String[0]);
    public static final ParseField FAILURE_INDICES_FIELD = new ParseField("failure_indices", new String[0]);
    public static final ParseField ROLLOVER_ON_WRITE_FIELD = new ParseField("rollover_on_write", new String[0]);
    public static final ParseField AUTO_SHARDING_FIELD = new ParseField("auto_sharding", new String[0]);
    private static final ConstructingObjectParser<DataStream, Void> PARSER = new ConstructingObjectParser("data_stream", args -> {
        boolean failureStoreEnabled = DataStream.isFailureStoreFeatureFlagEnabled() && args[12] != null && (Boolean)args[12] != false;
        List failureStoreIndices = DataStream.isFailureStoreFeatureFlagEnabled() && args[13] != null ? (List)args[13] : List.of();
        return new DataStream((String)args[0], (List)args[1], (Long)args[2], (Map)args[3], args[4] != null && (Boolean)args[4] != false, args[5] != null && (Boolean)args[5] != false, args[6] != null && (Boolean)args[6] != false, args[7] != null && (Boolean)args[7] != false, args[8] != null ? IndexMode.fromString((String)args[8]) : null, (DataStreamLifecycle)args[9], failureStoreEnabled, failureStoreIndices, args[10] != null && (Boolean)args[10] != false, (DataStreamAutoShardingEvent)args[11]);
    });
    public static final XContentParserConfiguration TS_EXTRACT_CONFIG;
    private static final DateFormatter TIMESTAMP_FORMATTER;

    public static boolean isFailureStoreFeatureFlagEnabled() {
        return FAILURE_STORE_FEATURE_FLAG.isEnabled();
    }

    public DataStream(String name, List<Index> indices, long generation, Map<String, Object> metadata, boolean hidden, boolean replicated, boolean system, boolean allowCustomRouting, IndexMode indexMode, DataStreamLifecycle lifecycle, boolean failureStoreEnabled, List<Index> failureIndices, boolean rolloverOnWrite, @Nullable DataStreamAutoShardingEvent autoShardingEvent) {
        this(name, indices, generation, metadata, hidden, replicated, system, System::currentTimeMillis, allowCustomRouting, indexMode, lifecycle, failureStoreEnabled, failureIndices, rolloverOnWrite, autoShardingEvent);
    }

    DataStream(String name, List<Index> indices, long generation, Map<String, Object> metadata, boolean hidden, boolean replicated, boolean system, LongSupplier timeProvider, boolean allowCustomRouting, IndexMode indexMode, DataStreamLifecycle lifecycle, boolean failureStoreEnabled, List<Index> failureIndices, boolean rolloverOnWrite, @Nullable DataStreamAutoShardingEvent autoShardingEvent) {
        this.name = name;
        this.indices = List.copyOf(indices);
        assert (!indices.isEmpty());
        this.generation = generation;
        this.metadata = metadata;
        assert (!system || hidden);
        this.hidden = hidden;
        this.replicated = replicated;
        this.timeProvider = timeProvider;
        this.system = system;
        this.allowCustomRouting = allowCustomRouting;
        this.indexMode = indexMode;
        this.lifecycle = lifecycle;
        this.failureStoreEnabled = failureStoreEnabled;
        this.failureIndices = failureIndices;
        assert (DataStream.assertConsistent(this.indices));
        assert (!replicated || !rolloverOnWrite) : "replicated data streams cannot be marked for lazy rollover";
        this.rolloverOnWrite = rolloverOnWrite;
        this.autoShardingEvent = autoShardingEvent;
    }

    private static boolean assertConsistent(List<Index> indices) {
        assert (indices.size() > 0);
        HashSet<String> indexNames = new HashSet<String>();
        for (Index index : indices) {
            boolean added = indexNames.add(index.getName());
            assert (added) : "found duplicate index entries in " + indices;
        }
        return true;
    }

    @Override
    public IndexAbstraction.Type getType() {
        return IndexAbstraction.Type.DATA_STREAM;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDataStreamRelated() {
        return true;
    }

    @Override
    public List<Index> getIndices() {
        return this.indices;
    }

    public long getGeneration() {
        return this.generation;
    }

    public List<Index> getFailureIndices() {
        return this.failureIndices;
    }

    @Override
    public Index getWriteIndex() {
        return this.indices.get(this.indices.size() - 1);
    }

    @Nullable
    public Index getFailureStoreWriteIndex() {
        return !this.isFailureStoreEnabled() || this.failureIndices.isEmpty() ? null : this.failureIndices.get(this.failureIndices.size() - 1);
    }

    public boolean isFailureStoreIndex(String indexName) {
        if (this.failureStoreLookup == null) {
            this.failureStoreLookup = this.failureIndices == null || this.failureIndices.isEmpty() ? Set.of() : this.failureIndices.stream().map(Index::getName).collect(Collectors.toSet());
        }
        return this.failureStoreLookup.contains(indexName);
    }

    public boolean rolloverOnWrite() {
        return this.rolloverOnWrite;
    }

    public Index selectTimeSeriesWriteIndex(Instant timestamp, Metadata metadata) {
        for (int i = this.indices.size() - 1; i >= 0; --i) {
            Index index = this.indices.get(i);
            IndexMetadata im = metadata.index(index);
            if (im.getIndexMode() != IndexMode.TIME_SERIES) continue;
            Instant start = im.getTimeSeriesStart();
            Instant end = im.getTimeSeriesEnd();
            if (timestamp.compareTo(start) < 0 || timestamp.compareTo(end) >= 0) continue;
            return index;
        }
        return null;
    }

    public void validate(Function<String, IndexMetadata> imSupplier) {
        if (this.indexMode == IndexMode.TIME_SERIES) {
            List<Tuple> startAndEndTimes = this.indices.stream().map(index -> {
                IndexMetadata im = (IndexMetadata)imSupplier.apply(index.getName());
                if (im == null) {
                    throw new IllegalStateException("index [" + index.getName() + "] is not found in the index metadata supplier");
                }
                return im;
            }).filter(im -> im.getTimeSeriesStart() != null && im.getTimeSeriesEnd() != null).map(im -> {
                Instant start = im.getTimeSeriesStart();
                Instant end = im.getTimeSeriesEnd();
                assert (end.isAfter(start));
                return new Tuple<String, Tuple<Instant, Instant>>(im.getIndex().getName(), new Tuple<Instant, Instant>(start, end));
            }).sorted(Comparator.comparing(entry -> (Instant)((Tuple)entry.v2()).v1())).toList();
            Tuple previous = null;
            DateFormatter formatter = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;
            for (Tuple current : startAndEndTimes) {
                if (previous == null) {
                    previous = current;
                    continue;
                }
                if (((Instant)((Tuple)previous.v2()).v2()).compareTo((Instant)((Tuple)current.v2()).v1()) <= 0) continue;
                String range1 = formatter.format((TemporalAccessor)((Tuple)previous.v2()).v1()) + " TO " + formatter.format((TemporalAccessor)((Tuple)previous.v2()).v2());
                String range2 = formatter.format((TemporalAccessor)((Tuple)current.v2()).v1()) + " TO " + formatter.format((TemporalAccessor)((Tuple)current.v2()).v2());
                throw new IllegalArgumentException("backing index [" + (String)previous.v1() + "] with range [" + range1 + "] is overlapping with backing index [" + (String)current.v1() + "] with range [" + range2 + "]");
            }
        }
    }

    @Nullable
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    @Override
    public boolean isSystem() {
        return this.system;
    }

    public boolean isAllowCustomRouting() {
        return this.allowCustomRouting;
    }

    public boolean isFailureStoreEnabled() {
        return this.failureStoreEnabled;
    }

    @Nullable
    public IndexMode getIndexMode() {
        return this.indexMode;
    }

    @Nullable
    public DataStreamLifecycle getLifecycle() {
        return this.lifecycle;
    }

    public DataStreamAutoShardingEvent getAutoShardingEvent() {
        return this.autoShardingEvent;
    }

    public DataStream rollover(Index writeIndex, long generation, boolean timeSeries, @Nullable DataStreamAutoShardingEvent autoShardingEvent) {
        this.ensureNotReplicated();
        return this.unsafeRollover(writeIndex, generation, timeSeries, autoShardingEvent);
    }

    public DataStream unsafeRollover(Index writeIndex, long generation, boolean timeSeries, DataStreamAutoShardingEvent autoShardingEvent) {
        IndexMode indexMode = this.indexMode;
        if ((indexMode == null || indexMode == IndexMode.STANDARD) && timeSeries) {
            indexMode = IndexMode.TIME_SERIES;
        } else if (indexMode == IndexMode.TIME_SERIES && !timeSeries) {
            indexMode = null;
        }
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.add(writeIndex);
        return this.copy().setIndices(backingIndices).setGeneration(generation).setReplicated(false).setIndexMode(indexMode).setAutoShardingEvent(autoShardingEvent).setRolloverOnWrite(false).build();
    }

    public DataStream rolloverFailureStore(Index writeIndex, long generation) {
        this.ensureNotReplicated();
        return this.unsafeRolloverFailureStore(writeIndex, generation);
    }

    public DataStream unsafeRolloverFailureStore(Index writeIndex, long generation) {
        ArrayList<Index> failureIndices = new ArrayList<Index>(this.failureIndices);
        failureIndices.add(writeIndex);
        return this.copy().setGeneration(generation).setReplicated(false).setFailureIndices(failureIndices).build();
    }

    public Tuple<String, Long> nextWriteIndexAndGeneration(Metadata clusterMetadata) {
        this.ensureNotReplicated();
        return this.unsafeNextWriteIndexAndGeneration(clusterMetadata);
    }

    public Tuple<String, Long> unsafeNextWriteIndexAndGeneration(Metadata clusterMetadata) {
        return this.generateNextWriteIndexAndGeneration(clusterMetadata, DataStream::getDefaultBackingIndexName);
    }

    public Tuple<String, Long> nextFailureStoreWriteIndexAndGeneration(Metadata clusterMetadata) {
        this.ensureNotReplicated();
        return this.unsafeNextFailureStoreWriteIndexAndGeneration(clusterMetadata);
    }

    public Tuple<String, Long> unsafeNextFailureStoreWriteIndexAndGeneration(Metadata clusterMetadata) {
        return this.generateNextWriteIndexAndGeneration(clusterMetadata, DataStream::getDefaultFailureStoreName);
    }

    private Tuple<String, Long> generateNextWriteIndexAndGeneration(Metadata clusterMetadata, TriFunction<String, Long, Long, String> nameGenerator) {
        String newWriteIndexName;
        long generation = this.generation;
        long currentTimeMillis = this.timeProvider.getAsLong();
        while (clusterMetadata.hasIndexAbstraction(newWriteIndexName = nameGenerator.apply(this.getName(), ++generation, currentTimeMillis))) {
        }
        return Tuple.tuple(newWriteIndexName, generation);
    }

    private void ensureNotReplicated() {
        if (this.replicated) {
            throw new IllegalArgumentException("data stream [" + this.name + "] cannot be rolled over, because it is a replicated data stream");
        }
    }

    public DataStream removeBackingIndex(Index index) {
        int backingIndexPosition = this.indices.indexOf(index);
        if (backingIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s]", index.getName(), this.name));
        }
        if (this.indices.size() == backingIndexPosition + 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot remove backing index [%s] of data stream [%s] because it is the write index", index.getName(), this.name));
        }
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.remove(index);
        assert (backingIndices.size() == this.indices.size() - 1);
        return this.copy().setIndices(backingIndices).setGeneration(this.generation + 1L).build();
    }

    public DataStream removeFailureStoreIndex(Index index) {
        int failureIndexPosition = this.failureIndices.indexOf(index);
        if (failureIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s] failure store", index.getName(), this.name));
        }
        if (this.failureIndices.size() == failureIndexPosition + 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot remove backing index [%s] of data stream [%s] because it is the write index", index.getName(), this.name));
        }
        ArrayList<Index> updatedFailureIndices = new ArrayList<Index>(this.failureIndices);
        updatedFailureIndices.remove(index);
        assert (updatedFailureIndices.size() == this.failureIndices.size() - 1);
        return this.copy().setGeneration(this.generation + 1L).setFailureIndices(updatedFailureIndices).build();
    }

    public DataStream replaceBackingIndex(Index existingBackingIndex, Index newBackingIndex) {
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        int backingIndexPosition = backingIndices.indexOf(existingBackingIndex);
        if (backingIndexPosition == -1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not part of data stream [%s]", existingBackingIndex.getName(), this.name));
        }
        if (this.indices.size() == backingIndexPosition + 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot replace backing index [%s] of data stream [%s] because it is the write index", existingBackingIndex.getName(), this.name));
        }
        backingIndices.set(backingIndexPosition, newBackingIndex);
        return this.copy().setIndices(backingIndices).setGeneration(this.generation + 1L).build();
    }

    public DataStream addBackingIndex(Metadata clusterMetadata, Index index) {
        DataStream parentDataStream = ((IndexAbstraction)clusterMetadata.getIndicesLookup().get(index.getName())).getParentDataStream();
        if (parentDataStream != null) {
            this.validateDataStreamAlreadyContainsIndex(index, parentDataStream, false);
            return this;
        }
        this.ensureNoAliasesOnIndex(clusterMetadata, index);
        ArrayList<Index> backingIndices = new ArrayList<Index>(this.indices);
        backingIndices.add(0, index);
        assert (backingIndices.size() == this.indices.size() + 1);
        return this.copy().setIndices(backingIndices).setGeneration(this.generation + 1L).build();
    }

    public DataStream addFailureStoreIndex(Metadata clusterMetadata, Index index) {
        DataStream parentDataStream = ((IndexAbstraction)clusterMetadata.getIndicesLookup().get(index.getName())).getParentDataStream();
        if (parentDataStream != null) {
            this.validateDataStreamAlreadyContainsIndex(index, parentDataStream, true);
            return this;
        }
        this.ensureNoAliasesOnIndex(clusterMetadata, index);
        ArrayList<Index> updatedFailureIndices = new ArrayList<Index>(this.failureIndices);
        updatedFailureIndices.add(0, index);
        assert (updatedFailureIndices.size() == this.failureIndices.size() + 1);
        return this.copy().setGeneration(this.generation + 1L).setFailureIndices(updatedFailureIndices).build();
    }

    private void validateDataStreamAlreadyContainsIndex(Index index, DataStream parentDataStream, boolean targetFailureStore) {
        if (!parentDataStream.equals(this) || parentDataStream.isFailureStoreIndex(index.getName()) != targetFailureStore) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot add index [%s] to data stream [%s] because it is already a %s index on data stream [%s]", index.getName(), this.getName(), parentDataStream.isFailureStoreIndex(index.getName()) ? "failure store" : "backing", parentDataStream.getName()));
        }
    }

    private void ensureNoAliasesOnIndex(Metadata clusterMetadata, Index index) {
        IndexMetadata im = clusterMetadata.index(((IndexAbstraction)clusterMetadata.getIndicesLookup().get(index.getName())).getWriteIndex());
        if (im.getAliases().size() > 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot add index [%s] to data stream [%s] until its %s [%s] %s removed", index.getName(), this.getName(), im.getAliases().size() > 1 ? "aliases" : "alias", Strings.collectionToCommaDelimitedString(im.getAliases().keySet().stream().sorted().toList()), im.getAliases().size() > 1 ? "are" : "is"));
        }
    }

    public DataStream promoteDataStream() {
        return this.copy().setReplicated(false).build();
    }

    @Nullable
    public DataStream snapshot(Collection<String> indicesInSnapshot) {
        ArrayList<Index> reconciledIndices = new ArrayList<Index>(this.indices);
        if (!reconciledIndices.removeIf(x -> !indicesInSnapshot.contains(x.getName()))) {
            return this;
        }
        if (reconciledIndices.size() == 0) {
            return null;
        }
        return this.copy().setIndices(reconciledIndices).setMetadata((Map<String, Object>)(this.metadata == null ? null : new HashMap<String, Object>(this.metadata))).build();
    }

    public List<Index> getIndicesPastRetention(Function<String, IndexMetadata> indexMetadataSupplier, LongSupplier nowSupplier, DataStreamGlobalRetention globalRetention) {
        if (this.lifecycle == null || !this.lifecycle.isEnabled() || this.lifecycle.getEffectiveDataRetention(globalRetention) == null) {
            return List.of();
        }
        List<Index> indicesPastRetention = this.getNonWriteIndicesOlderThan(this.lifecycle.getEffectiveDataRetention(globalRetention), indexMetadataSupplier, this::isIndexManagedByDataStreamLifecycle, nowSupplier);
        return indicesPastRetention;
    }

    public List<DataStreamLifecycle.Downsampling.Round> getDownsamplingRoundsFor(Index index, Function<String, IndexMetadata> indexMetadataSupplier, LongSupplier nowSupplier) {
        assert (this.indices.contains(index)) : "the provided index must be a backing index for this datastream";
        if (this.lifecycle == null || this.lifecycle.getDownsamplingRounds() == null) {
            return List.of();
        }
        IndexMetadata indexMetadata = indexMetadataSupplier.apply(index.getName());
        if (indexMetadata == null || IndexSettings.MODE.get(indexMetadata.getSettings()) != IndexMode.TIME_SERIES) {
            return List.of();
        }
        TimeValue indexGenerationTime = this.getGenerationLifecycleDate(indexMetadata);
        if (indexGenerationTime != null) {
            long nowMillis = nowSupplier.getAsLong();
            long indexGenerationTimeMillis = indexGenerationTime.millis();
            ArrayList<DataStreamLifecycle.Downsampling.Round> orderedRoundsForIndex = new ArrayList<DataStreamLifecycle.Downsampling.Round>(this.lifecycle.getDownsamplingRounds().size());
            for (DataStreamLifecycle.Downsampling.Round round : this.lifecycle.getDownsamplingRounds()) {
                if (nowMillis < indexGenerationTimeMillis + round.after().getMillis()) continue;
                orderedRoundsForIndex.add(round);
            }
            return orderedRoundsForIndex;
        }
        return List.of();
    }

    public List<Index> getNonWriteIndicesOlderThan(TimeValue retentionPeriod, Function<String, IndexMetadata> indexMetadataSupplier, @Nullable Predicate<IndexMetadata> indicesPredicate, LongSupplier nowSupplier) {
        ArrayList<Index> olderIndices = new ArrayList<Index>();
        for (Index index : this.indices) {
            if (!this.isIndexOderThan(index, retentionPeriod.getMillis(), nowSupplier.getAsLong(), indicesPredicate, indexMetadataSupplier)) continue;
            olderIndices.add(index);
        }
        return olderIndices;
    }

    private boolean isIndexOderThan(Index index, long retentionPeriod, long now, Predicate<IndexMetadata> indicesPredicate, Function<String, IndexMetadata> indexMetadataSupplier) {
        IndexMetadata indexMetadata = indexMetadataSupplier.apply(index.getName());
        if (indexMetadata == null) {
            return false;
        }
        TimeValue indexLifecycleDate = this.getGenerationLifecycleDate(indexMetadata);
        return indexLifecycleDate != null && now >= indexLifecycleDate.getMillis() + retentionPeriod && (indicesPredicate == null || indicesPredicate.test(indexMetadata));
    }

    public boolean isIndexManagedByDataStreamLifecycle(Index index, Function<String, IndexMetadata> indexMetadataSupplier) {
        if (!this.indices.contains(index)) {
            return false;
        }
        IndexMetadata indexMetadata = indexMetadataSupplier.apply(index.getName());
        if (indexMetadata == null) {
            return false;
        }
        return this.isIndexManagedByDataStreamLifecycle(indexMetadata);
    }

    private boolean isIndexManagedByDataStreamLifecycle(IndexMetadata indexMetadata) {
        if (indexMetadata.getLifecyclePolicyName() != null && this.lifecycle != null && this.lifecycle.isEnabled()) {
            return IndexSettings.PREFER_ILM_SETTING.get(indexMetadata.getSettings()) == false;
        }
        return this.lifecycle != null && this.lifecycle.isEnabled();
    }

    @Nullable
    public TimeValue getGenerationLifecycleDate(IndexMetadata indexMetadata) {
        if (indexMetadata.getIndex().equals(this.getWriteIndex())) {
            return null;
        }
        Long originationDate = indexMetadata.getSettings().getAsLong("index.lifecycle.origination_date", null);
        RolloverInfo rolloverInfo = indexMetadata.getRolloverInfos().get(this.getName());
        if (rolloverInfo != null) {
            return TimeValue.timeValueMillis(Objects.requireNonNullElseGet(originationDate, rolloverInfo::getTime));
        }
        return TimeValue.timeValueMillis(Objects.requireNonNullElseGet(originationDate, indexMetadata::getCreationDate));
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation) {
        return DataStream.getDefaultBackingIndexName(dataStreamName, generation, System.currentTimeMillis());
    }

    public static String getDefaultBackingIndexName(String dataStreamName, long generation, long epochMillis) {
        return String.format(Locale.ROOT, ".ds-%s-%s-%06d", dataStreamName, DATE_FORMATTER.formatMillis(epochMillis), generation);
    }

    public static String getDefaultFailureStoreName(String dataStreamName, long generation, long epochMillis) {
        return String.format(Locale.ROOT, ".fs-%s-%s-%06d", dataStreamName, DATE_FORMATTER.formatMillis(epochMillis), generation);
    }

    public DataStream(StreamInput in) throws IOException {
        this(DataStream.readName(in), DataStream.readIndices(in), in.readVLong(), in.readGenericMap(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0) ? in.readBoolean() : false, in.getTransportVersion().onOrAfter(TransportVersions.V_8_1_0) ? in.readOptionalEnum(IndexMode.class) : null, in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? in.readOptionalWriteable(DataStreamLifecycle::new) : null, in.getTransportVersion().onOrAfter(ADDED_FAILURE_STORE_TRANSPORT_VERSION) ? in.readBoolean() : false, in.getTransportVersion().onOrAfter(ADDED_FAILURE_STORE_TRANSPORT_VERSION) ? DataStream.readIndices(in) : List.of(), in.getTransportVersion().onOrAfter(TransportVersions.LAZY_ROLLOVER_ADDED) ? in.readBoolean() : false, in.getTransportVersion().onOrAfter(ADDED_AUTO_SHARDING_EVENT_VERSION) ? in.readOptionalWriteable(DataStreamAutoShardingEvent::new) : null);
    }

    static String readName(StreamInput in) throws IOException {
        String name = in.readString();
        in.readString();
        return name;
    }

    static List<Index> readIndices(StreamInput in) throws IOException {
        return in.readCollectionAsImmutableList(Index::new);
    }

    public static Diff<DataStream> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(DataStream::new, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(TIMESTAMP_FIELD_NAME);
        out.writeCollection(this.indices);
        out.writeVLong(this.generation);
        out.writeGenericMap(this.metadata);
        out.writeBoolean(this.hidden);
        out.writeBoolean(this.replicated);
        out.writeBoolean(this.system);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_0_0)) {
            out.writeBoolean(this.allowCustomRouting);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_1_0)) {
            out.writeOptionalEnum(this.indexMode);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            out.writeOptionalWriteable(this.lifecycle);
        }
        if (out.getTransportVersion().onOrAfter(ADDED_FAILURE_STORE_TRANSPORT_VERSION)) {
            out.writeBoolean(this.failureStoreEnabled);
            out.writeCollection(this.failureIndices);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.LAZY_ROLLOVER_ADDED)) {
            out.writeBoolean(this.rolloverOnWrite);
        }
        if (out.getTransportVersion().onOrAfter(ADDED_AUTO_SHARDING_EVENT_VERSION)) {
            out.writeOptionalWriteable(this.autoShardingEvent);
        }
    }

    public static DataStream fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration, @Nullable DataStreamGlobalRetention globalRetention) throws IOException {
        builder.startObject();
        builder.field(NAME_FIELD.getPreferredName(), this.name);
        builder.field(TIMESTAMP_FIELD_FIELD.getPreferredName()).startObject().field(NAME_FIELD.getPreferredName(), TIMESTAMP_FIELD_NAME).endObject();
        builder.xContentList(INDICES_FIELD.getPreferredName(), this.indices);
        builder.field(GENERATION_FIELD.getPreferredName(), this.generation);
        if (DataStream.isFailureStoreFeatureFlagEnabled() && !this.failureIndices.isEmpty()) {
            builder.xContentList(FAILURE_INDICES_FIELD.getPreferredName(), this.failureIndices);
        }
        if (this.metadata != null) {
            builder.field(METADATA_FIELD.getPreferredName(), this.metadata);
        }
        builder.field(HIDDEN_FIELD.getPreferredName(), this.hidden);
        builder.field(REPLICATED_FIELD.getPreferredName(), this.replicated);
        builder.field(SYSTEM_FIELD.getPreferredName(), this.system);
        builder.field(ALLOW_CUSTOM_ROUTING.getPreferredName(), this.allowCustomRouting);
        if (DataStream.isFailureStoreFeatureFlagEnabled()) {
            builder.field(FAILURE_STORE_FIELD.getPreferredName(), this.failureStoreEnabled);
        }
        if (this.indexMode != null) {
            builder.field(INDEX_MODE.getPreferredName(), this.indexMode);
        }
        if (this.lifecycle != null) {
            builder.field(LIFECYCLE.getPreferredName());
            this.lifecycle.toXContent(builder, params, rolloverConfiguration, globalRetention);
        }
        builder.field(ROLLOVER_ON_WRITE_FIELD.getPreferredName(), this.rolloverOnWrite);
        if (this.autoShardingEvent != null) {
            builder.startObject(AUTO_SHARDING_FIELD.getPreferredName());
            this.autoShardingEvent.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataStream that = (DataStream)o;
        return this.name.equals(that.name) && this.indices.equals(that.indices) && this.generation == that.generation && Objects.equals(this.metadata, that.metadata) && this.hidden == that.hidden && this.system == that.system && this.replicated == that.replicated && this.allowCustomRouting == that.allowCustomRouting && this.indexMode == that.indexMode && Objects.equals(this.lifecycle, that.lifecycle) && this.failureStoreEnabled == that.failureStoreEnabled && this.failureIndices.equals(that.failureIndices) && this.rolloverOnWrite == that.rolloverOnWrite && Objects.equals(this.autoShardingEvent, that.autoShardingEvent);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.indices, this.generation, this.metadata, this.hidden, this.system, this.replicated, this.allowCustomRouting, this.indexMode, this.lifecycle, this.failureStoreEnabled, this.failureIndices, this.rolloverOnWrite, this.autoShardingEvent});
    }

    @Override
    public Index getWriteIndex(IndexRequest request, Metadata metadata) {
        if (request.opType() != DocWriteRequest.OpType.CREATE) {
            return this.getWriteIndex();
        }
        if (this.getIndexMode() != IndexMode.TIME_SERIES) {
            return this.getWriteIndex();
        }
        Object rawTimestamp = request.getRawTimestamp();
        Instant timestamp = rawTimestamp != null ? DataStream.getTimeStampFromRaw(rawTimestamp) : DataStream.getTimestampFromParser(request.source(), request.getContentType());
        Index result = this.selectTimeSeriesWriteIndex(timestamp = DataStream.getCanonicalTimestampBound(timestamp), metadata);
        if (result == null) {
            String timestampAsString = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.format(timestamp);
            String writeableIndicesString = this.getIndices().stream().map(metadata::index).map(IndexMetadata::getSettings).map(settings -> "[" + settings.get(IndexSettings.TIME_SERIES_START_TIME.getKey()) + "," + settings.get(IndexSettings.TIME_SERIES_END_TIME.getKey()) + "]").collect(Collectors.joining());
            throw new IllegalArgumentException("the document timestamp [" + timestampAsString + "] is outside of ranges of currently writable indices [" + writeableIndicesString + "]");
        }
        return result;
    }

    @Override
    public DataStream getParentDataStream() {
        return null;
    }

    public static List<Index> getIndicesWithinMaxAgeRange(DataStream dataStream, Function<Index, IndexMetadata> indexProvider, TimeValue maxIndexAge, LongSupplier nowSupplier) {
        List<Index> dataStreamIndices = dataStream.getIndices();
        long currentTimeMillis = nowSupplier.getAsLong();
        int firstIndexWithinAgeRange = Math.max(dataStreamIndices.size() - 2, 0);
        for (int i = 0; i < dataStreamIndices.size(); ++i) {
            Index index = dataStreamIndices.get(i);
            IndexMetadata indexMetadata = indexProvider.apply(index);
            long indexAge = currentTimeMillis - indexMetadata.getCreationDate();
            if (indexAge >= maxIndexAge.getMillis()) continue;
            firstIndexWithinAgeRange = i == 0 ? 0 : i - 1;
            break;
        }
        return dataStreamIndices.subList(firstIndexWithinAgeRange, dataStreamIndices.size());
    }

    private static Instant getTimeStampFromRaw(Object rawTimestamp) {
        try {
            if (rawTimestamp instanceof Long) {
                Long lTimestamp = (Long)rawTimestamp;
                return Instant.ofEpochMilli(lTimestamp);
            }
            if (rawTimestamp instanceof String) {
                String sTimestamp = (String)rawTimestamp;
                return DateFormatters.from(TIMESTAMP_FORMATTER.parse(sTimestamp), TIMESTAMP_FORMATTER.locale()).toInstant();
            }
            throw new IllegalArgumentException("timestamp [" + rawTimestamp + "] type [" + rawTimestamp.getClass() + "] error");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error get data stream timestamp field: " + e.getMessage(), e);
        }
    }

    private static Instant getTimestampFromParser(BytesReference source, XContentType xContentType) {
        Instant instant;
        block12: {
            XContentParser parser = XContentHelper.createParserNotCompressed(TS_EXTRACT_CONFIG, source, xContentType);
            try {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
                instant = switch (parser.nextToken()) {
                    case XContentParser.Token.VALUE_STRING -> DateFormatters.from(TIMESTAMP_FORMATTER.parse(parser.text()), TIMESTAMP_FORMATTER.locale()).toInstant();
                    case XContentParser.Token.VALUE_NUMBER -> Instant.ofEpochMilli(parser.longValue());
                    default -> throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "Failed to parse object: expecting token of type [%s] or [%s] but found [%s]", new Object[]{XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NUMBER, parser.currentToken()}), new Object[0]);
                };
                if (parser == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error extracting data stream timestamp field: " + e.getMessage(), e);
                }
            }
            parser.close();
        }
        return instant;
    }

    public static Instant getCanonicalTimestampBound(Instant time) {
        return time.truncatedTo(ChronoUnit.SECONDS);
    }

    public static Builder builder(String name, List<Index> indices) {
        return new Builder(name, indices);
    }

    public Builder copy() {
        return new Builder(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        ConstructingObjectParser tsFieldParser = new ConstructingObjectParser("timestamp_field", args -> {
            if (!TIMESTAMP_FIELD_NAME.equals(args[0])) {
                throw new IllegalArgumentException("unexpected timestamp field [" + args[0] + "]");
            }
            return TIMESTAMP_FIELD_NAME;
        });
        tsFieldParser.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        PARSER.declareObject((f, v) -> {
            assert (v == TIMESTAMP_FIELD_NAME);
        }, tsFieldParser, TIMESTAMP_FIELD_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> Index.fromXContent(p), INDICES_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), GENERATION_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), HIDDEN_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), REPLICATED_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), SYSTEM_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ALLOW_CUSTOM_ROUTING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEX_MODE);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataStreamLifecycle.fromXContent(p), LIFECYCLE);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ROLLOVER_ON_WRITE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataStreamAutoShardingEvent.fromXContent(p), AUTO_SHARDING_FIELD);
        if (DataStream.isFailureStoreFeatureFlagEnabled()) {
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FAILURE_STORE_FIELD);
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Index.fromXContent(p), FAILURE_INDICES_FIELD);
        }
        TS_EXTRACT_CONFIG = XContentParserConfiguration.EMPTY.withFiltering(Set.of(TIMESTAMP_FIELD_NAME), null, false);
        TIMESTAMP_FORMATTER = DateFormatter.forPattern("strict_date_optional_time_nanos||strict_date_optional_time||epoch_millis");
    }

    public static class Builder {
        private LongSupplier timeProvider = System::currentTimeMillis;
        private String name;
        private List<Index> indices;
        private long generation = 1L;
        @Nullable
        private Map<String, Object> metadata = null;
        private boolean hidden = false;
        private boolean replicated = false;
        private boolean system = false;
        private boolean allowCustomRouting = false;
        @Nullable
        private IndexMode indexMode = null;
        @Nullable
        private DataStreamLifecycle lifecycle = null;
        private boolean rolloverOnWrite = false;
        private boolean failureStoreEnabled = false;
        private List<Index> failureIndices = List.of();
        @Nullable
        private DataStreamAutoShardingEvent autoShardingEvent = null;

        public Builder(String name, List<Index> indices) {
            this.name = name;
            assert (!indices.isEmpty()) : "Cannot create data stream with empty backing indices";
            this.indices = indices;
        }

        public Builder(DataStream dataStream) {
            this.timeProvider = dataStream.timeProvider;
            this.name = dataStream.name;
            this.indices = dataStream.indices;
            this.generation = dataStream.generation;
            this.metadata = dataStream.metadata;
            this.hidden = dataStream.hidden;
            this.replicated = dataStream.replicated;
            this.system = dataStream.system;
            this.allowCustomRouting = dataStream.allowCustomRouting;
            this.indexMode = dataStream.indexMode;
            this.lifecycle = dataStream.lifecycle;
            this.rolloverOnWrite = dataStream.rolloverOnWrite;
            this.failureStoreEnabled = dataStream.failureStoreEnabled;
            this.failureIndices = dataStream.failureIndices;
            this.autoShardingEvent = dataStream.autoShardingEvent;
        }

        public Builder setTimeProvider(LongSupplier timeProvider) {
            this.timeProvider = timeProvider;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setIndices(List<Index> indices) {
            assert (!indices.isEmpty()) : "Cannot create data stream with empty backing indices";
            this.indices = indices;
            return this;
        }

        public Builder setGeneration(long generation) {
            this.generation = generation;
            return this;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder setReplicated(boolean replicated) {
            this.replicated = replicated;
            return this;
        }

        public Builder setSystem(boolean system) {
            this.system = system;
            return this;
        }

        public Builder setAllowCustomRouting(boolean allowCustomRouting) {
            this.allowCustomRouting = allowCustomRouting;
            return this;
        }

        public Builder setIndexMode(IndexMode indexMode) {
            this.indexMode = indexMode;
            return this;
        }

        public Builder setLifecycle(DataStreamLifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public Builder setRolloverOnWrite(boolean rolloverOnWrite) {
            this.rolloverOnWrite = rolloverOnWrite;
            return this;
        }

        public Builder setFailureStoreEnabled(boolean failureStoreEnabled) {
            this.failureStoreEnabled = failureStoreEnabled;
            return this;
        }

        public Builder setFailureIndices(List<Index> failureIndices) {
            this.failureIndices = failureIndices;
            return this;
        }

        public Builder setAutoShardingEvent(DataStreamAutoShardingEvent autoShardingEvent) {
            this.autoShardingEvent = autoShardingEvent;
            return this;
        }

        public DataStream build() {
            return new DataStream(this.name, this.indices, this.generation, this.metadata, this.hidden, this.replicated, this.system, this.timeProvider, this.allowCustomRouting, this.indexMode, this.lifecycle, this.failureStoreEnabled, this.failureIndices, this.rolloverOnWrite, this.autoShardingEvent);
        }
    }
}

