/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.snapshots.InFlightShardSnapshotStates;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SnapshotsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final SnapshotsInProgress EMPTY = new SnapshotsInProgress(Map.of(), Set.of());
    public static final String TYPE = "snapshots";
    public static final String ABORTED_FAILURE_TEXT = "Snapshot was aborted by deletion";
    private final Map<String, ByRepo> entries;
    private final Set<String> nodesIdsForRemoval;
    private static final TransportVersion DIFFABLE_VERSION = TransportVersions.V_8_5_0;

    public static SnapshotsInProgress get(ClusterState state) {
        return state.custom(TYPE, EMPTY);
    }

    public SnapshotsInProgress(StreamInput in) throws IOException {
        this(SnapshotsInProgress.collectByRepo(in), SnapshotsInProgress.readNodeIdsForRemoval(in));
    }

    private static Set<String> readNodeIdsForRemoval(StreamInput in) throws IOException {
        return in.getTransportVersion().onOrAfter(TransportVersions.SNAPSHOTS_IN_PROGRESS_TRACKING_REMOVING_NODES_ADDED) ? in.readCollectionAsImmutableSet(StreamInput::readString) : Set.of();
    }

    private static Map<String, ByRepo> collectByRepo(StreamInput in) throws IOException {
        int count = in.readVInt();
        if (count == 0) {
            return Map.of();
        }
        HashMap<String, List> entriesByRepo = new HashMap<String, List>();
        for (int i = 0; i < count; ++i) {
            Entry entry = Entry.readFrom(in);
            entriesByRepo.computeIfAbsent(entry.repository(), repo -> new ArrayList()).add(entry);
        }
        Map<String, ByRepo> res = Maps.newMapWithExpectedSize(entriesByRepo.size());
        for (Map.Entry entryForRepo : entriesByRepo.entrySet()) {
            res.put((String)entryForRepo.getKey(), new ByRepo((List)entryForRepo.getValue()));
        }
        return res;
    }

    private SnapshotsInProgress(Map<String, ByRepo> entries, Set<String> nodesIdsForRemoval) {
        this.entries = Map.copyOf(entries);
        this.nodesIdsForRemoval = nodesIdsForRemoval;
        assert (SnapshotsInProgress.assertConsistentEntries(this.entries));
    }

    public SnapshotsInProgress withUpdatedEntriesForRepo(String repository, List<Entry> updatedEntries) {
        if (updatedEntries.equals(this.forRepo(repository))) {
            return this;
        }
        HashMap<String, ByRepo> copy = new HashMap<String, ByRepo>(this.entries);
        if (updatedEntries.isEmpty()) {
            copy.remove(repository);
            if (copy.isEmpty()) {
                return EMPTY;
            }
        } else {
            copy.put(repository, new ByRepo(updatedEntries));
        }
        return new SnapshotsInProgress(copy, this.nodesIdsForRemoval);
    }

    public SnapshotsInProgress withAddedEntry(Entry entry) {
        ArrayList<Entry> forRepo = new ArrayList<Entry>(this.forRepo(entry.repository()));
        forRepo.add(entry);
        return this.withUpdatedEntriesForRepo(entry.repository(), forRepo);
    }

    public List<Entry> forRepo(String repository) {
        return this.entries.getOrDefault((Object)repository, (ByRepo)ByRepo.EMPTY).entries;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int count() {
        int count = 0;
        for (ByRepo byRepo : this.entries.values()) {
            count += byRepo.entries.size();
        }
        return count;
    }

    public Iterable<List<Entry>> entriesByRepo() {
        return () -> Iterators.map(this.entries.values().iterator(), byRepo -> byRepo.entries);
    }

    public Stream<Entry> asStream() {
        return this.entries.values().stream().flatMap(t -> t.entries.stream());
    }

    @Nullable
    public Entry snapshot(Snapshot snapshot) {
        return SnapshotsInProgress.findInList(snapshot, this.forRepo(snapshot.getRepository()));
    }

    @Nullable
    private static Entry findInList(Snapshot snapshot, List<Entry> forRepo) {
        for (Entry entry : forRepo) {
            Snapshot curr = entry.snapshot();
            if (!curr.equals(snapshot)) continue;
            return entry;
        }
        return null;
    }

    public Map<RepositoryShardId, Set<ShardGeneration>> obsoleteGenerations(String repository, SnapshotsInProgress old) {
        HashMap<RepositoryShardId, Set> obsoleteGenerations = new HashMap<RepositoryShardId, Set>();
        List<Entry> updatedSnapshots = this.forRepo(repository);
        for (Entry entry : old.forRepo(repository)) {
            Entry updatedEntry = SnapshotsInProgress.findInList(entry.snapshot(), updatedSnapshots);
            if (updatedEntry == null || updatedEntry == entry) continue;
            for (Map.Entry<RepositoryShardId, ShardSnapshotStatus> oldShardAssignment : entry.shardsByRepoShardId().entrySet()) {
                RepositoryShardId repositoryShardId = oldShardAssignment.getKey();
                ShardSnapshotStatus oldStatus = oldShardAssignment.getValue();
                ShardSnapshotStatus newStatus = updatedEntry.shardsByRepoShardId().get(repositoryShardId);
                if (oldStatus.state != ShardState.SUCCESS || oldStatus.generation() == null || newStatus == null || newStatus.state() != ShardState.SUCCESS || newStatus.generation() == null || oldStatus.generation().equals(newStatus.generation())) continue;
                obsoleteGenerations.computeIfAbsent(repositoryShardId, ignored -> new HashSet()).add(oldStatus.generation());
            }
        }
        return Map.copyOf(obsoleteGenerations);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.MINIMUM_COMPATIBLE;
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter(DIFFABLE_VERSION)) {
            return new SnapshotInProgressDiff(in);
        }
        return SnapshotsInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    @Override
    public Diff<ClusterState.Custom> diff(ClusterState.Custom previousState) {
        return new SnapshotInProgressDiff((SnapshotsInProgress)previousState, this);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.count());
        Iterator iterator = this.asStream().iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).writeTo(out);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.SNAPSHOTS_IN_PROGRESS_TRACKING_REMOVING_NODES_ADDED)) {
            out.writeStringCollection(this.nodesIdsForRemoval);
        } else assert (this.nodesIdsForRemoval.isEmpty()) : this.nodesIdsForRemoval;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.concat(ChunkedToXContentHelper.startArray(TYPE), this.asStream().iterator(), ChunkedToXContentHelper.endArray(), ChunkedToXContentHelper.startArray("node_ids_for_removal"), Iterators.map(this.nodesIdsForRemoval.iterator(), s -> (builder, params) -> builder.value((String)s)), ChunkedToXContentHelper.endArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotsInProgress other = (SnapshotsInProgress)o;
        return this.nodesIdsForRemoval.equals(other.nodesIdsForRemoval) && this.entries.equals(other.entries);
    }

    public int hashCode() {
        return Objects.hash(this.entries, this.nodesIdsForRemoval);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotsInProgress[entries=[");
        Iterator entryList = this.asStream().iterator();
        boolean firstEntry = true;
        while (entryList.hasNext()) {
            if (!firstEntry) {
                builder.append(",");
            }
            builder.append(((Entry)entryList.next()).snapshot().getSnapshotId().getName());
            firstEntry = false;
        }
        return builder.append("],nodeIdsForRemoval=").append(this.nodesIdsForRemoval).append("]").toString();
    }

    public static Entry startedEntry(Snapshot snapshot, boolean includeGlobalState, boolean partial, Map<String, IndexId> indices, List<String> dataStreams, long startTime, long repositoryStateId, Map<ShardId, ShardSnapshotStatus> shards, Map<String, Object> userMetadata, IndexVersion version, List<SnapshotFeatureInfo> featureStates) {
        return Entry.snapshot(snapshot, includeGlobalState, partial, SnapshotsInProgress.completed(shards.values()) ? State.SUCCESS : State.STARTED, indices, dataStreams, featureStates, startTime, repositoryStateId, shards, null, userMetadata, version);
    }

    public static Entry startClone(Snapshot snapshot, SnapshotId source, Map<String, IndexId> indices, long startTime, long repositoryStateId, IndexVersion version) {
        return Entry.createClone(snapshot, State.STARTED, indices, startTime, repositoryStateId, null, version, source, Map.of());
    }

    public static boolean completed(Collection<ShardSnapshotStatus> shards) {
        for (ShardSnapshotStatus status : shards) {
            if (status.state().completed) continue;
            return false;
        }
        return true;
    }

    public boolean isNodeIdForRemoval(String nodeId) {
        return nodeId != null && this.nodesIdsForRemoval.contains(nodeId);
    }

    private static boolean hasFailures(Map<RepositoryShardId, ShardSnapshotStatus> clones) {
        for (ShardSnapshotStatus value : clones.values()) {
            if (!value.state().failed()) continue;
            return true;
        }
        return false;
    }

    private static boolean assertConsistentEntries(Map<String, ByRepo> entries) {
        for (Map.Entry<String, ByRepo> repoEntries : entries.entrySet()) {
            HashSet<Tuple<String, Integer>> assignedShards = new HashSet<Tuple<String, Integer>>();
            HashSet<Tuple<String, Integer>> queuedShards = new HashSet<Tuple<String, Integer>>();
            List<Entry> entriesForRepository = repoEntries.getValue().entries;
            String repository = repoEntries.getKey();
            assert (!entriesForRepository.isEmpty()) : "found empty list of snapshots for " + repository + " in " + entries;
            for (Entry entry : entriesForRepository) {
                assert (entry.repository().equals(repository)) : "mismatched repository " + entry + " tracked under " + repository;
                for (Map.Entry<RepositoryShardId, ShardSnapshotStatus> shard : entry.shardsByRepoShardId().entrySet()) {
                    RepositoryShardId sid = shard.getKey();
                    ShardSnapshotStatus shardSnapshotStatus = shard.getValue();
                    assert (SnapshotsInProgress.assertShardStateConsistent(entriesForRepository, assignedShards, queuedShards, sid.indexName(), sid.shardId(), shardSnapshotStatus));
                    assert (entry.state() != State.ABORTED || shardSnapshotStatus.state == ShardState.ABORTED || shardSnapshotStatus.state().completed()) : sid + " is in state " + shardSnapshotStatus.state() + " in aborted snapshot " + entry.snapshot;
                }
            }
            InFlightShardSnapshotStates.forEntries(entriesForRepository);
        }
        return true;
    }

    private static boolean assertShardStateConsistent(List<Entry> entries, Set<Tuple<String, Integer>> assignedShards, Set<Tuple<String, Integer>> queuedShards, String indexName, int shardId, ShardSnapshotStatus shardSnapshotStatus) {
        if (shardSnapshotStatus.isActive()) {
            Tuple<String, Integer> plainShardId = Tuple.tuple(indexName, shardId);
            assert (assignedShards.add(plainShardId)) : plainShardId + " is assigned twice in " + entries;
            assert (!queuedShards.contains(plainShardId)) : plainShardId + " is queued then assigned in " + entries;
        } else if (shardSnapshotStatus.state() == ShardState.QUEUED) {
            queuedShards.add(Tuple.tuple(indexName, shardId));
        }
        return true;
    }

    public SnapshotsInProgress withUpdatedNodeIdsForRemoval(ClusterState clusterState) {
        assert (clusterState.getMinTransportVersion().onOrAfter(TransportVersions.SNAPSHOTS_IN_PROGRESS_TRACKING_REMOVING_NODES_ADDED));
        HashSet<String> updatedNodeIdsForRemoval = new HashSet<String>(this.nodesIdsForRemoval);
        Set<String> nodeIdsMarkedForRemoval = SnapshotsInProgress.getNodesIdsMarkedForRemoval(clusterState);
        updatedNodeIdsForRemoval.addAll(nodeIdsMarkedForRemoval);
        updatedNodeIdsForRemoval.removeAll(this.getObsoleteNodeIdsForRemoval(nodeIdsMarkedForRemoval));
        if (updatedNodeIdsForRemoval.equals(this.nodesIdsForRemoval)) {
            return this;
        }
        return new SnapshotsInProgress(this.entries, Collections.unmodifiableSet(updatedNodeIdsForRemoval));
    }

    private static Set<String> getNodesIdsMarkedForRemoval(ClusterState clusterState) {
        NodesShutdownMetadata nodesShutdownMetadata = clusterState.metadata().nodeShutdowns();
        int shutdownMetadataCount = nodesShutdownMetadata.getAllNodeIds().size();
        if (shutdownMetadataCount == 0) {
            return Set.of();
        }
        HashSet<String> result = Sets.newHashSetWithExpectedSize(shutdownMetadataCount);
        for (Map.Entry<String, SingleNodeShutdownMetadata> entry : nodesShutdownMetadata.getAll().entrySet()) {
            if (entry.getValue().getType() == SingleNodeShutdownMetadata.Type.RESTART) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private Set<String> getObsoleteNodeIdsForRemoval(Set<String> latestNodeIdsMarkedForRemoval) {
        HashSet<String> obsoleteNodeIdsForRemoval = new HashSet<String>(this.nodesIdsForRemoval);
        obsoleteNodeIdsForRemoval.removeIf(latestNodeIdsMarkedForRemoval::contains);
        if (obsoleteNodeIdsForRemoval.isEmpty()) {
            return Set.of();
        }
        for (ByRepo byRepo : this.entries.values()) {
            for (Entry entry : byRepo.entries()) {
                if (entry.state() != State.STARTED || !entry.hasShardsInInitState()) continue;
                for (ShardSnapshotStatus shardSnapshotStatus : entry.shards().values()) {
                    if (shardSnapshotStatus.state() != ShardState.INIT) continue;
                    obsoleteNodeIdsForRemoval.remove(shardSnapshotStatus.nodeId());
                    if (!obsoleteNodeIdsForRemoval.isEmpty()) continue;
                    return Set.of();
                }
            }
        }
        return obsoleteNodeIdsForRemoval;
    }

    public boolean nodeIdsForRemovalChanged(SnapshotsInProgress other) {
        return !this.nodesIdsForRemoval.equals(other.nodesIdsForRemoval);
    }

    public static class Entry
    implements Writeable,
    ToXContentObject,
    RepositoryOperation,
    Diffable<Entry> {
        private final State state;
        private final Snapshot snapshot;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final Map<ShardId, ShardSnapshotStatus> shards;
        private final Map<String, IndexId> indices;
        private final Map<String, Index> snapshotIndices;
        private final List<String> dataStreams;
        private final List<SnapshotFeatureInfo> featureStates;
        private final long startTime;
        private final long repositoryStateId;
        private final IndexVersion version;
        @Nullable
        private final SnapshotId source;
        private final Map<RepositoryShardId, ShardSnapshotStatus> shardStatusByRepoShardId;
        @Nullable
        private final Map<String, Object> userMetadata;
        @Nullable
        private final String failure;
        private final boolean hasShardsInInitState;

        public static Entry snapshot(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, Map<String, IndexId> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, long startTime, long repositoryStateId, Map<ShardId, ShardSnapshotStatus> shards, String failure, Map<String, Object> userMetadata, IndexVersion version) {
            Map<String, Index> res = Maps.newMapWithExpectedSize(indices.size());
            Map<RepositoryShardId, ShardSnapshotStatus> byRepoShardIdBuilder = Maps.newHashMapWithExpectedSize(shards.size());
            boolean hasInitStateShards = false;
            for (Map.Entry<ShardId, ShardSnapshotStatus> entry : shards.entrySet()) {
                ShardId shardId = entry.getKey();
                IndexId indexId = indices.get(shardId.getIndexName());
                Index index = shardId.getIndex();
                Index existing = res.put(indexId.getName(), index);
                assert (existing == null || existing.equals(index)) : "Conflicting indices [" + existing + "] and [" + index + "]";
                ShardSnapshotStatus shardSnapshotStatus = entry.getValue();
                hasInitStateShards |= shardSnapshotStatus.state() == ShardState.INIT;
                byRepoShardIdBuilder.put(new RepositoryShardId(indexId, shardId.id()), shardSnapshotStatus);
            }
            return new Entry(snapshot, includeGlobalState, partial, state, indices, dataStreams, featureStates, startTime, repositoryStateId, shards, failure, userMetadata, version, null, byRepoShardIdBuilder, res, hasInitStateShards);
        }

        private static Entry createClone(Snapshot snapshot, State state, Map<String, IndexId> indices, long startTime, long repositoryStateId, String failure, IndexVersion version, SnapshotId source, Map<RepositoryShardId, ShardSnapshotStatus> shardStatusByRepoShardId) {
            return new Entry(snapshot, true, false, state, indices, List.of(), List.of(), startTime, repositoryStateId, Map.of(), failure, Map.of(), version, source, shardStatusByRepoShardId, Map.of(), false);
        }

        private Entry(Snapshot snapshot, boolean includeGlobalState, boolean partial, State state, Map<String, IndexId> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, long startTime, long repositoryStateId, Map<ShardId, ShardSnapshotStatus> shards, String failure, Map<String, Object> userMetadata, IndexVersion version, @Nullable SnapshotId source, Map<RepositoryShardId, ShardSnapshotStatus> shardStatusByRepoShardId, Map<String, Index> snapshotIndices, boolean hasShardsInInitState) {
            this.state = state;
            this.snapshot = snapshot;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.indices = Map.copyOf(indices);
            this.dataStreams = List.copyOf(dataStreams);
            this.featureStates = List.copyOf(featureStates);
            this.startTime = startTime;
            this.shards = shards;
            this.repositoryStateId = repositoryStateId;
            this.failure = failure;
            this.userMetadata = userMetadata == null ? null : Map.copyOf(userMetadata);
            this.version = version;
            this.source = source;
            this.shardStatusByRepoShardId = Map.copyOf(shardStatusByRepoShardId);
            this.snapshotIndices = snapshotIndices;
            this.hasShardsInInitState = hasShardsInInitState;
            assert (Entry.assertShardsConsistent(this.source, this.state, this.indices, this.shards, this.shardStatusByRepoShardId, this.hasShardsInInitState));
        }

        private static Entry readFrom(StreamInput in) throws IOException {
            Snapshot snapshot = new Snapshot(in);
            boolean includeGlobalState = in.readBoolean();
            boolean partial = in.readBoolean();
            State state = State.fromValue(in.readByte());
            Map<String, IndexId> indices = in.readMapValues(IndexId::new, IndexId::getName);
            long startTime = in.readLong();
            Map<ShardId, ShardSnapshotStatus> shards = in.readImmutableMap(ShardId::new, ShardSnapshotStatus::readFrom);
            long repositoryStateId = in.readLong();
            String failure = in.readOptionalString();
            Map<String, Object> userMetadata = in.readGenericMap();
            IndexVersion version = IndexVersion.readVersion(in);
            List<String> dataStreams = in.readStringCollectionAsImmutableList();
            SnapshotId source = in.readOptionalWriteable(SnapshotId::new);
            Map<RepositoryShardId, ShardSnapshotStatus> clones = in.readImmutableMap(RepositoryShardId::readFrom, ShardSnapshotStatus::readFrom);
            List<SnapshotFeatureInfo> featureStates = in.readCollectionAsImmutableList(SnapshotFeatureInfo::new);
            if (source == null) {
                return Entry.snapshot(snapshot, includeGlobalState, partial, state, indices, dataStreams, featureStates, startTime, repositoryStateId, shards, failure, userMetadata, version);
            }
            assert (shards.isEmpty());
            return Entry.createClone(snapshot, state, indices, startTime, repositoryStateId, failure, version, source, clones);
        }

        private static boolean assertShardsConsistent(SnapshotId source, State state, Map<String, IndexId> indices, Map<ShardId, ShardSnapshotStatus> shards, Map<RepositoryShardId, ShardSnapshotStatus> statusByRepoShardId, boolean hasInitStateShards) {
            boolean shardsCompleted;
            if ((state == State.INIT || state == State.ABORTED) && shards.isEmpty()) {
                return true;
            }
            if (hasInitStateShards) assert (state == State.STARTED) : "shouldn't have INIT-state shards in state " + state;
            Set<String> indexNames = indices.keySet();
            HashSet indexNamesInShards = new HashSet();
            shards.entrySet().forEach(s -> {
                indexNamesInShards.add(((ShardId)s.getKey()).getIndexName());
                assert (source == null || ((ShardSnapshotStatus)s.getValue()).nodeId == null) : "Shard snapshot must not be assigned to data node when copying from snapshot [" + source + "]";
            });
            assert (source == null || !indexNames.isEmpty()) : "No empty snapshot clones allowed";
            assert (source != null || indexNames.equals(indexNamesInShards)) : "Indices in shards " + indexNamesInShards + " differ from expected indices " + indexNames + " for state [" + state + "]";
            boolean bl = shardsCompleted = SnapshotsInProgress.completed(shards.values()) && SnapshotsInProgress.completed(statusByRepoShardId.values());
            if (source == null || !statusByRepoShardId.isEmpty()) assert (state.completed() && shardsCompleted || !state.completed() && !shardsCompleted) : "Completed state must imply all shards completed but saw state [" + state + "] and shards " + shards;
            if (source != null && state.completed()) assert (!SnapshotsInProgress.hasFailures(statusByRepoShardId) || state == State.FAILED) : "Failed shard clones in [" + statusByRepoShardId + "] but state was [" + state + "]";
            if (source == null) {
                assert (shards.size() == statusByRepoShardId.size());
                boolean foundInitStateShard = false;
                for (Map.Entry<ShardId, ShardSnapshotStatus> entry : shards.entrySet()) {
                    foundInitStateShard |= entry.getValue().state() == ShardState.INIT;
                    ShardId routingShardId = entry.getKey();
                    assert (statusByRepoShardId.get(new RepositoryShardId(indices.get(routingShardId.getIndexName()), routingShardId.id())) == entry.getValue()) : "found inconsistent values tracked by routing- and repository shard id";
                }
                assert (foundInitStateShard == hasInitStateShards) : "init shard state flag does not match shard states";
            }
            return true;
        }

        public Entry withRepoGen(long newRepoGen) {
            assert (newRepoGen > this.repositoryStateId) : "Updated repository generation [" + newRepoGen + "] must be higher than current generation [" + this.repositoryStateId + "]";
            return new Entry(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.featureStates, this.startTime, newRepoGen, this.shards, this.failure, this.userMetadata, this.version, this.source, this.shardStatusByRepoShardId, this.snapshotIndices, this.hasShardsInInitState);
        }

        public Entry withUpdatedIndexIds(Map<IndexId, IndexId> updates) {
            if (this.isClone()) {
                assert (this.indices.values().stream().noneMatch(updates::containsKey)) : "clone index ids can not be updated but saw tried to update " + updates + " on " + this;
                return this;
            }
            HashMap<String, IndexId> updatedIndices = null;
            for (IndexId existingIndexId : this.indices.values()) {
                IndexId updatedIndexId = updates.get(existingIndexId);
                if (updatedIndexId == null) continue;
                if (updatedIndices == null) {
                    updatedIndices = new HashMap<String, IndexId>(this.indices);
                }
                updatedIndices.put(updatedIndexId.getName(), updatedIndexId);
            }
            if (updatedIndices != null) {
                return Entry.snapshot(this.snapshot, this.includeGlobalState, this.partial, this.state, updatedIndices, this.dataStreams, this.featureStates, this.startTime, this.repositoryStateId, this.shards, this.failure, this.userMetadata, this.version);
            }
            return this;
        }

        public Entry withClones(Map<RepositoryShardId, ShardSnapshotStatus> updatedClones) {
            if (updatedClones.equals(this.shardStatusByRepoShardId)) {
                return this;
            }
            assert (this.shards.isEmpty());
            return Entry.createClone(this.snapshot, SnapshotsInProgress.completed(updatedClones.values()) ? (SnapshotsInProgress.hasFailures(updatedClones) ? State.FAILED : State.SUCCESS) : this.state, this.indices, this.startTime, this.repositoryStateId, this.failure, this.version, this.source, updatedClones);
        }

        @Nullable
        public Entry abort() {
            HashMap<ShardId, ShardSnapshotStatus> shardsBuilder = new HashMap<ShardId, ShardSnapshotStatus>();
            boolean completed = true;
            boolean allQueued = true;
            for (Map.Entry<ShardId, ShardSnapshotStatus> shardEntry : this.shards.entrySet()) {
                ShardSnapshotStatus status = shardEntry.getValue();
                allQueued &= status.state() == ShardState.QUEUED;
                if (!status.state().completed()) {
                    String nodeId;
                    status = new ShardSnapshotStatus(nodeId, (nodeId = status.nodeId()) == null ? ShardState.FAILED : ShardState.ABORTED, status.generation(), "aborted by snapshot deletion");
                }
                completed &= status.state().completed();
                shardsBuilder.put(shardEntry.getKey(), status);
            }
            if (allQueued) {
                return null;
            }
            return Entry.snapshot(this.snapshot, this.includeGlobalState, this.partial, completed ? State.SUCCESS : State.ABORTED, this.indices, this.dataStreams, this.featureStates, this.startTime, this.repositoryStateId, Map.copyOf(shardsBuilder), SnapshotsInProgress.ABORTED_FAILURE_TEXT, this.userMetadata, this.version);
        }

        public Entry withShardStates(Map<ShardId, ShardSnapshotStatus> shards) {
            if (SnapshotsInProgress.completed(shards.values())) {
                return Entry.snapshot(this.snapshot, this.includeGlobalState, this.partial, State.SUCCESS, this.indices, this.dataStreams, this.featureStates, this.startTime, this.repositoryStateId, shards, this.failure, this.userMetadata, this.version);
            }
            return this.withStartedShards(shards);
        }

        public Entry withStartedShards(Map<ShardId, ShardSnapshotStatus> shards) {
            Entry updated = Entry.snapshot(this.snapshot, this.includeGlobalState, this.partial, this.state, this.indices, this.dataStreams, this.featureStates, this.startTime, this.repositoryStateId, shards, this.failure, this.userMetadata, this.version);
            assert (!updated.state().completed() && !SnapshotsInProgress.completed(updated.shardsByRepoShardId().values())) : "Only running snapshots allowed but saw [" + updated + "]";
            return updated;
        }

        @Override
        public String repository() {
            return this.snapshot.getRepository();
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public Map<RepositoryShardId, ShardSnapshotStatus> shardsByRepoShardId() {
            return this.shardStatusByRepoShardId;
        }

        public Index indexByName(String name) {
            assert (!this.isClone()) : "tried to get routing index for clone entry [" + this + "]";
            return this.snapshotIndices.get(name);
        }

        public Map<ShardId, ShardSnapshotStatus> shards() {
            assert (!this.isClone()) : "tried to get routing shards for clone entry [" + this + "]";
            return this.shards;
        }

        public ShardId shardId(RepositoryShardId repositoryShardId) {
            assert (!this.isClone()) : "must not be called for clone [" + this + "]";
            return new ShardId(this.indexByName(repositoryShardId.indexName()), repositoryShardId.shardId());
        }

        public State state() {
            return this.state;
        }

        public Map<String, IndexId> indices() {
            return this.indices;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public Map<String, Object> userMetadata() {
            return this.userMetadata;
        }

        public boolean hasShardsInInitState() {
            return this.hasShardsInInitState;
        }

        public boolean partial() {
            return this.partial;
        }

        public long startTime() {
            return this.startTime;
        }

        public List<String> dataStreams() {
            return this.dataStreams;
        }

        public List<SnapshotFeatureInfo> featureStates() {
            return this.featureStates;
        }

        @Override
        public long repositoryStateId() {
            return this.repositoryStateId;
        }

        public String failure() {
            return this.failure;
        }

        public IndexVersion version() {
            return this.version;
        }

        @Nullable
        public SnapshotId source() {
            return this.source;
        }

        public boolean isClone() {
            return this.source != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.includeGlobalState != entry.includeGlobalState) {
                return false;
            }
            if (this.partial != entry.partial) {
                return false;
            }
            if (this.startTime != entry.startTime) {
                return false;
            }
            if (!this.indices.equals(entry.indices)) {
                return false;
            }
            if (!this.dataStreams.equals(entry.dataStreams)) {
                return false;
            }
            if (!this.shards.equals(entry.shards)) {
                return false;
            }
            if (!this.snapshot.equals(entry.snapshot)) {
                return false;
            }
            if (this.state != entry.state) {
                return false;
            }
            if (this.repositoryStateId != entry.repositoryStateId) {
                return false;
            }
            if (!Objects.equals(this.failure, ((Entry)o).failure)) {
                return false;
            }
            if (!Objects.equals(this.userMetadata, ((Entry)o).userMetadata)) {
                return false;
            }
            if (!this.version.equals(entry.version)) {
                return false;
            }
            if (!Objects.equals(this.source, ((Entry)o).source)) {
                return false;
            }
            if (!this.shardStatusByRepoShardId.equals(((Entry)o).shardStatusByRepoShardId)) {
                return false;
            }
            return this.featureStates.equals(entry.featureStates);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + this.snapshot.hashCode();
            result = 31 * result + (this.includeGlobalState ? 1 : 0);
            result = 31 * result + (this.partial ? 1 : 0);
            result = 31 * result + this.shards.hashCode();
            result = 31 * result + this.indices.hashCode();
            result = 31 * result + this.dataStreams.hashCode();
            result = 31 * result + Long.hashCode(this.startTime);
            result = 31 * result + Long.hashCode(this.repositoryStateId);
            result = 31 * result + (this.failure == null ? 0 : this.failure.hashCode());
            result = 31 * result + (this.userMetadata == null ? 0 : this.userMetadata.hashCode());
            result = 31 * result + this.version.hashCode();
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + this.shardStatusByRepoShardId.hashCode();
            result = 31 * result + this.featureStates.hashCode();
            return result;
        }

        public String toString() {
            return Strings.toString(this);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            Writeable shardId;
            builder.startObject();
            builder.field("repository", this.snapshot.getRepository());
            builder.field("snapshot", this.snapshot.getSnapshotId().getName());
            builder.field("uuid", this.snapshot.getSnapshotId().getUUID());
            builder.field("include_global_state", this.includeGlobalState());
            builder.field("partial", this.partial);
            builder.field("state", this.state);
            builder.startArray("indices");
            for (IndexId indexId : this.indices.values()) {
                indexId.toXContent(builder, params);
            }
            builder.endArray();
            builder.timeField("start_time_millis", "start_time", this.startTime);
            builder.field("repository_state_id", this.repositoryStateId);
            builder.startArray("shards");
            for (Map.Entry entry : this.shards.entrySet()) {
                shardId = (ShardId)entry.getKey();
                Entry.writeShardSnapshotStatus(builder, ((ShardId)shardId).getIndex(), ((ShardId)shardId).getId(), (ShardSnapshotStatus)entry.getValue());
            }
            builder.endArray();
            builder.startArray("feature_states");
            for (SnapshotFeatureInfo snapshotFeatureInfo : this.featureStates) {
                snapshotFeatureInfo.toXContent(builder, params);
            }
            builder.endArray();
            if (this.isClone()) {
                builder.field("source", this.source);
                builder.startArray("clones");
                for (Map.Entry entry : this.shardStatusByRepoShardId.entrySet()) {
                    shardId = (RepositoryShardId)entry.getKey();
                    Entry.writeShardSnapshotStatus(builder, ((RepositoryShardId)shardId).index(), ((RepositoryShardId)shardId).shardId(), (ShardSnapshotStatus)entry.getValue());
                }
                builder.endArray();
            }
            builder.array("data_streams", this.dataStreams.toArray(new String[0]));
            builder.endObject();
            return builder;
        }

        private static void writeShardSnapshotStatus(XContentBuilder builder, ToXContent indexId, int shardId, ShardSnapshotStatus status) throws IOException {
            builder.startObject();
            builder.field("index", indexId);
            builder.field("shard", shardId);
            builder.field("state", status.state());
            builder.field("generation", status.generation());
            builder.field("node", status.nodeId());
            if (status.state() == ShardState.SUCCESS) {
                ShardSnapshotResult result = status.shardSnapshotResult();
                builder.startObject("result");
                builder.field("generation", result.getGeneration());
                builder.humanReadableField("size_in_bytes", "size", result.getSize());
                builder.field("segments", result.getSegmentCount());
                builder.endObject();
            }
            if (status.reason() != null) {
                builder.field("reason", status.reason());
            }
            builder.endObject();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.snapshot.writeTo(out);
            out.writeBoolean(this.includeGlobalState);
            out.writeBoolean(this.partial);
            out.writeByte(this.state.value());
            out.writeCollection(this.indices.values());
            out.writeLong(this.startTime);
            out.writeMap(this.shards);
            out.writeLong(this.repositoryStateId);
            out.writeOptionalString(this.failure);
            out.writeGenericMap(this.userMetadata);
            IndexVersion.writeVersion(this.version, out);
            out.writeStringCollection(this.dataStreams);
            out.writeOptionalWriteable(this.source);
            if (this.source == null) {
                out.writeMap(Map.of());
            } else {
                out.writeMap(this.shardStatusByRepoShardId);
            }
            out.writeCollection(this.featureStates);
        }

        @Override
        public Diff<Entry> diff(Entry previousState) {
            return new EntryDiff(previousState, this);
        }
    }

    private record ByRepo(List<Entry> entries) implements Diffable<ByRepo>
    {
        static final ByRepo EMPTY = new ByRepo(List.of());
        private static final DiffableUtils.NonDiffableValueSerializer<String, Integer> INT_DIFF_VALUE_SERIALIZER = new DiffableUtils.NonDiffableValueSerializer<String, Integer>(){

            @Override
            public void write(Integer value, StreamOutput out) throws IOException {
                out.writeVInt(value);
            }

            @Override
            public Integer read(StreamInput in, String key) throws IOException {
                return in.readVInt();
            }
        };

        private ByRepo(List<Entry> entries) {
            this.entries = List.copyOf(entries);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.entries);
        }

        @Override
        public Diff<ByRepo> diff(ByRepo previousState) {
            return new ByRepoDiff(DiffableUtils.diff(ByRepo.toMapByUUID(previousState), ByRepo.toMapByUUID(this), DiffableUtils.getStringKeySerializer()), DiffableUtils.diff(ByRepo.toPositionMap(previousState), ByRepo.toPositionMap(this), DiffableUtils.getStringKeySerializer(), INT_DIFF_VALUE_SERIALIZER));
        }

        public static Map<String, Integer> toPositionMap(ByRepo part) {
            Map<String, Integer> res = Maps.newMapWithExpectedSize(part.entries.size());
            for (int i = 0; i < part.entries.size(); ++i) {
                String snapshotUUID = part.entries.get(i).snapshot().getSnapshotId().getUUID();
                assert (!res.containsKey(snapshotUUID));
                res.put(snapshotUUID, i);
            }
            return res;
        }

        public static Map<String, Entry> toMapByUUID(ByRepo part) {
            Map<String, Entry> res = Maps.newMapWithExpectedSize(part.entries.size());
            for (Entry entry : part.entries) {
                String snapshotUUID = entry.snapshot().getSnapshotId().getUUID();
                assert (!res.containsKey(snapshotUUID));
                res.put(snapshotUUID, entry);
            }
            return res;
        }

        private record ByRepoDiff(DiffableUtils.MapDiff<String, Entry, Map<String, Entry>> diffBySnapshotUUID, DiffableUtils.MapDiff<String, Integer, Map<String, Integer>> positionDiff) implements Diff<ByRepo>
        {
            @Override
            public ByRepo apply(ByRepo part) {
                Map<String, Entry> updated = this.diffBySnapshotUUID.apply(ByRepo.toMapByUUID(part));
                Map<String, Integer> updatedPositions = this.positionDiff.apply(ByRepo.toPositionMap(part));
                Entry[] arr = new Entry[updated.size()];
                updatedPositions.forEach((uuid, position) -> {
                    arr[position.intValue()] = (Entry)updated.get(uuid);
                });
                return new ByRepo(List.of(arr));
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                this.diffBySnapshotUUID.writeTo(out);
                this.positionDiff.writeTo(out);
            }
        }
    }

    public record ShardSnapshotStatus(@Nullable String nodeId, ShardState state, @Nullable ShardGeneration generation, @Nullable String reason, @Nullable ShardSnapshotResult shardSnapshotResult) implements Writeable
    {
        @Nullable
        private final ShardSnapshotResult shardSnapshotResult;
        public static final ShardSnapshotStatus UNASSIGNED_QUEUED = new ShardSnapshotStatus(null, ShardState.QUEUED, null);
        public static final ShardSnapshotStatus MISSING = new ShardSnapshotStatus(null, ShardState.MISSING, null, "missing index");

        public ShardSnapshotStatus(String nodeId, ShardGeneration generation) {
            this(nodeId, ShardState.INIT, generation);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, @Nullable ShardGeneration generation) {
            this(nodeId, ShardSnapshotStatus.assertNotSuccess(state), generation, null);
        }

        @SuppressForbidden(reason="using a private constructor within the same file")
        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, @Nullable ShardGeneration generation, String reason) {
            this(nodeId, ShardSnapshotStatus.assertNotSuccess(state), generation, reason, null);
        }

        public ShardSnapshotStatus(@Nullable String nodeId, ShardState state, @Nullable ShardGeneration generation, String reason, @Nullable ShardSnapshotResult shardSnapshotResult) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
            this.generation = generation;
            this.shardSnapshotResult = shardSnapshotResult;
            assert (this.assertConsistent());
        }

        private static ShardState assertNotSuccess(ShardState shardState) {
            assert (shardState != ShardState.SUCCESS) : "use ShardSnapshotStatus#success";
            return shardState;
        }

        @SuppressForbidden(reason="using a private constructor within the same file")
        public static ShardSnapshotStatus success(String nodeId, ShardSnapshotResult shardSnapshotResult) {
            return new ShardSnapshotStatus(nodeId, ShardState.SUCCESS, shardSnapshotResult.getGeneration(), null, shardSnapshotResult);
        }

        private boolean assertConsistent() {
            assert (!this.state.failed() || this.reason != null);
            assert (this.state != ShardState.INIT && this.state != ShardState.WAITING && this.state != ShardState.PAUSED_FOR_NODE_REMOVAL || this.nodeId != null) : "Null node id for state [" + this.state + "]";
            assert (this.state != ShardState.QUEUED || this.nodeId == null && this.generation == null && this.reason == null) : "Found unexpected non-null values for queued state shard nodeId[" + this.nodeId + "][" + this.generation + "][" + this.reason + "]";
            assert (this.state == ShardState.SUCCESS || this.shardSnapshotResult == null);
            assert (this.shardSnapshotResult == null || this.shardSnapshotResult.getGeneration().equals(this.generation)) : "generation [" + this.generation + "] does not match result generation [" + this.shardSnapshotResult.getGeneration() + "]";
            return true;
        }

        @SuppressForbidden(reason="using a private constructor within the same file")
        public static ShardSnapshotStatus readFrom(StreamInput in) throws IOException {
            String nodeId = DiscoveryNode.deduplicateNodeIdentifier(in.readOptionalString());
            ShardState state = ShardState.fromValue(in.readByte());
            ShardGeneration generation = in.readOptionalWriteable(ShardGeneration::new);
            String reason = in.readOptionalString();
            ShardSnapshotResult shardSnapshotResult = in.readOptionalWriteable(ShardSnapshotResult::new);
            if (state == ShardState.QUEUED) {
                return UNASSIGNED_QUEUED;
            }
            return new ShardSnapshotStatus(nodeId, state, generation, reason, shardSnapshotResult);
        }

        @SuppressForbidden(reason="using a private constructor within the same file")
        public ShardSnapshotStatus withUpdatedGeneration(ShardGeneration newGeneration) {
            assert (this.state == ShardState.SUCCESS) : "can't move generation in state " + this.state;
            return new ShardSnapshotStatus(this.nodeId, this.state, newGeneration, this.reason, this.shardSnapshotResult == null ? null : new ShardSnapshotResult(newGeneration, this.shardSnapshotResult.getSize(), this.shardSnapshotResult.getSegmentCount()));
        }

        @Nullable
        public ShardSnapshotResult shardSnapshotResult() {
            assert (this.state == ShardState.SUCCESS) : "result is unavailable in state " + this.state;
            return this.shardSnapshotResult;
        }

        public boolean isActive() {
            return switch (this.state) {
                default -> throw new IncompatibleClassChangeError();
                case ShardState.INIT, ShardState.ABORTED, ShardState.WAITING, ShardState.PAUSED_FOR_NODE_REMOVAL -> true;
                case ShardState.SUCCESS, ShardState.FAILED, ShardState.MISSING, ShardState.QUEUED -> false;
            };
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalWriteable(this.generation);
            out.writeOptionalString(this.reason);
            out.writeOptionalWriteable(this.shardSnapshotResult);
        }
    }

    public static enum ShardState {
        INIT(0, false, false),
        SUCCESS(2, true, false),
        FAILED(3, true, true),
        ABORTED(4, false, true),
        MISSING(5, true, true),
        WAITING(6, false, false),
        QUEUED(7, false, false),
        PAUSED_FOR_NODE_REMOVAL(8, false, false);

        private final byte value;
        private final boolean completed;
        private final boolean failed;

        private ShardState(byte value, boolean completed, boolean failed) {
            this.value = value;
            this.completed = completed;
            this.failed = failed;
        }

        public boolean completed() {
            return this.completed;
        }

        public boolean failed() {
            return this.failed;
        }

        public static ShardState fromValue(byte value) {
            return switch (value) {
                case 0 -> INIT;
                case 2 -> SUCCESS;
                case 3 -> FAILED;
                case 4 -> ABORTED;
                case 5 -> MISSING;
                case 6 -> WAITING;
                case 7 -> QUEUED;
                case 8 -> PAUSED_FOR_NODE_REMOVAL;
                default -> throw new IllegalArgumentException("No shard snapshot state for value [" + value + "]");
            };
        }
    }

    private static final class SnapshotInProgressDiff
    implements NamedDiff<ClusterState.Custom> {
        private final SnapshotsInProgress after;
        private final DiffableUtils.MapDiff<String, ByRepo, Map<String, ByRepo>> mapDiff;
        private final Set<String> nodeIdsForRemoval;

        SnapshotInProgressDiff(SnapshotsInProgress before, SnapshotsInProgress after) {
            this.mapDiff = DiffableUtils.diff(before.entries, after.entries, DiffableUtils.getStringKeySerializer());
            this.nodeIdsForRemoval = after.nodesIdsForRemoval;
            this.after = after;
        }

        SnapshotInProgressDiff(StreamInput in) throws IOException {
            this.mapDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), i -> new ByRepo(i.readCollectionAsImmutableList(Entry::readFrom)), i -> new ByRepo.ByRepoDiff(DiffableUtils.readJdkMapDiff(i, DiffableUtils.getStringKeySerializer(), Entry::readFrom, EntryDiff::new), DiffableUtils.readJdkMapDiff(i, DiffableUtils.getStringKeySerializer(), ByRepo.INT_DIFF_VALUE_SERIALIZER)));
            this.nodeIdsForRemoval = SnapshotsInProgress.readNodeIdsForRemoval(in);
            this.after = null;
        }

        @Override
        public SnapshotsInProgress apply(ClusterState.Custom part) {
            SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)part;
            return new SnapshotsInProgress(this.mapDiff.apply(snapshotsInProgress.entries), this.nodeIdsForRemoval);
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.MINIMUM_COMPATIBLE;
        }

        @Override
        public String getWriteableName() {
            return SnapshotsInProgress.TYPE;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            assert (this.after != null) : "should only write instances that were diffed from this node's state";
            if (out.getTransportVersion().onOrAfter(DIFFABLE_VERSION)) {
                this.mapDiff.writeTo(out);
            } else {
                new SimpleDiffable.CompleteDiff<SnapshotsInProgress>(this.after).writeTo(out);
            }
            if (out.getTransportVersion().onOrAfter(TransportVersions.SNAPSHOTS_IN_PROGRESS_TRACKING_REMOVING_NODES_ADDED)) {
                out.writeStringCollection(this.nodeIdsForRemoval);
            } else assert (this.nodeIdsForRemoval.isEmpty()) : this.nodeIdsForRemoval;
        }
    }

    public static enum State {
        INIT(0, false),
        STARTED(1, false),
        SUCCESS(2, true),
        FAILED(3, true),
        ABORTED(4, false);

        private final byte value;
        private final boolean completed;

        private State(byte value, boolean completed) {
            this.value = value;
            this.completed = completed;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this.completed;
        }

        public static State fromValue(byte value) {
            return switch (value) {
                case 0 -> INIT;
                case 1 -> STARTED;
                case 2 -> SUCCESS;
                case 3 -> FAILED;
                case 4 -> ABORTED;
                default -> throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
            };
        }
    }

    private static final class EntryDiff
    implements Diff<Entry> {
        private static final DiffableUtils.NonDiffableValueSerializer<String, IndexId> INDEX_ID_VALUE_SERIALIZER = new DiffableUtils.NonDiffableValueSerializer<String, IndexId>(){

            @Override
            public void write(IndexId value, StreamOutput out) throws IOException {
                out.writeString(value.getId());
            }

            @Override
            public IndexId read(StreamInput in, String key) throws IOException {
                return new IndexId(key, in.readString());
            }
        };
        private static final DiffableUtils.NonDiffableValueSerializer<?, ShardSnapshotStatus> SHARD_SNAPSHOT_STATUS_VALUE_SERIALIZER = new DiffableUtils.NonDiffableValueSerializer<Object, ShardSnapshotStatus>(){

            @Override
            public void write(ShardSnapshotStatus value, StreamOutput out) throws IOException {
                value.writeTo(out);
            }

            @Override
            public ShardSnapshotStatus read(StreamInput in, Object key) throws IOException {
                return ShardSnapshotStatus.readFrom(in);
            }
        };
        private static final DiffableUtils.KeySerializer<ShardId> SHARD_ID_KEY_SERIALIZER = new DiffableUtils.KeySerializer<ShardId>(){

            @Override
            public void writeKey(ShardId key, StreamOutput out) throws IOException {
                key.writeTo(out);
            }

            @Override
            public ShardId readKey(StreamInput in) throws IOException {
                return new ShardId(in);
            }
        };
        private static final DiffableUtils.KeySerializer<RepositoryShardId> REPO_SHARD_ID_KEY_SERIALIZER = new DiffableUtils.KeySerializer<RepositoryShardId>(){

            @Override
            public void writeKey(RepositoryShardId key, StreamOutput out) throws IOException {
                key.writeTo(out);
            }

            @Override
            public RepositoryShardId readKey(StreamInput in) throws IOException {
                return RepositoryShardId.readFrom(in);
            }
        };
        private final DiffableUtils.MapDiff<String, IndexId, Map<String, IndexId>> indexByIndexNameDiff;
        private final DiffableUtils.MapDiff<ShardId, ShardSnapshotStatus, Map<ShardId, ShardSnapshotStatus>> shardsByShardIdDiff;
        @Nullable
        private final DiffableUtils.MapDiff<RepositoryShardId, ShardSnapshotStatus, Map<RepositoryShardId, ShardSnapshotStatus>> shardsByRepoShardIdDiff;
        @Nullable
        private final List<String> updatedDataStreams;
        @Nullable
        private final String updatedFailure;
        private final long updatedRepositoryStateId;
        private final State updatedState;

        EntryDiff(StreamInput in) throws IOException {
            this.indexByIndexNameDiff = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), INDEX_ID_VALUE_SERIALIZER);
            this.updatedState = State.fromValue(in.readByte());
            this.updatedRepositoryStateId = in.readLong();
            this.updatedDataStreams = in.readOptionalStringCollectionAsList();
            this.updatedFailure = in.readOptionalString();
            this.shardsByShardIdDiff = DiffableUtils.readJdkMapDiff(in, SHARD_ID_KEY_SERIALIZER, SHARD_SNAPSHOT_STATUS_VALUE_SERIALIZER);
            this.shardsByRepoShardIdDiff = in.readOptionalWriteable(i -> DiffableUtils.readJdkMapDiff(i, REPO_SHARD_ID_KEY_SERIALIZER, SHARD_SNAPSHOT_STATUS_VALUE_SERIALIZER));
        }

        EntryDiff(Entry before, Entry after) {
            try {
                EntryDiff.verifyDiffable(before, after);
            }
            catch (Exception e) {
                IllegalArgumentException ex = new IllegalArgumentException("Cannot diff [" + before + "] and [" + after + "]");
                assert (false) : ex;
                throw ex;
            }
            this.indexByIndexNameDiff = DiffableUtils.diff(before.indices, after.indices, DiffableUtils.getStringKeySerializer(), INDEX_ID_VALUE_SERIALIZER);
            this.updatedDataStreams = before.dataStreams.equals(after.dataStreams) ? null : after.dataStreams;
            this.updatedState = after.state;
            this.updatedRepositoryStateId = after.repositoryStateId;
            this.updatedFailure = after.failure;
            this.shardsByShardIdDiff = DiffableUtils.diff(before.shards, after.shards, SHARD_ID_KEY_SERIALIZER, SHARD_SNAPSHOT_STATUS_VALUE_SERIALIZER);
            this.shardsByRepoShardIdDiff = before.isClone() ? DiffableUtils.diff(before.shardStatusByRepoShardId, after.shardStatusByRepoShardId, REPO_SHARD_ID_KEY_SERIALIZER, SHARD_SNAPSHOT_STATUS_VALUE_SERIALIZER) : null;
        }

        private static void verifyDiffable(Entry before, Entry after) {
            if (!before.snapshot().equals(after.snapshot())) {
                throw new IllegalArgumentException("snapshot changed from [" + before.snapshot() + "] to [" + after.snapshot() + "]");
            }
            if (before.startTime() != after.startTime()) {
                throw new IllegalArgumentException("start time changed from [" + before.startTime() + "] to [" + after.startTime() + "]");
            }
            if (!Objects.equals(before.source(), after.source())) {
                throw new IllegalArgumentException("source changed from [" + before.source() + "] to [" + after.source() + "]");
            }
            if (before.includeGlobalState() != after.includeGlobalState()) {
                throw new IllegalArgumentException("include global state changed from [" + before.includeGlobalState() + "] to [" + after.includeGlobalState() + "]");
            }
            if (before.partial() != after.partial()) {
                throw new IllegalArgumentException("partial changed from [" + before.partial() + "] to [" + after.partial() + "]");
            }
            if (!before.featureStates().equals(after.featureStates())) {
                throw new IllegalArgumentException("feature states changed from " + before.featureStates() + " to " + after.featureStates());
            }
            if (!Objects.equals(before.userMetadata(), after.userMetadata())) {
                throw new IllegalArgumentException("user metadata changed from " + before.userMetadata() + " to " + after.userMetadata());
            }
            if (!before.version().equals(after.version())) {
                throw new IllegalArgumentException("version changed from " + before.version() + " to " + after.version());
            }
        }

        @Override
        public Entry apply(Entry part) {
            Map<String, IndexId> updatedIndices = this.indexByIndexNameDiff.apply(part.indices);
            Map<ShardId, ShardSnapshotStatus> updatedStateByShard = this.shardsByShardIdDiff.apply(part.shards);
            if (!part.isClone() && updatedIndices == part.indices && updatedStateByShard == part.shards) {
                return new Entry(part.snapshot, part.includeGlobalState, part.partial, this.updatedState, updatedIndices, this.updatedDataStreams == null ? part.dataStreams : this.updatedDataStreams, part.featureStates, part.startTime, this.updatedRepositoryStateId, updatedStateByShard, this.updatedFailure, part.userMetadata, part.version, null, part.shardStatusByRepoShardId, part.snapshotIndices, part.hasShardsInInitState);
            }
            if (part.isClone()) {
                return Entry.createClone(part.snapshot, this.updatedState, updatedIndices, part.startTime, this.updatedRepositoryStateId, this.updatedFailure, part.version, part.source, this.shardsByRepoShardIdDiff.apply(part.shardStatusByRepoShardId));
            }
            return Entry.snapshot(part.snapshot, part.includeGlobalState, part.partial, this.updatedState, updatedIndices, this.updatedDataStreams == null ? part.dataStreams : this.updatedDataStreams, part.featureStates, part.startTime, this.updatedRepositoryStateId, updatedStateByShard, this.updatedFailure, part.userMetadata, part.version);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.indexByIndexNameDiff.writeTo(out);
            out.writeByte(this.updatedState.value());
            out.writeLong(this.updatedRepositoryStateId);
            out.writeOptionalStringCollection(this.updatedDataStreams);
            out.writeOptionalString(this.updatedFailure);
            this.shardsByShardIdDiff.writeTo(out);
            out.writeOptionalWriteable(this.shardsByRepoShardIdDiff);
        }
    }
}

