/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.CancellableFanOut;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public abstract class TransportNodesAction<NodesRequest extends BaseNodesRequest<NodesRequest>, NodesResponse extends BaseNodesResponse<?>, NodeRequest extends TransportRequest, NodeResponse extends BaseNodeResponse>
extends TransportAction<NodesRequest, NodesResponse> {
    private static final Logger logger = LogManager.getLogger(TransportNodesAction.class);
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final String transportNodeAction;
    private final Executor finalExecutor;

    protected TransportNodesAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<NodeRequest> nodeRequest, Executor executor) {
        super(actionName, actionFilters, transportService.getTaskManager());
        assert (!executor.equals(EsExecutors.DIRECT_EXECUTOR_SERVICE)) : "TransportNodesAction must always fork off the transport thread";
        this.clusterService = Objects.requireNonNull(clusterService);
        this.transportService = Objects.requireNonNull(transportService);
        this.finalExecutor = executor;
        this.transportNodeAction = actionName + "[n]";
        transportService.registerRequestHandler(this.transportNodeAction, this.finalExecutor, nodeRequest, new NodeTransportHandler());
    }

    @Override
    protected void doExecute(Task task, NodesRequest request, ActionListener<NodesResponse> listener) {
        if (((BaseNodesRequest)request).concreteNodes() == null) {
            this.resolveRequest(request, this.clusterService.state());
            assert (((BaseNodesRequest)request).concreteNodes() != null);
        }
        new CancellableFanOut<DiscoveryNode, NodeResponse, CheckedConsumer<ActionListener<NodesResponse>, Exception>>((BaseNodesRequest)request, task){
            final ArrayList<NodeResponse> responses;
            final ArrayList<FailedNodeException> exceptions;
            final TransportRequestOptions transportRequestOptions;
            final /* synthetic */ BaseNodesRequest val$request;
            final /* synthetic */ Task val$task;
            {
                this.val$request = baseNodesRequest;
                this.val$task = task;
                this.responses = new ArrayList(this.val$request.concreteNodes().length);
                this.exceptions = new ArrayList(0);
                this.transportRequestOptions = TransportRequestOptions.timeout(this.val$request.timeout());
                this.addReleaseOnCancellationListener();
            }

            private void addReleaseOnCancellationListener() {
                if (this.val$task instanceof CancellableTask) {
                    CancellableTask cancellableTask = (CancellableTask)this.val$task;
                    cancellableTask.addListener(() -> {
                        List drainedResponses;
                        ArrayList arrayList = this.responses;
                        synchronized (arrayList) {
                            drainedResponses = List.copyOf(this.responses);
                            this.responses.clear();
                        }
                        Releasables.wrap(Iterators.map(drainedResponses.iterator(), r -> r::decRef)).close();
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void sendItemRequest(DiscoveryNode discoveryNode, ActionListener<NodeResponse> listener) {
                Object nodeRequest = TransportNodesAction.this.newNodeRequest(this.val$request);
                if (this.val$task != null) {
                    nodeRequest.setParentTask(TransportNodesAction.this.clusterService.localNode().getId(), this.val$task.getId());
                }
                try {
                    TransportNodesAction.this.transportService.sendRequest(discoveryNode, TransportNodesAction.this.transportNodeAction, (TransportRequest)nodeRequest, this.transportRequestOptions, new ActionListenerResponseHandler(listener, TransportNodesAction.this.nodeResponseReader(discoveryNode), TransportNodesAction.this.finalExecutor));
                }
                finally {
                    ((TransportMessage)nodeRequest).decRef();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onItemResponse(DiscoveryNode discoveryNode, NodeResponse nodeResponse) {
                nodeResponse.mustIncRef();
                ArrayList arrayList = this.responses;
                synchronized (arrayList) {
                    CancellableTask cancellableTask;
                    if (!(this.val$task instanceof CancellableTask && (cancellableTask = (CancellableTask)this.val$task).isCancelled())) {
                        this.responses.add(nodeResponse);
                        return;
                    }
                }
                ((TransportMessage)nodeResponse).decRef();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onItemFailure(DiscoveryNode discoveryNode, Exception e) {
                logger.debug(() -> Strings.format("failed to execute [%s] on node [%s]", TransportNodesAction.this.actionName, discoveryNode), (Throwable)e);
                ArrayList<FailedNodeException> arrayList = this.exceptions;
                synchronized (arrayList) {
                    this.exceptions.add(new FailedNodeException(discoveryNode.getId(), "Failed node [" + discoveryNode.getId() + "]", e));
                }
            }

            @Override
            protected CheckedConsumer<ActionListener<NodesResponse>, Exception> onCompletion() {
                return l -> {
                    try (Releasable ignored = Releasables.wrap(Iterators.map(this.responses.iterator(), r -> r::decRef));){
                        TransportNodesAction.this.newResponseAsync(this.val$task, this.val$request, this.responses, (List<FailedNodeException>)this.exceptions, l);
                    }
                };
            }

            public String toString() {
                return TransportNodesAction.this.actionName;
            }
        }.run(task, Iterators.forArray(((BaseNodesRequest)request).concreteNodes()), new ThreadedActionListener<CheckedConsumer>(this.finalExecutor, listener.delegateFailureAndWrap((l, c) -> c.accept(l))));
    }

    private Writeable.Reader<NodeResponse> nodeResponseReader(DiscoveryNode discoveryNode) {
        return in -> this.newNodeResponse(in, discoveryNode);
    }

    protected abstract NodesResponse newResponse(NodesRequest var1, List<NodeResponse> var2, List<FailedNodeException> var3);

    protected void newResponseAsync(Task task, NodesRequest request, List<NodeResponse> responses, List<FailedNodeException> failures, ActionListener<NodesResponse> listener) {
        ActionListener.run(listener, l -> ActionListener.respondAndRelease(l, this.newResponse(request, responses, failures)));
    }

    protected abstract NodeRequest newNodeRequest(NodesRequest var1);

    protected abstract NodeResponse newNodeResponse(StreamInput var1, DiscoveryNode var2) throws IOException;

    protected abstract NodeResponse nodeOperation(NodeRequest var1, Task var2);

    protected void nodeOperationAsync(NodeRequest request, Task task, ActionListener<NodeResponse> listener) {
        ActionListener.respondAndRelease(listener, this.nodeOperation(request, task));
    }

    protected void resolveRequest(NodesRequest request, ClusterState clusterState) {
        assert (((BaseNodesRequest)request).concreteNodes() == null) : "request concreteNodes shouldn't be set";
        String[] nodesIds = clusterState.nodes().resolveNodes(((BaseNodesRequest)request).nodesIds());
        ((BaseNodesRequest)request).setConcreteNodes((DiscoveryNode[])Arrays.stream(nodesIds).map(clusterState.nodes()::get).toArray(DiscoveryNode[]::new));
    }

    class NodeTransportHandler
    implements TransportRequestHandler<NodeRequest> {
        NodeTransportHandler() {
        }

        @Override
        public void messageReceived(NodeRequest request, TransportChannel channel, Task task) throws Exception {
            ActionListener.run(new ChannelActionListener(channel), channelListener -> TransportNodesAction.this.nodeOperationAsync(request, task, channelListener));
        }
    }
}

