/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.SimpleRefCounted;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.profile.SearchProfileShardResult;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.transport.LeakTracker;

public class SearchResponseSections
implements RefCounted {
    public static final SearchResponseSections EMPTY_WITH_TOTAL_HITS = new SearchResponseSections(SearchHits.EMPTY_WITH_TOTAL_HITS, null, null, false, null, null, 1);
    public static final SearchResponseSections EMPTY_WITHOUT_TOTAL_HITS = new SearchResponseSections(SearchHits.EMPTY_WITHOUT_TOTAL_HITS, null, null, false, null, null, 1);
    protected final SearchHits hits;
    protected final InternalAggregations aggregations;
    protected final Suggest suggest;
    protected final SearchProfileResults profileResults;
    protected final boolean timedOut;
    protected final Boolean terminatedEarly;
    protected final int numReducePhases;
    private final RefCounted refCounted;

    public SearchResponseSections(SearchHits hits, InternalAggregations aggregations, Suggest suggest, boolean timedOut, Boolean terminatedEarly, SearchProfileResults profileResults, int numReducePhases) {
        this.hits = hits;
        hits.incRef();
        this.aggregations = aggregations;
        this.suggest = suggest;
        this.profileResults = profileResults;
        this.timedOut = timedOut;
        this.terminatedEarly = terminatedEarly;
        this.numReducePhases = numReducePhases;
        this.refCounted = hits.getHits().length > 0 ? LeakTracker.wrap(new SimpleRefCounted()) : ALWAYS_REFERENCED;
    }

    public final SearchHits hits() {
        return this.hits;
    }

    public final Suggest suggest() {
        return this.suggest;
    }

    public final Map<String, SearchProfileShardResult> profile() {
        if (this.profileResults == null) {
            return Collections.emptyMap();
        }
        return this.profileResults.getShardResults();
    }

    @Override
    public void incRef() {
        this.refCounted.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.refCounted.tryIncRef();
    }

    @Override
    public boolean decRef() {
        if (this.refCounted.decRef()) {
            this.hits.decRef();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasReferences() {
        return this.refCounted.hasReferences();
    }
}

