/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class MaxAgeCondition
extends Condition<TimeValue> {
    public static final String NAME = "max_age";

    public MaxAgeCondition(TimeValue value) {
        super(NAME, Condition.Type.MAX);
        this.value = value;
    }

    public MaxAgeCondition(StreamInput in) throws IOException {
        super(NAME, Condition.Type.MAX);
        this.value = TimeValue.timeValueMillis(in.readLong());
    }

    @Override
    public Condition.Result evaluate(Condition.Stats stats) {
        long indexAge = System.currentTimeMillis() - stats.indexCreated();
        return new Condition.Result(this, ((TimeValue)this.value).getMillis() <= indexAge);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(((TimeValue)this.value).getMillis());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field(NAME, ((TimeValue)this.value).getStringRep());
    }

    public static MaxAgeCondition fromXContent(XContentParser parser) throws IOException {
        if (parser.nextToken() == XContentParser.Token.VALUE_STRING) {
            return new MaxAgeCondition(TimeValue.parseTimeValue(parser.text(), NAME));
        }
        throw new IllegalArgumentException("invalid token when parsing max_age condition: " + parser.currentToken());
    }
}

