/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.storedscripts;

import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.storedscripts.GetScriptContextRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.GetScriptContextResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.script.ScriptContextInfo;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportGetScriptContextAction
extends HandledTransportAction<GetScriptContextRequest, GetScriptContextResponse> {
    private final ScriptService scriptService;

    @Inject
    public TransportGetScriptContextAction(TransportService transportService, ActionFilters actionFilters, ScriptService scriptService) {
        super("cluster:admin/script_context/get", transportService, actionFilters, GetScriptContextRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.scriptService = scriptService;
    }

    @Override
    protected void doExecute(Task task, GetScriptContextRequest request, ActionListener<GetScriptContextResponse> listener) {
        Set<ScriptContextInfo> contexts = this.scriptService.getContextInfos();
        listener.onResponse(new GetScriptContextResponse(contexts));
    }
}

