/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.stats.AnalysisStats;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsIndices;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodes;
import org.elasticsearch.action.admin.cluster.stats.MappingStats;
import org.elasticsearch.action.admin.cluster.stats.VersionStats;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterSnapshotStats;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterStatsResponse
extends BaseNodesResponse<ClusterStatsNodeResponse>
implements ToXContentFragment {
    final ClusterStatsNodes nodesStats;
    final ClusterStatsIndices indicesStats;
    final ClusterHealthStatus status;
    final ClusterSnapshotStats clusterSnapshotStats;
    final long timestamp;
    final String clusterUUID;

    public ClusterStatsResponse(long timestamp, String clusterUUID, ClusterName clusterName, List<ClusterStatsNodeResponse> nodes, List<FailedNodeException> failures, MappingStats mappingStats, AnalysisStats analysisStats, VersionStats versionStats, ClusterSnapshotStats clusterSnapshotStats) {
        super(clusterName, nodes, failures);
        this.clusterUUID = clusterUUID;
        this.timestamp = timestamp;
        this.nodesStats = new ClusterStatsNodes(nodes);
        this.indicesStats = new ClusterStatsIndices(nodes, mappingStats, analysisStats, versionStats);
        ClusterHealthStatus status = null;
        for (ClusterStatsNodeResponse response : nodes) {
            if (response.clusterStatus() == null) continue;
            status = response.clusterStatus();
            break;
        }
        this.status = status;
        this.clusterSnapshotStats = clusterSnapshotStats;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public ClusterStatsNodes getNodesStats() {
        return this.nodesStats;
    }

    public ClusterStatsIndices getIndicesStats() {
        return this.indicesStats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    @Override
    protected List<ClusterStatsNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return (List)TransportAction.localOnly();
    }

    @Override
    protected void writeNodesTo(StreamOutput out, List<ClusterStatsNodeResponse> nodes) throws IOException {
        TransportAction.localOnly();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("cluster_uuid", this.getClusterUUID());
        builder.field("timestamp", this.getTimestamp());
        if (this.status != null) {
            builder.field("status", this.status.name().toLowerCase(Locale.ROOT));
        }
        builder.startObject("indices");
        this.indicesStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("nodes");
        this.nodesStats.toXContent(builder, params);
        builder.endObject();
        builder.field("snapshots");
        this.clusterSnapshotStats.toXContent(builder, params);
        return builder;
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

