/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.stats.AnalysisStats;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.cluster.stats.MappingStats;
import org.elasticsearch.action.admin.cluster.stats.SearchUsageStats;
import org.elasticsearch.action.admin.cluster.stats.VersionStats;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.index.cache.query.QueryCacheStats;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.shard.DenseVectorStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterStatsIndices
implements ToXContentFragment {
    private final int indexCount;
    private final ShardStats shards;
    private final DocsStats docs;
    private final StoreStats store;
    private final SearchUsageStats searchUsageStats;
    private final FieldDataStats fieldData;
    private final QueryCacheStats queryCache;
    private final CompletionStats completion;
    private final SegmentsStats segments;
    private final AnalysisStats analysis;
    private final MappingStats mappings;
    private final VersionStats versions;
    private final DenseVectorStats denseVectorStats;

    public ClusterStatsIndices(List<ClusterStatsNodeResponse> nodeResponses, MappingStats mappingStats, AnalysisStats analysisStats, VersionStats versionStats) {
        HashMap<String, ShardStats> countsPerIndex = new HashMap<String, ShardStats>();
        this.docs = new DocsStats();
        this.store = new StoreStats();
        this.searchUsageStats = new SearchUsageStats();
        this.fieldData = new FieldDataStats();
        this.queryCache = new QueryCacheStats();
        this.completion = new CompletionStats();
        this.segments = new SegmentsStats();
        this.denseVectorStats = new DenseVectorStats();
        for (ClusterStatsNodeResponse clusterStatsNodeResponse : nodeResponses) {
            for (org.elasticsearch.action.admin.indices.stats.ShardStats shardStats : clusterStatsNodeResponse.shardsStats()) {
                ShardStats indexShardStats = (ShardStats)countsPerIndex.get(shardStats.getShardRouting().getIndexName());
                if (indexShardStats == null) {
                    indexShardStats = new ShardStats();
                    countsPerIndex.put(shardStats.getShardRouting().getIndexName(), indexShardStats);
                }
                ++indexShardStats.total;
                CommonStats shardCommonStats = shardStats.getStats();
                if (shardStats.getShardRouting().primary()) {
                    ++indexShardStats.primaries;
                    this.docs.add(shardCommonStats.getDocs());
                }
                this.store.add(shardCommonStats.getStore());
                this.fieldData.add(shardCommonStats.getFieldData());
                this.queryCache.add(shardCommonStats.getQueryCache());
                this.completion.add(shardCommonStats.getCompletion());
                this.segments.add(shardCommonStats.getSegments());
                this.denseVectorStats.add(shardCommonStats.getDenseVectorStats());
            }
            this.searchUsageStats.add(clusterStatsNodeResponse.searchUsageStats());
        }
        this.shards = new ShardStats();
        this.indexCount = countsPerIndex.size();
        for (Map.Entry entry : countsPerIndex.entrySet()) {
            this.shards.addIndexShardCount((ShardStats)entry.getValue());
        }
        this.mappings = mappingStats;
        this.analysis = analysisStats;
        this.versions = versionStats;
    }

    public int getIndexCount() {
        return this.indexCount;
    }

    public ShardStats getShards() {
        return this.shards;
    }

    public DocsStats getDocs() {
        return this.docs;
    }

    public StoreStats getStore() {
        return this.store;
    }

    public FieldDataStats getFieldData() {
        return this.fieldData;
    }

    public QueryCacheStats getQueryCache() {
        return this.queryCache;
    }

    public CompletionStats getCompletion() {
        return this.completion;
    }

    public SegmentsStats getSegments() {
        return this.segments;
    }

    public MappingStats getMappings() {
        return this.mappings;
    }

    public AnalysisStats getAnalysis() {
        return this.analysis;
    }

    public VersionStats getVersions() {
        return this.versions;
    }

    public SearchUsageStats getSearchUsageStats() {
        return this.searchUsageStats;
    }

    public DenseVectorStats getDenseVectorStats() {
        return this.denseVectorStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("count", this.indexCount);
        this.shards.toXContent(builder, params);
        this.docs.toXContent(builder, params);
        this.store.toXContent(builder, params);
        this.fieldData.toXContent(builder, params);
        this.queryCache.toXContent(builder, params);
        this.completion.toXContent(builder, params);
        this.segments.toXContent(builder, params);
        if (this.mappings != null) {
            this.mappings.toXContent(builder, params);
        }
        if (this.analysis != null) {
            this.analysis.toXContent(builder, params);
        }
        if (this.versions != null) {
            this.versions.toXContent(builder, params);
        }
        this.searchUsageStats.toXContent(builder, params);
        this.denseVectorStats.toXContent(builder, params);
        return builder;
    }

    public static class ShardStats
    implements ToXContentFragment {
        int indices;
        int total;
        int primaries;
        int minIndexShards = -1;
        int maxIndexShards = -1;
        int minIndexPrimaryShards = -1;
        int maxIndexPrimaryShards = -1;
        double minIndexReplication = -1.0;
        double totalIndexReplication = 0.0;
        double maxIndexReplication = -1.0;

        public int getIndices() {
            return this.indices;
        }

        public int getTotal() {
            return this.total;
        }

        public int getPrimaries() {
            return this.primaries;
        }

        public double getReplication() {
            if (this.primaries == 0) {
                return 0.0;
            }
            return (double)(this.total - this.primaries) / (double)this.primaries;
        }

        public int getMaxIndexShards() {
            return this.maxIndexShards;
        }

        public int getMinIndexShards() {
            return this.minIndexShards;
        }

        public double getAvgIndexShards() {
            if (this.indices == 0) {
                return -1.0;
            }
            return (double)this.total / (double)this.indices;
        }

        public int getMaxIndexPrimaryShards() {
            return this.maxIndexPrimaryShards;
        }

        public int getMinIndexPrimaryShards() {
            return this.minIndexPrimaryShards;
        }

        public double getAvgIndexPrimaryShards() {
            if (this.indices == 0) {
                return -1.0;
            }
            return (double)this.primaries / (double)this.indices;
        }

        public double getMinIndexReplication() {
            return this.minIndexReplication;
        }

        public double getAvgIndexReplication() {
            if (this.indices == 0) {
                return -1.0;
            }
            return this.totalIndexReplication / (double)this.indices;
        }

        public double getMaxIndexReplication() {
            return this.maxIndexReplication;
        }

        public void addIndexShardCount(ShardStats indexShardCount) {
            ++this.indices;
            this.primaries += indexShardCount.primaries;
            this.total += indexShardCount.total;
            this.totalIndexReplication += indexShardCount.getReplication();
            if (this.indices == 1) {
                this.minIndexPrimaryShards = indexShardCount.primaries;
                this.maxIndexPrimaryShards = indexShardCount.primaries;
                this.minIndexShards = indexShardCount.total;
                this.maxIndexShards = indexShardCount.total;
                this.maxIndexReplication = this.minIndexReplication = indexShardCount.getReplication();
            } else {
                this.minIndexShards = Math.min(this.minIndexShards, indexShardCount.total);
                this.minIndexPrimaryShards = Math.min(this.minIndexPrimaryShards, indexShardCount.primaries);
                this.minIndexReplication = Math.min(this.minIndexReplication, indexShardCount.getReplication());
                this.maxIndexShards = Math.max(this.maxIndexShards, indexShardCount.total);
                this.maxIndexPrimaryShards = Math.max(this.maxIndexPrimaryShards, indexShardCount.primaries);
                this.maxIndexReplication = Math.max(this.maxIndexReplication, indexShardCount.getReplication());
            }
        }

        private static void addIntMinMax(String field, int min, int max, double avg, XContentBuilder builder) throws IOException {
            builder.startObject(field);
            builder.field("min", min);
            builder.field("max", max);
            builder.field("avg", avg);
            builder.endObject();
        }

        private static void addDoubleMinMax(String field, double min, double max, double avg, XContentBuilder builder) throws IOException {
            builder.startObject(field);
            builder.field("min", min);
            builder.field("max", max);
            builder.field("avg", avg);
            builder.endObject();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("shards");
            if (this.indices > 0) {
                builder.field("total", this.total);
                builder.field("primaries", this.primaries);
                builder.field("replication", this.getReplication());
                builder.startObject("index");
                ShardStats.addIntMinMax("shards", this.minIndexShards, this.maxIndexShards, this.getAvgIndexShards(), builder);
                ShardStats.addIntMinMax("primaries", this.minIndexPrimaryShards, this.maxIndexPrimaryShards, this.getAvgIndexPrimaryShards(), builder);
                ShardStats.addDoubleMinMax("replication", this.minIndexReplication, this.maxIndexReplication, this.getAvgIndexReplication(), builder);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public String toString() {
            return "total [" + this.total + "] primaries [" + this.primaries + "]";
        }

        static final class Fields {
            static final String SHARDS = "shards";
            static final String TOTAL = "total";
            static final String PRIMARIES = "primaries";
            static final String REPLICATION = "replication";
            static final String MIN = "min";
            static final String MAX = "max";
            static final String AVG = "avg";
            static final String INDEX = "index";

            Fields() {
            }
        }
    }

    static final class Fields {
        static final String COUNT = "count";

        Fields() {
        }
    }
}

