/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.migration;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetFeatureUpgradeStatusResponse
extends ActionResponse
implements ToXContentObject {
    private final List<FeatureUpgradeStatus> featureUpgradeStatuses;
    private final UpgradeStatus upgradeStatus;

    public GetFeatureUpgradeStatusResponse(List<FeatureUpgradeStatus> statuses, UpgradeStatus upgradeStatus) {
        this.featureUpgradeStatuses = Objects.nonNull(statuses) ? statuses : Collections.emptyList();
        this.upgradeStatus = upgradeStatus;
    }

    public GetFeatureUpgradeStatusResponse(StreamInput in) throws IOException {
        super(in);
        this.featureUpgradeStatuses = in.readCollectionAsImmutableList(FeatureUpgradeStatus::new);
        this.upgradeStatus = in.readEnum(UpgradeStatus.class);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("features");
        for (FeatureUpgradeStatus featureUpgradeStatus : this.featureUpgradeStatuses) {
            builder.value(featureUpgradeStatus);
        }
        builder.endArray();
        builder.field("migration_status", this.upgradeStatus);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.featureUpgradeStatuses);
        out.writeEnum(this.upgradeStatus);
    }

    public List<FeatureUpgradeStatus> getFeatureUpgradeStatuses() {
        return this.featureUpgradeStatuses;
    }

    public UpgradeStatus getUpgradeStatus() {
        return this.upgradeStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetFeatureUpgradeStatusResponse that = (GetFeatureUpgradeStatusResponse)o;
        return Objects.equals(this.featureUpgradeStatuses, that.featureUpgradeStatuses) && Objects.equals((Object)this.upgradeStatus, (Object)that.upgradeStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.featureUpgradeStatuses, this.upgradeStatus});
    }

    public String toString() {
        return "GetFeatureUpgradeStatusResponse{featureUpgradeStatuses=" + this.featureUpgradeStatuses + ", upgradeStatus='" + this.upgradeStatus + "'}";
    }

    public static enum UpgradeStatus {
        NO_MIGRATION_NEEDED,
        MIGRATION_NEEDED,
        IN_PROGRESS,
        ERROR;


        public static UpgradeStatus combine(UpgradeStatus ... statuses) {
            int statusOrd = 0;
            for (UpgradeStatus status : statuses) {
                statusOrd = Math.max(status.ordinal(), statusOrd);
            }
            return UpgradeStatus.values()[statusOrd];
        }
    }

    public static class FeatureUpgradeStatus
    implements Writeable,
    ToXContentObject {
        private final String featureName;
        private final IndexVersion minimumIndexVersion;
        private final UpgradeStatus upgradeStatus;
        private final List<IndexInfo> indexInfos;

        public FeatureUpgradeStatus(String featureName, IndexVersion minimumIndexVersion, UpgradeStatus upgradeStatus, List<IndexInfo> indexInfos) {
            this.featureName = featureName;
            this.minimumIndexVersion = minimumIndexVersion;
            this.upgradeStatus = upgradeStatus;
            this.indexInfos = indexInfos;
        }

        public FeatureUpgradeStatus(StreamInput in) throws IOException {
            this.featureName = in.readString();
            this.minimumIndexVersion = IndexVersion.readVersion(in);
            this.upgradeStatus = in.readEnum(UpgradeStatus.class);
            this.indexInfos = in.readCollectionAsImmutableList(IndexInfo::new);
        }

        public String getFeatureName() {
            return this.featureName;
        }

        public IndexVersion getMinimumIndexVersion() {
            return this.minimumIndexVersion;
        }

        public UpgradeStatus getUpgradeStatus() {
            return this.upgradeStatus;
        }

        public List<IndexInfo> getIndexVersions() {
            return this.indexInfos;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.featureName);
            IndexVersion.writeVersion(this.minimumIndexVersion, out);
            out.writeEnum(this.upgradeStatus);
            out.writeCollection(this.indexInfos);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("feature_name", this.featureName);
            builder.field("minimum_index_version", this.minimumIndexVersion.toReleaseVersion());
            builder.field("migration_status", this.upgradeStatus);
            builder.startArray("indices");
            for (IndexInfo version : this.indexInfos) {
                builder.value(version);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureUpgradeStatus that = (FeatureUpgradeStatus)o;
            return Objects.equals(this.featureName, that.featureName) && Objects.equals(this.minimumIndexVersion, that.minimumIndexVersion) && Objects.equals((Object)this.upgradeStatus, (Object)that.upgradeStatus) && Objects.equals(this.indexInfos, that.indexInfos);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.featureName, this.minimumIndexVersion, this.upgradeStatus, this.indexInfos});
        }

        public String toString() {
            return "FeatureUpgradeStatus{featureName='" + this.featureName + "', minimumIndexVersion='" + this.minimumIndexVersion + "', upgradeStatus='" + this.upgradeStatus + "', indexInfos=" + this.indexInfos + "}";
        }
    }

    public static class IndexInfo
    implements Writeable,
    ToXContentObject {
        private static final Map<String, String> STACK_TRACE_ENABLED_PARAMS = Map.of("rest.exception.stacktrace.skip", "false");
        private final String indexName;
        private final IndexVersion version;
        @Nullable
        private final Exception exception;

        public IndexInfo(String indexName, IndexVersion version, Exception exception) {
            this.indexName = indexName;
            this.version = version;
            this.exception = exception;
        }

        public IndexInfo(StreamInput in) throws IOException {
            this.indexName = in.readString();
            this.version = IndexVersion.readVersion(in);
            boolean hasException = in.readBoolean();
            this.exception = hasException ? in.readException() : null;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public IndexVersion getVersion() {
            return this.version;
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.indexName);
            IndexVersion.writeVersion(this.version, out);
            if (this.exception != null) {
                out.writeBoolean(true);
                out.writeException(this.exception);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            ToXContent.DelegatingMapParams exceptionParams = new ToXContent.DelegatingMapParams(STACK_TRACE_ENABLED_PARAMS, params);
            builder.startObject();
            builder.field("index", this.indexName);
            builder.field("version", this.version.toReleaseVersion());
            if (this.exception != null) {
                builder.startObject("failure_cause");
                ElasticsearchException.generateFailureXContent(builder, exceptionParams, this.exception, true);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexInfo that = (IndexInfo)o;
            return this.indexName.equals(that.indexName) && this.version.equals(that.version);
        }

        public int hashCode() {
            return Objects.hash(this.indexName, this.version);
        }

        public String toString() {
            return "IndexInfo{indexName='" + this.indexName + "', version='" + this.version + "', exception='" + (this.exception == null ? "null" : this.exception.getMessage()) + "'}";
        }
    }
}

