/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;

public final class SingleResultDeduplicator<T> {
    private final ThreadContext threadContext;
    private List<ActionListener<T>> waitingListeners;
    private ThreadContext.StoredContext waitingStoredContext;
    private final Consumer<ActionListener<T>> executeAction;

    public SingleResultDeduplicator(ThreadContext threadContext, Consumer<ActionListener<T>> executeAction) {
        this.threadContext = threadContext;
        this.executeAction = executeAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ActionListener<T> listener) {
        SingleResultDeduplicator singleResultDeduplicator = this;
        synchronized (singleResultDeduplicator) {
            if (this.waitingListeners != null) {
                if (this.waitingListeners.isEmpty()) {
                    assert (this.waitingStoredContext == null);
                    this.waitingStoredContext = this.threadContext.newStoredContext();
                }
                this.waitingListeners.add(ContextPreservingActionListener.wrapPreservingContext(listener, this.threadContext));
                return;
            }
            this.waitingListeners = new ArrayList<ActionListener<T>>();
            this.waitingStoredContext = null;
        }
        this.doExecute(ContextPreservingActionListener.wrapPreservingContext(listener, this.threadContext), null);
    }

    private void doExecute(ActionListener<T> listener, @Nullable ThreadContext.StoredContext storedContext) {
        ActionListener<T> wrappedListener = ActionListener.runBefore(listener, () -> {
            ThreadContext.StoredContext thisStoredContext;
            List<ActionListener<T>> listeners;
            SingleResultDeduplicator singleResultDeduplicator = this;
            synchronized (singleResultDeduplicator) {
                if (this.waitingListeners.isEmpty()) {
                    this.waitingListeners = null;
                    this.waitingStoredContext = null;
                    return;
                }
                listeners = this.waitingListeners;
                thisStoredContext = this.waitingStoredContext;
                assert (thisStoredContext != null) : "stored context must not be null for the first listener in a batch";
                this.waitingListeners = new ArrayList<ActionListener<T>>();
                this.waitingStoredContext = null;
            }
            try (ThreadContext.StoredContext ignore = this.threadContext.newStoredContext();){
                this.doExecute(new ActionListener<T>(){

                    @Override
                    public void onResponse(T response) {
                        ActionListener.onResponse(listeners, response);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        ActionListener.onFailure(listeners, e);
                    }
                }, thisStoredContext);
            }
        });
        if (storedContext != null) {
            storedContext.restore();
        }
        ActionListener.run(wrappedListener, this.executeAction::accept);
    }
}

