/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration.geoip;

import co.elastic.logstash.filters.elasticintegration.geoip.GeoIpDatabaseAdapter;
import co.elastic.logstash.filters.elasticintegration.geoip.GeoipDatabaseHolder;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.ingest.geoip.GeoIpDatabase;

public class ManagedGeoipDatabaseHolder
implements GeoipDatabaseHolder,
Closeable {
    private static final Logger LOGGER = LogManager.getLogger();
    private GeoIpDatabaseAdapter currentDatabase;
    private final String databaseTypeIdentifier;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public ManagedGeoipDatabaseHolder(String databaseTypeIdentifier) {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
        this.databaseTypeIdentifier = databaseTypeIdentifier;
    }

    @Override
    public boolean isValid() {
        return this.withLock((Lock)this.readLock, () -> Objects.nonNull(this.currentDatabase));
    }

    @Override
    public GeoIpDatabase getDatabase() {
        return this.withLock((Lock)this.readLock, () -> this.currentDatabase);
    }

    @Override
    public String getTypeIdentifier() {
        return this.databaseTypeIdentifier;
    }

    @Override
    public String info() {
        return this.withLock((Lock)this.readLock, () -> String.format("ManagedGeoipDatabase{type=%s, valid=%s}", this.getTypeIdentifier(), this.isValid()));
    }

    public void setDatabasePath(String newDatabasePath) {
        this.withLock((Lock)this.writeLock, () -> {
            this.currentDatabase = Optional.ofNullable(newDatabasePath).map(x$0 -> Paths.get(x$0, new String[0])).map(this::loadDatabase).orElse(null);
        });
    }

    @Override
    public void close() throws IOException {
        this.withLock((Lock)this.writeLock, () -> {
            if (Objects.nonNull(this.currentDatabase)) {
                IOUtils.closeWhileHandlingException((Closeable)this.currentDatabase);
                this.currentDatabase = null;
            }
        });
    }

    private GeoIpDatabaseAdapter loadDatabase(Path databasePath) {
        try {
            GeoIpDatabaseAdapter candidate = GeoIpDatabaseAdapter.defaultForPath(databasePath);
            String candidateType = candidate.getDatabaseType();
            if (!Objects.equals(candidateType, this.databaseTypeIdentifier)) {
                throw new IllegalStateException(String.format("Incompatible database type `%s` (expected `%s`)", candidateType, this.databaseTypeIdentifier));
            }
            return candidate;
        }
        catch (IOException e) {
            LOGGER.warn(() -> String.format("failed to load database from path `%s`: %s", databasePath, e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLock(Lock lock, Supplier<T> handler) {
        lock.lock();
        try {
            T t = handler.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    private void withLock(Lock lock, Runnable runnable) {
        this.withLock(lock, () -> {
            runnable.run();
            return null;
        });
    }
}

