/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logstash.filters.elasticintegration;

import co.elastic.logstash.api.Password;
import co.elastic.logstash.filters.elasticintegration.PluginConfiguration;
import co.elastic.logstash.filters.elasticintegration.util.Exceptions;
import co.elastic.logstash.filters.elasticintegration.util.KeyStoreUtil;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ElasticsearchRestClientBuilder {
    private final Supplier<RestClientBuilder> restClientBuilderSupplier;
    private final TrustConfig trustConfig = new TrustConfig();
    private final IdentityConfig identityConfig = new IdentityConfig();
    private final RequestAuthConfig requestAuthConfig = new RequestAuthConfig();
    private final ElasticApiConfig elasticApiConfig = new ElasticApiConfig();
    private String userAgentHeaderValue;

    public static ElasticsearchRestClientBuilder forCloudId(String cloudId) {
        return ElasticsearchRestClientBuilder.forCloudId(cloudId, CloudIdRestClientBuilderFactory.DEFAULT);
    }

    static ElasticsearchRestClientBuilder forCloudId(String cloudId, CloudIdRestClientBuilderFactory factory) {
        return new ElasticsearchRestClientBuilder(() -> factory.getBuilder(cloudId));
    }

    public static ElasticsearchRestClientBuilder forURLs(Collection<URL> urls) {
        return ElasticsearchRestClientBuilder.forURLs(urls, HostsArrayRestClientBuilderFactory.DEFAULT);
    }

    static ElasticsearchRestClientBuilder forURLs(Collection<URL> urls, HostsArrayRestClientBuilderFactory factory) {
        Objects.requireNonNull(urls, "urls must not be null");
        if (urls.isEmpty()) {
            throw new IllegalStateException("urls must not be empty");
        }
        String commonScheme = ElasticsearchRestClientBuilder.extractCommon(urls, URL::getProtocol, "protocol", null);
        String commonPath = ElasticsearchRestClientBuilder.extractCommon(urls, URL::getPath, "path", "/");
        if (urls.stream().map(URL::getPort).anyMatch(given -> given == -1)) {
            throw new IllegalStateException("URLS must include port specification");
        }
        HttpHost[] httpHosts = (HttpHost[])urls.stream().map(url -> new HttpHost(url.getHost(), url.getPort(), commonScheme)).toArray(HttpHost[]::new);
        return new ElasticsearchRestClientBuilder(() -> factory.getBuilder(httpHosts).setPathPrefix(commonPath));
    }

    public static Optional<ElasticsearchRestClientBuilder> fromPluginConfiguration(PluginConfiguration config) {
        return ElasticsearchRestClientBuilder.builderInit(config).map(builder -> builder.configureTrust(trustConfig -> {
            config.sslVerificationMode().ifPresent(trustConfig::setSSLVerificationMode);
            config.truststore().ifPresent(truststore -> {
                Password truststorePassword = config.truststorePassword().orElseThrow(ElasticsearchRestClientBuilder.missingRequired("truststorePassword"));
                trustConfig.setTrustStore((Path)truststore, truststorePassword);
            });
            config.sslCertificateAuthorities().ifPresent(trustConfig::setCertificateAuthorities);
        }).configureIdentity(identityConfig -> {
            config.keystore().ifPresent(keystore -> {
                Password keystorePassword = config.keystorePassword().orElseThrow(ElasticsearchRestClientBuilder.missingRequired("keystorePassword"));
                identityConfig.setKeyStore((Path)keystore, keystorePassword);
            });
            config.sslCertificate().ifPresent(sslCertificate -> {
                Path sslKey = config.sslKey().orElseThrow(ElasticsearchRestClientBuilder.missingRequired("sslKey"));
                Password sslKeyPassphrase = config.sslKeyPassphrase().orElseThrow(ElasticsearchRestClientBuilder.missingRequired("sslKeyPassphrase"));
                identityConfig.setCertificateKeyPair((Path)sslCertificate, sslKey, sslKeyPassphrase);
            });
        }).configureRequestAuth(requestAuthConfig -> {
            config.authBasicUsername().ifPresent(username -> {
                Password authBasicPassword = config.authBasicPassword().orElseThrow(ElasticsearchRestClientBuilder.missingRequired("authBasicPassword"));
                requestAuthConfig.setBasicAuth((String)username, authBasicPassword);
            });
            config.cloudAuth().ifPresent(requestAuthConfig::setCloudAuth);
            config.apiKey().ifPresent(requestAuthConfig::setApiKey);
        }));
    }

    private static Supplier<IllegalArgumentException> missingRequired(String param) {
        return () -> new IllegalArgumentException(String.format("missing required `%s`", param));
    }

    private static Optional<ElasticsearchRestClientBuilder> builderInit(PluginConfiguration config) {
        return config.cloudId().map(ElasticsearchRestClientBuilder::forCloudId).or(() -> config.hosts().map(ElasticsearchRestClientBuilder::forURLs));
    }

    private ElasticsearchRestClientBuilder(Supplier<RestClientBuilder> restClientBuilderSupplier) {
        this.restClientBuilderSupplier = restClientBuilderSupplier;
    }

    public ElasticsearchRestClientBuilder configureIdentity(Consumer<IdentityConfig> identityConfigurator) {
        identityConfigurator.accept(this.identityConfig);
        return this;
    }

    public ElasticsearchRestClientBuilder configureTrust(Consumer<TrustConfig> trustConfigurator) {
        trustConfigurator.accept(this.trustConfig);
        return this;
    }

    public ElasticsearchRestClientBuilder configureRequestAuth(Consumer<RequestAuthConfig> requestAuthConfigurator) {
        requestAuthConfigurator.accept(this.requestAuthConfig);
        return this;
    }

    public ElasticsearchRestClientBuilder configureElasticApi(Consumer<ElasticApiConfig> elasticApiConfigConsumer) {
        elasticApiConfigConsumer.accept(this.elasticApiConfig);
        return this;
    }

    public synchronized ElasticsearchRestClientBuilder setUserAgentHeaderValue(String userAgentHeaderValue) {
        this.userAgentHeaderValue = userAgentHeaderValue;
        return this;
    }

    public RestClient build() {
        return this.build(this.restClientBuilderSupplier.get());
    }

    RestClient build(RestClientBuilder restClientBuilder) {
        return this.configureHttpClient(restClientBuilder, httpClientBuilder -> {
            this.trustConfig.configureHttpClient(httpClientBuilder);
            this.requestAuthConfig.configureHttpClient(httpClientBuilder);
            httpClientBuilder.setSSLContext(ElasticsearchRestClientBuilder.configureSSLContext(sslContextBuilder -> {
                this.trustConfig.configureSSLContext(sslContextBuilder);
                this.identityConfig.configureSSLContext(sslContextBuilder);
            }));
            this.elasticApiConfig.configureHttpClient(httpClientBuilder);
            if (Objects.nonNull(this.userAgentHeaderValue)) {
                httpClientBuilder.setUserAgent(this.userAgentHeaderValue);
            }
        }).build();
    }

    private static SSLContext configureSSLContext(SSLContextConfigurator sslContextConfigurator) {
        SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
        sslContextConfigurator.configure(sslContextBuilder);
        try {
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            throw Exceptions.wrap(e, "Failed to build SSL Context");
        }
    }

    private RestClientBuilder configureHttpClient(RestClientBuilder restClientBuilder, HttpClientConfigurator configurator) {
        return restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> {
            configurator.configure(httpClientBuilder);
            return httpClientBuilder;
        });
    }

    private static <T, V> V extractCommon(Collection<T> input, Function<T, V> extractor, String message, V valueIfMissing) {
        List<Object> provided = input.stream().map(extractor).map(ex -> Objects.requireNonNullElse(ex, valueIfMissing)).distinct().toList();
        if (provided.isEmpty()) {
            throw new IllegalStateException(String.format("non-uniform(%s):%s", message, input));
        }
        if (provided.size() > 1) {
            throw new IllegalStateException(String.format("non-uniform(%s):%s", message, input));
        }
        return (V)provided.get(0);
    }

    @FunctionalInterface
    static interface CloudIdRestClientBuilderFactory {
        public static final CloudIdRestClientBuilderFactory DEFAULT = RestClient::builder;

        public RestClientBuilder getBuilder(String var1);
    }

    @FunctionalInterface
    static interface HostsArrayRestClientBuilderFactory {
        public static final HostsArrayRestClientBuilderFactory DEFAULT = RestClient::builder;

        public RestClientBuilder getBuilder(HttpHost ... var1);
    }

    public static class TrustConfig {
        private SSLVerificationMode sslVerificationMode = SSLVerificationMode.FULL;
        private KeyStore trustStore;

        public TrustConfig setSSLVerificationMode(String proposedVerificationMode) {
            Objects.requireNonNull(proposedVerificationMode, "proposedVerificationMode");
            return this.setSSLVerificationMode(SSLVerificationMode.valueOf(proposedVerificationMode.toUpperCase()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TrustConfig setSSLVerificationMode(SSLVerificationMode proposedVerificationMode) {
            Objects.requireNonNull(proposedVerificationMode, "proposedVerificationMode");
            TrustConfig trustConfig = this;
            synchronized (trustConfig) {
                if (proposedVerificationMode == SSLVerificationMode.NONE && Objects.nonNull(this.trustStore)) {
                    throw new IllegalStateException("SSL Verification Mode cannot be set to NONE when connection trust configuration has been provided");
                }
                this.sslVerificationMode = proposedVerificationMode;
            }
            return this;
        }

        public TrustConfig setCertificateAuthorities(List<Path> certificateAuthorities) {
            Objects.requireNonNull(certificateAuthorities, "certificateAuthorities");
            return this.setTrustStore(KeyStoreUtil.fromCertificateAuthorities(certificateAuthorities));
        }

        public TrustConfig setTrustStore(Path trustStorePath, Password trustStorePassword) {
            Objects.requireNonNull(trustStorePath, "trustStorePath");
            Objects.requireNonNull(trustStorePassword, "trustStorePassword");
            return this.setTrustStore(KeyStoreUtil.load(trustStorePath, trustStorePassword));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized TrustConfig setTrustStore(KeyStore trustStore) {
            TrustConfig trustConfig = this;
            synchronized (trustConfig) {
                if (this.sslVerificationMode == SSLVerificationMode.NONE) {
                    throw new IllegalStateException("Configuring connection trust source is not allowed when verification is set to NONE");
                }
                if (Objects.nonNull(this.trustStore)) {
                    throw new IllegalStateException("Only one connection trust source may be provided");
                }
                this.trustStore = trustStore;
            }
            return this;
        }

        public void configureSSLContext(SSLContextBuilder sslContextBuilder) {
            try {
                if (this.sslVerificationMode == SSLVerificationMode.NONE) {
                    sslContextBuilder.loadTrustMaterial(null, TrustAllStrategy.INSTANCE);
                } else if (Objects.nonNull(this.trustStore)) {
                    sslContextBuilder.loadTrustMaterial(this.trustStore, null);
                }
            }
            catch (Exception e) {
                throw Exceptions.wrap(e, "Failed to configure SSL Context");
            }
        }

        public void configureHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
            if (this.sslVerificationMode == SSLVerificationMode.CERTIFICATE) {
                httpClientBuilder.setSSLHostnameVerifier(new NoopHostnameVerifier());
            }
        }
    }

    public static class IdentityConfig {
        private KeyStore keyStore;
        private Password keyPassword;

        public IdentityConfig setKeyStore(Path keystorePath, Password password) {
            Objects.requireNonNull(keystorePath, "keystorePath");
            Objects.requireNonNull(password, "password");
            return this.setKeyStoreAndPassword(KeyStoreUtil.load(keystorePath, password), password);
        }

        public IdentityConfig setCertificateKeyPair(Path certificatePath, Path keyPath, Password keyPassword) {
            Objects.requireNonNull(certificatePath, "certificatePath");
            Objects.requireNonNull(keyPath, "keyPath");
            Objects.requireNonNull(keyPassword, "keyPassword");
            return this.setKeyStoreAndPassword(KeyStoreUtil.fromCertKeyPair(certificatePath, keyPath, keyPassword), keyPassword);
        }

        private synchronized IdentityConfig setKeyStoreAndPassword(KeyStore proposedKeyStore, Password proposedPassword) {
            if (Objects.nonNull(this.keyStore) || Objects.nonNull(this.keyPassword)) {
                throw new IllegalStateException("Only one connection identity source may be provided");
            }
            this.keyStore = proposedKeyStore;
            this.keyPassword = proposedPassword;
            return this;
        }

        public void configureSSLContext(SSLContextBuilder sslContextBuilder) {
            if (Objects.isNull(this.keyStore)) {
                return;
            }
            try {
                sslContextBuilder.loadKeyMaterial(this.keyStore, this.keyPassword.getPassword().toCharArray());
            }
            catch (Exception e) {
                throw Exceptions.wrap(e, "Failed to configure SSL Context");
            }
        }
    }

    public static class RequestAuthConfig {
        private HttpClientConfigurator httpClientConfigurator;

        public RequestAuthConfig setBasicAuth(String username, Password password) {
            Objects.requireNonNull(username, "username");
            Objects.requireNonNull(password, "password");
            assert (username.indexOf(58) == -1) : "username cannot contain colon (`:`)";
            String encodedCredentials = Base64.getEncoder().encodeToString(String.format("%s:%s", username, password.getPassword()).getBytes(StandardCharsets.UTF_8));
            AuthorizationHeaderHttpRequestInterceptor interceptor = new AuthorizationHeaderHttpRequestInterceptor(String.format("Basic %s", encodedCredentials));
            return this.setHttpClientConfigurator(HttpClientConfigurator.forAddInterceptorFirst(interceptor));
        }

        public RequestAuthConfig setApiKey(Password apiKey) {
            Objects.requireNonNull(apiKey, "apiKey");
            String encodedApiKey = apiKey.getPassword().matches("[^:]+:[^:]+") ? Base64.getEncoder().encodeToString(apiKey.getPassword().getBytes(StandardCharsets.UTF_8)) : apiKey.getPassword();
            AuthorizationHeaderHttpRequestInterceptor interceptor = new AuthorizationHeaderHttpRequestInterceptor(String.format("ApiKey %s", encodedApiKey));
            return this.setHttpClientConfigurator(HttpClientConfigurator.forAddInterceptorFirst(interceptor));
        }

        public RequestAuthConfig setCloudAuth(Password cloudAuth) {
            String password;
            String username;
            Objects.requireNonNull(cloudAuth, "cloudAuth");
            String cloudAuthValue = cloudAuth.getValue();
            int colonIndex = cloudAuthValue.indexOf(":");
            if (colonIndex <= 0 || Strings.isNullOrEmpty((String)(username = cloudAuthValue.substring(0, colonIndex))) || Strings.isNullOrEmpty((String)(password = cloudAuthValue.substring(colonIndex + 1)))) {
                throw new IllegalArgumentException("Invalid cloudAuth.");
            }
            return this.setBasicAuth(username, new Password(password));
        }

        private synchronized RequestAuthConfig setHttpClientConfigurator(HttpClientConfigurator httpClientConfigurator) {
            if (Objects.nonNull(this.httpClientConfigurator)) {
                throw new IllegalStateException("Only one request authentication source may be provided");
            }
            this.httpClientConfigurator = httpClientConfigurator;
            return this;
        }

        public void configureHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
            if (Objects.nonNull(this.httpClientConfigurator)) {
                this.httpClientConfigurator.configure(httpClientBuilder);
            }
        }
    }

    public static class ElasticApiConfig {
        private String apiVersion;

        public synchronized ElasticApiConfig setApiVersion(String apiVersion) {
            if (Objects.nonNull(this.apiVersion)) {
                throw new IllegalStateException("Only one Elastic Api Version may be provided");
            }
            this.apiVersion = apiVersion;
            return this;
        }

        public void configureHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
            if (Objects.nonNull(this.apiVersion)) {
                BasicHeader elasticApiVersionHeader = new BasicHeader("Elastic-Api-Version", this.apiVersion);
                EAVHttpRequestInterceptor interceptor = new EAVHttpRequestInterceptor(elasticApiVersionHeader);
                HttpClientConfigurator.forAddInterceptorFirst(interceptor).configure(httpClientBuilder);
            }
        }
    }

    @FunctionalInterface
    static interface HttpClientConfigurator {
        public void configure(HttpAsyncClientBuilder var1);

        public static HttpClientConfigurator forAddInterceptorFirst(HttpRequestInterceptor interceptor) {
            return httpAsyncClientBuilder -> httpAsyncClientBuilder.addInterceptorFirst(interceptor);
        }
    }

    @FunctionalInterface
    static interface SSLContextConfigurator {
        public void configure(SSLContextBuilder var1);
    }

    private static enum SSLVerificationMode {
        FULL,
        CERTIFICATE,
        NONE;

    }

    static class EAVHttpRequestInterceptor
    extends HeaderInterceptor {
        EAVHttpRequestInterceptor(Header h) {
            super(h);
        }
    }

    static class AuthorizationHeaderHttpRequestInterceptor
    extends HeaderInterceptor {
        AuthorizationHeaderHttpRequestInterceptor(String headerValue) {
            super(new BasicHeader("Authorization", headerValue));
        }
    }

    static abstract class HeaderInterceptor
    implements HttpRequestInterceptor {
        private final Header header;

        HeaderInterceptor(Header h) {
            this.header = h;
        }

        @Override
        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            String method = request.getRequestLine().getMethod();
            if (method.equalsIgnoreCase("CONNECT")) {
                return;
            }
            request.setHeader(this.header);
        }
    }
}

