/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.json.ExternallyTaggedUnion;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RollupSearchResponse<TDocument>
implements JsonpSerializable {
    private final long took;
    private final boolean timedOut;
    @Nullable
    private final Boolean terminatedEarly;
    private final ShardStatistics shards;
    private final HitsMetadata<TDocument> hits;
    private final Map<String, Aggregate> aggregations;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<RollupSearchResponse<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> RollupSearchResponse.createRollupSearchResponseDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:rollup.rollup_search.TDocument")));

    private RollupSearchResponse(Builder<TDocument> builder) {
        this.took = ApiTypeHelper.requireNonNull(((Builder)builder).took, this, "took");
        this.timedOut = ApiTypeHelper.requireNonNull(((Builder)builder).timedOut, this, "timedOut");
        this.terminatedEarly = ((Builder)builder).terminatedEarly;
        this.shards = ApiTypeHelper.requireNonNull(((Builder)builder).shards, this, "shards");
        this.hits = ApiTypeHelper.requireNonNull(((Builder)builder).hits, this, "hits");
        this.aggregations = ApiTypeHelper.unmodifiable(((Builder)builder).aggregations);
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> RollupSearchResponse<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<RollupSearchResponse<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long took() {
        return this.took;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    @Nullable
    public final Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final HitsMetadata<TDocument> hits() {
        return this.hits;
    }

    public final Map<String, Aggregate> aggregations() {
        return this.aggregations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        if (this.terminatedEarly != null) {
            generator.writeKey("terminated_early");
            generator.write(this.terminatedEarly);
        }
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            ExternallyTaggedUnion.serializeTypedKeys(this.aggregations, generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public static <TDocument> JsonpDeserializer<RollupSearchResponse<TDocument>> createRollupSearchResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> RollupSearchResponse.setupRollupSearchResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupRollupSearchResponseDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::terminatedEarly, JsonpDeserializer.booleanDeserializer(), "terminated_early");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(tDocumentDeserializer), "hits");
        op.add(Builder::aggregations, Aggregate._TYPED_KEYS_DESERIALIZER, "aggregations");
    }

    public static class Builder<TDocument>
    extends WithJsonObjectBuilderBase<Builder<TDocument>>
    implements ObjectBuilder<RollupSearchResponse<TDocument>> {
        private Long took;
        private Boolean timedOut;
        @Nullable
        private Boolean terminatedEarly;
        private ShardStatistics shards;
        private HitsMetadata<TDocument> hits;
        @Nullable
        private Map<String, Aggregate> aggregations;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> took(long value) {
            this.took = value;
            return this;
        }

        public final Builder<TDocument> timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public final Builder<TDocument> terminatedEarly(@Nullable Boolean value) {
            this.terminatedEarly = value;
            return this;
        }

        public final Builder<TDocument> shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder<TDocument> shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder<TDocument> hits(HitsMetadata<TDocument> value) {
            this.hits = value;
            return this;
        }

        public final Builder<TDocument> hits(Function<HitsMetadata.Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        public final Builder<TDocument> aggregations(Map<String, Aggregate> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder<TDocument> aggregations(String key, Aggregate value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder<TDocument> aggregations(String key, Function<Aggregate.Builder, ObjectBuilder<Aggregate>> fn) {
            return this.aggregations(key, fn.apply(new Aggregate.Builder()).build());
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public RollupSearchResponse<TDocument> build() {
            this._checkSingleUse();
            return new RollupSearchResponse(this);
        }
    }
}

