/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DeploymentAssignmentState;
import co.elastic.clients.elasticsearch.ml.TrainedModelAssignmentRoutingTable;
import co.elastic.clients.elasticsearch.ml.TrainedModelAssignmentTaskParameters;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelAssignment
implements JsonpSerializable {
    private final DeploymentAssignmentState assignmentState;
    @Nullable
    private final Integer maxAssignedAllocations;
    private final Map<String, TrainedModelAssignmentRoutingTable> routingTable;
    private final DateTime startTime;
    private final TrainedModelAssignmentTaskParameters taskParameters;
    public static final JsonpDeserializer<TrainedModelAssignment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelAssignment::setupTrainedModelAssignmentDeserializer);

    private TrainedModelAssignment(Builder builder) {
        this.assignmentState = ApiTypeHelper.requireNonNull(builder.assignmentState, this, "assignmentState");
        this.maxAssignedAllocations = builder.maxAssignedAllocations;
        this.routingTable = ApiTypeHelper.unmodifiableRequired(builder.routingTable, (Object)this, "routingTable");
        this.startTime = ApiTypeHelper.requireNonNull(builder.startTime, this, "startTime");
        this.taskParameters = ApiTypeHelper.requireNonNull(builder.taskParameters, this, "taskParameters");
    }

    public static TrainedModelAssignment of(Function<Builder, ObjectBuilder<TrainedModelAssignment>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final DeploymentAssignmentState assignmentState() {
        return this.assignmentState;
    }

    @Nullable
    public final Integer maxAssignedAllocations() {
        return this.maxAssignedAllocations;
    }

    public final Map<String, TrainedModelAssignmentRoutingTable> routingTable() {
        return this.routingTable;
    }

    public final DateTime startTime() {
        return this.startTime;
    }

    public final TrainedModelAssignmentTaskParameters taskParameters() {
        return this.taskParameters;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("assignment_state");
        this.assignmentState.serialize(generator, mapper);
        if (this.maxAssignedAllocations != null) {
            generator.writeKey("max_assigned_allocations");
            generator.write(this.maxAssignedAllocations);
        }
        if (ApiTypeHelper.isDefined(this.routingTable)) {
            generator.writeKey("routing_table");
            generator.writeStartObject();
            for (Map.Entry<String, TrainedModelAssignmentRoutingTable> item0 : this.routingTable.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("start_time");
        this.startTime.serialize(generator, mapper);
        generator.writeKey("task_parameters");
        this.taskParameters.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelAssignmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::assignmentState, DeploymentAssignmentState._DESERIALIZER, "assignment_state");
        op.add(Builder::maxAssignedAllocations, JsonpDeserializer.integerDeserializer(), "max_assigned_allocations");
        op.add(Builder::routingTable, JsonpDeserializer.stringMapDeserializer(TrainedModelAssignmentRoutingTable._DESERIALIZER), "routing_table");
        op.add(Builder::startTime, DateTime._DESERIALIZER, "start_time");
        op.add(Builder::taskParameters, TrainedModelAssignmentTaskParameters._DESERIALIZER, "task_parameters");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelAssignment> {
        private DeploymentAssignmentState assignmentState;
        @Nullable
        private Integer maxAssignedAllocations;
        private Map<String, TrainedModelAssignmentRoutingTable> routingTable;
        private DateTime startTime;
        private TrainedModelAssignmentTaskParameters taskParameters;

        public final Builder assignmentState(DeploymentAssignmentState value) {
            this.assignmentState = value;
            return this;
        }

        public final Builder maxAssignedAllocations(@Nullable Integer value) {
            this.maxAssignedAllocations = value;
            return this;
        }

        public final Builder routingTable(Map<String, TrainedModelAssignmentRoutingTable> map) {
            this.routingTable = Builder._mapPutAll(this.routingTable, map);
            return this;
        }

        public final Builder routingTable(String key, TrainedModelAssignmentRoutingTable value) {
            this.routingTable = Builder._mapPut(this.routingTable, key, value);
            return this;
        }

        public final Builder routingTable(String key, Function<TrainedModelAssignmentRoutingTable.Builder, ObjectBuilder<TrainedModelAssignmentRoutingTable>> fn) {
            return this.routingTable(key, fn.apply(new TrainedModelAssignmentRoutingTable.Builder()).build());
        }

        public final Builder startTime(DateTime value) {
            this.startTime = value;
            return this;
        }

        public final Builder taskParameters(TrainedModelAssignmentTaskParameters value) {
            this.taskParameters = value;
            return this;
        }

        public final Builder taskParameters(Function<TrainedModelAssignmentTaskParameters.Builder, ObjectBuilder<TrainedModelAssignmentTaskParameters>> fn) {
            return this.taskParameters(fn.apply(new TrainedModelAssignmentTaskParameters.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelAssignment build() {
            this._checkSingleUse();
            return new TrainedModelAssignment(this);
        }
    }
}

