/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AnomalyExplanation
implements JsonpSerializable {
    @Nullable
    private final Integer anomalyCharacteristicsImpact;
    @Nullable
    private final Integer anomalyLength;
    @Nullable
    private final String anomalyType;
    @Nullable
    private final Boolean highVariancePenalty;
    @Nullable
    private final Boolean incompleteBucketPenalty;
    @Nullable
    private final Double lowerConfidenceBound;
    @Nullable
    private final Integer multiBucketImpact;
    @Nullable
    private final Integer singleBucketImpact;
    @Nullable
    private final Double typicalValue;
    @Nullable
    private final Double upperConfidenceBound;
    public static final JsonpDeserializer<AnomalyExplanation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnomalyExplanation::setupAnomalyExplanationDeserializer);

    private AnomalyExplanation(Builder builder) {
        this.anomalyCharacteristicsImpact = builder.anomalyCharacteristicsImpact;
        this.anomalyLength = builder.anomalyLength;
        this.anomalyType = builder.anomalyType;
        this.highVariancePenalty = builder.highVariancePenalty;
        this.incompleteBucketPenalty = builder.incompleteBucketPenalty;
        this.lowerConfidenceBound = builder.lowerConfidenceBound;
        this.multiBucketImpact = builder.multiBucketImpact;
        this.singleBucketImpact = builder.singleBucketImpact;
        this.typicalValue = builder.typicalValue;
        this.upperConfidenceBound = builder.upperConfidenceBound;
    }

    public static AnomalyExplanation of(Function<Builder, ObjectBuilder<AnomalyExplanation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer anomalyCharacteristicsImpact() {
        return this.anomalyCharacteristicsImpact;
    }

    @Nullable
    public final Integer anomalyLength() {
        return this.anomalyLength;
    }

    @Nullable
    public final String anomalyType() {
        return this.anomalyType;
    }

    @Nullable
    public final Boolean highVariancePenalty() {
        return this.highVariancePenalty;
    }

    @Nullable
    public final Boolean incompleteBucketPenalty() {
        return this.incompleteBucketPenalty;
    }

    @Nullable
    public final Double lowerConfidenceBound() {
        return this.lowerConfidenceBound;
    }

    @Nullable
    public final Integer multiBucketImpact() {
        return this.multiBucketImpact;
    }

    @Nullable
    public final Integer singleBucketImpact() {
        return this.singleBucketImpact;
    }

    @Nullable
    public final Double typicalValue() {
        return this.typicalValue;
    }

    @Nullable
    public final Double upperConfidenceBound() {
        return this.upperConfidenceBound;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.anomalyCharacteristicsImpact != null) {
            generator.writeKey("anomaly_characteristics_impact");
            generator.write(this.anomalyCharacteristicsImpact);
        }
        if (this.anomalyLength != null) {
            generator.writeKey("anomaly_length");
            generator.write(this.anomalyLength);
        }
        if (this.anomalyType != null) {
            generator.writeKey("anomaly_type");
            generator.write(this.anomalyType);
        }
        if (this.highVariancePenalty != null) {
            generator.writeKey("high_variance_penalty");
            generator.write(this.highVariancePenalty);
        }
        if (this.incompleteBucketPenalty != null) {
            generator.writeKey("incomplete_bucket_penalty");
            generator.write(this.incompleteBucketPenalty);
        }
        if (this.lowerConfidenceBound != null) {
            generator.writeKey("lower_confidence_bound");
            generator.write(this.lowerConfidenceBound);
        }
        if (this.multiBucketImpact != null) {
            generator.writeKey("multi_bucket_impact");
            generator.write(this.multiBucketImpact);
        }
        if (this.singleBucketImpact != null) {
            generator.writeKey("single_bucket_impact");
            generator.write(this.singleBucketImpact);
        }
        if (this.typicalValue != null) {
            generator.writeKey("typical_value");
            generator.write(this.typicalValue);
        }
        if (this.upperConfidenceBound != null) {
            generator.writeKey("upper_confidence_bound");
            generator.write(this.upperConfidenceBound);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAnomalyExplanationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::anomalyCharacteristicsImpact, JsonpDeserializer.integerDeserializer(), "anomaly_characteristics_impact");
        op.add(Builder::anomalyLength, JsonpDeserializer.integerDeserializer(), "anomaly_length");
        op.add(Builder::anomalyType, JsonpDeserializer.stringDeserializer(), "anomaly_type");
        op.add(Builder::highVariancePenalty, JsonpDeserializer.booleanDeserializer(), "high_variance_penalty");
        op.add(Builder::incompleteBucketPenalty, JsonpDeserializer.booleanDeserializer(), "incomplete_bucket_penalty");
        op.add(Builder::lowerConfidenceBound, JsonpDeserializer.doubleDeserializer(), "lower_confidence_bound");
        op.add(Builder::multiBucketImpact, JsonpDeserializer.integerDeserializer(), "multi_bucket_impact");
        op.add(Builder::singleBucketImpact, JsonpDeserializer.integerDeserializer(), "single_bucket_impact");
        op.add(Builder::typicalValue, JsonpDeserializer.doubleDeserializer(), "typical_value");
        op.add(Builder::upperConfidenceBound, JsonpDeserializer.doubleDeserializer(), "upper_confidence_bound");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AnomalyExplanation> {
        @Nullable
        private Integer anomalyCharacteristicsImpact;
        @Nullable
        private Integer anomalyLength;
        @Nullable
        private String anomalyType;
        @Nullable
        private Boolean highVariancePenalty;
        @Nullable
        private Boolean incompleteBucketPenalty;
        @Nullable
        private Double lowerConfidenceBound;
        @Nullable
        private Integer multiBucketImpact;
        @Nullable
        private Integer singleBucketImpact;
        @Nullable
        private Double typicalValue;
        @Nullable
        private Double upperConfidenceBound;

        public final Builder anomalyCharacteristicsImpact(@Nullable Integer value) {
            this.anomalyCharacteristicsImpact = value;
            return this;
        }

        public final Builder anomalyLength(@Nullable Integer value) {
            this.anomalyLength = value;
            return this;
        }

        public final Builder anomalyType(@Nullable String value) {
            this.anomalyType = value;
            return this;
        }

        public final Builder highVariancePenalty(@Nullable Boolean value) {
            this.highVariancePenalty = value;
            return this;
        }

        public final Builder incompleteBucketPenalty(@Nullable Boolean value) {
            this.incompleteBucketPenalty = value;
            return this;
        }

        public final Builder lowerConfidenceBound(@Nullable Double value) {
            this.lowerConfidenceBound = value;
            return this;
        }

        public final Builder multiBucketImpact(@Nullable Integer value) {
            this.multiBucketImpact = value;
            return this;
        }

        public final Builder singleBucketImpact(@Nullable Integer value) {
            this.singleBucketImpact = value;
            return this;
        }

        public final Builder typicalValue(@Nullable Double value) {
            this.typicalValue = value;
            return this;
        }

        public final Builder upperConfidenceBound(@Nullable Double value) {
            this.upperConfidenceBound = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AnomalyExplanation build() {
            this._checkSingleUse();
            return new AnomalyExplanation(this);
        }
    }
}

