/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.builder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.EvalType;
import org.jruby.ParseResult;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ast.IterNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.builder.EnsureBlockInfo;
import org.jruby.ir.builder.IRLoop;
import org.jruby.ir.builder.LazyMethodDefinition;
import org.jruby.ir.builder.RescueBlockInfo;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.ArrayDerefInstr;
import org.jruby.ir.instructions.AsFixnumInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BIntInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.BuildCompoundStringInstr;
import org.jruby.ir.instructions.BuildDynRegExpInstr;
import org.jruby.ir.instructions.BuildLambdaInstr;
import org.jruby.ir.instructions.BuildRangeInstr;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckForLJEInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetEncodingInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.IntegerMathInstr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadBlockImplicitClosureInstr;
import org.jruby.ir.instructions.LoadFrameClosureInstr;
import org.jruby.ir.instructions.LoadImplicitClosureInstr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveRubyExceptionInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.ReturnOrRethrowSavedExcInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SearchModuleForConstInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.TraceInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DepthCloneable;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Integer;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.MutableString;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Range;
import org.jruby.ir.operands.Rational;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryCurrentModuleVariable;
import org.jruby.ir.operands.TemporaryIntVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.CallType;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Signature;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;
import org.jruby.util.DefinedMessage;
import org.jruby.util.KeyValuePair;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.cli.Options;

public abstract class IRBuilder<U, V, W, X, Y, Z> {
    static final boolean PARSER_TIMING = Options.PARSER_SUMMARY.load();
    static final UnexecutableNil U_NIL = UnexecutableNil.U_NIL;
    private final IRManager manager;
    protected final IRScope scope;
    protected final IRBuilder parent;
    protected final List<Instr> instructions;
    protected int coverageMode;
    protected IRBuilder variableBuilder;
    protected List<Object> argumentDescriptions;
    public boolean executesOnce = true;
    int temporaryVariableIndex = -1;
    private boolean needsYieldBlock = false;
    public boolean underscoreVariableSeen = false;
    int lastProcessedLineNum = -1;
    private Variable currentModuleVariable = null;
    protected Encoding encoding;
    protected int flipVariableCount = 0;
    LineInfo needsLineNumInfo = null;
    final Deque<RescueBlockInfo> activeRescueBlockStack = new ArrayDeque<RescueBlockInfo>(4);
    final Deque<EnsureBlockInfo> activeEnsureBlockStack = new ArrayDeque<EnsureBlockInfo>(4);
    final Deque<EnsureBlockInfo> ensureBodyBuildStack = new ArrayDeque<EnsureBlockInfo>(4);
    final Deque<Label> activeRescuers = new ArrayDeque<Label>(4);
    final Deque<IRLoop> loopStack = new LinkedList<IRLoop>();
    public EvalType evalType = null;
    RubySymbol methodName = null;
    protected int afterPrologueIndex = 0;
    private TemporaryVariable yieldClosureVariable = null;
    EnumSet<IRFlags> flags;
    private boolean selfUsed = false;
    private boolean currentModuleUsed = false;

    public IRBuilder(IRManager manager, IRScope scope, IRBuilder parent, IRBuilder variableBuilder, Encoding encoding2) {
        this.manager = manager;
        this.scope = scope;
        this.parent = parent;
        this.instructions = new ArrayList<Instr>(50);
        this.activeRescuers.push(Label.UNRESCUED_REGION_LABEL);
        int n = this.coverageMode = parent == null ? 0 : parent.coverageMode;
        if (parent != null) {
            this.executesOnce = parent.executesOnce;
        }
        this.variableBuilder = variableBuilder;
        this.flags = IRScope.allocateInitialFlags(scope);
        this.encoding = encoding2;
    }

    public static InterpreterContext buildRoot(IRManager manager, ParseResult rootNode) {
        String file2 = rootNode.getFile();
        IRScriptBody script = new IRScriptBody(manager, file2 == null ? "(anon)" : file2, rootNode.getStaticScope());
        return manager.getBuilderFactory().topIRBuilder(manager, script, rootNode).buildRootInner(rootNode);
    }

    protected Operand buildEnsureInternal(U body, U elseNode, U[] exceptions, U rescueBody, X optRescue, boolean isModifier, U ensureNode, boolean isRescue, U reference2) {
        boolean isEnsureExpr;
        Variable savedGlobalException = this.temp();
        this.addInstr(new GetGlobalVariableInstr(savedGlobalException, this.symbol("$!")));
        EnsureBlockInfo ebi = new EnsureBlockInfo(this.scope, this.getCurrentLoop(), this.activeRescuers.peek());
        if (isRescue) {
            ebi.savedGlobalException = savedGlobalException;
        }
        this.ensureBodyBuildStack.push(ebi);
        Operand ensureRetVal = ensureNode == null ? this.nil() : this.build(ensureNode);
        this.ensureBodyBuildStack.pop();
        this.activeEnsureBlockStack.push(ebi);
        this.addInstr(new LabelInstr(ebi.regionStart));
        this.addInstr(new ExceptionRegionStartMarkerInstr(ebi.dummyRescueBlockLabel));
        this.activeRescuers.push(ebi.dummyRescueBlockLabel);
        Variable ensureExprValue = this.temp();
        Operand rv = isRescue ? this.buildRescueInternal(body, elseNode, exceptions, rescueBody, optRescue, isModifier, ebi, reference2) : this.build(body);
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.activeRescuers.pop();
        boolean bl = isEnsureExpr = ensureNode != null && rv != U_NIL && !isRescue;
        if (isEnsureExpr) {
            this.addInstr(new CopyInstr(ensureExprValue, rv));
            ebi.cloneIntoHostScope(this);
            this.addInstr(new JumpInstr(ebi.end));
        }
        this.activeEnsureBlockStack.pop();
        this.addInstr(new LabelInstr(ebi.dummyRescueBlockLabel));
        Variable exc = this.addResultInstr(new ReceiveJRubyExceptionInstr(this.temp()));
        if (ensureNode != null) {
            ebi.emitBody(this);
        }
        if (ensureRetVal == U_NIL) {
            rv = U_NIL;
        }
        this.addInstr(new ThrowExceptionInstr(exc));
        this.addInstr(new LabelInstr(ebi.end));
        return isEnsureExpr ? ensureExprValue : rv;
    }

    public InterpreterContext buildEvalRoot(ParseResult rootNode) {
        this.executesOnce = false;
        this.coverageMode = 0;
        this.addInstr(this.getManager().newLineNumber(this.scope.getLine()));
        this.afterPrologueIndex = this.instructions.size() - 1;
        Operand returnValue = this.build(rootNode);
        this.addInstr(new ReturnInstr(returnValue));
        this.prependUsedImplicitState(null);
        this.computeScopeFlagsFrom(this.instructions);
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 2, this.flags);
    }

    protected InterpreterContext buildRootInner(ParseResult parseResult) {
        long time = 0L;
        if (PARSER_TIMING) {
            time = System.nanoTime();
        }
        this.coverageMode = parseResult.getCoverageMode();
        this.addInstr(new ReturnInstr(this.build(parseResult)));
        this.computeScopeFlagsFrom(this.instructions);
        if (this.scope.canReceiveNonlocalReturns()) {
            this.handleNonlocalReturnInMethod();
        }
        this.prependUsedImplicitState(null);
        InterpreterContext ic = this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
        if (PARSER_TIMING) {
            this.manager.getRuntime().getParserManager().getParserStats().addIRBuildTime(System.nanoTime() - time);
        }
        return ic;
    }

    public void computeScopeFlagsFrom(List<Instr> instructions) {
        for (Instr i2 : instructions) {
            i2.computeScopeFlags(this.scope, this.flags);
        }
        this.calculateClosureScopeFlags();
        if (this.computeNeedsDynamicScopeFlag()) {
            this.flags.add(IRFlags.REQUIRES_DYNSCOPE);
        }
        this.flags.add(IRFlags.FLAGS_COMPUTED);
    }

    private void calculateClosureScopeFlags() {
        for (IRClosure cl : this.scope.getClosures()) {
            if (cl.usesEval()) {
                this.scope.setCanReceiveBreaks();
                this.scope.setCanReceiveNonlocalReturns();
                this.scope.setUsesZSuper();
                continue;
            }
            if (cl.hasBreakInstructions() || cl.canReceiveBreaks()) {
                this.scope.setCanReceiveBreaks();
            }
            if (cl.hasNonLocalReturns() || cl.canReceiveNonlocalReturns()) {
                this.scope.setCanReceiveNonlocalReturns();
            }
            if (!cl.usesZSuper()) continue;
            this.scope.setUsesZSuper();
        }
    }

    private boolean computeNeedsDynamicScopeFlag() {
        return this.scope.hasNonLocalReturns() || this.scope.canCaptureCallersBinding() || this.scope.canReceiveNonlocalReturns() || this.flags.contains((Object)IRFlags.BINDING_HAS_ESCAPED);
    }

    protected boolean hasListener() {
        return this.manager.getIRScopeListener() != null;
    }

    protected void maybeGenerateIsNotEmptyErrorString(Variable errorString, Operand result2, Operand value2) {
        this.label("empty", empty -> this.cond((Label)empty, result2, this.tru(), () -> this.addInstr(new BuildCompoundStringInstr(errorString, new Operand[]{value2, new FrozenString(" is not empty")}, UTF8Encoding.INSTANCE, 13, true, this.getFileName(), this.lastProcessedLineNum))));
    }

    protected RubySymbol methodNameFor() {
        IRMethod method2 = this.scope.getNearestMethod();
        return method2 == null ? null : method2.getName();
    }

    protected IRLoop getCurrentLoop() {
        return this.loopStack.peek();
    }

    public void addInstr(Instr instr) {
        if (this.needsLineNumInfo != null) {
            LineInfo type2 = this.needsLineNumInfo;
            this.needsLineNumInfo = null;
            if (type2 == LineInfo.Coverage) {
                this.addInstr(new LineNumberInstr(this.lastProcessedLineNum, this.coverageMode));
            } else {
                this.addInstr(this.manager.newLineNumber(this.lastProcessedLineNum));
            }
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.addInstr(new TraceInstr(RubyEvent.LINE, this.getCurrentModuleVariable(), this.methodNameFor(), this.getFileName(), this.lastProcessedLineNum + 1));
            }
        }
        if (this.ensureBodyBuildStack.isEmpty()) {
            instr.computeScopeFlags(this.scope, this.flags);
            if (this.hasListener()) {
                this.manager.getIRScopeListener().addedInstr(this.scope, instr, this.instructions.size());
            }
            this.instructions.add(instr);
        } else {
            this.ensureBodyBuildStack.peek().addInstr(instr);
        }
    }

    public void addInstrAtBeginning(Instr instr) {
        if (this.ensureBodyBuildStack.isEmpty()) {
            instr.computeScopeFlags(this.scope, this.flags);
            if (this.hasListener()) {
                this.manager.getIRScopeListener().addedInstr(this.scope, instr, 0);
            }
            this.instructions.add(0, instr);
        } else {
            this.ensureBodyBuildStack.peek().addInstrAtBeginning(instr);
        }
    }

    protected Variable addResultInstr(ResultInstr instr) {
        this.addInstr((Instr)((Object)instr));
        return instr.getResult();
    }

    protected void emitEnsureBlocks(IRLoop loop2) {
        int n = this.activeEnsureBlockStack.size();
        EnsureBlockInfo[] ebArray = this.activeEnsureBlockStack.toArray(new EnsureBlockInfo[n]);
        for (int i2 = 0; i2 < n; ++i2) {
            EnsureBlockInfo ebi = ebArray[i2];
            if (loop2 != null && ebi.innermostLoop != loop2) break;
            ebi.cloneIntoHostScope(this);
        }
    }

    private boolean isDefineMethod() {
        if (this.methodName != null) {
            String name2 = this.methodName.asJavaString();
            return "define_method".equals(name2) || "define_singleton_method".equals(name2);
        }
        return false;
    }

    protected boolean isTopLevel() {
        return this.scope.isTopLocalVariableScope() && this.scope instanceof IRScriptBody;
    }

    protected boolean isTopScope() {
        IRScope s2;
        boolean isTopScope;
        IRScope topScope = this.scope.getNearestNonClosurelikeScope();
        boolean bl = isTopScope = topScope instanceof IRScriptBody && this.evalType == null || this.evalType != null && this.evalType != EvalType.MODULE_EVAL && this.evalType != EvalType.BINDING_EVAL;
        if (!isTopScope) {
            return false;
        }
        for (s2 = topScope; s2 != null && !(s2 instanceof IRModuleBody); s2 = s2.getLexicalParent()) {
        }
        return s2 == null;
    }

    protected void outputExceptionCheck(Operand excType, Operand excObj, Label caughtLabel) {
        Variable eqqResult = this.addResultInstr(new RescueEQQInstr(this.temp(), excType, excObj));
        this.addInstr(IRBuilder.createBranch(eqqResult, this.tru(), caughtLabel));
    }

    protected Operand protectCodeWithRescue(CodeBlock protectedCode, CodeBlock rescueBlock) {
        Variable rv = this.temp();
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = this.getNewLabel();
        Label rescueLabel = this.getNewLabel();
        this.addInstr(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionStartMarkerInstr(rescueLabel));
        Operand v1 = protectedCode.run();
        this.addInstr(new CopyInstr(rv, v1));
        this.addInstr(new JumpInstr(rEndLabel));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        Label caughtLabel = this.getNewLabel();
        Variable exc = this.temp();
        Variable excType = this.temp();
        this.addInstr(new LabelInstr(rescueLabel));
        this.addInstr(new ReceiveRubyExceptionInstr(exc));
        this.addInstr(new InheritanceSearchConstInstr(excType, this.getManager().getObjectClass(), this.getManager().runtime.newSymbol(CommonByteLists.EXCEPTION)));
        this.outputExceptionCheck(excType, exc, caughtLabel);
        this.addInstr(new ThrowExceptionInstr(exc));
        this.addInstr(new LabelInstr(caughtLabel));
        Operand v2 = rescueBlock.run();
        if (v2 != null) {
            this.addInstr(new CopyInstr(rv, this.nil()));
        }
        this.addInstr(new LabelInstr(rEndLabel));
        return rv;
    }

    private TemporaryVariable createTemporaryVariable() {
        if (this.variableBuilder != null) {
            return this.variableBuilder.createTemporaryVariable();
        }
        ++this.temporaryVariableIndex;
        if (this.scope.getScopeType() == IRScopeType.CLOSURE) {
            return new TemporaryClosureVariable(((IRClosure)this.scope).closureId, this.temporaryVariableIndex);
        }
        return this.manager.newTemporaryLocalVariable(this.temporaryVariableIndex);
    }

    private TemporaryVariable createIntVariable() {
        if (this.variableBuilder != null) {
            return this.variableBuilder.createIntVariable();
        }
        ++this.temporaryVariableIndex;
        return new TemporaryIntVariable(this.temporaryVariableIndex);
    }

    public static Instr createBranch(Operand v1, Operand v2, Label jmpTarget) {
        if (v2 instanceof Boolean) {
            Boolean lhs = (Boolean)v2;
            if (lhs.isTrue()) {
                if (v1.isTruthyImmediate()) {
                    return new JumpInstr(jmpTarget);
                }
                if (v1.isFalseyImmediate()) {
                    return NopInstr.NOP;
                }
                return new BTrueInstr(jmpTarget, v1);
            }
            if (lhs.isFalse()) {
                if (v1.isTruthyImmediate()) {
                    return NopInstr.NOP;
                }
                if (v1.isFalseyImmediate()) {
                    return new JumpInstr(jmpTarget);
                }
                return new BFalseInstr(jmpTarget, v1);
            }
        } else if (v2 instanceof Nil) {
            if (v1 instanceof Nil) {
                return new JumpInstr(jmpTarget);
            }
            if (v1.isTruthyImmediate()) {
                return NopInstr.NOP;
            }
            return new BNilInstr(jmpTarget, v1);
        }
        if (v2 == UndefinedValue.UNDEFINED) {
            if (v1 == UndefinedValue.UNDEFINED) {
                return new JumpInstr(jmpTarget);
            }
            return new BUndefInstr(jmpTarget, v1);
        }
        throw new RuntimeException("BUG: no BEQ");
    }

    public void determineZSuperCallArgs(IRScope scope, IRBuilder<U, V, W, X, Y, Z> builder, List<Operand> callArgs, List<KeyValuePair<Operand, Operand>> keywordArgs) {
        if (builder != null) {
            for (Instr instr : builder.instructions) {
                IRBuilder.extractCallOperands(callArgs, keywordArgs, instr);
            }
        } else {
            for (Instr instr : scope.getInterpreterContext().getInstructions()) {
                IRBuilder.extractCallOperands(callArgs, keywordArgs, instr);
            }
        }
    }

    private Operand[] adjustVariableDepth(Operand[] args2, int depthFromSuper) {
        if (depthFromSuper == 0) {
            return args2;
        }
        Operand[] newArgs = new Operand[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newArgs[i2] = args2[i2] instanceof Hash ? ((Hash)args2[i2]).cloneForLVarDepth(depthFromSuper) : ((DepthCloneable)((Object)args2[i2])).cloneForDepth(depthFromSuper);
        }
        return newArgs;
    }

    public static Operand[] addArg(Operand[] args2, Operand extraArg) {
        Operand[] newArgs = new Operand[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = extraArg;
        return newArgs;
    }

    protected Operand putConstant(RubySymbol name2, Operand value2) {
        return this.putConstant(this.findContainerModule(), name2, value2);
    }

    protected Operand putConstant(Operand parent, RubySymbol name2, Operand value2) {
        this.addInstr(new PutConstInstr(parent, name2, value2));
        return value2;
    }

    public static Operand[] removeArg(Operand[] args2) {
        Operand[] newArgs = new Operand[args2.length - 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length - 1);
        return newArgs;
    }

    protected Operand searchModuleForConst(Variable result2, Operand startingModule, RubySymbol name2) {
        if (result2 == null) {
            result2 = this.temp();
        }
        return this.addResultInstr(new SearchModuleForConstInstr(result2, startingModule, name2, true));
    }

    protected Operand searchModuleForConstNoFrills(Variable result2, Operand startingModule, RubySymbol name2) {
        if (result2 == null) {
            result2 = this.temp();
        }
        return this.addResultInstr(new SearchModuleForConstInstr(result2, startingModule, name2, false, false));
    }

    protected Operand searchConst(Variable result2, RubySymbol name2) {
        if (result2 == null) {
            result2 = this.temp();
        }
        return this.addResultInstr(new SearchConstInstr(result2, CurrentScope.INSTANCE, name2, false));
    }

    public Operand classVarContainer(boolean declContext) {
        IRScope cvarScope;
        int n = 0;
        for (cvarScope = this.scope; cvarScope != null && !(cvarScope instanceof IREvalScript) && !cvarScope.isNonSingletonClassBody(); cvarScope = cvarScope.getLexicalParent()) {
            if (cvarScope instanceof IRFor) continue;
            ++n;
        }
        if (cvarScope != null && cvarScope.isNonSingletonClassBody()) {
            return ScopeModule.ModuleFor(n);
        }
        return this.addResultInstr(new GetClassVarContainerModuleInstr(this.temp(), CurrentScope.INSTANCE, declContext ? null : this.buildSelf()));
    }

    protected Operand addRaiseError(String id2, String message2) {
        return this.addRaiseError(id2, new MutableString(message2));
    }

    Operand addRaiseError(String id2, Operand message2) {
        Operand exceptionClass = this.searchModuleForConst(this.temp(), this.getManager().getObjectClass(), this.symbol(id2));
        Operand kernel = this.searchModuleForConst(this.temp(), this.getManager().getObjectClass(), this.symbol("Kernel"));
        return this.call(this.temp(), kernel, "raise", exceptionClass, message2);
    }

    protected static void extractCallOperands(List<Operand> callArgs, List<KeyValuePair<Operand, Operand>> keywordArgs, Instr instr) {
        if (instr instanceof ReceiveKeywordRestArgInstr) {
            keywordArgs.add(0, new KeyValuePair<Symbol, Variable>(Symbol.KW_REST_ARG_DUMMY, ((ReceiveArgBase)instr).getResult()));
        } else if (instr instanceof ReceiveKeywordArgInstr) {
            ReceiveKeywordArgInstr receiveKwargInstr = (ReceiveKeywordArgInstr)instr;
            keywordArgs.add(new KeyValuePair<Symbol, Variable>(new Symbol(receiveKwargInstr.getKey()), receiveKwargInstr.getResult()));
        } else if (instr instanceof ReceiveRestArgInstr) {
            callArgs.add(new Splat(((ReceiveRestArgInstr)instr).getResult()));
        } else if (instr instanceof ReceiveArgBase) {
            callArgs.add(((ReceiveArgBase)instr).getResult());
        }
    }

    protected void receiveBreakException(Operand block, CallInstr callInstr) {
        this.receiveBreakException(block, () -> this.addResultInstr(callInstr));
    }

    protected void handleBreakAndReturnsInLambdas() {
        Label rEndLabel = this.getNewLabel();
        Label rescueLabel = Label.getGlobalEnsureBlockLabel();
        this.addInstrAtBeginning(new ExceptionRegionStartMarkerInstr(rescueLabel));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.addInstr(new LabelInstr(rescueLabel));
        Variable exc = this.temp();
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        Variable ret = this.temp();
        this.addInstr(new RuntimeHelperCall(ret, RuntimeHelperCall.Methods.HANDLE_BREAK_AND_RETURNS_IN_LAMBDA, new Operand[]{exc}));
        this.addInstr(new ReturnOrRethrowSavedExcInstr(ret));
        this.addInstr(new LabelInstr(rEndLabel));
    }

    protected void handleNonlocalReturnInMethod() {
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = this.getNewLabel();
        Label gebLabel = this.getNewLabel();
        this.addInstrAtBeginning(new ExceptionRegionStartMarkerInstr(gebLabel));
        this.addInstrAtBeginning(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.addInstr(new LabelInstr(gebLabel));
        Variable exc = this.temp();
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        Variable ret = this.temp();
        this.addInstr(new RuntimeHelperCall(ret, RuntimeHelperCall.Methods.HANDLE_NONLOCAL_RETURN, new Operand[]{exc}));
        this.addInstr(new ReturnInstr(ret));
        this.addInstr(new LabelInstr(rEndLabel));
    }

    private Operand receiveBreakException(Operand block, CodeBlock codeBlock) {
        if (block == null || !(block instanceof WrappedIRClosure) || !((WrappedIRClosure)block).getClosure().hasBreakInstructions()) {
            return codeBlock.run();
        }
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = this.getNewLabel();
        Label rescueLabel = this.getNewLabel();
        this.addInstr(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionStartMarkerInstr(rescueLabel));
        Variable callResult = (Variable)codeBlock.run();
        this.addInstr(new JumpInstr(rEndLabel));
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.addInstr(new LabelInstr(rescueLabel));
        Variable exc = this.temp();
        this.addInstr(new ReceiveJRubyExceptionInstr(exc));
        this.addInstr(new RuntimeHelperCall(callResult, RuntimeHelperCall.Methods.HANDLE_PROPAGATED_BREAK, new Operand[]{exc}));
        this.addInstr(new LabelInstr(rEndLabel));
        return callResult;
    }

    protected Variable call(Variable result2, Operand object, String name2, Operand ... args2) {
        return this.call(result2, object, this.symbol(name2), args2);
    }

    protected Variable call(Variable result2, Operand object, RubySymbol name2, Operand ... args2) {
        return this._call(result2, CallType.NORMAL, object, name2, args2);
    }

    protected Variable _call(Variable result2, CallType type2, Operand object, RubySymbol name2, Operand ... args2) {
        if (result2 == null) {
            result2 = this.temp();
        }
        return this.addResultInstr(CallInstr.create(this.scope, type2, result2, name2, object, args2, NullBlock.INSTANCE, 0));
    }

    public Operand classVarDefinitionContainer() {
        return this.classVarContainer(false);
    }

    protected void cond(Label label2, Operand value2, Operand test2) {
        this.addInstr(IRBuilder.createBranch(value2, test2, label2));
    }

    protected void cond(Label endLabel, Operand value2, Operand test2, RunIt body) {
        this.addInstr(IRBuilder.createBranch(value2, test2, endLabel));
        body.apply();
    }

    protected void cond_ne(Label label2, Operand value2, Operand test2) {
        this.addInstr(BNEInstr.create(label2, value2, test2));
    }

    protected void cond_ne(Label endLabel, Operand value2, Operand test2, RunIt body) {
        this.addInstr(BNEInstr.create(endLabel, value2, test2));
        body.apply();
    }

    public Variable copy(Operand value2) {
        return this.copy(null, value2);
    }

    public Variable copy(Variable result2, Operand value2) {
        if (result2 == null) {
            result2 = value2 instanceof Integer || value2 instanceof TemporaryIntVariable ? this.createIntVariable() : this.createTemporaryVariable();
        }
        return this.addResultInstr(new CopyInstr(result2, value2));
    }

    protected Boolean fals() {
        return this.manager.getFalse();
    }

    protected Variable fcall(Variable result2, Operand object, String name2, Operand ... args2) {
        return this.fcall(result2, object, this.symbol(name2), args2);
    }

    protected Variable fcall(Variable result2, Operand object, RubySymbol name2, Operand ... args2) {
        return this._call(result2, CallType.FUNCTIONAL, object, name2, args2);
    }

    protected Fixnum fix(long value2) {
        return this.manager.newFixnum(value2);
    }

    protected void if_else(Operand testVariable, Operand testValue, VoidCodeBlock ifBlock, VoidCodeBlock elseBlock) {
        Label elseLabel = this.getNewLabel();
        Label endLabel = this.getNewLabel();
        this.addInstr(BNEInstr.create(elseLabel, testVariable, testValue));
        ifBlock.run();
        this.addInstr(new JumpInstr(endLabel));
        this.addInstr(new LabelInstr(elseLabel));
        elseBlock.run();
        this.addInstr(new LabelInstr(endLabel));
    }

    protected void if_not(Operand testVariable, Operand testValue, VoidCodeBlock ifBlock) {
        this.label("if_not_end", endLabel -> {
            this.addInstr(IRBuilder.createBranch(testVariable, testValue, endLabel));
            ifBlock.run();
        });
    }

    protected void for_loop(Consumer<Label> test2, Consumer<Label> increment, Consume2<Label, Label> body) {
        Label top = this.getNewLabel("for_top");
        Label bottom = this.getNewLabel("for_bottom");
        this.label("for_end", after -> {
            this.addInstr(new LabelInstr(top));
            test2.accept((Label)after);
            body.apply((Label)after, bottom);
            this.addInstr(new LabelInstr(bottom));
            increment.accept((Label)after);
            this.jump(top);
        });
    }

    protected void jump(Label label2) {
        this.addInstr(new JumpInstr(label2));
    }

    protected void label(String labelName, Consumer<Label> block) {
        Label label2 = this.getNewLabel(labelName);
        block.accept(label2);
        this.addInstr(new LabelInstr(label2));
    }

    protected Nil nil() {
        return this.manager.getNil();
    }

    private boolean hackCheckUSASCII(byte[] bytes2) {
        for (int i2 = 0; i2 < bytes2.length; ++i2) {
            if (bytes2[i2] >= 0) continue;
            return false;
        }
        return true;
    }

    protected RubySymbol symbol(String id2) {
        return this.manager.runtime.newSymbol(id2);
    }

    protected RubySymbol symbol(ByteList bytelist) {
        return this.manager.runtime.newSymbol(bytelist);
    }

    protected Operand tap(Operand value2, Consumer<Operand> block) {
        block.accept(value2);
        return value2;
    }

    private Variable intTemp() {
        return this.createIntVariable();
    }

    protected Variable temp() {
        return this.createTemporaryVariable();
    }

    protected void type_error(String message2) {
        this.addRaiseError("TypeError", message2);
    }

    protected void times(int times2, Consume2<Label, Integer> body) {
        this.label("times_end", end2 -> {
            for (int i2 = 0; i2 < times2; ++i2) {
                body.apply((Label)end2, new Integer(i2));
            }
        });
    }

    protected Boolean tru() {
        return this.manager.getTrue();
    }

    public Variable createCurrentModuleVariable() {
        ++this.temporaryVariableIndex;
        return TemporaryCurrentModuleVariable.ModuleVariableFor(this.temporaryVariableIndex);
    }

    public Variable getCurrentModuleVariable() {
        this.currentModuleUsed = true;
        if (this.currentModuleVariable == null) {
            this.currentModuleVariable = this.createCurrentModuleVariable();
        }
        return this.currentModuleVariable;
    }

    protected String getFileName() {
        return this.scope.getFile();
    }

    public RubySymbol getName() {
        return this.scope.getName();
    }

    protected Label getNewLabel() {
        return this.scope.getNewLabel();
    }

    protected Label getNewLabel(String labelName) {
        return this.scope.getNewLabel(labelName);
    }

    protected Variable getValueInTemporaryVariable(Operand val) {
        if (val != null && val instanceof TemporaryVariable) {
            return (Variable)val;
        }
        return this.copy(val);
    }

    public TemporaryVariable getYieldClosureVariable() {
        this.needsYieldBlock = true;
        if (this.yieldClosureVariable == null) {
            this.yieldClosureVariable = this.createTemporaryVariable();
            return this.yieldClosureVariable;
        }
        return this.yieldClosureVariable;
    }

    protected static Operand[] getZSuperCallOperands(IRScope scope, List<Operand> callArgs, List<KeyValuePair<Operand, Operand>> keywordArgs, int[] flags2) {
        if (scope.getNearestTopLocalVariableScope().receivesKeywordArgs()) {
            flags2[0] = flags2[0] | 2;
            int i2 = 0;
            Operand[] args2 = new Operand[callArgs.size() + 1];
            for (Operand arg2 : callArgs) {
                args2[i2++] = arg2;
            }
            args2[i2] = new Hash(keywordArgs);
            return args2;
        }
        return callArgs.toArray(new Operand[callArgs.size()]);
    }

    protected boolean canBacktraceBeRemoved(U[] exceptions, U rescueBody, X optRescue, U elseNode, boolean isModifier) {
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            return false;
        }
        if (!isModifier && elseNode != null) {
            return false;
        }
        if (optRescue != null) {
            return false;
        }
        if (exceptions != null) {
            return false;
        }
        if (this.isErrorInfoGlobal(rescueBody)) {
            return false;
        }
        return this.isSideEffectFree(rescueBody);
    }

    protected abstract U[] exceptionNodesFor(X var1);

    protected abstract U bodyFor(X var1);

    protected abstract X optRescueFor(X var1);

    protected abstract U referenceFor(X var1);

    protected abstract boolean isSideEffectFree(U var1);

    protected abstract boolean isErrorInfoGlobal(U var1);

    protected abstract boolean canBeLazyMethod(V var1);

    public abstract Operand build(ParseResult var1);

    protected Operand buildWithOrder(U node, boolean preserveOrder) {
        Operand value2 = this.build(node);
        return preserveOrder && !(value2 instanceof ImmutableLiteral) ? this.copy(value2) : value2;
    }

    protected Operand buildAlias(Operand newName, Operand oldName) {
        this.addInstr(new AliasInstr(newName, oldName));
        return this.nil();
    }

    protected Operand buildAnd(Operand left2, CodeBlock right, BinaryType truth) {
        switch (truth) {
            case LeftTrue: {
                return right.run();
            }
            case LeftFalse: {
                return left2;
            }
        }
        return this.tap(this.getValueInTemporaryVariable(left2), ret -> this.label("and", label2 -> this.cond((Label)label2, left2, this.fals(), () -> this.copy((Variable)ret, right.run()))));
    }

    protected Operand buildBreak(CodeBlock value2, int line) {
        IRLoop currLoop = this.getCurrentLoop();
        if (currLoop != null) {
            if (!this.activeEnsureBlockStack.isEmpty()) {
                this.emitEnsureBlocks(currLoop);
            }
            currLoop.hasBreak = true;
            this.addInstr(new CopyInstr(currLoop.loopResult, value2.run()));
            this.addInstr(new JumpInstr(currLoop.loopEndLabel));
        } else if (this.scope instanceof IRClosure) {
            IRScope returnScope = this.scope.getLexicalParent();
            if (this.scope instanceof IREvalScript || returnScope == null) {
                this.throwSyntaxError(line, "Can't escape from eval with redo");
            } else {
                this.addInstr(new BreakInstr(value2.run(), returnScope.getId()));
            }
        } else {
            this.throwSyntaxError(line, "Invalid break");
        }
        return U_NIL;
    }

    protected Operand[] setupCallArgs(U args2, int[] flags2) {
        return args2 == null ? Operand.EMPTY_ARRAY : this.buildCallArgs(args2, flags2);
    }

    protected Operand buildCase(U predicate, U[] arms, U elsey) {
        Operand testValue = this.buildCaseTestValue(predicate);
        Label elseLabel = this.getNewLabel();
        Label endLabel = this.getNewLabel();
        boolean hasExplicitElse = elsey != null;
        Variable result2 = this.temp();
        HashMap<Label, U> bodies = new HashMap<Label, U>();
        HashSet<IRubyObject> seenLiterals = new HashSet<IRubyObject>();
        HashMap<IRubyObject, java.lang.Integer> originalLocs = new HashMap<IRubyObject, java.lang.Integer>();
        for (U arm : arms) {
            Label bodyLabel = this.getNewLabel();
            this.buildWhenArgs(arm, testValue, bodyLabel, seenLiterals, originalLocs);
            bodies.put(bodyLabel, this.whenBody(arm));
        }
        this.addInstr(new JumpInstr(elseLabel));
        if (hasExplicitElse) {
            bodies.put(elseLabel, elsey);
        }
        int numberOfBodies = bodies.size();
        int i2 = 1;
        for (Map.Entry entry : bodies.entrySet()) {
            this.addInstr(new LabelInstr((Label)entry.getKey()));
            Operand bodyValue = this.build(entry.getValue());
            if (bodyValue != null) {
                this.addInstr(new CopyInstr(result2, bodyValue));
                if (i2 != numberOfBodies) {
                    this.addInstr(new JumpInstr(endLabel));
                } else if (!hasExplicitElse) {
                    this.addInstr(new JumpInstr(endLabel));
                }
            }
            ++i2;
        }
        if (!hasExplicitElse) {
            this.addInstr(new LabelInstr(elseLabel));
            this.addInstr(new CopyInstr(result2, this.nil()));
        }
        this.addInstr(new LabelInstr(endLabel));
        return result2;
    }

    protected abstract U whenBody(W var1);

    private Operand buildCaseTestValue(U test2) {
        if (this.isLiteralString(test2)) {
            return this.frozen_string(test2);
        }
        if (test2 == null) {
            return UndefinedValue.UNDEFINED;
        }
        Operand testValue = this.build(test2);
        return testValue == null ? UndefinedValue.UNDEFINED : testValue;
    }

    protected Operand buildClass(ByteList className, U superNode, U cpath, U bodyNode, StaticScope scope, int line, int endLine) {
        boolean executesOnce = this.executesOnce;
        Operand superClass = superNode == null ? null : this.build(superNode);
        Operand container = this.getContainerFromCPath(cpath);
        IRClassBody body = new IRClassBody(this.getManager(), this.scope, className, line, scope, executesOnce);
        Variable bodyResult = this.addResultInstr(new DefineClassInstr(this.temp(), body, container, superClass));
        this.getManager().getBuilderFactory().newIRBuilder(this.getManager(), body, this, this.encoding).buildModuleOrClassBody(bodyNode, line, endLine);
        return bodyResult;
    }

    protected abstract Operand getContainerFromCPath(U var1);

    protected Operand buildClassVar(Variable result2, RubySymbol name2) {
        if (result2 == null) {
            result2 = this.temp();
        }
        if (this.isTopScope()) {
            return this.addRaiseError("RuntimeError", "class variable access from toplevel");
        }
        return this.addResultInstr(new GetClassVariableInstr(result2, this.classVarDefinitionContainer(), name2));
    }

    protected Operand buildClassVarAsgn(RubySymbol name2, U valueNode) {
        if (this.isTopScope()) {
            return this.addRaiseError("RuntimeError", "class variable access from toplevel");
        }
        Operand value2 = this.build(valueNode);
        this.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(), name2, value2));
        return value2;
    }

    protected Operand buildConditional(Variable result2, U predicate, U statements, U consequent) {
        Label falseLabel = this.getNewLabel();
        Label doneLabel = this.getNewLabel();
        this.addInstr(IRBuilder.createBranch(this.build(predicate), this.fals(), falseLabel));
        boolean thenNull = false;
        boolean elseNull = false;
        boolean thenUnil = false;
        boolean elseUnil = false;
        if (statements != null) {
            Operand thenResult = this.build(statements);
            if (thenResult != U_NIL) {
                result2 = this.getValueInTemporaryVariable(thenResult);
                this.addInstr(new JumpInstr(doneLabel));
            } else {
                if (result2 == null) {
                    result2 = this.temp();
                }
                thenUnil = true;
            }
        } else {
            thenNull = true;
            if (result2 == null) {
                result2 = this.temp();
            }
            this.copy(result2, this.nil());
            this.addInstr(new JumpInstr(doneLabel));
        }
        this.addInstr(new LabelInstr(falseLabel));
        if (consequent != null) {
            Operand elseResult = this.build(consequent);
            if (elseResult != U_NIL) {
                this.copy(result2, elseResult);
            } else {
                elseUnil = true;
            }
        } else {
            elseNull = true;
            this.copy(result2, this.nil());
        }
        if (thenNull && elseNull) {
            this.addInstr(new LabelInstr(doneLabel));
            return this.nil();
        }
        if (thenUnil && elseUnil) {
            return U_NIL;
        }
        this.addInstr(new LabelInstr(doneLabel));
        return result2;
    }

    protected Operand buildDefn(IRMethod method2) {
        this.addInstr(new DefineInstanceMethodInstr(method2));
        return new Symbol(method2.getName());
    }

    protected Operand buildDefs(U receiver2, IRMethod method2) {
        this.addInstr(new DefineClassMethodInstr(this.build(receiver2), method2));
        return new Symbol(method2.getName());
    }

    protected Operand buildDRegex(Variable result2, U[] children2, RegexpOptions options2) {
        Operand[] pieces = new Operand[children2.length];
        Encoding encoding2 = options2.getKCode().getEncoding();
        for (int i2 = 0; i2 < children2.length; ++i2) {
            this.dynamicPiece(pieces, i2, children2[i2], encoding2);
        }
        if (result2 == null) {
            result2 = this.temp();
        }
        this.addInstr(new BuildDynRegExpInstr(result2, pieces, options2));
        return result2;
    }

    protected Operand buildDStr(Variable result2, U[] nodePieces, Encoding encoding2, boolean isFrozen, int line) {
        if (result2 == null) {
            result2 = this.temp();
        }
        Operand[] pieces = new Operand[nodePieces.length];
        int estimatedSize = 0;
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            estimatedSize += this.dynamicPiece(pieces, i2, nodePieces[i2], null);
        }
        this.addInstr(new BuildCompoundStringInstr(result2, pieces, encoding2, estimatedSize, isFrozen, this.getFileName(), line));
        return result2;
    }

    protected Operand buildDSymbol(Variable result2, U[] nodePieces, Encoding encoding2, int line) {
        return this.copy(new DynamicSymbol(this.buildDStr(result2, nodePieces, encoding2, false, line)));
    }

    public Operand buildDXStr(Variable result2, U[] nodePieces, Encoding encoding2, int line) {
        return this.fcall(result2, (Operand)this.buildSelf(), "`", this.buildDStr(result2, nodePieces, encoding2, false, line));
    }

    protected Operand buildEncoding(Encoding encoding2) {
        return this.addResultInstr(new GetEncodingInstr(this.temp(), encoding2));
    }

    protected Operand buildFlip(U begin2, U end2, boolean isExclusive) {
        Fixnum s1 = this.manager.newFixnum(1L);
        Fixnum s2 = this.manager.newFixnum(2L);
        IRBuilder nearestNonClosureBuilder = this.getNearestFlipVariableScopeBuilder();
        if (nearestNonClosureBuilder == null) {
            TemporaryVariable excType = this.createTemporaryVariable();
            this.addInstr(new InheritanceSearchConstInstr(excType, this.manager.getObjectClass(), this.manager.runtime.newSymbol(CommonByteLists.NOT_IMPLEMENTED_ERROR)));
            Variable exc = this.addResultInstr(CallInstr.create(this.scope, CallType.NORMAL, this.temp(), this.symbol(CommonByteLists.NEW), excType, new Operand[]{new FrozenString("Flip support currently broken")}, NullBlock.INSTANCE, 0));
            this.addInstr(new ThrowExceptionInstr(exc));
            return this.nil();
        }
        Variable flipState = nearestNonClosureBuilder.getNewFlipFlopStateVariable();
        nearestNonClosureBuilder.initFlipStateVariable(flipState, s1);
        if (this.scope instanceof IRClosure) {
            int n = 0;
            IRScope x = this.scope;
            while (!x.isWhereFlipFlopStateVariableIs()) {
                ++n;
                x = x.getLexicalParent();
            }
            if (n > 0) {
                flipState = ((LocalVariable)flipState).cloneForDepth(n);
            }
        }
        TemporaryVariable returnVal = this.createTemporaryVariable();
        Label s2Label = this.getNewLabel();
        Label doneLabel = this.getNewLabel();
        this.addInstr(new CopyInstr(returnVal, this.manager.getFalse()));
        this.addInstr(BNEInstr.create(s2Label, flipState, s1));
        Operand s1Val = this.build(begin2);
        this.addInstr(BNEInstr.create(s2Label, s1Val, this.tru()));
        this.addInstr(new CopyInstr(returnVal, this.tru()));
        this.addInstr(new CopyInstr(flipState, s2));
        this.addInstr(new LabelInstr(s2Label));
        if (isExclusive) {
            this.addInstr(IRBuilder.createBranch(returnVal, this.tru(), doneLabel));
        }
        this.addInstr(BNEInstr.create(doneLabel, flipState, s2));
        Operand s2Val = this.build(end2);
        this.addInstr(new CopyInstr(returnVal, this.tru()));
        this.addInstr(BNEInstr.create(doneLabel, s2Val, this.tru()));
        this.addInstr(new CopyInstr(flipState, s1));
        this.addInstr(new LabelInstr(doneLabel));
        return returnVal;
    }

    private Variable getNewFlipFlopStateVariable() {
        this.scope.setHasFlipFlops(true);
        return this.getNewLocalVariable(this.symbol("%flip" + this.flipVariableCount++), 0);
    }

    protected Operand buildFor(U receiverNode, U var, U body, StaticScope staticScope, Signature signature, int line, int endLine) {
        Variable result2 = this.temp();
        Operand receiver2 = this.build(receiverNode);
        Operand forBlock = this.buildForIter(var, body, staticScope, signature, line, endLine);
        CallInstr callInstr = new CallInstr(this.scope, CallType.NORMAL, result2, this.symbol(CommonByteLists.EACH), receiver2, Instr.EMPTY_OPERANDS, forBlock, 0, this.scope.maybeUsingRefinements());
        this.receiveBreakException(forBlock, callInstr);
        return result2;
    }

    protected Operand buildForIter(U var, U body, StaticScope staticScope, Signature signature, int line, int endLine) {
        IRFor closure = new IRFor(this.getManager(), this.scope, line, staticScope, signature);
        this.getManager().getBuilderFactory().newIRBuilder(this.getManager(), closure, this, this.encoding).buildIterInner(null, var, body, endLine);
        return new WrappedIRClosure(this.buildSelf(), closure);
    }

    protected Operand buildGlobalAsgn(RubySymbol name2, U valueNode) {
        Operand value2 = this.build(valueNode);
        this.addInstr(new PutGlobalVarInstr(name2, value2));
        return value2;
    }

    protected Operand buildGlobalVar(Variable result2, RubySymbol name2) {
        if (result2 == null) {
            result2 = this.temp();
        }
        return this.addResultInstr(new GetGlobalVariableInstr(result2, name2));
    }

    protected Operand buildInstAsgn(RubySymbol name2, U valueNode) {
        Operand value2 = this.build(valueNode);
        this.addInstr(new PutFieldInstr(this.buildSelf(), name2, value2));
        return value2;
    }

    protected Operand buildInstVar(RubySymbol name2) {
        return this.addResultInstr(new GetFieldInstr(this.temp(), (Operand)this.buildSelf(), name2, false));
    }

    protected Variable buildClassVarGetDefinition(RubySymbol name2) {
        return this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_CLASS_VAR, new Operand[]{this.classVarDefinitionContainer(), new FrozenString(name2), new FrozenString(DefinedMessage.CLASS_VARIABLE.getText())}));
    }

    protected Variable buildConstantGetDefinition(RubySymbol name2) {
        Label defLabel = this.getNewLabel();
        Label doneLabel = this.getNewLabel();
        Variable tmpVar = this.temp();
        this.addInstr(new LexicalSearchConstInstr(tmpVar, CurrentScope.INSTANCE, name2));
        this.addInstr(BNEInstr.create(defLabel, tmpVar, UndefinedValue.UNDEFINED));
        this.addInstr(new InheritanceSearchConstInstr(tmpVar, this.findContainerModule(), name2));
        this.addInstr(BNEInstr.create(defLabel, tmpVar, UndefinedValue.UNDEFINED));
        this.addInstr(new CopyInstr(tmpVar, this.nil()));
        this.addInstr(new JumpInstr(doneLabel));
        this.addInstr(new LabelInstr(defLabel));
        this.addInstr(new CopyInstr(tmpVar, new FrozenString(DefinedMessage.CONSTANT.getText())));
        this.addInstr(new LabelInstr(doneLabel));
        return tmpVar;
    }

    protected Variable buildGlobalVarGetDefinition(RubySymbol name2) {
        return this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_GLOBAL, new Operand[]{new FrozenString(name2), new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
    }

    protected Operand buildInstVarGetDefinition(RubySymbol name2) {
        Variable result2 = this.temp();
        Label done = this.getNewLabel();
        Label undefined = this.getNewLabel();
        Variable value2 = this.addResultInstr(new GetFieldInstr(this.temp(), (Operand)this.buildSelf(), name2, true));
        this.addInstr(IRBuilder.createBranch(value2, UndefinedValue.UNDEFINED, undefined));
        this.copy(result2, new FrozenString(DefinedMessage.INSTANCE_VARIABLE.getText()));
        this.jump(done);
        this.addInstr(new LabelInstr(undefined));
        this.copy(result2, this.nil());
        this.addInstr(new LabelInstr(done));
        return result2;
    }

    protected Operand buildIter(U var, U body, StaticScope staticScope, Signature signature, int line, int endLine) {
        ByteList prefix = this.createPrefixForIter(var);
        IRClosure closure = new IRClosure(this.getManager(), this.scope, line, staticScope, signature, prefix, this.coverageMode);
        this.getManager().getBuilderFactory().newIRBuilder(this.getManager(), closure, this, this.encoding).buildIterInner(this.methodName, var, body, endLine);
        this.methodName = null;
        return new WrappedIRClosure(this.buildSelf(), closure);
    }

    private ByteList createPrefixForLambda(U var) {
        ByteList prefix = new ByteList("->(".getBytes());
        this.createPrefixFromArgs(prefix, var);
        prefix.append(41);
        return prefix;
    }

    private ByteList createPrefixForIter(U var) {
        ByteList prefix = new ByteList();
        if (this.methodName != null) {
            prefix.append(this.methodName.getBytes());
            prefix.append(" ".getBytes());
        }
        prefix.append("&|".getBytes());
        this.createPrefixFromArgs(prefix, var);
        prefix.append(124);
        return prefix;
    }

    protected void createPrefixFromArgs(ByteList prefix, U var) {
    }

    protected InterpreterContext buildIterInner(RubySymbol methodName, U var, U body, int endLine) {
        Operand closureRetVal;
        long time = 0L;
        if (PARSER_TIMING) {
            time = System.nanoTime();
        }
        this.methodName = methodName;
        boolean forNode = this.scope instanceof IRFor;
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(new TraceInstr(RubyEvent.B_CALL, this.getCurrentModuleVariable(), this.getName(), this.getFileName(), this.scope.getLine() + 1));
        }
        if (forNode) {
            this.receiveForArgs(var);
        } else {
            this.receiveBlockArgs(var);
        }
        this.afterPrologueIndex = this.instructions.size();
        Operand operand = closureRetVal = body == null ? this.nil() : this.build(body);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(new TraceInstr(RubyEvent.B_RETURN, this.getCurrentModuleVariable(), this.getName(), this.getFileName(), endLine + 1));
        }
        if (closureRetVal != U_NIL) {
            this.addInstr(new ReturnInstr(closureRetVal));
        }
        this.prependUsedClosureImplicitState(forNode);
        if (!forNode) {
            this.handleBreakAndReturnsInLambdas();
        }
        this.computeScopeFlagsFrom(this.instructions);
        InterpreterContext ic = this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
        if (PARSER_TIMING) {
            this.manager.getRuntime().getParserManager().getParserStats().addIRBuildTime(System.nanoTime() - time);
        }
        return ic;
    }

    public Operand buildLambda(U args2, U body, StaticScope staticScope, Signature signature, int line) {
        IRClosure closure = new IRClosure(this.getManager(), this.scope, line, staticScope, signature, this.createPrefixForLambda(args2), this.coverageMode);
        this.getManager().getBuilderFactory().newIRBuilder(this.getManager(), closure, this, this.encoding).buildLambdaInner(args2, body);
        Variable lambda2 = this.temp();
        WrappedIRClosure lambdaBody = new WrappedIRClosure(closure.getSelf(), closure);
        this.addInstr(new BuildLambdaInstr(lambda2, lambdaBody));
        return lambda2;
    }

    protected InterpreterContext buildLambdaInner(U blockArgs, U body) {
        long time = 0L;
        if (PARSER_TIMING) {
            time = System.nanoTime();
        }
        this.receiveBlockArgs(blockArgs);
        Operand closureRetVal = this.build(body);
        if (closureRetVal != U_NIL) {
            this.addInstr(new ReturnInstr(closureRetVal));
        }
        this.prependUsedClosureImplicitState(false);
        this.handleBreakAndReturnsInLambdas();
        this.computeScopeFlagsFrom(this.instructions);
        InterpreterContext ic = this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
        if (PARSER_TIMING) {
            this.manager.getRuntime().getParserManager().getParserStats().addIRBuildTime(System.nanoTime() - time);
        }
        return ic;
    }

    protected Operand buildLocalVariableAssign(RubySymbol name2, int depth, U valueNode) {
        Operand value2;
        LocalVariable variable = this.getLocalVariable(name2, depth);
        if (variable != (value2 = this.build(variable, valueNode))) {
            this.copy(variable, value2);
        }
        return variable;
    }

    protected Operand buildConditionalLoop(U conditionNode, U bodyNode, boolean isWhile, boolean isLoopHeadCondition) {
        Operand cv;
        if (isLoopHeadCondition && (isWhile && this.alwaysFalse(conditionNode) || !isWhile && this.alwaysTrue(conditionNode))) {
            this.build(conditionNode);
            return this.nil();
        }
        IRLoop loop2 = new IRLoop(this.scope, this.getCurrentLoop(), this.temp());
        Variable loopResult = loop2.loopResult;
        Label setupResultLabel = this.getNewLabel();
        this.loopStack.push(loop2);
        this.addInstr(new LabelInstr(loop2.loopStartLabel));
        if (isLoopHeadCondition) {
            cv = this.build(conditionNode);
            this.addInstr(IRBuilder.createBranch(cv, isWhile ? this.fals() : this.tru(), setupResultLabel));
        }
        this.addInstr(new LabelInstr(loop2.iterStartLabel));
        this.addInstr(new ThreadPollInstr(true));
        if (bodyNode != null) {
            this.build(bodyNode);
        }
        if (loop2.hasNext) {
            this.addInstr(new LabelInstr(loop2.iterEndLabel));
        }
        if (isLoopHeadCondition) {
            this.addInstr(new JumpInstr(loop2.loopStartLabel));
        } else {
            cv = this.build(conditionNode);
            this.addInstr(IRBuilder.createBranch(cv, isWhile ? this.tru() : this.fals(), loop2.iterStartLabel));
        }
        this.addInstr(new LabelInstr(setupResultLabel));
        this.addInstr(new CopyInstr(loopResult, this.nil()));
        if (loop2.hasBreak) {
            this.addInstr(new LabelInstr(loop2.loopEndLabel));
        }
        this.loopStack.pop();
        return loopResult;
    }

    protected Variable buildDefinitionCheck(ResultInstr definedInstr, String definedReturnValue) {
        Label undefLabel = this.getNewLabel();
        this.addInstr((Instr)((Object)definedInstr));
        this.addInstr(IRBuilder.createBranch(definedInstr.getResult(), this.fals(), undefLabel));
        return this.buildDefnCheckIfThenPaths(undefLabel, new FrozenString(definedReturnValue));
    }

    protected Variable buildDefnCheckIfThenPaths(Label undefLabel, Operand defVal) {
        Label defLabel = this.getNewLabel();
        Variable tmpVar = this.getValueInTemporaryVariable(defVal);
        this.addInstr(new JumpInstr(defLabel));
        this.addInstr(new LabelInstr(undefLabel));
        this.addInstr(new CopyInstr(tmpVar, this.nil()));
        this.addInstr(new LabelInstr(defLabel));
        return tmpVar;
    }

    public Operand buildMatch(Variable result2, Operand regexp2) {
        Variable tempLastLine = this.temp();
        this.addResultInstr(new GetGlobalVariableInstr(tempLastLine, this.symbol("$_")));
        if (result2 == null) {
            result2 = this.temp();
        }
        return this.addResultInstr(new MatchInstr(this.scope, result2, regexp2, tempLastLine));
    }

    protected Operand buildModule(ByteList name2, U cpath, U bodyNode, StaticScope scope, int line, int endLine) {
        boolean executesOnce = this.executesOnce;
        Operand container = this.getContainerFromCPath(cpath);
        IRModuleBody body = new IRModuleBody(this.getManager(), this.scope, name2, line, scope, executesOnce);
        Variable bodyResult = this.addResultInstr(new DefineModuleInstr(this.temp(), container, body));
        this.getManager().getBuilderFactory().newIRBuilder(this.getManager(), body, this, this.encoding).buildModuleOrClassBody(bodyNode, line, endLine);
        return bodyResult;
    }

    protected InterpreterContext buildModuleOrClassBody(U body, int startLine, int endLine) {
        this.addInstr(new TraceInstr(RubyEvent.CLASS, this.getCurrentModuleVariable(), null, this.getFileName(), startLine + 1));
        Operand bodyReturnValue = this.build(body);
        this.addInstr(this.getManager().newLineNumber(endLine));
        this.addInstr(new TraceInstr(RubyEvent.END, this.getCurrentModuleVariable(), null, this.getFileName(), endLine + 1));
        this.addInstr(new ReturnInstr(bodyReturnValue));
        this.prependUsedImplicitState(null);
        this.computeScopeFlagsFrom(this.instructions);
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
    }

    protected Operand buildNext(Operand rv, int line) {
        IRLoop currLoop = this.getCurrentLoop();
        if (!this.activeEnsureBlockStack.isEmpty()) {
            this.emitEnsureBlocks(currLoop);
        }
        if (currLoop != null) {
            currLoop.hasNext = true;
            this.addInstr(new JumpInstr(currLoop.iterEndLabel));
        } else {
            this.addInstr(new ThreadPollInstr(true));
            if (this.scope instanceof IRClosure) {
                if (this.scope instanceof IREvalScript) {
                    this.throwSyntaxError(line, "Can't escape from eval with next");
                } else {
                    this.addInstr(new ReturnInstr(rv));
                }
            } else {
                this.throwSyntaxError(line, "Invalid next");
            }
        }
        return U_NIL;
    }

    protected Operand buildNthRef(int matchNumber) {
        return this.copy(new NthRef(this.scope, matchNumber));
    }

    protected Operand buildOpAsgn(U receiver2, U value2, RubySymbol reader, RubySymbol writer, RubySymbol operator, boolean isLazy) {
        boolean isLogical;
        Variable writerValue = this.temp();
        Operand v1 = this.build(receiver2);
        CallType callType = v1 == Self.SELF ? CallType.FUNCTIONAL : CallType.NORMAL;
        Label lazyLabel = null;
        Label endLabel = null;
        Variable result2 = this.temp();
        if (isLazy) {
            lazyLabel = this.getNewLabel();
            endLabel = this.getNewLabel();
            this.addInstr(new BNilInstr(lazyLabel, v1));
        }
        Variable readerValue = this._call(this.temp(), callType, v1, reader, new Operand[0]);
        boolean isOr = operator.idString().equals("||");
        boolean bl = isLogical = isOr || operator.idString().equals("&&");
        if (isLogical) {
            Label l = this.getNewLabel();
            this.addInstr(IRBuilder.createBranch(readerValue, isOr ? this.tru() : this.fals(), l));
            Operand v2 = this.build(value2);
            this._call(writerValue, callType, v1, writer, v2);
            this.addInstr(new CopyInstr(readerValue, v2));
            this.addInstr(new LabelInstr(l));
            if (!isLazy) {
                return readerValue;
            }
            this.addInstr(new CopyInstr(result2, (Operand)readerValue));
        } else {
            Operand v2 = this.build(value2);
            Variable setValue2 = this.call(this.temp(), (Operand)readerValue, operator, v2);
            this._call(writerValue, callType, v1, writer, setValue2);
            if (!isLazy) {
                return setValue2;
            }
            this.addInstr(new CopyInstr(result2, (Operand)setValue2));
        }
        this.addInstr(new JumpInstr(endLabel));
        this.addInstr(new LabelInstr(lazyLabel));
        this.addInstr(new CopyInstr(result2, this.nil()));
        this.addInstr(new LabelInstr(endLabel));
        return result2;
    }

    protected Operand buildOpAsgnAnd(CodeBlock lhs, CodeBlock rhs) {
        Label done = this.getNewLabel();
        Operand leftValue = lhs.run();
        Variable result2 = this.getValueInTemporaryVariable(leftValue);
        this.addInstr(IRBuilder.createBranch(result2, this.fals(), done));
        Operand value2 = rhs.run();
        this.copy(result2, value2);
        this.addInstr(new LabelInstr(done));
        return result2;
    }

    protected Operand buildOpAsgnConstDeclOr(U left2, U right, RubySymbol leftName) {
        Variable result2 = this.temp();
        Label falseCheck = this.getNewLabel();
        Label done = this.getNewLabel();
        Label assign = this.getNewLabel();
        Operand module = this.buildColon2ForConstAsgnDeclNode(left2, result2, false);
        this.addInstr(BNEInstr.create(falseCheck, result2, UndefinedValue.UNDEFINED));
        this.addInstr(new JumpInstr(assign));
        this.addInstr(new LabelInstr(falseCheck));
        this.addInstr(BNEInstr.create(done, result2, this.fals()));
        this.addInstr(new LabelInstr(assign));
        Operand rhsValue = this.build(right);
        this.copy(result2, rhsValue);
        this.addInstr(new PutConstInstr(module, leftName, rhsValue));
        this.addInstr(new LabelInstr(done));
        return result2;
    }

    protected Operand buildOpAsgnConstDeclAnd(U left2, U right, RubySymbol leftName) {
        Variable result2 = this.temp();
        Label done = this.getNewLabel();
        Operand module = this.buildColon2ForConstAsgnDeclNode(left2, result2, true);
        this.addInstr(new BFalseInstr(done, result2));
        Operand rhsValue = this.build(right);
        this.copy(result2, rhsValue);
        this.addInstr(new PutConstInstr(module, leftName, rhsValue));
        this.addInstr(new LabelInstr(done));
        return result2;
    }

    protected abstract Operand buildColon2ForConstAsgnDeclNode(U var1, Variable var2, boolean var3);

    @Deprecated
    protected Operand buildOpAsgnConstDecl(Y left2, U right, RubySymbol operator) {
        Operand lhs = this.build(left2);
        Operand rhs = this.build(right);
        Variable result2 = this.call(this.temp(), lhs, operator, rhs);
        return this.copy(this.temp(), this.putConstant(left2, (Operand)result2));
    }

    protected Operand buildOpAsgnConstDecl(Y left2, RubySymbol name2, U right, RubySymbol operator) {
        Operand parent = this.buildColon2ForConstAsgnDeclNode(left2, this.temp(), false);
        Operand lhs = this.searchModuleForConst(this.temp(), parent, name2);
        Operand rhs = this.build(right);
        Variable result2 = this.call(this.temp(), lhs, operator, rhs);
        return this.copy(this.temp(), this.putConstant(parent, name2, result2));
    }

    protected abstract Operand putConstant(Y var1, Operand var2);

    protected Operand buildOpAsgnOr(CodeBlock lhs, CodeBlock rhs) {
        Label done = this.getNewLabel();
        Variable result2 = (Variable)lhs.run();
        this.addInstr(IRBuilder.createBranch(result2, this.tru(), done));
        Operand value2 = rhs.run();
        this.copy(result2, value2);
        this.addInstr(new LabelInstr(done));
        return result2;
    }

    protected Operand buildOpElementAsgnWith(U receiver2, U args2, U block, U value2, Boolean truthy) {
        Operand array2 = this.buildWithOrder(receiver2, this.containsVariableAssignment(args2) || this.containsVariableAssignment(value2));
        CallType callType = array2 == Self.SELF ? CallType.FUNCTIONAL : CallType.NORMAL;
        Label endLabel = this.getNewLabel();
        Variable elt = this.temp();
        int[] flags2 = new int[]{0};
        Operand[] argList = this.setupCallArgs(args2, flags2);
        Operand blockArg = this.setupCallClosure(args2, block);
        this.addInstr(CallInstr.create(this.scope, callType, elt, this.symbol(ArrayDerefInstr.AREF), array2, argList, blockArg, flags2[0]));
        this.addInstr(IRBuilder.createBranch(elt, truthy, endLabel));
        Operand valueArg = this.build(value2);
        argList = IRBuilder.addArg(argList, valueArg);
        this.addInstr(CallInstr.create(this.scope, callType, elt, this.symbol(ArrayDerefInstr.ASET), array2, argList, blockArg, flags2[0]));
        this.addInstr(new CopyInstr(elt, valueArg));
        this.addInstr(new LabelInstr(endLabel));
        return elt;
    }

    protected Operand buildOpElementAsgnWithMethod(U receiver2, U args2, U block, U value2, RubySymbol operator) {
        Operand array2 = this.buildWithOrder(receiver2, this.containsVariableAssignment(args2) || this.containsVariableAssignment(value2));
        CallType callType = array2 == Self.SELF ? CallType.FUNCTIONAL : CallType.NORMAL;
        int[] flags2 = new int[]{0};
        Operand[] argList = this.setupCallArgs(args2, flags2);
        Operand blockArg = this.setupCallClosure(args2, block);
        Variable elt = this.temp();
        this.addInstr(CallInstr.create(this.scope, callType, elt, this.symbol(ArrayDerefInstr.AREF), array2, argList, blockArg, flags2[0]));
        Operand valueArg = this.build(value2);
        this._call(elt, callType, elt, operator, valueArg);
        argList = IRBuilder.addArg(argList, elt);
        this.addInstr(CallInstr.create(this.scope, callType, this.temp(), this.symbol(ArrayDerefInstr.ASET), array2, argList, blockArg, flags2[0]));
        return elt;
    }

    protected Operand buildOpAsgnOrWithDefined(U first2, U second2) {
        Label l1 = this.getNewLabel();
        Label l2 = this.getNewLabel();
        Variable flag = this.temp();
        Operand v1 = this.buildGetDefinition(first2);
        this.addInstr(new CopyInstr(flag, v1));
        this.addInstr(IRBuilder.createBranch(flag, this.nil(), l2));
        v1 = this.build(first2);
        this.addInstr(new CopyInstr(flag, v1));
        Variable result2 = this.getValueInTemporaryVariable(v1);
        this.addInstr(new LabelInstr(l2));
        this.addInstr(IRBuilder.createBranch(flag, this.tru(), l1));
        Operand v2 = this.build(second2);
        this.addInstr(new CopyInstr(result2, v2));
        this.addInstr(new LabelInstr(l1));
        return result2;
    }

    protected Operand buildOr(Operand left2, CodeBlock right, BinaryType type2) {
        if (type2 == BinaryType.LeftTrue) {
            return left2;
        }
        if (type2 == BinaryType.LeftFalse) {
            return right.run();
        }
        Label endOfExprLabel = this.getNewLabel();
        Variable result2 = this.getValueInTemporaryVariable(left2);
        this.addInstr(IRBuilder.createBranch(left2, this.tru(), endOfExprLabel));
        this.addInstr(new CopyInstr(result2, right.run()));
        this.addInstr(new LabelInstr(endOfExprLabel));
        return result2;
    }

    protected Variable deconstructHashPatternKeys(Label testEnd, Variable errorString, U constantNode, U[] keyNodes, U rest, Variable result2, Operand obj, boolean isSinglePattern) {
        Operand keys2;
        if ((keyNodes != null && keyNodes.length > 0 || rest != null) && !this.hasNamedRest(rest)) {
            int length2 = keyNodes.length;
            Operand[] builtKeys = new Operand[length2];
            for (int i2 = 0; i2 < length2; ++i2) {
                builtKeys[i2] = this.build(keyNodes[i2]);
            }
            keys2 = new Array(builtKeys);
        } else {
            keys2 = this.nil();
        }
        if (constantNode != null) {
            this.buildPatternConstant(testEnd, result2, constantNode, obj, isSinglePattern, errorString);
        }
        this.buildPatternDeconstructRespondTo(testEnd, result2, obj, isSinglePattern, errorString, "deconstruct_keys");
        return this.call(this.temp(), obj, "deconstruct_keys", keys2);
    }

    private boolean hasNamedRest(U rest) {
        return rest != null && !this.isBareStar(rest);
    }

    protected abstract U getInExpression(U var1);

    protected abstract U getInBody(U var1);

    protected abstract boolean isBareStar(U var1);

    protected void buildArrayPattern(Label testEnd, Variable result2, Variable deconstructed, U constant, U[] pre, U rest, U[] post, Operand obj, boolean inAlteration, boolean isSinglePattern, Variable errorString) {
        int i2;
        Variable restNum = this.addResultInstr(new CopyInstr(this.intTemp(), new Integer(0)));
        if (constant != null) {
            this.buildPatternConstant(testEnd, result2, constant, obj, isSinglePattern, errorString);
        }
        this.buildPatternDeconstructRespondTo(testEnd, result2, obj, isSinglePattern, errorString, "deconstruct");
        this.label("deconstruct_cache_end", deconstruct_cache_end -> this.cond_ne((Label)deconstruct_cache_end, deconstructed, this.nil(), () -> {
            this.call(deconstructed, obj, "deconstruct", new Operand[0]);
            this.label("array_check_end", arrayCheck -> {
                this.addInstr(new EQQInstr(this.scope, result2, this.getManager().getArrayClass(), deconstructed, false, false));
                this.cond((Label)arrayCheck, result2, this.tru(), () -> this.type_error("deconstruct must return Array"));
            });
        }));
        int preArgsSize = pre == null ? 0 : pre.length;
        int postArgsSize = post == null ? 0 : post.length;
        Integer minArgsCount = new Integer(preArgsSize + postArgsSize);
        Variable length2 = this.addResultInstr(new RuntimeHelperCall(this.intTemp(), RuntimeHelperCall.Methods.ARRAY_LENGTH, new Operand[]{deconstructed}));
        this.buildPatternArrayLengthCheck(testEnd, result2, deconstructed, isSinglePattern, errorString, length2, minArgsCount, rest != null);
        if (preArgsSize > 0) {
            for (i2 = 0; i2 < preArgsSize; ++i2) {
                Variable elt = this.call(this.temp(), (Operand)deconstructed, "[]", this.fix(i2));
                this.buildPatternEach(testEnd, result2, obj, this.copy(this.nil()), elt, pre[i2], inAlteration, isSinglePattern, errorString);
                this.cond_ne(testEnd, result2, this.tru());
            }
        }
        if (rest != null) {
            this.addInstr(new IntegerMathInstr(IntegerMathInstr.Op.SUBTRACT, restNum, (Operand)length2, (Operand)minArgsCount));
            if (!this.isBareStar(rest)) {
                Variable min2 = this.copy(this.fix(preArgsSize));
                Variable max2 = this.as_fixnum(restNum);
                Variable elt = this.call(this.temp(), (Operand)deconstructed, "[]", min2, max2);
                this.buildPatternMatch(result2, obj, this.copy(this.nil()), rest, elt, inAlteration, isSinglePattern, errorString);
                this.cond_ne(testEnd, result2, this.tru());
            }
        }
        if (postArgsSize > 0) {
            for (i2 = 0; i2 < postArgsSize; ++i2) {
                Variable j = this.addResultInstr(new IntegerMathInstr(IntegerMathInstr.Op.ADD, this.intTemp(), (Operand)new Integer(i2 + preArgsSize), (Operand)restNum));
                Variable k = this.as_fixnum(j);
                Variable elt = this.call(this.temp(), (Operand)deconstructed, "[]", k);
                this.buildPatternEach(testEnd, result2, obj, this.copy(this.nil()), elt, post[i2], inAlteration, isSinglePattern, errorString);
                this.cond_ne(testEnd, result2, this.tru());
            }
        }
    }

    private void buildPatternConstant(Label testEnd, Variable result2, U constant, Operand obj, boolean isSinglePattern, Variable errorString) {
        Operand expression = this.build(constant);
        this.addInstr(new EQQInstr(this.scope, result2, expression, obj, false, true));
        if (isSinglePattern) {
            this.buildPatternSetEQQError(errorString, result2, obj, expression, obj);
        }
        this.cond_ne(testEnd, result2, this.tru());
    }

    protected void buildPatternSetEQQError(Variable errorString, Variable result2, Operand obj, Operand expression, Operand value2) {
        this.buildPatternSetGeneralError(errorString, result2, new FrozenString("%s: %s === %s does not return true"), obj, expression, value2);
    }

    protected void buildPatternSetGeneralError(Variable errorString, Variable result2, Operand ... args2) {
        this.label("match_succeeded", matchSucceeded -> {
            this.cond_ne((Label)matchSucceeded, result2, this.fals());
            this.fcall(errorString, (Operand)this.getManager().getObjectClass(), "sprintf", args2);
        });
    }

    protected void buildFindPattern(Label testEnd, Variable result2, Variable deconstructed, U constant, U pre, U[] args2, U post, Operand obj, boolean inAlteration, boolean isSinglePattern, Variable errorString) {
        if (constant != null) {
            this.buildPatternConstant(testEnd, result2, constant, obj, isSinglePattern, errorString);
        }
        this.label("deconstruct_end", deconstructCheck -> this.cond_ne((Label)deconstructCheck, deconstructed, this.nil(), () -> {
            this.buildPatternDeconstructRespondTo(testEnd, result2, obj, isSinglePattern, errorString, "deconstruct");
            this.call(deconstructed, obj, "deconstruct", new Operand[0]);
            this.label("array_check_end", arrayCheck -> {
                this.addInstr(new EQQInstr(this.scope, result2, this.getManager().getArrayClass(), deconstructed, false, false));
                this.cond((Label)arrayCheck, result2, this.tru(), () -> this.type_error("deconstruct must return Array"));
            });
        }));
        Variable length2 = this.addResultInstr(new RuntimeHelperCall(this.intTemp(), RuntimeHelperCall.Methods.ARRAY_LENGTH, new Operand[]{deconstructed}));
        int fixedArgsLength = args2.length;
        Integer minArgsCount = new Integer(fixedArgsLength);
        boolean hasRest = pre != null || post != null;
        this.buildPatternArrayLengthCheck(testEnd, result2, deconstructed, isSinglePattern, errorString, length2, minArgsCount, hasRest);
        Variable limit2 = this.addResultInstr(new IntegerMathInstr(IntegerMathInstr.Op.SUBTRACT, this.intTemp(), (Operand)length2, (Operand)minArgsCount));
        Variable i2 = this.copy(new Integer(0));
        this.for_loop(after -> this.addInstr(new BIntInstr((Label)after, BIntInstr.Op.GT, (Operand)i2, (Operand)limit2)), after -> this.addInstr(new IntegerMathInstr(IntegerMathInstr.Op.ADD, i2, (Operand)i2, (Operand)new Integer(1))), (after, bottom) -> {
            this.times(fixedArgsLength, (end_times, j) -> {
                Object pat = args2[j.value];
                Variable deconstructIndex = this.addResultInstr(new IntegerMathInstr(IntegerMathInstr.Op.ADD, this.intTemp(), (Operand)i2, (Operand)new Integer(j.value)));
                Variable deconstructFixnum = this.as_fixnum(deconstructIndex);
                Variable test2 = this.call(this.temp(), (Operand)deconstructed, "[]", deconstructFixnum);
                this.buildPatternMatch(result2, obj, this.copy(this.nil()), pat, test2, false, isSinglePattern, errorString);
                this.cond_ne((Label)bottom, result2, this.tru());
            });
            if (pre != null && !this.isBareStar(pre)) {
                Variable iFixnum = this.as_fixnum(i2);
                Variable test2 = this.call(this.temp(), (Operand)deconstructed, "[]", this.getManager().newFixnum(0L), iFixnum);
                this.buildPatternMatch(result2, obj, this.copy(this.nil()), pre, test2, false, isSinglePattern, errorString);
                this.cond_ne((Label)bottom, result2, this.tru());
            }
            if (post != null && !this.isBareStar(post)) {
                Variable deconstructIndex = this.addResultInstr(new IntegerMathInstr(IntegerMathInstr.Op.ADD, this.intTemp(), (Operand)i2, minArgsCount));
                Variable deconstructFixnum = this.as_fixnum(deconstructIndex);
                Variable lengthFixnum = this.as_fixnum(length2);
                Variable test3 = this.call(this.temp(), (Operand)deconstructed, "[]", deconstructFixnum, lengthFixnum);
                this.buildPatternMatch(result2, obj, this.copy(this.nil()), post, test3, false, isSinglePattern, errorString);
                this.cond_ne((Label)bottom, result2, this.tru());
            }
            this.jump((Label)after);
        });
    }

    private void buildPatternArrayLengthCheck(Label testEnd, Variable result2, Variable deconstructed, boolean isSinglePattern, Variable errorString, Variable length2, Operand minArgsCount, boolean hasRest) {
        this.label("size_check_end", minArgsCheck -> {
            BIntInstr.Op compareOp = hasRest ? BIntInstr.Op.GTE : BIntInstr.Op.EQ;
            this.addInstr(new BIntInstr((Label)minArgsCheck, compareOp, (Operand)length2, minArgsCount));
            if (isSinglePattern) {
                this.fcall(errorString, (Operand)this.getManager().getObjectClass(), "sprintf", new FrozenString("%s: %s length mismatch (given %d, expected %d" + (hasRest ? "+" : "") + ")"), deconstructed, deconstructed, this.as_fixnum(length2), this.as_fixnum(minArgsCount));
            }
            this.addInstr(new CopyInstr(result2, this.fals()));
            this.jump(testEnd);
        });
    }

    private void buildPatternDeconstructRespondTo(Label testEnd, Variable result2, Operand obj, boolean isSinglePattern, Variable errorString, String methodName) {
        this.call(result2, obj, "respond_to?", new Symbol(this.symbol(methodName)));
        if (isSinglePattern) {
            this.buildPatternSetGeneralError(errorString, result2, new FrozenString("%s: %s does not respond to #" + methodName), obj, obj);
        }
        this.cond_ne(testEnd, result2, this.tru());
    }

    protected Operand buildPatternCase(U test2, U[] cases, U consequent) {
        Variable result2 = this.temp();
        Operand value2 = this.build(test2);
        Variable errorString = this.copy(this.nil());
        this.label("pattern_case_end", end2 -> {
            ArrayList<Label> labels = new ArrayList<Label>();
            HashMap<Label, Object> bodies = new HashMap<Label, Object>();
            Variable deconstructed = this.copy(this.nil());
            boolean isSinglePattern = cases.length == 1;
            for (Object in : cases) {
                Label bodyLabel = this.getNewLabel();
                Object body = this.getInBody(in);
                Variable eqqResult = this.copy(this.tru());
                labels.add(bodyLabel);
                this.buildPatternMatch(eqqResult, value2, deconstructed, this.getInExpression(in), value2, false, isSinglePattern, errorString);
                this.addInstr(IRBuilder.createBranch(eqqResult, this.tru(), bodyLabel));
                bodies.put(bodyLabel, body);
            }
            if (consequent != null) {
                Operand bodyValue = this.build(consequent);
                if (bodyValue != null) {
                    this.copy(result2, bodyValue);
                }
            } else {
                Variable inspect2 = this.temp();
                this.label("key_check_error", key_check_end -> {
                    Variable whichError = this.addResultInstr(new EQQInstr(this.scope, this.temp(), this.getManager().getSymbolClass(), errorString, false, false));
                    this.addInstr(IRBuilder.createBranch(whichError, this.tru(), key_check_end));
                    this.if_else(errorString, this.nil(), () -> this.call(inspect2, value2, "inspect", new Operand[0]), () -> this.copy(inspect2, errorString));
                    this.addRaiseError("NoMatchingPatternError", inspect2);
                    this.jump((Label)end2);
                });
                this.fcall(inspect2, (Operand)this.manager.getObjectClass(), "sprintf", new FrozenString("%s: key not found: :%s"), value2, errorString);
                Operand exceptionClass = this.searchModuleForConst(this.temp(), this.getManager().getObjectClass(), this.symbol("NoMatchingPatternKeyError"));
                ArrayList<KeyValuePair<Operand, Operand>> kwargs = new ArrayList<KeyValuePair<Operand, Operand>>();
                kwargs.add(new KeyValuePair<Symbol, Variable>(new Symbol(this.symbol("key")), errorString));
                kwargs.add(new KeyValuePair<Symbol, Operand>(new Symbol(this.symbol("matchee")), value2));
                Variable exception2 = this.addResultInstr(CallInstr.create(this.scope, CallType.NORMAL, this.temp(), this.symbol("new"), exceptionClass, new Operand[]{inspect2, new Hash(kwargs)}, NullBlock.INSTANCE, 2));
                Operand kernel = this.searchModuleForConst(this.temp(), this.getManager().getObjectClass(), this.symbol("Kernel"));
                this.call(this.temp(), kernel, "raise", exception2);
            }
            this.jump((Label)end2);
            for (Label label2 : labels) {
                this.addInstr(new LabelInstr(label2));
                Operand bodyValue = this.build(bodies.get(label2));
                if (bodyValue != null) {
                    this.copy(result2, bodyValue);
                }
                this.jump((Label)end2);
            }
        });
        return result2;
    }

    protected abstract Variable buildPatternEach(Label var1, Variable var2, Operand var3, Variable var4, Operand var5, U var6, boolean var7, boolean var8, Variable var9);

    protected void buildPatternEachIf(Variable result2, Operand original, Variable deconstructed, Operand value2, U condition, U thenBody, U elseBody, boolean inAlternation, boolean isSinglePattern, Variable errorString) {
        boolean unless;
        if (thenBody != null) {
            unless = false;
            this.buildPatternMatch(result2, original, deconstructed, thenBody, value2, inAlternation, isSinglePattern, errorString);
        } else {
            unless = true;
            this.buildPatternMatch(result2, original, deconstructed, elseBody, value2, inAlternation, isSinglePattern, errorString);
        }
        this.label("if_else_end", conditionalEnd -> {
            this.cond_ne((Label)conditionalEnd, result2, this.tru());
            Operand ifResult = this.build(condition);
            if (unless) {
                this.call(result2, ifResult, "!", new Operand[0]);
            } else {
                this.addInstr(new CopyInstr(result2, ifResult));
            }
        });
    }

    protected abstract void buildAssocs(Label var1, Operand var2, Variable var3, Z var4, boolean var5, boolean var6, Variable var7, boolean var8, Variable var9);

    protected void buildHashPattern(Label testEnd, Variable result2, Variable deconstructed, U constant, Z assocs, U[] assocsKeys, U rest, Operand obj, boolean inAlteration, boolean isSinglePattern, Variable errorString) {
        boolean hasRest = rest != null;
        Variable d = this.deconstructHashPatternKeys(testEnd, errorString, constant, assocsKeys, rest, result2, obj, isSinglePattern);
        this.label("hash_check_end", endHashCheck -> {
            this.addInstr(new EQQInstr(this.scope, result2, this.getManager().getHashClass(), d, false, true));
            this.cond((Label)endHashCheck, result2, this.tru(), () -> this.type_error("deconstruct_keys must return Hash"));
        });
        if (hasRest) {
            this.call(d, (Operand)d, "dup", new Operand[0]);
        }
        if (hasRest || assocsKeys.length > 0) {
            this.buildAssocs(testEnd, obj, result2, assocs, inAlteration, isSinglePattern, errorString, hasRest, d);
        } else {
            this.call(result2, (Operand)d, "empty?", new Operand[0]);
            if (isSinglePattern) {
                this.maybeGenerateIsNotEmptyErrorString(errorString, result2, d);
            }
            this.cond_ne(testEnd, result2, this.tru());
        }
        if (hasRest) {
            if (this.isNilRest(rest)) {
                this.call(result2, (Operand)d, "empty?", new Operand[0]);
                if (isSinglePattern) {
                    this.maybeGenerateIsNotEmptyErrorString(errorString, result2, d);
                }
                this.cond_ne(testEnd, result2, this.tru());
            } else if (!this.isBareStar(rest)) {
                this.buildPatternEach(testEnd, result2, obj, this.copy(this.nil()), d, rest, inAlteration, isSinglePattern, errorString);
                this.cond_ne(testEnd, result2, this.tru());
            }
        }
    }

    protected void buildPatternEachHash(Label testEnd, Variable result2, Operand original, Variable deconstructed, Operand value2, U key2, U assocValue, boolean inAlternation, boolean isSinglePattern, Variable errorString) {
        this.buildPatternMatch(result2, original, deconstructed, key2, value2, inAlternation, isSinglePattern, errorString);
        this.buildPatternEach(testEnd, result2, original, deconstructed, value2, assocValue, inAlternation, isSinglePattern, errorString);
    }

    protected abstract boolean isNilRest(U var1);

    protected Operand buildPatternLocal(Operand value2, RubySymbol name2, int line, int depth, boolean inAlternation) {
        if (inAlternation && name2.idString().charAt(0) != '_') {
            this.throwSyntaxError(line, RubyStringBuilder.str(this.getManager().getRuntime(), "illegal variable in alternative pattern (", name2, ")"));
        }
        return this.copy(this.getLocalVariable(name2, depth), value2);
    }

    protected void buildPatternOr(Label testEnd, Operand original, Variable result2, Variable deconstructed, Operand value2, U left2, U right, boolean isSinglePattern, Variable errorString) {
        this.label("or_lhs_end", firstCase -> this.buildPatternEach((Label)firstCase, result2, original, deconstructed, value2, left2, true, isSinglePattern, errorString));
        this.label("or_rhs_end", secondCase -> this.cond((Label)secondCase, result2, this.tru(), () -> this.buildPatternEach(testEnd, result2, original, deconstructed, value2, right, true, isSinglePattern, errorString)));
    }

    protected void buildPatternMatch(Variable result2, Operand original, Variable deconstructed, U arg2, Operand obj, boolean inAlternation, boolean isSinglePattern, Variable errorString) {
        this.label("pattern_end", testEnd -> this.buildPatternEach((Label)testEnd, result2, original, deconstructed, obj, arg2, inAlternation, isSinglePattern, errorString));
    }

    protected void hackPostExeSource(IRBuilder builder) {
    }

    protected Operand buildPostExe(U body, int line) {
        IRScope topLevel = this.scope.getRootLexicalScope();
        IRScope nearestLVarScope = this.scope.getNearestTopLocalVariableScope();
        StaticScope parentScope = nearestLVarScope.getStaticScope();
        StaticScope staticScope = parentScope.duplicate();
        staticScope.setEnclosingScope(parentScope);
        IRClosure endClosure = new IRClosure(this.getManager(), this.scope, line, staticScope, Signature.NO_ARGUMENTS, CommonByteLists._END_, true);
        staticScope.setIRScope(endClosure);
        endClosure.setIsEND();
        IRBuilder builder = this.getManager().getBuilderFactory().newIRBuilder(this.getManager(), endClosure, null, this.encoding);
        builder.hackPostExeSource(this);
        builder.buildPrePostExeInner(body);
        this.addInstr(new RecordEndBlockInstr(topLevel, new WrappedIRClosure(this.buildSelf(), endClosure)));
        return this.nil();
    }

    private InterpreterContext buildPrePostExeInner(U body) {
        this.build(body);
        this.addInstr(new ReturnInstr(this.nil()));
        this.prependUsedImplicitState(null);
        this.computeScopeFlagsFrom(this.instructions);
        return this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
    }

    protected Operand buildPreExe(U body) {
        List<Instr> beginInstrs = this.getManager().getBuilderFactory().newIRBuilder(this.getManager(), this.scope, this, this, this.encoding).buildPreExeInner(body);
        this.instructions.addAll(this.afterPrologueIndex, beginInstrs);
        this.afterPrologueIndex += beginInstrs.size();
        return this.nil();
    }

    private List<Instr> buildPreExeInner(U body) {
        this.build(body);
        return this.instructions;
    }

    protected Operand buildRange(U beginNode, U endNode, boolean isExclusive) {
        Operand begin2 = this.build(beginNode);
        Operand end2 = this.build(endNode);
        if (begin2 instanceof ImmutableLiteral && end2 instanceof ImmutableLiteral) {
            return new Range((ImmutableLiteral)begin2, (ImmutableLiteral)end2, isExclusive);
        }
        return this.addResultInstr(new BuildRangeInstr(this.temp(), begin2, end2, isExclusive));
    }

    protected Operand buildRational(U numerator2, U denominator2) {
        return new Rational((ImmutableLiteral)this.build(numerator2), (ImmutableLiteral)this.build(denominator2));
    }

    protected Operand buildRedo(int line) {
        IRLoop currLoop;
        if (!this.activeEnsureBlockStack.isEmpty()) {
            this.emitEnsureBlocks(this.getCurrentLoop());
        }
        if ((currLoop = this.getCurrentLoop()) != null) {
            this.addInstr(new JumpInstr(currLoop.iterStartLabel));
        } else if (this.scope instanceof IRClosure) {
            if (this.scope instanceof IREvalScript) {
                this.throwSyntaxError(line, "Can't escape from eval with redo");
            } else {
                this.addInstr(new ThreadPollInstr(true));
                Label startLabel = new Label(this.scope.getId() + "_START", 0);
                this.instructions.add(this.afterPrologueIndex, new LabelInstr(startLabel));
                this.addInstr(new JumpInstr(startLabel));
            }
        } else {
            this.throwSyntaxError(line, "Invalid redo");
        }
        return this.nil();
    }

    protected void buildRescueBodyInternal(U[] exceptions, U body, X consequent, Variable rv, Variable exc, Label endLabel, U reference2) {
        Operand x;
        Label uncaughtLabel = this.getNewLabel("MISSED");
        Label caughtLabel = this.getNewLabel("RESCUE");
        if (exceptions == null || exceptions.length == 0) {
            this.outputExceptionCheck(this.getManager().getStandardError(), exc, caughtLabel);
        } else {
            for (int i2 = 0; i2 < exceptions.length; ++i2) {
                this.outputExceptionCheck(this.build(exceptions[i2]), exc, caughtLabel);
            }
        }
        this.addInstr(new LabelInstr(uncaughtLabel));
        if (consequent != null) {
            this.buildRescueBodyInternal(this.exceptionNodesFor(consequent), this.bodyFor(consequent), this.optRescueFor(consequent), rv, exc, endLabel, this.referenceFor(consequent));
        } else {
            this.addInstr(new ThrowExceptionInstr(exc));
        }
        this.addInstr(new LabelInstr(caughtLabel));
        if (reference2 != null) {
            Variable exception2 = this.addResultInstr(new GetGlobalVariableInstr(this.temp(), this.symbol("$!")));
            this.buildAssignment(reference2, exception2);
        }
        if ((x = this.build(body)) != U_NIL) {
            this.addInstr(new CopyInstr(rv, x));
            if (this.activeEnsureBlockStack.peek() != null) {
                this.activeEnsureBlockStack.peek().cloneIntoHostScope(this);
            }
            this.addInstr(new JumpInstr(endLabel));
        }
    }

    protected abstract void buildAssignment(U var1, Operand var2);

    protected Operand buildAttrAssign(Variable result2, U receiver2, U argsNode, U blockNode, RubySymbol name2, boolean isLazy, boolean containsAssignment) {
        Operand obj = this.buildWithOrder(receiver2, containsAssignment);
        Label lazyLabel = null;
        Label endLabel = null;
        if (result2 == null) {
            result2 = this.temp();
        }
        if (isLazy) {
            lazyLabel = this.getNewLabel();
            endLabel = this.getNewLabel();
            this.addInstr(new BNilInstr(lazyLabel, obj));
        }
        int[] flags2 = new int[1];
        Operand[] rhs = new Operand[1];
        Operand[] args2 = this.buildAttrAssignCallArgs(argsNode, rhs, containsAssignment);
        Operand block = this.setupCallClosure(argsNode, blockNode);
        this.addInstr(AttrAssignInstr.create(this.scope, obj, name2, args2, block, flags2[0], this.scope.maybeUsingRefinements()));
        this.addInstr(new CopyInstr(result2, rhs[0]));
        if (isLazy) {
            this.addInstr(new JumpInstr(endLabel));
            this.addInstr(new LabelInstr(lazyLabel));
            this.addInstr(new CopyInstr(result2, this.nil()));
            this.addInstr(new LabelInstr(endLabel));
        }
        return result2;
    }

    protected abstract Operand[] buildAttrAssignCallArgs(U var1, Operand[] var2, boolean var3);

    protected Operand buildRescueInternal(U bodyNode, U elseNode, U[] exceptions, U rescueBody, X optRescue, boolean isModifier, EnsureBlockInfo ensure, U reference2) {
        boolean needsBacktrace = !this.canBacktraceBeRemoved(exceptions, rescueBody, optRescue, elseNode, isModifier);
        Label rBeginLabel = this.getNewLabel();
        Label rEndLabel = ensure.end;
        Label rescueLabel = this.getNewLabel("RESC_TEST");
        ensure.needsBacktrace = needsBacktrace;
        this.addInstr(new LabelInstr(rBeginLabel));
        this.addInstr(new ExceptionRegionStartMarkerInstr(rescueLabel));
        this.activeRescuers.push(rescueLabel);
        this.addInstr(this.getManager().needsBacktrace(needsBacktrace));
        Operand tmp = this.nil();
        Variable rv = this.temp();
        if (bodyNode != null) {
            tmp = this.build(bodyNode);
        }
        this.addInstr(new ExceptionRegionEndMarkerInstr());
        this.activeRescuers.pop();
        if (elseNode != null) {
            this.addInstr(new LabelInstr(this.getNewLabel()));
            tmp = this.build(elseNode);
        }
        RescueBlockInfo rbi = new RescueBlockInfo(rBeginLabel, ensure.savedGlobalException);
        this.activeRescueBlockStack.push(rbi);
        if (tmp != U_NIL) {
            this.addInstr(new CopyInstr(rv, tmp));
            ensure.cloneIntoHostScope(this);
            this.addInstr(new JumpInstr(rEndLabel));
        }
        this.addInstr(new LabelInstr(rescueLabel));
        if (!needsBacktrace) {
            this.addInstr(this.getManager().needsBacktrace(true));
        }
        Variable exc = this.addResultInstr(new ReceiveRubyExceptionInstr(this.temp()));
        this.buildRescueBodyInternal(exceptions, rescueBody, optRescue, rv, exc, rEndLabel, reference2);
        this.activeRescueBlockStack.pop();
        return rv;
    }

    protected Operand buildRetry(int line) {
        if (this.activeRescueBlockStack.isEmpty()) {
            this.throwSyntaxError(line, "Invalid retry");
        } else {
            this.addInstr(new ThreadPollInstr(true));
            RescueBlockInfo rbi = this.activeRescueBlockStack.peek();
            this.addInstr(new PutGlobalVarInstr(this.symbol("$!"), (Operand)rbi.savedExceptionVariable));
            this.addInstr(new JumpInstr(rbi.entryLabel));
            this.scope.setHasLoops();
        }
        return this.nil();
    }

    protected Operand buildReturn(Operand value2, int line) {
        Operand retVal = value2;
        if (this.scope instanceof IRClosure) {
            if (this.scope.isWithinEND()) {
                this.addInstr(new ThrowExceptionInstr(IRException.RETURN_LocalJumpError));
            } else {
                boolean definedWithinMethod;
                boolean bl = definedWithinMethod = this.scope.getNearestMethod() != null;
                if (!(this.scope instanceof IREvalScript) && !(this.scope instanceof IRFor)) {
                    this.addInstr(new CheckForLJEInstr(definedWithinMethod));
                }
                if (!this.activeRescueBlockStack.isEmpty()) {
                    RescueBlockInfo rbi = this.activeRescueBlockStack.peek();
                    this.addInstr(new PutGlobalVarInstr(this.symbol("$!"), (Operand)rbi.savedExceptionVariable));
                }
                this.addInstr(new NonlocalReturnInstr(retVal, definedWithinMethod ? this.scope.getNearestMethod().getId() : "--none--"));
            }
        } else if (this.scope.isModuleBody()) {
            IRMethod sm = this.scope.getNearestMethod();
            if (sm == null) {
                this.addInstr(new ThrowExceptionInstr(IRException.RETURN_LocalJumpError));
            }
            if (sm != null) {
                this.addInstr(new NonlocalReturnInstr(retVal, sm.getId()));
            }
        } else {
            retVal = this.processEnsureRescueBlocks(retVal);
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.addInstr(new TraceInstr(RubyEvent.RETURN, this.getCurrentModuleVariable(), this.getName(), this.getFileName(), line + 1));
            }
            this.addInstr(new ReturnInstr(retVal));
        }
        return U_NIL;
    }

    protected Operand buildSClass(U receiverNode, U bodyNode, StaticScope scope, int line, int endLine) {
        Operand receiver2 = this.build(receiverNode);
        IRMetaClassBody body = new IRMetaClassBody(this.getManager(), this.scope, this.getManager().getMetaClassName().getBytes(), line, scope);
        Variable sClassVar = this.addResultInstr(new DefineMetaClassInstr(this.temp(), receiver2, body));
        Variable bodyResult = this.addResultInstr(new ProcessModuleBodyInstr(this.temp(), (Operand)sClassVar));
        this.getManager().getBuilderFactory().newIRBuilder(this.getManager(), body, this, this.encoding).buildModuleOrClassBody(bodyNode, line, endLine);
        return bodyResult;
    }

    protected Variable buildSelf() {
        this.selfUsed = true;
        return this.scope.getSelf();
    }

    protected Operand buildSuper(Variable aResult, U iterNode, U argsNode, int line, boolean isNewline) {
        Variable result2 = aResult == null ? this.temp() : aResult;
        Operand tempBlock = this.setupCallClosure(argsNode, iterNode);
        if (tempBlock == NullBlock.INSTANCE) {
            tempBlock = this.getYieldClosureVariable();
        }
        Operand block = tempBlock;
        boolean inClassBody = this.scope instanceof IRMethod && this.scope.getLexicalParent() instanceof IRClassBody;
        boolean isInstanceMethod = inClassBody && ((IRMethod)this.scope).isInstanceMethod;
        int[] flags2 = new int[]{0};
        Operand[] args2 = this.setupCallArgs(argsNode, flags2);
        this.determineIfWeNeedLineNumber(line, isNewline, false, false);
        if ((flags2[0] & 4) != 0) {
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{args2[args2.length - 1]}));
            this.if_else(test2, this.tru(), () -> this.receiveBreakException(block, this.determineSuperInstr(result2, IRBuilder.removeArg(args2), block, flags2[0], inClassBody, isInstanceMethod)), () -> this.receiveBreakException(block, this.determineSuperInstr(result2, args2, block, flags2[0], inClassBody, isInstanceMethod)));
        } else {
            this.receiveBreakException(block, this.determineSuperInstr(result2, args2, block, flags2[0], inClassBody, isInstanceMethod));
        }
        return result2;
    }

    protected Operand buildUndef(Operand name2) {
        return this.addResultInstr(new UndefMethodInstr(this.temp(), name2));
    }

    public Operand buildVAlias(RubySymbol left2, RubySymbol right) {
        this.addInstr(new GVarAliasInstr(new MutableString(left2), new MutableString(right)));
        return this.nil();
    }

    protected abstract void buildWhenArgs(W var1, Operand var2, Label var3, Set<IRubyObject> var4, Map<IRubyObject, java.lang.Integer> var5);

    protected void buildWhenValue(Variable eqqResult, Operand testValue, Label bodyLabel, U node, Set<IRubyObject> seenLiterals, Map<IRubyObject, java.lang.Integer> origLocs, boolean needsSplat) {
        if (this.literalWhenCheck(node, seenLiterals, origLocs)) {
            Operand expression = this.isLiteralString(node) ? this.frozen_string(node) : this.buildWithOrder(node, this.containsVariableAssignment(node));
            this.addInstr(new EQQInstr(this.scope, eqqResult, expression, testValue, needsSplat, this.scope.maybeUsingRefinements()));
            this.addInstr(IRBuilder.createBranch(eqqResult, this.tru(), bodyLabel));
        }
    }

    protected void buildWhenValues(Variable eqqResult, U[] exprValues, Operand testValue, Label bodyLabel, Set<IRubyObject> seenLiterals, Map<IRubyObject, java.lang.Integer> origLocs) {
        for (U value2 : exprValues) {
            this.buildWhenValue(eqqResult, testValue, bodyLabel, value2, seenLiterals, origLocs, false);
        }
    }

    protected abstract Operand[] buildCallArgs(U var1, int[] var2);

    protected abstract Operand buildGetDefinition(U var1);

    protected abstract boolean containsVariableAssignment(U var1);

    protected abstract Operand frozen_string(U var1);

    protected abstract int getLine(U var1);

    protected abstract IRubyObject getWhenLiteral(U var1);

    protected abstract boolean isLiteralString(U var1);

    protected abstract boolean needsDefinitionCheck(U var1);

    protected abstract void receiveForArgs(U var1);

    protected abstract void receiveBlockArgs(U var1);

    protected abstract Operand setupCallClosure(U var1, U var2);

    protected boolean literalWhenCheck(U value2, Set<IRubyObject> seenLiterals, Map<IRubyObject, java.lang.Integer> origLocs) {
        IRubyObject literal = this.getWhenLiteral(value2);
        if (literal != null) {
            if (seenLiterals.contains(literal)) {
                this.getManager().getRuntime().getWarnings().warning(IRubyWarnings.ID.MISCELLANEOUS, this.getFileName(), this.getLine(value2), "duplicated 'when' clause with line " + (origLocs.get(literal) + 1) + " is ignored");
                return false;
            }
            seenLiterals.add(literal);
            origLocs.put(literal, this.getLine(value2));
            return true;
        }
        return true;
    }

    protected Operand buildZSuper(Variable result2, U iter) {
        Operand block = this.setupCallClosure(null, iter);
        if (block == NullBlock.INSTANCE) {
            block = this.getYieldClosureVariable();
        }
        return this.scope instanceof IRMethod ? this.buildZSuper(result2, block) : this.buildZSuperIfNest(result2, block);
    }

    protected Operand buildZSuper(Variable result2, Operand block) {
        ArrayList<Operand> callArgs = new ArrayList<Operand>(5);
        ArrayList<KeyValuePair<Operand, Operand>> keywordArgs = new ArrayList<KeyValuePair<Operand, Operand>>(3);
        this.determineZSuperCallArgs(this.scope, this, callArgs, keywordArgs);
        boolean inClassBody = this.scope instanceof IRMethod && this.scope.getLexicalParent() instanceof IRClassBody;
        boolean isInstanceMethod = inClassBody && ((IRMethod)this.scope).isInstanceMethod;
        Variable zsuperResult = result2 == null ? this.temp() : result2;
        int[] flags2 = new int[]{0};
        if (keywordArgs.size() == 1 && ((Operand)((KeyValuePair)keywordArgs.get(0)).getKey()).equals(Symbol.KW_REST_ARG_DUMMY)) {
            flags2[0] = flags2[0] | 6;
            Operand keywordRest = (Operand)((KeyValuePair)keywordArgs.get(0)).getValue();
            Operand[] args2 = callArgs.toArray(new Operand[callArgs.size()]);
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{keywordRest}));
            this.if_else(test2, this.tru(), () -> this.receiveBreakException(block, this.determineSuperInstr(zsuperResult, args2, block, flags2[0], inClassBody, isInstanceMethod)), () -> this.receiveBreakException(block, this.determineSuperInstr(zsuperResult, IRBuilder.addArg(args2, keywordRest), block, flags2[0], inClassBody, isInstanceMethod)));
        } else {
            Operand[] args3 = IRBuilder.getZSuperCallOperands(this.scope, callArgs, keywordArgs, flags2);
            this.receiveBreakException(block, this.determineSuperInstr(zsuperResult, args3, block, flags2[0], inClassBody, isInstanceMethod));
        }
        return zsuperResult;
    }

    protected Operand buildZSuperIfNest(Variable result2, Operand block) {
        Variable zsuperResult;
        int depthFrom = 0;
        IRBuilder superBuilder = this;
        IRScope superScope = this.scope;
        boolean defineMethod = false;
        while (superScope instanceof IRClosure) {
            if (superBuilder != null && superBuilder.isDefineMethod()) {
                defineMethod = true;
            }
            superBuilder = superBuilder != null && superBuilder.parent != null ? superBuilder.parent : null;
            superScope = superScope.getLexicalParent();
            ++depthFrom;
        }
        int depthFromSuper = depthFrom;
        Variable variable = zsuperResult = result2 == null ? this.temp() : result2;
        if (superScope instanceof IRMethod && !defineMethod) {
            ArrayList<Operand> callArgs = new ArrayList<Operand>(5);
            ArrayList<KeyValuePair<Operand, Operand>> keywordArgs = new ArrayList<KeyValuePair<Operand, Operand>>(3);
            int[] flags2 = new int[]{0};
            this.determineZSuperCallArgs(superScope, superBuilder, callArgs, keywordArgs);
            if (keywordArgs.size() == 1 && ((Operand)((KeyValuePair)keywordArgs.get(0)).getKey()).equals(Symbol.KW_REST_ARG_DUMMY)) {
                flags2[0] = flags2[0] | 6;
                Operand keywordRest = ((DepthCloneable)((KeyValuePair)keywordArgs.get(0)).getValue()).cloneForDepth(depthFromSuper);
                Operand[] args2 = this.adjustVariableDepth(callArgs.toArray(new Operand[callArgs.size()]), depthFromSuper);
                Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{keywordRest}));
                this.if_else(test2, this.tru(), () -> this.addInstr(new ZSuperInstr(this.scope, zsuperResult, this.buildSelf(), args2, block, flags2[0], this.scope.maybeUsingRefinements())), () -> this.addInstr(new ZSuperInstr(this.scope, zsuperResult, this.buildSelf(), IRBuilder.addArg(args2, keywordRest), block, flags2[0], this.scope.maybeUsingRefinements())));
            } else {
                Operand[] args3 = this.adjustVariableDepth(IRBuilder.getZSuperCallOperands(this.scope, callArgs, keywordArgs, flags2), depthFromSuper);
                this.addInstr(new ZSuperInstr(this.scope, zsuperResult, this.buildSelf(), args3, block, flags2[0], this.scope.maybeUsingRefinements()));
            }
        } else {
            this.scope.setUsesZSuper();
            this.addRaiseError("RuntimeError", "implicit argument passing of super from method defined by define_method() is not supported. Specify all arguments explicitly.");
        }
        return zsuperResult;
    }

    protected abstract boolean alwaysFalse(U var1);

    protected abstract boolean alwaysTrue(U var1);

    protected abstract Operand build(Variable var1, U var2);

    protected abstract Operand build(U var1);

    protected abstract int dynamicPiece(Operand[] var1, int var2, U var3, Encoding var4);

    protected abstract void receiveMethodArgs(V var1);

    protected IRMethod defineNewMethod(LazyMethodDefinition<U, V, W, X, Y, Z> defn, ByteList name2, int line, StaticScope scope, boolean isInstanceMethod) {
        IRMethod method2 = new IRMethod(this.getManager(), this.scope, defn, name2, isInstanceMethod, line, scope, this.coverageMode);
        if (!this.canBeLazyMethod(defn.getMethod())) {
            method2.lazilyAcquireInterpreterContext();
        }
        return method2;
    }

    public InterpreterContext defineMethodInner(LazyMethodDefinition<U, V, W, X, Y, Z> defNode, IRScope parent, int coverageMode) {
        long time = 0L;
        if (PARSER_TIMING) {
            time = System.nanoTime();
        }
        this.coverageMode = coverageMode;
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(this.getManager().newLineNumber(this.scope.getLine() + 1));
            this.addInstr(new TraceInstr(RubyEvent.CALL, this.getCurrentModuleVariable(), this.getName(), this.getFileName(), this.scope.getLine() + 1));
        }
        this.receiveMethodArgs(defNode.getMethod());
        Operand rv = this.build(defNode.getMethodBody());
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            int endLine = defNode.getEndLine();
            this.addInstr(new LineNumberInstr(endLine));
            this.addInstr(new TraceInstr(RubyEvent.RETURN, this.getCurrentModuleVariable(), this.getName(), this.getFileName(), endLine));
        }
        if (rv != null) {
            this.addInstr(new ReturnInstr(rv));
        }
        this.computeScopeFlagsFrom(this.instructions);
        if (this.scope.canReceiveNonlocalReturns()) {
            this.handleNonlocalReturnInMethod();
        }
        ((IRMethod)this.scope).setArgumentDescriptors(this.createArgumentDescriptor());
        this.prependUsedImplicitState(parent);
        this.computeScopeFlagsFrom(this.instructions);
        InterpreterContext ic = this.scope.allocateInterpreterContext(this.instructions, this.temporaryVariableIndex + 1, this.flags);
        if (PARSER_TIMING) {
            this.manager.getRuntime().getParserManager().getParserStats().addIRBuildTime(System.nanoTime() - time);
        }
        return ic;
    }

    private void prependUsedImplicitState(IRScope parent) {
        int numberOfInstrs = 0;
        if (this.needsYieldBlock) {
            if (this.scope instanceof IRMethod) {
                ++numberOfInstrs;
                this.addInstrAtBeginning(new LoadImplicitClosureInstr(this.getYieldClosureVariable()));
            } else if (!(this.scope instanceof IRModuleBody || this.scope instanceof IRClassBody || this.scope instanceof IRMetaClassBody)) {
                ++numberOfInstrs;
                this.addInstrAtBeginning(new LoadFrameClosureInstr(this.getYieldClosureVariable()));
            }
        }
        if (this.currentModuleUsed) {
            if (this.scope instanceof IRMethod && parent != null) {
                ++numberOfInstrs;
                int nearestScopeDepth = parent.getNearestModuleReferencingScopeDepth();
                this.addInstrAtBeginning(new CopyInstr(this.getCurrentModuleVariable(), ScopeModule.ModuleFor(nearestScopeDepth == -1 ? 1 : nearestScopeDepth)));
            } else {
                ++numberOfInstrs;
                this.addInstrAtBeginning(new CopyInstr(this.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
            }
        }
        if (this.selfUsed) {
            ++numberOfInstrs;
            this.addInstrAtBeginning(this.manager.getReceiveSelfInstr());
        }
        if (numberOfInstrs > 0) {
            this.afterPrologueIndex += numberOfInstrs;
        }
    }

    private void prependUsedClosureImplicitState(boolean forLoop) {
        int numberOfInstrs = 0;
        if (this.needsYieldBlock) {
            ++numberOfInstrs;
            this.addInstrAtBeginning(new LoadBlockImplicitClosureInstr(this.getYieldClosureVariable()));
        }
        if (!forLoop && this.currentModuleUsed) {
            ++numberOfInstrs;
            this.addInstrAtBeginning(new CopyInstr(this.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        }
        if (this.selfUsed) {
            ++numberOfInstrs;
            this.addInstrAtBeginning(this.manager.getReceiveSelfInstr());
        }
        if (numberOfInstrs > 0) {
            this.afterPrologueIndex += numberOfInstrs;
        }
    }

    protected ArgumentDescriptor[] createArgumentDescriptor() {
        ArgumentDescriptor[] argDesc;
        if (this.argumentDescriptions == null) {
            argDesc = ArgumentDescriptor.EMPTY_ARRAY;
        } else {
            argDesc = new ArgumentDescriptor[this.argumentDescriptions.size() / 2];
            for (int i2 = 0; i2 < this.argumentDescriptions.size(); i2 += 2) {
                ArgumentType type2 = (ArgumentType)((Object)this.argumentDescriptions.get(i2));
                RubySymbol symbol = (RubySymbol)this.argumentDescriptions.get(i2 + 1);
                argDesc[i2 / 2] = new ArgumentDescriptor(type2, symbol);
            }
        }
        return argDesc;
    }

    public void addArgumentDescription(ArgumentType type2, RubySymbol name2) {
        if (this.argumentDescriptions == null) {
            this.argumentDescriptions = new ArrayList<Object>();
        }
        this.argumentDescriptions.add((Object)type2);
        this.argumentDescriptions.add(name2);
    }

    protected Variable argumentResult(RubySymbol name2) {
        boolean isUnderscore;
        if (name2 == null) {
            return this.temp();
        }
        boolean bl = isUnderscore = name2.getBytes().realSize() == 1 && name2.getBytes().charAt(0) == '_';
        if (isUnderscore && this.underscoreVariableSeen) {
            return this.temp();
        }
        if (isUnderscore) {
            this.underscoreVariableSeen = true;
        }
        return this.getNewLocalVariable(name2, 0);
    }

    private void checkForOptimizableDefineMethod(RubySymbol name2, U iter, Operand block) {
        IRClosure closure;
        if (CommonByteLists.DEFINE_METHOD_METHOD.equals(name2.getBytes()) && block instanceof WrappedIRClosure && !(closure = ((WrappedIRClosure)block).getClosure()).accessesParentsLocalVariables() && iter instanceof IterNode) {
            closure.setSource((IterNode)iter);
        }
    }

    protected Variable createCall(Variable result2, Operand receiver2, CallType callType, RubySymbol name2, U argsNode, U iter, int line, boolean isNewline) {
        int[] flags2 = new int[]{0};
        Operand[] args2 = this.setupCallArgs(argsNode, flags2);
        if (callType == CallType.FUNCTIONAL) {
            this.determineIfMaybeRefined(name2, args2);
        }
        Operand block = this.setupCallClosure(argsNode, iter);
        this.determineIfWeNeedLineNumber(line, isNewline, false, false);
        if ((flags2[0] & 4) != 0) {
            Variable test2 = this.addResultInstr(new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{args2[args2.length - 1]}));
            this.if_else(test2, this.tru(), () -> this.receiveBreakException(block, CallInstr.create(this.scope, callType, result2, name2, receiver2, IRBuilder.removeArg(args2), block, flags2[0])), () -> this.receiveBreakException(block, CallInstr.create(this.scope, callType, result2, name2, receiver2, args2, block, flags2[0])));
        } else {
            if (callType == CallType.FUNCTIONAL) {
                this.checkForOptimizableDefineMethod(name2, iter, block);
            }
            this.receiveBreakException(block, CallInstr.create(this.scope, callType, result2, name2, receiver2, args2, block, flags2[0]));
        }
        return result2;
    }

    protected void determineIfWeNeedLineNumber(int line, boolean isNewline, boolean implicitNil, boolean def) {
        if (line != this.lastProcessedLineNum && !implicitNil) {
            LineInfo needsCoverage;
            LineInfo lineInfo = needsCoverage = isNewline ? LineInfo.Coverage : null;
            if (!(needsCoverage == null || def && this.coverageMode == 0)) {
                this.needsLineNumInfo = isNewline ? needsCoverage : LineInfo.Backtrace;
            }
            this.lastProcessedLineNum = line;
        }
    }

    protected void determineIfMaybeRefined(RubySymbol methodName, Operand[] args2) {
        IRScope outerScope = this.scope.getNearestTopLocalVariableScope();
        boolean refinement = false;
        if (!(outerScope instanceof IRMethod)) {
            ByteList methodBytes = methodName.getBytes();
            if (args2.length == 1) {
                refinement = IRBuilder.isRefinementCall(methodBytes);
            } else if (args2.length == 2 && CommonByteLists.SEND.equal(methodBytes) && args2[0] instanceof Symbol) {
                Symbol sendName = (Symbol)args2[0];
                methodBytes = sendName.getBytes();
                refinement = IRBuilder.isRefinementCall(methodBytes);
            }
        }
        if (refinement) {
            this.scope.setIsMaybeUsingRefinements();
        }
    }

    protected CallInstr determineSuperInstr(Variable result2, Operand[] args2, Operand block, int flags2, boolean inClassBody, boolean isInstanceMethod) {
        if (result2 == null) {
            result2 = this.temp();
        }
        return inClassBody ? (isInstanceMethod ? new InstanceSuperInstr(this.scope, result2, this.getCurrentModuleVariable(), this.getName(), args2, block, flags2, this.scope.maybeUsingRefinements()) : new ClassSuperInstr(this.scope, result2, this.getCurrentModuleVariable(), this.getName(), args2, block, flags2, this.scope.maybeUsingRefinements())) : new UnresolvedSuperInstr(this.scope, result2, this.buildSelf(), args2, block, flags2, this.scope.maybeUsingRefinements());
    }

    protected Operand findContainerModule() {
        int nearestModuleBodyDepth = this.scope.getNearestModuleReferencingScopeDepth();
        return nearestModuleBodyDepth == -1 ? this.getCurrentModuleVariable() : ScopeModule.ModuleFor(nearestModuleBodyDepth);
    }

    protected Variable as_fixnum(Operand value2) {
        return this.addResultInstr(new AsFixnumInstr(this.temp(), value2));
    }

    public abstract LocalVariable getLocalVariable(RubySymbol var1, int var2);

    public LocalVariable getNewLocalVariable(RubySymbol name2, int scopeDepth) {
        return this.scope.getNewLocalVariable(name2, scopeDepth);
    }

    public IRManager getManager() {
        return this.manager;
    }

    private static boolean isRefinementCall(ByteList methodBytes) {
        return CommonByteLists.USING_METHOD.equals(methodBytes) || CommonByteLists.REFINE_METHOD.equals(methodBytes);
    }

    protected Operand processEnsureRescueBlocks(Operand retVal) {
        if (!this.activeEnsureBlockStack.isEmpty()) {
            retVal = this.addResultInstr(new CopyInstr(this.temp(), retVal));
            this.emitEnsureBlocks(null);
        }
        return retVal;
    }

    protected void throwSyntaxError(int line, String message2) {
        String errorMessage = this.getFileName() + ":" + (line + 1) + ": " + message2;
        throw this.scope.getManager().getRuntime().newSyntaxError(errorMessage);
    }

    protected BinaryType binaryType(U node) {
        return this.alwaysTrue(node) ? BinaryType.LeftTrue : (this.alwaysFalse(node) ? BinaryType.LeftFalse : BinaryType.Normal);
    }

    protected Encoding getEncoding() {
        return this.encoding;
    }

    public void initFlipStateVariable(Variable v, Operand initState) {
        this.addInstrAtBeginning(new CopyInstr(v, initState));
    }

    private IRBuilder getNearestFlipVariableScopeBuilder() {
        IRBuilder current2 = this;
        while (current2 != null && !current2.scope.isWhereFlipFlopStateVariableIs()) {
            current2 = current2.parent;
        }
        return current2;
    }

    public static enum BinaryType {
        Normal,
        LeftTrue,
        LeftFalse;

    }

    protected static interface VoidCodeBlockOne {
        public void run(Operand var1);
    }

    protected static interface VoidCodeBlock {
        public void run();
    }

    protected static interface RunIt {
        public void apply();
    }

    protected static interface Consume2<T, U> {
        public void apply(T var1, U var2);
    }

    protected static interface CodeBlock {
        public Operand run();
    }

    static enum LineInfo {
        Coverage,
        Backtrace;

    }
}

