/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.textstructure.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.grok.GrokCaptureExtracter;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class TestGrokPatternAction {
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:monitor/text_structure/test_grok_pattern");

    public static class Response
    extends ActionResponse
    implements ToXContentObject,
    Writeable {
        private final List<Map<String, Object>> ranges;

        public Response(List<Map<String, Object>> ranges) {
            this.ranges = ranges;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("matches");
            for (Map<String, Object> ranges : this.ranges) {
                builder.startObject();
                builder.field("matched", ranges != null);
                if (ranges != null) {
                    builder.startObject("fields");
                    for (Map.Entry<String, Object> rangeOrList : ranges.entrySet()) {
                        List<Object> listOfRanges = rangeOrList.getValue() instanceof List ? (List<Object>)rangeOrList.getValue() : List.of(rangeOrList.getValue());
                        builder.startArray(rangeOrList.getKey());
                        for (Object rangeObject : listOfRanges) {
                            GrokCaptureExtracter.Range range = (GrokCaptureExtracter.Range)rangeObject;
                            builder.startObject();
                            builder.field("match", range.match());
                            builder.field("offset", range.offset());
                            builder.field("length", range.length());
                            builder.endObject();
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }
    }

    public static class Request
    extends ActionRequest {
        public static final ParseField GROK_PATTERN = new ParseField("grok_pattern", new String[0]);
        public static final ParseField TEXT = new ParseField("text", new String[0]);
        public static final ParseField ECS_COMPATIBILITY = new ParseField("ecs_compatibility", new String[0]);
        private static final ObjectParser<Builder, Void> PARSER = Request.createParser();
        private final String grokPattern;
        private final List<String> text;
        private final String ecsCompatibility;

        private static ObjectParser<Builder, Void> createParser() {
            ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>("textstructure/testgrokpattern", false, Builder::new);
            parser.declareString(Builder::grokPattern, GROK_PATTERN);
            parser.declareStringArray(Builder::text, TEXT);
            return parser;
        }

        private Request(String grokPattern, List<String> text, String ecsCompatibility) {
            this.grokPattern = ExceptionsHelper.requireNonNull(grokPattern, GROK_PATTERN.getPreferredName());
            this.text = ExceptionsHelper.requireNonNull(text, TEXT.getPreferredName());
            this.ecsCompatibility = ecsCompatibility;
        }

        public static Request parseRequest(String ecsCompatibility, XContentParser parser) throws IOException {
            return PARSER.parse(parser, null).ecsCompatibility(ecsCompatibility).build();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            TransportAction.localOnly();
        }

        public String getGrokPattern() {
            return this.grokPattern;
        }

        public List<String> getText() {
            return this.text;
        }

        public String getEcsCompatibility() {
            return this.ecsCompatibility;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.grokPattern, request.grokPattern) && Objects.equals(this.text, request.text);
        }

        public int hashCode() {
            return Objects.hash(this.grokPattern, this.text);
        }

        @Override
        public String toString() {
            return "Request{grokPattern='" + this.grokPattern + "', text=" + this.text + "}";
        }

        public static class Builder {
            private String grokPattern;
            private List<String> text;
            private String ecsCompatibility;

            public Builder grokPattern(String grokPattern) {
                this.grokPattern = grokPattern;
                return this;
            }

            public Builder text(List<String> text) {
                this.text = text;
                return this;
            }

            public Builder ecsCompatibility(String ecsCompatibility) {
                this.ecsCompatibility = Strings.isNullOrEmpty(ecsCompatibility) ? null : ecsCompatibility;
                return this;
            }

            public Request build() {
                return new Request(this.grokPattern, this.text, this.ecsCompatibility);
            }
        }
    }
}

