/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.store;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.xpack.core.security.authc.CrossClusterAccessSubjectInfo;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleKey;
import org.elasticsearch.xpack.core.security.authz.store.RoleReferenceResolver;
import org.elasticsearch.xpack.core.security.authz.store.RolesRetrievalResult;

public interface RoleReference {
    public RoleKey id();

    public void resolve(RoleReferenceResolver var1, ActionListener<RolesRetrievalResult> var2);

    public static enum ApiKeyRoleType {
        ASSIGNED,
        LIMITED_BY;

    }

    public static final class ServiceAccountRoleReference
    implements RoleReference {
        private final String principal;

        public ServiceAccountRoleReference(String principal) {
            this.principal = principal;
        }

        public String getPrincipal() {
            return this.principal;
        }

        @Override
        public RoleKey id() {
            return new RoleKey(Set.of(this.principal), "service_account");
        }

        @Override
        public void resolve(RoleReferenceResolver resolver, ActionListener<RolesRetrievalResult> listener) {
            resolver.resolveServiceAccountRoleReference(this, listener);
        }
    }

    public static final class BwcApiKeyRoleReference
    implements RoleReference {
        private final String apiKeyId;
        private final Map<String, Object> roleDescriptorsMap;
        private final ApiKeyRoleType roleType;

        public BwcApiKeyRoleReference(String apiKeyId, Map<String, Object> roleDescriptorsMap, ApiKeyRoleType roleType) {
            this.apiKeyId = apiKeyId;
            this.roleDescriptorsMap = roleDescriptorsMap;
            this.roleType = roleType;
        }

        @Override
        public RoleKey id() {
            return new RoleKey(Set.of(this.apiKeyId), "bwc_api_key_" + this.roleType);
        }

        @Override
        public void resolve(RoleReferenceResolver resolver, ActionListener<RolesRetrievalResult> listener) {
            resolver.resolveBwcApiKeyRoleReference(this, listener);
        }

        public String getApiKeyId() {
            return this.apiKeyId;
        }

        public Map<String, Object> getRoleDescriptorsMap() {
            return this.roleDescriptorsMap;
        }

        public ApiKeyRoleType getRoleType() {
            return this.roleType;
        }
    }

    public static final class FixedRoleReference
    implements RoleReference {
        private final RoleDescriptor roleDescriptor;
        private final String source;

        public FixedRoleReference(RoleDescriptor roleDescriptor, String source) {
            this.roleDescriptor = roleDescriptor;
            this.source = source;
        }

        @Override
        public RoleKey id() {
            return new RoleKey(Set.of(this.roleDescriptor.getName()), this.source);
        }

        @Override
        public void resolve(RoleReferenceResolver resolver, ActionListener<RolesRetrievalResult> listener) {
            RolesRetrievalResult rolesRetrievalResult = new RolesRetrievalResult();
            rolesRetrievalResult.addDescriptors(Set.of(this.roleDescriptor));
            listener.onResponse(rolesRetrievalResult);
        }
    }

    public static final class CrossClusterAccessRoleReference
    implements RoleReference {
        private final CrossClusterAccessSubjectInfo.RoleDescriptorsBytes roleDescriptorsBytes;
        private RoleKey id = null;
        private final String userPrincipal;

        public CrossClusterAccessRoleReference(String userPrincipal, CrossClusterAccessSubjectInfo.RoleDescriptorsBytes roleDescriptorsBytes) {
            this.userPrincipal = userPrincipal;
            this.roleDescriptorsBytes = roleDescriptorsBytes;
        }

        @Override
        public RoleKey id() {
            if (this.id == null) {
                String roleDescriptorsHash = this.roleDescriptorsBytes.digest();
                this.id = new RoleKey(Set.of("cross_cluster_access:" + roleDescriptorsHash), "cross_cluster_access");
            }
            return this.id;
        }

        @Override
        public void resolve(RoleReferenceResolver resolver, ActionListener<RolesRetrievalResult> listener) {
            resolver.resolveCrossClusterAccessRoleReference(this, listener);
        }

        public String getUserPrincipal() {
            return this.userPrincipal;
        }

        public CrossClusterAccessSubjectInfo.RoleDescriptorsBytes getRoleDescriptorsBytes() {
            return this.roleDescriptorsBytes;
        }
    }

    public static final class ApiKeyRoleReference
    implements RoleReference {
        private final String apiKeyId;
        private final BytesReference roleDescriptorsBytes;
        private final ApiKeyRoleType roleType;
        private RoleKey id = null;
        private final boolean checkForInvalidLegacyRoleDescriptorsForCrossClusterAccess;

        public ApiKeyRoleReference(String apiKeyId, BytesReference roleDescriptorsBytes, ApiKeyRoleType roleType) {
            this(apiKeyId, roleDescriptorsBytes, roleType, false);
        }

        public ApiKeyRoleReference(String apiKeyId, BytesReference roleDescriptorsBytes, ApiKeyRoleType roleType, boolean checkForInvalidLegacyRoleDescriptorsForCrossClusterAccess) {
            this.apiKeyId = apiKeyId;
            this.roleDescriptorsBytes = roleDescriptorsBytes;
            this.roleType = roleType;
            this.checkForInvalidLegacyRoleDescriptorsForCrossClusterAccess = checkForInvalidLegacyRoleDescriptorsForCrossClusterAccess;
        }

        @Override
        public RoleKey id() {
            if (this.id == null) {
                String roleDescriptorsHash = MessageDigests.toHexString(MessageDigests.digest(this.roleDescriptorsBytes, MessageDigests.sha256()));
                this.id = new RoleKey(Set.of("apikey:" + roleDescriptorsHash), "apikey_" + this.roleType);
            }
            return this.id;
        }

        @Override
        public void resolve(RoleReferenceResolver resolver, ActionListener<RolesRetrievalResult> listener) {
            resolver.resolveApiKeyRoleReference(this, listener);
        }

        public String getApiKeyId() {
            return this.apiKeyId;
        }

        public BytesReference getRoleDescriptorsBytes() {
            return this.roleDescriptorsBytes;
        }

        public ApiKeyRoleType getRoleType() {
            return this.roleType;
        }

        public boolean checkForInvalidLegacyRoleDescriptorsForCrossClusterAccess() {
            return this.checkForInvalidLegacyRoleDescriptorsForCrossClusterAccess;
        }
    }

    public static final class NamedRoleReference
    implements RoleReference {
        private final String[] roleNames;

        public NamedRoleReference(String[] roleNames) {
            this.roleNames = roleNames;
        }

        public String[] getRoleNames() {
            return this.roleNames;
        }

        @Override
        public RoleKey id() {
            if (this.roleNames.length == 0) {
                return RoleKey.ROLE_KEY_EMPTY;
            }
            HashSet<String> distinctRoles = new HashSet<String>(List.of(this.roleNames));
            if (distinctRoles.size() == 1 && distinctRoles.contains(ReservedRolesStore.SUPERUSER_ROLE_DESCRIPTOR.getName())) {
                return RoleKey.ROLE_KEY_SUPERUSER;
            }
            return new RoleKey(Set.copyOf(distinctRoles), "roles_stores");
        }

        @Override
        public void resolve(RoleReferenceResolver resolver, ActionListener<RolesRetrievalResult> listener) {
            resolver.resolveNamedRoleReference(this, listener);
        }
    }
}

