/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class ResourcePrivileges {
    private final String resource;
    private final Map<String, Boolean> privileges;

    ResourcePrivileges(String resource, Map<String, Boolean> privileges) {
        this.resource = Objects.requireNonNull(resource);
        this.privileges = Collections.unmodifiableMap(privileges);
    }

    public String getResource() {
        return this.resource;
    }

    public Map<String, Boolean> getPrivileges() {
        return this.privileges;
    }

    public boolean isAllowed(String privilege) {
        return Boolean.TRUE.equals(this.privileges.get(privilege));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{resource='" + this.resource + "', privileges=" + this.privileges + "}";
    }

    public int hashCode() {
        int result = this.resource.hashCode();
        result = 31 * result + this.privileges.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePrivileges other = (ResourcePrivileges)o;
        return this.resource.equals(other.resource) && this.privileges.equals(other.privileges);
    }

    public static Builder builder(String resource) {
        return new Builder(resource);
    }

    public static final class Builder {
        private final String resource;
        private Map<String, Boolean> privileges = new TreeMap<String, Boolean>();

        private Builder(String resource) {
            this.resource = resource;
        }

        public Builder addPrivilege(String privilege, Boolean allowed) {
            this.privileges.compute(privilege, (k, v) -> v == null ? allowed : v != false && allowed != false);
            return this;
        }

        public Builder addPrivileges(Map<String, Boolean> privilegeMap) {
            for (Map.Entry<String, Boolean> entry : privilegeMap.entrySet()) {
                this.addPrivilege(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public ResourcePrivileges build() {
            return new ResourcePrivileges(this.resource, this.privileges);
        }
    }
}

