/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.profile;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.profile.Profile;
import org.elasticsearch.xpack.core.security.xcontent.XContentUtils;

public class GetProfilesResponse
extends ActionResponse
implements ToXContentObject {
    private final List<Profile> profiles;
    private final Map<String, Exception> errors;

    public GetProfilesResponse(List<Profile> profiles, Map<String, Exception> errors) {
        this.profiles = Objects.requireNonNull(profiles);
        this.errors = Objects.requireNonNull(errors);
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public Map<String, Exception> getErrors() {
        return this.errors;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.profiles);
        out.writeMap(this.errors, StreamOutput::writeException);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("profiles");
        for (Profile profile : this.profiles) {
            profile.toXContent(builder, params);
        }
        builder.endArray();
        XContentUtils.maybeAddErrorDetails(builder, this.errors);
        builder.endObject();
        return builder;
    }
}

