/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.NlpInferenceResults;

public class TextSimilarityInferenceResults
extends NlpInferenceResults {
    public static final String NAME = "text_similarity";
    private final String resultsField;
    private final double score;

    public TextSimilarityInferenceResults(String resultsField, double score, boolean isTruncated) {
        super(isTruncated);
        this.resultsField = resultsField;
        this.score = score;
    }

    public TextSimilarityInferenceResults(StreamInput in) throws IOException {
        super(in);
        this.resultsField = in.readString();
        this.score = in.readDouble();
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.resultsField);
        out.writeDouble(this.score);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TextSimilarityInferenceResults that = (TextSimilarityInferenceResults)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.score, that.score);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultsField, this.score);
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public Double predictedValue() {
        return this.score;
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        map.put(this.resultsField, this.score);
    }

    @Override
    public Map<String, Object> asMap(String outputField) {
        Map<String, Object> map = super.asMap(outputField);
        map.put(outputField, this.score);
        return map;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.resultsField, this.score);
    }
}

