/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.preprocessing.customwordembedding;

public enum ScriptCode {
    Common(0),
    Latin(1),
    Greek(2),
    Cyrillic(3),
    Armenian(4),
    Hebrew(5),
    Arabic(6),
    Syriac(7),
    Thaana(8),
    Devanagari(9),
    Bengali(10),
    Gurmukhi(11),
    Gujarati(12),
    Oriya(13),
    Tamil(14),
    Telugu(15),
    Kannada(16),
    Malayalam(17),
    Sinhala(18),
    Thai(19),
    Lao(20),
    Tibetan(21),
    Myanmar(22),
    Georgian(23),
    Hani(24),
    Ethiopic(25),
    Cherokee(26),
    Canadian_Aboriginal(27),
    Ogham(28),
    Runic(29),
    Khmer(30),
    Mongolian(31),
    Undefined_32(32),
    Undefined_33(33),
    Bopomofo(34),
    Undefined_35(35),
    Yi(36),
    Old_Italic(37),
    Gothic(38),
    Deseret(39),
    Inherited(40),
    Tagalog(41),
    Hanunoo(42),
    Buhid(43),
    Tagbanwa(44),
    Limbu(45),
    Tai_Le(46),
    Linear_B(47),
    Ugaritic(48),
    Shavian(49),
    Osmanya(50),
    Cypriot(51),
    Braille(52),
    Buginese(53),
    Coptic(54),
    New_Tai_Lue(55),
    Glagolitic(56),
    Tifinagh(57),
    Syloti_Nagri(58),
    Old_Persian(59),
    Kharoshthi(60),
    Balinese(61),
    Cuneiform(62),
    Phoenician(63),
    Phags_Pa(64),
    Nko(65),
    Sundanese(66),
    Lepcha(67),
    Ol_Chiki(68),
    Vai(69),
    Saurashtra(70),
    Kayah_Li(71),
    Rejang(72),
    Lycian(73),
    Carian(74),
    Lydian(75),
    Cham(76),
    Tai_Tham(77),
    Tai_Viet(78),
    Avestan(79),
    Egyptian_Hieroglyphs(80),
    Samaritan(81),
    Lisu(82),
    Bamum(83),
    Javanese(84),
    Meetei_Mayek(85),
    Imperial_Aramaic(86),
    Old_South_Arabian(87),
    Inscriptional_Parthian(88),
    Inscriptional_Pahlavi(89),
    Old_Turkic(90),
    Kaithi(91),
    Batak(92),
    Brahmi(93),
    Mandaic(94),
    Chakma(95),
    Meroitic_Cursive(96),
    Meroitic_Hieroglyphs(97),
    Miao(98),
    Sharada(99),
    Sora_Sompeng(100),
    Takri(101),
    MAX_SCRIPT_CODE(102);

    private final int code;

    private ScriptCode(int code) {
        this.code = code;
    }

    public static ScriptCode unicodeScriptToULScript(Character.UnicodeScript scriptId) {
        switch (scriptId) {
            case COMMON: {
                return Common;
            }
            case LATIN: {
                return Latin;
            }
            case GREEK: {
                return Greek;
            }
            case CYRILLIC: {
                return Cyrillic;
            }
            case ARMENIAN: {
                return Armenian;
            }
            case HEBREW: {
                return Hebrew;
            }
            case ARABIC: {
                return Arabic;
            }
            case SYRIAC: {
                return Syriac;
            }
            case THAANA: {
                return Thaana;
            }
            case DEVANAGARI: {
                return Devanagari;
            }
            case BENGALI: {
                return Bengali;
            }
            case GURMUKHI: {
                return Gurmukhi;
            }
            case GUJARATI: {
                return Gujarati;
            }
            case ORIYA: {
                return Oriya;
            }
            case TAMIL: {
                return Tamil;
            }
            case TELUGU: {
                return Telugu;
            }
            case KANNADA: {
                return Kannada;
            }
            case MALAYALAM: {
                return Malayalam;
            }
            case SINHALA: {
                return Sinhala;
            }
            case THAI: {
                return Thai;
            }
            case LAO: {
                return Lao;
            }
            case TIBETAN: {
                return Tibetan;
            }
            case MYANMAR: {
                return Myanmar;
            }
            case GEORGIAN: {
                return Georgian;
            }
            case HANGUL: 
            case HAN: 
            case HIRAGANA: 
            case KATAKANA: {
                return Hani;
            }
            case ETHIOPIC: {
                return Ethiopic;
            }
            case CHEROKEE: {
                return Cherokee;
            }
            case CANADIAN_ABORIGINAL: {
                return Canadian_Aboriginal;
            }
            case OGHAM: {
                return Ogham;
            }
            case RUNIC: {
                return Runic;
            }
            case KHMER: {
                return Khmer;
            }
            case MONGOLIAN: {
                return Mongolian;
            }
            case BOPOMOFO: {
                return Bopomofo;
            }
            case YI: {
                return Yi;
            }
            case OLD_ITALIC: {
                return Old_Italic;
            }
            case GOTHIC: {
                return Gothic;
            }
            case DESERET: {
                return Deseret;
            }
            case INHERITED: {
                return Inherited;
            }
            case TAGALOG: {
                return Tagalog;
            }
            case HANUNOO: {
                return Hanunoo;
            }
            case BUHID: {
                return Buhid;
            }
            case TAGBANWA: {
                return Tagbanwa;
            }
            case LIMBU: {
                return Limbu;
            }
            case TAI_LE: {
                return Tai_Le;
            }
            case LINEAR_B: {
                return Linear_B;
            }
            case UGARITIC: {
                return Ugaritic;
            }
            case SHAVIAN: {
                return Shavian;
            }
            case OSMANYA: {
                return Osmanya;
            }
            case CYPRIOT: {
                return Cypriot;
            }
            case BRAILLE: {
                return Braille;
            }
            case BUGINESE: {
                return Buginese;
            }
            case COPTIC: {
                return Coptic;
            }
            case NEW_TAI_LUE: {
                return New_Tai_Lue;
            }
            case GLAGOLITIC: {
                return Glagolitic;
            }
            case TIFINAGH: {
                return Tifinagh;
            }
            case SYLOTI_NAGRI: {
                return Syloti_Nagri;
            }
            case OLD_PERSIAN: {
                return Old_Persian;
            }
            case KHAROSHTHI: {
                return Kharoshthi;
            }
            case BALINESE: {
                return Balinese;
            }
            case CUNEIFORM: {
                return Cuneiform;
            }
            case PHOENICIAN: {
                return Phoenician;
            }
            case PHAGS_PA: {
                return Phags_Pa;
            }
            case NKO: {
                return Nko;
            }
            case SUNDANESE: {
                return Sundanese;
            }
            case LEPCHA: {
                return Lepcha;
            }
            case OL_CHIKI: {
                return Ol_Chiki;
            }
            case VAI: {
                return Vai;
            }
            case SAURASHTRA: {
                return Saurashtra;
            }
            case KAYAH_LI: {
                return Kayah_Li;
            }
            case REJANG: {
                return Rejang;
            }
            case LYCIAN: {
                return Lycian;
            }
            case CARIAN: {
                return Carian;
            }
            case LYDIAN: {
                return Lydian;
            }
            case CHAM: {
                return Cham;
            }
            case TAI_THAM: {
                return Tai_Tham;
            }
            case TAI_VIET: {
                return Tai_Viet;
            }
            case AVESTAN: {
                return Avestan;
            }
            case EGYPTIAN_HIEROGLYPHS: {
                return Egyptian_Hieroglyphs;
            }
            case SAMARITAN: {
                return Samaritan;
            }
            case LISU: {
                return Lisu;
            }
            case BAMUM: {
                return Bamum;
            }
            case JAVANESE: {
                return Javanese;
            }
            case MEETEI_MAYEK: {
                return Meetei_Mayek;
            }
            case IMPERIAL_ARAMAIC: {
                return Imperial_Aramaic;
            }
            case OLD_SOUTH_ARABIAN: {
                return Old_South_Arabian;
            }
            case INSCRIPTIONAL_PARTHIAN: {
                return Inscriptional_Parthian;
            }
            case INSCRIPTIONAL_PAHLAVI: {
                return Inscriptional_Pahlavi;
            }
            case OLD_TURKIC: {
                return Old_Turkic;
            }
            case KAITHI: {
                return Kaithi;
            }
            case BATAK: {
                return Batak;
            }
            case BRAHMI: {
                return Brahmi;
            }
            case MANDAIC: {
                return Mandaic;
            }
            case MEROITIC_CURSIVE: {
                return Meroitic_Cursive;
            }
            case MEROITIC_HIEROGLYPHS: {
                return Meroitic_Hieroglyphs;
            }
            case CHAKMA: {
                return Chakma;
            }
            case SHARADA: {
                return Sharada;
            }
            case SORA_SOMPENG: {
                return Sora_Sompeng;
            }
            case MIAO: {
                return Miao;
            }
            case TAKRI: {
                return Takri;
            }
        }
        return Common;
    }

    public int toInt() {
        return this.code;
    }
}

