/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;

public class PutJobAction
extends ActionType<Response> {
    public static final PutJobAction INSTANCE = new PutJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/put";

    private PutJobAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final Job job;

        public Response(Job job) {
            this.job = job;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.job = new Job(in);
        }

        public Job getResponse() {
            return this.job;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.job.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.job.doXContentBody(builder, params);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.job, response.job);
        }

        public int hashCode() {
            return Objects.hash(this.job);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private Job.Builder jobBuilder;

        public static Request parseRequest(String jobId, XContentParser parser, IndicesOptions indicesOptions) {
            Job.Builder jobBuilder = Job.REST_REQUEST_PARSER.apply(parser, null);
            if (jobBuilder.getId() == null) {
                jobBuilder.setId(jobId);
            } else if (!Strings.isNullOrEmpty(jobId) && !jobId.equals(jobBuilder.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", Job.ID.getPreferredName(), jobBuilder.getId(), jobId));
            }
            jobBuilder.setDatafeedIndicesOptionsIfRequired(indicesOptions);
            return new Request(jobBuilder);
        }

        public Request(Job.Builder jobBuilder) {
            jobBuilder.validateInputFields();
            jobBuilder.validateDetectorsAreUnique();
            this.jobBuilder = jobBuilder;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.jobBuilder = new Job.Builder(in);
        }

        public Job.Builder getJobBuilder() {
            return this.jobBuilder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.jobBuilder.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.jobBuilder, request.jobBuilder);
        }

        public int hashCode() {
            return Objects.hash(this.jobBuilder);
        }
    }
}

