/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.PersistentTasksClusterService;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsTaskState;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelConfig;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeState;
import org.elasticsearch.xpack.core.ml.job.snapshot.upgrade.SnapshotUpgradeTaskState;
import org.elasticsearch.xpack.core.ml.utils.MemoryTrackedTaskState;

public final class MlTasks {
    public static final String MODEL_IMPORT_TASK_TYPE = "model_import";
    public static final String MODEL_IMPORT_TASK_ACTION = "xpack/ml/model_import[n]";
    public static final String TRAINED_MODEL_ASSIGNMENT_TASK_TYPE = "trained_model_assignment";
    public static final String TRAINED_MODEL_ASSIGNMENT_TASK_ACTION = "xpack/ml/trained_model_assignment[n]";
    public static final String JOB_TASK_NAME = "xpack/ml/job";
    public static final String DATAFEED_TASK_NAME = "xpack/ml/datafeed";
    public static final String DATA_FRAME_ANALYTICS_TASK_NAME = "xpack/ml/data_frame/analytics";
    public static final String JOB_SNAPSHOT_UPGRADE_TASK_NAME = "xpack/ml/job/snapshot/upgrade";
    public static final Set<String> ML_PROCESS_TASKS = Set.of("xpack/ml/job", "xpack/ml/data_frame/analytics", "xpack/ml/job/snapshot/upgrade");
    public static final String JOB_TASK_ID_PREFIX = "job-";
    public static final String DATAFEED_TASK_ID_PREFIX = "datafeed-";
    public static final String DATA_FRAME_ANALYTICS_TASK_ID_PREFIX = "data_frame_analytics-";
    public static final String JOB_SNAPSHOT_UPGRADE_TASK_ID_PREFIX = "job-snapshot-upgrade-";
    private static final String DOWNLOAD_MODEL_TASK_DESCRIPTION_PREFIX = "model_id-";
    public static final PersistentTasksCustomMetadata.Assignment AWAITING_UPGRADE = new PersistentTasksCustomMetadata.Assignment(null, "persistent task cannot be assigned while upgrade mode is enabled.");
    public static final PersistentTasksCustomMetadata.Assignment RESET_IN_PROGRESS = new PersistentTasksCustomMetadata.Assignment(null, "persistent task will not be assigned as a feature reset is in progress.");
    public static final TimeValue PERSISTENT_TASK_MASTER_NODE_TIMEOUT = TimeValue.timeValueDays(365L);

    private MlTasks() {
    }

    public static String jobTaskId(String jobId) {
        return JOB_TASK_ID_PREFIX + jobId;
    }

    public static String jobId(String jobTaskId) {
        return jobTaskId.substring(JOB_TASK_ID_PREFIX.length());
    }

    public static String datafeedTaskId(String datafeedId) {
        return DATAFEED_TASK_ID_PREFIX + datafeedId;
    }

    public static String snapshotUpgradeTaskId(String jobId, String snapshotId) {
        return JOB_SNAPSHOT_UPGRADE_TASK_ID_PREFIX + jobId + "-" + snapshotId;
    }

    public static String dataFrameAnalyticsTaskId(String id) {
        return DATA_FRAME_ANALYTICS_TASK_ID_PREFIX + id;
    }

    public static String dataFrameAnalyticsId(String taskId) {
        return taskId.substring(DATA_FRAME_ANALYTICS_TASK_ID_PREFIX.length());
    }

    public static String trainedModelAssignmentTaskDescription(String deploymentId) {
        return TrainedModelConfig.MODEL_ID.getPreferredName() + "[" + deploymentId + "]";
    }

    @Nullable
    public static PersistentTasksCustomMetadata.PersistentTask<?> getJobTask(String jobId, @Nullable PersistentTasksCustomMetadata tasks) {
        return tasks == null ? null : tasks.getTask(MlTasks.jobTaskId(jobId));
    }

    @Nullable
    public static PersistentTasksCustomMetadata.PersistentTask<?> getDatafeedTask(String datafeedId, @Nullable PersistentTasksCustomMetadata tasks) {
        return tasks == null ? null : tasks.getTask(MlTasks.datafeedTaskId(datafeedId));
    }

    @Nullable
    public static PersistentTasksCustomMetadata.PersistentTask<?> getDataFrameAnalyticsTask(String analyticsId, @Nullable PersistentTasksCustomMetadata tasks) {
        return tasks == null ? null : tasks.getTask(MlTasks.dataFrameAnalyticsTaskId(analyticsId));
    }

    @Nullable
    public static PersistentTasksCustomMetadata.PersistentTask<?> getSnapshotUpgraderTask(String jobId, String snapshotId, @Nullable PersistentTasksCustomMetadata tasks) {
        return tasks == null ? null : tasks.getTask(MlTasks.snapshotUpgradeTaskId(jobId, snapshotId));
    }

    public static JobState getJobState(String jobId, @Nullable PersistentTasksCustomMetadata tasks) {
        PersistentTasksCustomMetadata.PersistentTask<?> task = MlTasks.getJobTask(jobId, tasks);
        if (task != null) {
            JobTaskState jobTaskState = (JobTaskState)task.getState();
            if (jobTaskState == null) {
                return JobState.OPENING;
            }
            return jobTaskState.getState();
        }
        return JobState.CLOSED;
    }

    public static JobState getJobStateModifiedForReassignments(String jobId, @Nullable PersistentTasksCustomMetadata tasks) {
        return MlTasks.getJobStateModifiedForReassignments(MlTasks.getJobTask(jobId, tasks));
    }

    public static JobState getJobStateModifiedForReassignments(@Nullable PersistentTasksCustomMetadata.PersistentTask<?> task) {
        if (task == null) {
            return JobState.CLOSED;
        }
        JobTaskState jobTaskState = (JobTaskState)task.getState();
        if (jobTaskState == null) {
            return JobState.OPENING;
        }
        JobState jobState = jobTaskState.getState();
        if (jobTaskState.isStatusStale(task)) {
            if (jobState == JobState.CLOSING) {
                return JobState.CLOSED;
            }
            if (jobState != JobState.FAILED) {
                return JobState.OPENING;
            }
        }
        return jobState;
    }

    public static Instant getLastJobTaskStateChangeTime(String jobId, @Nullable PersistentTasksCustomMetadata tasks) {
        JobTaskState jobTaskState;
        PersistentTasksCustomMetadata.PersistentTask<?> task = MlTasks.getJobTask(jobId, tasks);
        if (task != null && (jobTaskState = (JobTaskState)task.getState()) != null) {
            return jobTaskState.getLastStateChangeTime();
        }
        return null;
    }

    public static SnapshotUpgradeState getSnapshotUpgradeState(String jobId, String snapshotId, @Nullable PersistentTasksCustomMetadata tasks) {
        return MlTasks.getSnapshotUpgradeState(MlTasks.getSnapshotUpgraderTask(jobId, snapshotId, tasks));
    }

    public static SnapshotUpgradeState getSnapshotUpgradeState(@Nullable PersistentTasksCustomMetadata.PersistentTask<?> task) {
        if (task == null) {
            return SnapshotUpgradeState.STOPPED;
        }
        SnapshotUpgradeTaskState taskState = (SnapshotUpgradeTaskState)task.getState();
        if (taskState == null) {
            return SnapshotUpgradeState.LOADING_OLD_STATE;
        }
        return taskState.getState();
    }

    public static DatafeedState getDatafeedState(String datafeedId, @Nullable PersistentTasksCustomMetadata tasks) {
        PersistentTasksCustomMetadata.PersistentTask<?> task = MlTasks.getDatafeedTask(datafeedId, tasks);
        return MlTasks.getDatafeedState(task);
    }

    public static DatafeedState getDatafeedState(PersistentTasksCustomMetadata.PersistentTask<?> task) {
        if (task == null) {
            return DatafeedState.STOPPED;
        }
        DatafeedState taskState = (DatafeedState)task.getState();
        if (taskState == null) {
            return DatafeedState.STARTING;
        }
        return taskState;
    }

    public static DataFrameAnalyticsState getDataFrameAnalyticsState(String analyticsId, @Nullable PersistentTasksCustomMetadata tasks) {
        PersistentTasksCustomMetadata.PersistentTask<?> task = MlTasks.getDataFrameAnalyticsTask(analyticsId, tasks);
        return MlTasks.getDataFrameAnalyticsState(task);
    }

    public static DataFrameAnalyticsState getDataFrameAnalyticsState(@Nullable PersistentTasksCustomMetadata.PersistentTask<?> task) {
        if (task == null) {
            return DataFrameAnalyticsState.STOPPED;
        }
        DataFrameAnalyticsTaskState taskState = (DataFrameAnalyticsTaskState)task.getState();
        if (taskState == null) {
            return DataFrameAnalyticsState.STARTING;
        }
        DataFrameAnalyticsState state = taskState.getState();
        if (taskState.isStatusStale(task)) {
            if (state == DataFrameAnalyticsState.STOPPING) {
                return DataFrameAnalyticsState.STOPPED;
            }
            if (state != DataFrameAnalyticsState.FAILED) {
                return DataFrameAnalyticsState.STARTING;
            }
        }
        return state;
    }

    public static Instant getLastDataFrameAnalyticsTaskStateChangeTime(String analyticsId, @Nullable PersistentTasksCustomMetadata tasks) {
        DataFrameAnalyticsTaskState taskState;
        PersistentTasksCustomMetadata.PersistentTask<?> task = MlTasks.getDataFrameAnalyticsTask(analyticsId, tasks);
        if (task != null && (taskState = (DataFrameAnalyticsTaskState)task.getState()) != null) {
            return taskState.getLastStateChangeTime();
        }
        return null;
    }

    public static Set<String> openJobIds(@Nullable PersistentTasksCustomMetadata tasks) {
        if (tasks == null) {
            return Collections.emptySet();
        }
        return MlTasks.openJobTasks(tasks).stream().map(t -> t.getId().substring(JOB_TASK_ID_PREFIX.length())).collect(Collectors.toSet());
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> openJobTasks(@Nullable PersistentTasksCustomMetadata tasks) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(JOB_TASK_NAME, Predicates.always());
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> datafeedTasksOnNode(@Nullable PersistentTasksCustomMetadata tasks, String nodeId) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(DATAFEED_TASK_NAME, task -> nodeId.equals(task.getExecutorNode()));
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> jobTasksOnNode(@Nullable PersistentTasksCustomMetadata tasks, String nodeId) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(JOB_TASK_NAME, task -> nodeId.equals(task.getExecutorNode()));
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> nonFailedJobTasksOnNode(@Nullable PersistentTasksCustomMetadata tasks, String nodeId) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(JOB_TASK_NAME, task -> {
            if (!nodeId.equals(task.getExecutorNode())) {
                return false;
            }
            JobTaskState state = (JobTaskState)task.getState();
            if (state == null) {
                return true;
            }
            return state.getState() != JobState.FAILED;
        });
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> snapshotUpgradeTasks(@Nullable PersistentTasksCustomMetadata tasks) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(JOB_SNAPSHOT_UPGRADE_TASK_NAME, Predicates.always());
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> snapshotUpgradeTasksOnNode(@Nullable PersistentTasksCustomMetadata tasks, String nodeId) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(JOB_SNAPSHOT_UPGRADE_TASK_NAME, task -> nodeId.equals(task.getExecutorNode()));
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> nonFailedSnapshotUpgradeTasksOnNode(@Nullable PersistentTasksCustomMetadata tasks, String nodeId) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(JOB_SNAPSHOT_UPGRADE_TASK_NAME, task -> {
            if (!nodeId.equals(task.getExecutorNode())) {
                return false;
            }
            SnapshotUpgradeTaskState taskState = (SnapshotUpgradeTaskState)task.getState();
            if (taskState == null) {
                return true;
            }
            SnapshotUpgradeState state = taskState.getState();
            return state != SnapshotUpgradeState.FAILED;
        });
    }

    public static Set<String> unassignedJobIds(@Nullable PersistentTasksCustomMetadata tasks, DiscoveryNodes nodes) {
        return MlTasks.unassignedJobTasks(tasks, nodes).stream().map(task -> task.getId().substring(JOB_TASK_ID_PREFIX.length())).collect(Collectors.toSet());
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> unassignedJobTasks(@Nullable PersistentTasksCustomMetadata tasks, DiscoveryNodes nodes) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(JOB_TASK_NAME, task -> PersistentTasksClusterService.needsReassignment(task.getAssignment(), nodes));
    }

    public static Set<String> startedDatafeedIds(@Nullable PersistentTasksCustomMetadata tasks) {
        if (tasks == null) {
            return Collections.emptySet();
        }
        return tasks.findTasks(DATAFEED_TASK_NAME, Predicates.always()).stream().map(t -> t.getId().substring(DATAFEED_TASK_ID_PREFIX.length())).collect(Collectors.toSet());
    }

    public static Set<String> unassignedDatafeedIds(@Nullable PersistentTasksCustomMetadata tasks, DiscoveryNodes nodes) {
        return MlTasks.unassignedDatafeedTasks(tasks, nodes).stream().map(task -> task.getId().substring(DATAFEED_TASK_ID_PREFIX.length())).collect(Collectors.toSet());
    }

    public static Collection<PersistentTasksCustomMetadata.PersistentTask<?>> unassignedDatafeedTasks(@Nullable PersistentTasksCustomMetadata tasks, DiscoveryNodes nodes) {
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks.findTasks(DATAFEED_TASK_NAME, task -> PersistentTasksClusterService.needsReassignment(task.getAssignment(), nodes));
    }

    public static MemoryTrackedTaskState getMemoryTrackedTaskState(PersistentTasksCustomMetadata.PersistentTask<?> task) {
        String taskName;
        return switch (taskName = task.getTaskName()) {
            case JOB_TASK_NAME -> MlTasks.getJobStateModifiedForReassignments(task);
            case JOB_SNAPSHOT_UPGRADE_TASK_NAME -> MlTasks.getSnapshotUpgradeState(task);
            case DATA_FRAME_ANALYTICS_TASK_NAME -> MlTasks.getDataFrameAnalyticsState(task);
            default -> throw new IllegalStateException("unexpected task type [" + task.getTaskName() + "]");
        };
    }

    public static Set<PersistentTasksCustomMetadata.PersistentTask<?>> findMlProcessTasks(@Nullable PersistentTasksCustomMetadata tasks) {
        if (tasks == null) {
            return Set.of();
        }
        return tasks.tasks().stream().filter(p -> ML_PROCESS_TASKS.contains(p.getTaskName())).collect(Collectors.toSet());
    }

    public static String prettyPrintTaskName(String taskName) {
        return switch (taskName) {
            case JOB_TASK_NAME -> "anomaly detection";
            case JOB_SNAPSHOT_UPGRADE_TASK_NAME -> "snapshot upgrade (anomaly detection)";
            case DATA_FRAME_ANALYTICS_TASK_NAME -> "data frame analytics";
            case DATAFEED_TASK_NAME -> "datafeed";
            default -> throw new IllegalArgumentException("unexpected task type [" + taskName + "]");
        };
    }

    public static String downloadModelTaskDescription(String modelId) {
        return DOWNLOAD_MODEL_TASK_DESCRIPTION_PREFIX + modelId;
    }
}

