/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.EmbeddingInt;
import org.elasticsearch.xpack.core.inference.results.LegacyTextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbedding;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;

public record TextEmbeddingResults(List<Embedding> embeddings) implements InferenceServiceResults,
TextEmbedding
{
    public static final String NAME = "text_embedding_service_results";
    public static final String TEXT_EMBEDDING = TaskType.TEXT_EMBEDDING.toString();

    public TextEmbeddingResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(Embedding::new));
    }

    TextEmbeddingResults(LegacyTextEmbeddingResults legacyTextEmbeddingResults) {
        this(legacyTextEmbeddingResults.embeddings().stream().map(embedding -> new Embedding(embedding.values())).collect(Collectors.toList()));
    }

    public static TextEmbeddingResults of(List<? extends InferenceResults> results) {
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>(results.size());
        for (InferenceResults inferenceResults : results) {
            if (inferenceResults instanceof org.elasticsearch.xpack.core.ml.inference.results.TextEmbeddingResults) {
                org.elasticsearch.xpack.core.ml.inference.results.TextEmbeddingResults embeddingResult = (org.elasticsearch.xpack.core.ml.inference.results.TextEmbeddingResults)inferenceResults;
                embeddings.add(Embedding.of(embeddingResult));
                continue;
            }
            if (inferenceResults instanceof ErrorInferenceResults) {
                ErrorInferenceResults errorResult = (ErrorInferenceResults)inferenceResults;
                Exception exception = errorResult.getException();
                if (exception instanceof ElasticsearchStatusException) {
                    ElasticsearchStatusException statusException = (ElasticsearchStatusException)exception;
                    throw statusException;
                }
                throw new ElasticsearchStatusException("Received error inference result.", RestStatus.INTERNAL_SERVER_ERROR, errorResult.getException(), new Object[0]);
            }
            throw new IllegalArgumentException("Received invalid inference result, of type " + inferenceResults.getClass().getName() + " but expected TextEmbeddingResults.");
        }
        return new TextEmbeddingResults(embeddings);
    }

    @Override
    public int getFirstEmbeddingSize() {
        return TextEmbeddingUtils.getFirstEmbeddingSize(new ArrayList<EmbeddingInt>(this.embeddings));
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TEXT_EMBEDDING);
        for (Embedding embedding : this.embeddings) {
            embedding.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.embeddings.stream().map(embedding -> embedding.values.stream().mapToDouble(value -> value.floatValue()).toArray()).map(values -> new org.elasticsearch.xpack.core.ml.inference.results.TextEmbeddingResults(TEXT_EMBEDDING, (double[])values, false)).toList();
    }

    @Override
    public List<? extends InferenceResults> transformToLegacyFormat() {
        LegacyTextEmbeddingResults legacyEmbedding = new LegacyTextEmbeddingResults(this.embeddings.stream().map(embedding -> new LegacyTextEmbeddingResults.Embedding(embedding.values)).toList());
        return List.of(legacyEmbedding);
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TEXT_EMBEDDING, this.embeddings.stream().map(Embedding::asMap).collect(Collectors.toList()));
        return map;
    }

    public record Embedding(List<Float> values) implements Writeable,
    ToXContentObject,
    EmbeddingInt
    {
        public static final String EMBEDDING = "embedding";

        public Embedding(StreamInput in) throws IOException {
            this(in.readCollectionAsImmutableList(StreamInput::readFloat));
        }

        public static Embedding of(org.elasticsearch.xpack.core.ml.inference.results.TextEmbeddingResults embeddingResult) {
            float[] embeddingAsArray;
            ArrayList<Float> embeddingAsList = new ArrayList<Float>();
            for (float dim : embeddingAsArray = embeddingResult.getInferenceAsFloat()) {
                embeddingAsList.add(Float.valueOf(dim));
            }
            return new Embedding(embeddingAsList);
        }

        @Override
        public int getSize() {
            return this.values.size();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.values, StreamOutput::writeFloat);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(EMBEDDING);
            for (Float value : this.values) {
                builder.value(value);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        public Map<String, Object> asMap() {
            return Map.of(EMBEDDING, this.values);
        }
    }
}

