/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.inference.TaskType;

public class DeleteInferenceModelAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteInferenceModelAction INSTANCE = new DeleteInferenceModelAction();
    public static final String NAME = "cluster:admin/xpack/inference/delete";

    public DeleteInferenceModelAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String inferenceEntityId;
        private final TaskType taskType;

        public Request(String inferenceEntityId, TaskType taskType) {
            this.inferenceEntityId = inferenceEntityId;
            this.taskType = taskType;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.inferenceEntityId = in.readString();
            this.taskType = TaskType.fromStream(in);
        }

        public String getInferenceEntityId() {
            return this.inferenceEntityId;
        }

        public TaskType getTaskType() {
            return this.taskType;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.inferenceEntityId);
            this.taskType.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.inferenceEntityId, request.inferenceEntityId) && this.taskType == request.taskType;
        }

        public int hashCode() {
            return Objects.hash(this.inferenceEntityId, this.taskType);
        }
    }
}

