/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;

public class IndexLifecycleExplainResponse
implements ToXContentObject,
Writeable {
    private static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
    private static final ParseField INDEX_CREATION_DATE_MILLIS_FIELD = new ParseField("index_creation_date_millis", new String[0]);
    private static final ParseField INDEX_CREATION_DATE_FIELD = new ParseField("index_creation_date", new String[0]);
    private static final ParseField MANAGED_BY_ILM_FIELD = new ParseField("managed", new String[0]);
    private static final ParseField POLICY_NAME_FIELD = new ParseField("policy", new String[0]);
    private static final ParseField LIFECYCLE_DATE_MILLIS_FIELD = new ParseField("lifecycle_date_millis", new String[0]);
    private static final ParseField LIFECYCLE_DATE_FIELD = new ParseField("lifecycle_date", new String[0]);
    private static final ParseField PHASE_FIELD = new ParseField("phase", new String[0]);
    private static final ParseField ACTION_FIELD = new ParseField("action", new String[0]);
    private static final ParseField STEP_FIELD = new ParseField("step", new String[0]);
    private static final ParseField FAILED_STEP_FIELD = new ParseField("failed_step", new String[0]);
    private static final ParseField IS_AUTO_RETRYABLE_ERROR_FIELD = new ParseField("is_auto_retryable_error", new String[0]);
    private static final ParseField FAILED_STEP_RETRY_COUNT_FIELD = new ParseField("failed_step_retry_count", new String[0]);
    private static final ParseField PHASE_TIME_MILLIS_FIELD = new ParseField("phase_time_millis", new String[0]);
    private static final ParseField PHASE_TIME_FIELD = new ParseField("phase_time", new String[0]);
    private static final ParseField ACTION_TIME_MILLIS_FIELD = new ParseField("action_time_millis", new String[0]);
    private static final ParseField ACTION_TIME_FIELD = new ParseField("action_time", new String[0]);
    private static final ParseField STEP_TIME_MILLIS_FIELD = new ParseField("step_time_millis", new String[0]);
    private static final ParseField STEP_TIME_FIELD = new ParseField("step_time", new String[0]);
    private static final ParseField STEP_INFO_FIELD = new ParseField("step_info", new String[0]);
    private static final ParseField PHASE_EXECUTION_INFO = new ParseField("phase_execution", new String[0]);
    private static final ParseField AGE_FIELD = new ParseField("age", new String[0]);
    private static final ParseField TIME_SINCE_INDEX_CREATION_FIELD = new ParseField("time_since_index_creation", new String[0]);
    private static final ParseField REPOSITORY_NAME = new ParseField("repository_name", new String[0]);
    private static final ParseField SHRINK_INDEX_NAME = new ParseField("shrink_index_name", new String[0]);
    private static final ParseField SNAPSHOT_NAME = new ParseField("snapshot_name", new String[0]);
    public static final ConstructingObjectParser<IndexLifecycleExplainResponse, Void> PARSER = new ConstructingObjectParser("index_lifecycle_explain_response", a -> new IndexLifecycleExplainResponse((String)a[0], (Long)a[19], (Boolean)a[1], (String)a[2], (Long)a[3], (String)a[4], (String)a[5], (String)a[6], (String)a[7], (Boolean)a[14], (Integer)a[15], (Long)a[8], (Long)a[9], (Long)a[10], (String)a[16], (String)a[17], (String)a[18], (BytesReference)a[11], (PhaseExecutionInfo)a[12]));
    private final String index;
    private final Long indexCreationDate;
    private final String policyName;
    private final String phase;
    private final String action;
    private final String step;
    private final String failedStep;
    private final Long lifecycleDate;
    private final Long phaseTime;
    private final Long actionTime;
    private final Long stepTime;
    private final boolean managedByILM;
    private final BytesReference stepInfo;
    private final PhaseExecutionInfo phaseExecutionInfo;
    private final Boolean isAutoRetryableError;
    private final Integer failedStepRetryCount;
    private final String repositoryName;
    private final String snapshotName;
    private final String shrinkIndexName;
    Supplier<Long> nowSupplier = System::currentTimeMillis;

    public static IndexLifecycleExplainResponse newManagedIndexResponse(String index, Long indexCreationDate, String policyName, Long lifecycleDate, String phase, String action, String step, String failedStep, Boolean isAutoRetryableError, Integer failedStepRetryCount, Long phaseTime, Long actionTime, Long stepTime, String repositoryName, String snapshotName, String shrinkIndexName, BytesReference stepInfo, PhaseExecutionInfo phaseExecutionInfo) {
        return new IndexLifecycleExplainResponse(index, indexCreationDate, true, policyName, lifecycleDate, phase, action, step, failedStep, isAutoRetryableError, failedStepRetryCount, phaseTime, actionTime, stepTime, repositoryName, snapshotName, shrinkIndexName, stepInfo, phaseExecutionInfo);
    }

    public static IndexLifecycleExplainResponse newUnmanagedIndexResponse(String index) {
        return new IndexLifecycleExplainResponse(index, null, false, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    private IndexLifecycleExplainResponse(String index, Long indexCreationDate, boolean managedByILM, String policyName, Long lifecycleDate, String phase, String action, String step, String failedStep, Boolean isAutoRetryableError, Integer failedStepRetryCount, Long phaseTime, Long actionTime, Long stepTime, String repositoryName, String snapshotName, String shrinkIndexName, BytesReference stepInfo, PhaseExecutionInfo phaseExecutionInfo) {
        if (managedByILM) {
            if (policyName == null) {
                throw new IllegalArgumentException("[" + POLICY_NAME_FIELD.getPreferredName() + "] cannot be null for managed index");
            }
            if (Stream.of(phase, action, step).anyMatch(Objects::isNull) && !Stream.of(phase, action, step).allMatch(Objects::isNull) && !"ERROR".equals(step)) {
                throw new IllegalArgumentException("managed index response must have complete step details [" + PHASE_FIELD.getPreferredName() + "=" + phase + ", " + ACTION_FIELD.getPreferredName() + "=" + action + ", " + STEP_FIELD.getPreferredName() + "=" + step + "]");
            }
        } else if (policyName != null || indexCreationDate != null || lifecycleDate != null || phase != null || action != null || step != null || failedStep != null || phaseTime != null || actionTime != null || stepTime != null || stepInfo != null || phaseExecutionInfo != null) {
            throw new IllegalArgumentException("Unmanaged index response must only contain fields: [" + MANAGED_BY_ILM_FIELD + ", " + INDEX_FIELD + "]");
        }
        this.index = index;
        this.indexCreationDate = indexCreationDate;
        this.policyName = policyName;
        this.managedByILM = managedByILM;
        this.lifecycleDate = lifecycleDate;
        this.phase = phase;
        this.action = action;
        this.step = step;
        this.phaseTime = phaseTime;
        this.actionTime = actionTime;
        this.stepTime = stepTime;
        this.failedStep = failedStep;
        this.isAutoRetryableError = isAutoRetryableError;
        this.failedStepRetryCount = failedStepRetryCount;
        this.stepInfo = stepInfo;
        this.phaseExecutionInfo = phaseExecutionInfo;
        this.repositoryName = repositoryName;
        this.snapshotName = snapshotName;
        this.shrinkIndexName = shrinkIndexName;
    }

    public IndexLifecycleExplainResponse(StreamInput in) throws IOException {
        this.index = in.readString();
        this.managedByILM = in.readBoolean();
        if (this.managedByILM) {
            this.policyName = in.readString();
            this.lifecycleDate = in.readOptionalLong();
            this.phase = in.readOptionalString();
            this.action = in.readOptionalString();
            this.step = in.readOptionalString();
            this.failedStep = in.readOptionalString();
            this.phaseTime = in.readOptionalLong();
            this.actionTime = in.readOptionalLong();
            this.stepTime = in.readOptionalLong();
            this.stepInfo = in.readOptionalBytesReference();
            this.phaseExecutionInfo = in.readOptionalWriteable(PhaseExecutionInfo::new);
            this.isAutoRetryableError = in.readOptionalBoolean();
            this.failedStepRetryCount = in.readOptionalVInt();
            this.repositoryName = in.readOptionalString();
            this.snapshotName = in.readOptionalString();
            this.shrinkIndexName = in.readOptionalString();
            this.indexCreationDate = in.getTransportVersion().onOrAfter(TransportVersions.V_8_1_0) ? in.readOptionalLong() : null;
        } else {
            this.policyName = null;
            this.lifecycleDate = null;
            this.phase = null;
            this.action = null;
            this.step = null;
            this.failedStep = null;
            this.isAutoRetryableError = null;
            this.failedStepRetryCount = null;
            this.phaseTime = null;
            this.actionTime = null;
            this.stepTime = null;
            this.stepInfo = null;
            this.phaseExecutionInfo = null;
            this.repositoryName = null;
            this.snapshotName = null;
            this.shrinkIndexName = null;
            this.indexCreationDate = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeBoolean(this.managedByILM);
        if (this.managedByILM) {
            out.writeString(this.policyName);
            out.writeOptionalLong(this.lifecycleDate);
            out.writeOptionalString(this.phase);
            out.writeOptionalString(this.action);
            out.writeOptionalString(this.step);
            out.writeOptionalString(this.failedStep);
            out.writeOptionalLong(this.phaseTime);
            out.writeOptionalLong(this.actionTime);
            out.writeOptionalLong(this.stepTime);
            out.writeOptionalBytesReference(this.stepInfo);
            out.writeOptionalWriteable(this.phaseExecutionInfo);
            out.writeOptionalBoolean(this.isAutoRetryableError);
            out.writeOptionalVInt(this.failedStepRetryCount);
            out.writeOptionalString(this.repositoryName);
            out.writeOptionalString(this.snapshotName);
            out.writeOptionalString(this.shrinkIndexName);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_1_0)) {
                out.writeOptionalLong(this.indexCreationDate);
            }
        }
    }

    public String getIndex() {
        return this.index;
    }

    public Long getIndexCreationDate() {
        return this.indexCreationDate;
    }

    public TimeValue getTimeSinceIndexCreation(Supplier<Long> now) {
        if (this.indexCreationDate == null) {
            return null;
        }
        return TimeValue.timeValueMillis(Math.max(0L, now.get() - this.indexCreationDate));
    }

    public boolean managedByILM() {
        return this.managedByILM;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public Long getLifecycleDate() {
        return this.lifecycleDate;
    }

    public String getPhase() {
        return this.phase;
    }

    public Long getPhaseTime() {
        return this.phaseTime;
    }

    public String getAction() {
        return this.action;
    }

    public Long getActionTime() {
        return this.actionTime;
    }

    public String getStep() {
        return this.step;
    }

    public Long getStepTime() {
        return this.stepTime;
    }

    public String getFailedStep() {
        return this.failedStep;
    }

    public BytesReference getStepInfo() {
        return this.stepInfo;
    }

    public PhaseExecutionInfo getPhaseExecutionInfo() {
        return this.phaseExecutionInfo;
    }

    public Boolean isAutoRetryableError() {
        return this.isAutoRetryableError;
    }

    public Integer getFailedStepRetryCount() {
        return this.failedStepRetryCount;
    }

    public TimeValue getAge(Supplier<Long> now) {
        if (this.lifecycleDate == null) {
            return TimeValue.MINUS_ONE;
        }
        return TimeValue.timeValueMillis(Math.max(0L, now.get() - this.lifecycleDate));
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public String getShrinkIndexName() {
        return this.shrinkIndexName;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX_FIELD.getPreferredName(), this.index);
        builder.field(MANAGED_BY_ILM_FIELD.getPreferredName(), this.managedByILM);
        if (this.managedByILM) {
            builder.field(POLICY_NAME_FIELD.getPreferredName(), this.policyName);
            if (this.indexCreationDate != null) {
                builder.timeField(INDEX_CREATION_DATE_MILLIS_FIELD.getPreferredName(), INDEX_CREATION_DATE_FIELD.getPreferredName(), this.indexCreationDate);
                builder.field(TIME_SINCE_INDEX_CREATION_FIELD.getPreferredName(), this.getTimeSinceIndexCreation(this.nowSupplier).toHumanReadableString(2));
            }
            if (this.lifecycleDate != null) {
                builder.timeField(LIFECYCLE_DATE_MILLIS_FIELD.getPreferredName(), LIFECYCLE_DATE_FIELD.getPreferredName(), this.lifecycleDate);
                builder.field(AGE_FIELD.getPreferredName(), this.getAge(this.nowSupplier).toHumanReadableString(2));
            }
            if (this.phase != null) {
                builder.field(PHASE_FIELD.getPreferredName(), this.phase);
            }
            if (this.phaseTime != null) {
                builder.timeField(PHASE_TIME_MILLIS_FIELD.getPreferredName(), PHASE_TIME_FIELD.getPreferredName(), this.phaseTime);
            }
            if (this.action != null) {
                builder.field(ACTION_FIELD.getPreferredName(), this.action);
            }
            if (this.actionTime != null) {
                builder.timeField(ACTION_TIME_MILLIS_FIELD.getPreferredName(), ACTION_TIME_FIELD.getPreferredName(), this.actionTime);
            }
            if (this.step != null) {
                builder.field(STEP_FIELD.getPreferredName(), this.step);
            }
            if (this.stepTime != null) {
                builder.timeField(STEP_TIME_MILLIS_FIELD.getPreferredName(), STEP_TIME_FIELD.getPreferredName(), this.stepTime);
            }
            if (Strings.hasLength(this.failedStep)) {
                builder.field(FAILED_STEP_FIELD.getPreferredName(), this.failedStep);
            }
            if (this.isAutoRetryableError != null) {
                builder.field(IS_AUTO_RETRYABLE_ERROR_FIELD.getPreferredName(), this.isAutoRetryableError);
            }
            if (this.failedStepRetryCount != null) {
                builder.field(FAILED_STEP_RETRY_COUNT_FIELD.getPreferredName(), this.failedStepRetryCount);
            }
            if (this.repositoryName != null) {
                builder.field(REPOSITORY_NAME.getPreferredName(), this.repositoryName);
            }
            if (this.snapshotName != null) {
                builder.field(SNAPSHOT_NAME.getPreferredName(), this.snapshotName);
            }
            if (this.shrinkIndexName != null) {
                builder.field(SHRINK_INDEX_NAME.getPreferredName(), this.shrinkIndexName);
            }
            if (this.stepInfo != null && this.stepInfo.length() > 0) {
                builder.rawField(STEP_INFO_FIELD.getPreferredName(), this.stepInfo.streamInput(), XContentType.JSON);
            }
            if (this.phaseExecutionInfo != null) {
                builder.field(PHASE_EXECUTION_INFO.getPreferredName(), this.phaseExecutionInfo);
            }
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.indexCreationDate, this.managedByILM, this.policyName, this.lifecycleDate, this.phase, this.action, this.step, this.failedStep, this.isAutoRetryableError, this.failedStepRetryCount, this.phaseTime, this.actionTime, this.stepTime, this.repositoryName, this.snapshotName, this.shrinkIndexName, this.stepInfo, this.phaseExecutionInfo);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        IndexLifecycleExplainResponse other = (IndexLifecycleExplainResponse)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.indexCreationDate, other.indexCreationDate) && Objects.equals(this.managedByILM, other.managedByILM) && Objects.equals(this.policyName, other.policyName) && Objects.equals(this.lifecycleDate, other.lifecycleDate) && Objects.equals(this.phase, other.phase) && Objects.equals(this.action, other.action) && Objects.equals(this.step, other.step) && Objects.equals(this.failedStep, other.failedStep) && Objects.equals(this.isAutoRetryableError, other.isAutoRetryableError) && Objects.equals(this.failedStepRetryCount, other.failedStepRetryCount) && Objects.equals(this.phaseTime, other.phaseTime) && Objects.equals(this.actionTime, other.actionTime) && Objects.equals(this.stepTime, other.stepTime) && Objects.equals(this.repositoryName, other.repositoryName) && Objects.equals(this.snapshotName, other.snapshotName) && Objects.equals(this.shrinkIndexName, other.shrinkIndexName) && Objects.equals(this.stepInfo, other.stepInfo) && Objects.equals(this.phaseExecutionInfo, other.phaseExecutionInfo);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), MANAGED_BY_ILM_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), POLICY_NAME_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LIFECYCLE_DATE_MILLIS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PHASE_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ACTION_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), STEP_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FAILED_STEP_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PHASE_TIME_MILLIS_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), ACTION_TIME_MILLIS_FIELD);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), STEP_TIME_MILLIS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.copyCurrentStructure(p);
            return BytesReference.bytes(builder);
        }, STEP_INFO_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PhaseExecutionInfo.parse(p, ""), PHASE_EXECUTION_INFO);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), AGE_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), IS_AUTO_RETRYABLE_ERROR_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), FAILED_STEP_RETRY_COUNT_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REPOSITORY_NAME);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), SNAPSHOT_NAME);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), SHRINK_INDEX_NAME);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), INDEX_CREATION_DATE_MILLIS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TIME_SINCE_INDEX_CREATION_FIELD);
    }
}

