/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class SetResetModeActionRequest
extends AcknowledgedRequest<SetResetModeActionRequest>
implements ToXContentObject {
    private final boolean enabled;
    private final boolean deleteMetadata;
    private static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    private static final ParseField DELETE_METADATA = new ParseField("delete_metadata", new String[0]);
    public static final ConstructingObjectParser<SetResetModeActionRequest, Void> PARSER = new ConstructingObjectParser("set_reset_mode_action_request", a -> new SetResetModeActionRequest((Boolean)a[0], (Boolean)a[1]));

    public static SetResetModeActionRequest enabled() {
        return new SetResetModeActionRequest(true, false);
    }

    public static SetResetModeActionRequest disabled(boolean deleteMetadata) {
        return new SetResetModeActionRequest(false, deleteMetadata);
    }

    SetResetModeActionRequest(boolean enabled, Boolean deleteMetadata) {
        this.enabled = enabled;
        this.deleteMetadata = deleteMetadata != null && deleteMetadata != false;
    }

    public SetResetModeActionRequest(StreamInput in) throws IOException {
        super(in);
        this.enabled = in.readBoolean();
        this.deleteMetadata = in.readBoolean();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean shouldDeleteMetadata() {
        return this.deleteMetadata;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.deleteMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.deleteMetadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SetResetModeActionRequest other = (SetResetModeActionRequest)obj;
        return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.deleteMetadata, other.deleteMetadata);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED.getPreferredName(), this.enabled);
        if (!this.enabled) {
            builder.field(DELETE_METADATA.getPreferredName(), this.deleteMetadata);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), DELETE_METADATA);
    }
}

