/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class KnnScoreDocQuery
extends Query {
    private final int[] docs;
    private final float[] scores;
    private final int[] segmentStarts;
    private final Object contextIdentity;

    KnnScoreDocQuery(int[] docs, float[] scores, int[] segmentStarts, Object contextIdentity) {
        this.docs = docs;
        this.scores = scores;
        this.segmentStarts = segmentStarts;
        this.contextIdentity = contextIdentity;
    }

    @Override
    public Query rewrite(IndexSearcher searcher) throws IOException {
        if (this.docs.length == 0) {
            return new MatchNoDocsQuery();
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        if (searcher.getIndexReader().getContext().id() != this.contextIdentity) {
            throw new IllegalStateException("This KnnScoreDocQuery was created by a different reader");
        }
        return new Weight(this){

            @Override
            public int count(LeafReaderContext context) {
                return KnnScoreDocQuery.this.segmentStarts[context.ord + 1] - KnnScoreDocQuery.this.segmentStarts[context.ord];
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) {
                int found = Arrays.binarySearch(KnnScoreDocQuery.this.docs, doc + context.docBase);
                if (found < 0) {
                    return Explanation.noMatch("not in top k documents", new Explanation[0]);
                }
                return Explanation.match((Number)Float.valueOf(KnnScoreDocQuery.this.scores[found] * boost), "within top k documents", new Explanation[0]);
            }

            @Override
            public Scorer scorer(final LeafReaderContext context) {
                if (KnnScoreDocQuery.this.segmentStarts[context.ord] == KnnScoreDocQuery.this.segmentStarts[context.ord + 1]) {
                    return null;
                }
                return new Scorer(this){
                    final int lower;
                    final int upper;
                    int upTo;
                    {
                        super(arg0);
                        this.lower = KnnScoreDocQuery.this.segmentStarts[context.ord];
                        this.upper = KnnScoreDocQuery.this.segmentStarts[context.ord + 1];
                        this.upTo = -1;
                    }

                    @Override
                    public DocIdSetIterator iterator() {
                        return new DocIdSetIterator(){

                            @Override
                            public int docID() {
                                return this.currentDocId();
                            }

                            @Override
                            public int nextDoc() {
                                upTo = upTo == -1 ? lower : ++upTo;
                                return this.currentDocId();
                            }

                            @Override
                            public int advance(int target) throws IOException {
                                return this.slowAdvance(target);
                            }

                            @Override
                            public long cost() {
                                return upper - lower;
                            }
                        };
                    }

                    @Override
                    public float getMaxScore(int docId) {
                        if (docId != Integer.MAX_VALUE) {
                            docId += context.docBase;
                        }
                        float maxScore = 0.0f;
                        for (int idx = Math.max(this.lower, this.upTo); idx < this.upper && KnnScoreDocQuery.this.docs[idx] <= docId; ++idx) {
                            maxScore = Math.max(maxScore, KnnScoreDocQuery.this.scores[idx] * boost);
                        }
                        return maxScore;
                    }

                    @Override
                    public float score() {
                        return KnnScoreDocQuery.this.scores[this.upTo] * boost;
                    }

                    @Override
                    public int advanceShallow(int docId) {
                        int start = Math.max(this.upTo, this.lower);
                        int docIdIndex = Arrays.binarySearch(KnnScoreDocQuery.this.docs, start, this.upper, docId + context.docBase);
                        if (docIdIndex < 0) {
                            docIdIndex = -1 - docIdIndex;
                        }
                        if (docIdIndex >= this.upper) {
                            return Integer.MAX_VALUE;
                        }
                        return KnnScoreDocQuery.this.docs[docIdIndex];
                    }

                    @Override
                    public int docID() {
                        return this.currentDocId();
                    }

                    private int currentDocId() {
                        if (this.upTo == -1) {
                            return -1;
                        }
                        if (this.upTo >= this.upper) {
                            return Integer.MAX_VALUE;
                        }
                        return KnnScoreDocQuery.this.docs[this.upTo] - context.docBase;
                    }
                };
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    int[] docs() {
        return this.docs;
    }

    float[] scores() {
        return this.scores;
    }

    @Override
    public String toString(String field) {
        return "ScoreAndDocQuery";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        return Arrays.equals(this.docs, ((KnnScoreDocQuery)obj).docs) && Arrays.equals(this.scores, ((KnnScoreDocQuery)obj).scores) && Arrays.equals(this.segmentStarts, ((KnnScoreDocQuery)obj).segmentStarts) && this.contextIdentity == ((KnnScoreDocQuery)obj).contextIdentity;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), Arrays.hashCode(this.docs), Arrays.hashCode(this.scores), Arrays.hashCode(this.segmentStarts), this.contextIdentity);
    }
}

