/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rank;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public abstract class RankDoc
extends ScoreDoc
implements Writeable {
    public static final int NO_RANK = -1;
    public int rank = -1;

    public RankDoc(int doc, float score, int shardIndex) {
        super(doc, score, shardIndex);
    }

    protected RankDoc(StreamInput in) throws IOException {
        super(in.readVInt(), in.readFloat(), in.readVInt());
        this.rank = in.readVInt();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.doc);
        out.writeFloat(this.score);
        out.writeVInt(this.shardIndex);
        out.writeVInt(this.rank);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankDoc rd = (RankDoc)o;
        return this.doc == rd.doc && this.score == rd.score && this.shardIndex == rd.shardIndex && this.rank == rd.rank && this.doEquals(rd);
    }

    protected abstract boolean doEquals(RankDoc var1);

    public final int hashCode() {
        return Objects.hash(this.doc, Float.valueOf(this.score), this.shardIndex, this.doHashCode());
    }

    protected abstract int doHashCode();

    @Override
    public String toString() {
        return "RankDoc{score=" + this.score + ", doc=" + this.doc + ", shardIndex=" + this.shardIndex + "}";
    }
}

