/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public interface Source {
    public XContentType sourceContentType();

    public Map<String, Object> source();

    public BytesReference internalSourceRef();

    public Source filter(SourceFilter var1);

    default public Object extractValue(String path, @Nullable Object nullValue) {
        return XContentMapValues.extractValue(path, this.source(), nullValue);
    }

    public static Source empty(XContentType xContentType) {
        return Source.fromMap(Map.of(), xContentType == null ? XContentType.JSON : xContentType);
    }

    public static Source fromBytes(BytesReference bytes) {
        return Source.fromBytes(bytes, null);
    }

    public static Source fromBytes(final BytesReference bytes, final XContentType type) {
        if (bytes == null || bytes.length() == 0) {
            return Source.empty(type);
        }
        if (!4.$assertionsDisabled && type != null && type.xContent() != XContentHelper.xContentType(bytes).xContent()) {
            throw new AssertionError((Object)("unexpected type " + type.xContent() + " expecting " + XContentHelper.xContentType(bytes).xContent()));
        }
        return new Source(){
            Map<String, Object> asMap = null;
            XContentType xContentType = type;

            private void parseBytes() {
                Tuple<XContentType, Map<String, Object>> t = XContentHelper.convertToMap(bytes, true);
                this.xContentType = t.v1();
                this.asMap = t.v2();
            }

            @Override
            public XContentType sourceContentType() {
                if (this.xContentType == null) {
                    this.xContentType = XContentHelper.xContentType(bytes);
                }
                return this.xContentType;
            }

            @Override
            public Map<String, Object> source() {
                if (this.asMap == null) {
                    this.parseBytes();
                }
                return this.asMap;
            }

            @Override
            public BytesReference internalSourceRef() {
                return bytes;
            }

            @Override
            public Source filter(SourceFilter sourceFilter) {
                if (this.asMap != null) {
                    return sourceFilter.filterMap(this);
                }
                return sourceFilter.filterBytes(this);
            }
        };
    }

    public static Source fromMap(Map<String, Object> map, final XContentType xContentType) {
        final Map<Object, Object> sourceMap = map == null ? Map.of() : map;
        return new Source(){

            @Override
            public XContentType sourceContentType() {
                return xContentType;
            }

            @Override
            public Map<String, Object> source() {
                return sourceMap;
            }

            @Override
            public BytesReference internalSourceRef() {
                return 2.mapToBytes(sourceMap, xContentType);
            }

            @Override
            public Source filter(SourceFilter sourceFilter) {
                return sourceFilter.filterMap(this);
            }

            private static BytesReference mapToBytes(Map<String, Object> value, XContentType xContentType2) {
                BytesStreamOutput streamOutput = new BytesStreamOutput(1024);
                try {
                    XContentBuilder builder = new XContentBuilder(xContentType2.xContent(), streamOutput);
                    builder.value(value);
                    return BytesReference.bytes(builder);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    public static Source lazy(final Supplier<Source> sourceSupplier) {
        return new Source(){
            Source inner = null;

            @Override
            public XContentType sourceContentType() {
                if (this.inner == null) {
                    this.inner = (Source)sourceSupplier.get();
                }
                return this.inner.sourceContentType();
            }

            @Override
            public Map<String, Object> source() {
                if (this.inner == null) {
                    this.inner = (Source)sourceSupplier.get();
                }
                return this.inner.source();
            }

            @Override
            public BytesReference internalSourceRef() {
                if (this.inner == null) {
                    this.inner = (Source)sourceSupplier.get();
                }
                return this.inner.internalSourceRef();
            }

            @Override
            public Source filter(SourceFilter sourceFilter) {
                if (this.inner == null) {
                    this.inner = (Source)sourceSupplier.get();
                }
                return this.inner.filter(sourceFilter);
            }
        };
    }

    static {
        if (4.$assertionsDisabled) {
            // empty if block
        }
    }
}

