/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FilterVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;

class ExitableDirectoryReader
extends FilterDirectoryReader {
    ExitableDirectoryReader(DirectoryReader in, final QueryCancellation queryCancellation) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            @Override
            public LeafReader wrap(LeafReader reader) {
                return new ExitableLeafReader(reader, queryCancellation);
            }
        });
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) {
        throw new UnsupportedOperationException("doWrapDirectoryReader() should never be invoked");
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    static interface QueryCancellation {
        public boolean isEnabled();

        public void checkCancelled();
    }

    private static class ExitableFloatVectorValues
    extends FilterVectorValues {
        private int calls;
        private final QueryCancellation queryCancellation;

        ExitableFloatVectorValues(FloatVectorValues vectorValues, QueryCancellation queryCancellation) {
            super(vectorValues);
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        @Override
        public int advance(int target) throws IOException {
            int advance = super.advance(target);
            this.checkAndThrowWithSampling();
            return advance;
        }

        @Override
        public int nextDoc() throws IOException {
            int nextDoc = super.nextDoc();
            this.checkAndThrowWithSampling();
            return nextDoc;
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }
    }

    private static class ExitableByteVectorValues
    extends ByteVectorValues {
        private int calls;
        private final QueryCancellation queryCancellation;
        private final ByteVectorValues in;

        private ExitableByteVectorValues(QueryCancellation queryCancellation, ByteVectorValues in) {
            this.queryCancellation = queryCancellation;
            this.in = in;
        }

        @Override
        public int dimension() {
            return this.in.dimension();
        }

        @Override
        public int size() {
            return this.in.size();
        }

        @Override
        public byte[] vectorValue() throws IOException {
            return this.in.vectorValue();
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int nextDoc = this.in.nextDoc();
            this.checkAndThrowWithSampling();
            return nextDoc;
        }

        @Override
        public int advance(int target) throws IOException {
            int advance = this.in.advance(target);
            this.checkAndThrowWithSampling();
            return advance;
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }
    }

    private static class ExitableIntersectVisitor
    implements PointValues.IntersectVisitor {
        static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 8191;
        private final QueryCancellation queryCancellation;
        private PointValues.IntersectVisitor in;
        private int calls;

        private ExitableIntersectVisitor(QueryCancellation queryCancellation) {
            this.queryCancellation = queryCancellation;
        }

        private void setIntersectVisitor(PointValues.IntersectVisitor in) {
            this.in = in;
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        @Override
        public void visit(int docID) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID);
        }

        @Override
        public void visit(DocIdSetIterator iterator) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(iterator);
        }

        @Override
        public void visit(int docID, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID, packedValue);
        }

        @Override
        public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(iterator, packedValue);
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.queryCancellation.checkCancelled();
            return this.in.compare(minPackedValue, maxPackedValue);
        }

        @Override
        public void grow(int count) {
            this.queryCancellation.checkCancelled();
            this.in.grow(count);
        }
    }

    private static class ExitablePointTree
    implements PointValues.PointTree {
        private final PointValues pointValues;
        private final PointValues.PointTree in;
        private final ExitableIntersectVisitor exitableIntersectVisitor;
        private final QueryCancellation queryCancellation;
        private int calls;

        private ExitablePointTree(PointValues pointValues, PointValues.PointTree in, QueryCancellation queryCancellation) {
            this.pointValues = pointValues;
            this.in = in;
            this.queryCancellation = queryCancellation;
            this.exitableIntersectVisitor = new ExitableIntersectVisitor(queryCancellation);
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        @Override
        public PointValues.PointTree clone() {
            this.queryCancellation.checkCancelled();
            return new ExitablePointTree(this.pointValues, this.in.clone(), this.queryCancellation);
        }

        @Override
        public boolean moveToChild() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToChild();
        }

        @Override
        public boolean moveToSibling() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToSibling();
        }

        @Override
        public boolean moveToParent() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.moveToParent();
        }

        @Override
        public byte[] getMinPackedValue() {
            this.checkAndThrowWithSampling();
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() {
            this.checkAndThrowWithSampling();
            return this.in.getMaxPackedValue();
        }

        @Override
        public long size() {
            this.queryCancellation.checkCancelled();
            return this.in.size();
        }

        @Override
        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.in.visitDocIDs(visitor);
        }

        @Override
        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.exitableIntersectVisitor.setIntersectVisitor(visitor);
            this.in.visitDocValues(this.exitableIntersectVisitor);
        }
    }

    static class ExitablePointValues
    extends PointValues {
        private final PointValues in;
        private final QueryCancellation queryCancellation;

        private ExitablePointValues(PointValues in, QueryCancellation queryCancellation) {
            this.in = in;
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        @Override
        public PointValues.PointTree getPointTree() throws IOException {
            this.queryCancellation.checkCancelled();
            return new ExitablePointTree(this.in, this.in.getPointTree(), this.queryCancellation);
        }

        @Override
        public byte[] getMinPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMaxPackedValue();
        }

        @Override
        public int getNumDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumDimensions();
        }

        @Override
        public int getNumIndexDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumIndexDimensions();
        }

        @Override
        public int getBytesPerDimension() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getBytesPerDimension();
        }

        @Override
        public long size() {
            this.queryCancellation.checkCancelled();
            return this.in.size();
        }

        @Override
        public int getDocCount() {
            this.queryCancellation.checkCancelled();
            return this.in.getDocCount();
        }
    }

    private static class ExitableTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 15;
        private int calls;
        private final QueryCancellation queryCancellation;

        private ExitableTermsEnum(TermsEnum termsEnum, QueryCancellation queryCancellation) {
            super(termsEnum);
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0xF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        @Override
        public BytesRef next() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.next();
        }
    }

    static class ExitableTerms
    extends FilterLeafReader.FilterTerms {
        private final QueryCancellation queryCancellation;

        ExitableTerms(Terms terms, QueryCancellation queryCancellation) {
            super(terms);
            this.queryCancellation = queryCancellation;
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new ExitableTermsEnum(this.in.intersect(compiled, startTerm), this.queryCancellation);
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new ExitableTermsEnum(this.in.iterator(), this.queryCancellation);
        }

        @Override
        public BytesRef getMin() throws IOException {
            return this.in.getMin();
        }

        @Override
        public BytesRef getMax() throws IOException {
            return this.in.getMax();
        }
    }

    static class ExitableLeafReader
    extends SequentialStoredFieldsLeafReader {
        private final QueryCancellation queryCancellation;

        private ExitableLeafReader(LeafReader leafReader, QueryCancellation queryCancellation) {
            super(leafReader);
            this.queryCancellation = queryCancellation;
        }

        @Override
        public PointValues getPointValues(String field) throws IOException {
            PointValues pointValues = this.in.getPointValues(field);
            if (pointValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitablePointValues(pointValues, this.queryCancellation) : pointValues;
        }

        @Override
        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            if (terms == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() && !(terms instanceof CompletionTerms) ? new ExitableTerms(terms, this.queryCancellation) : terms;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        @Override
        protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
            return reader;
        }

        @Override
        public ByteVectorValues getByteVectorValues(String field) throws IOException {
            ByteVectorValues vectorValues = this.in.getByteVectorValues(field);
            if (vectorValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitableByteVectorValues(this.queryCancellation, vectorValues) : vectorValues;
        }

        @Override
        public void searchNearestVectors(String field, byte[] target, KnnCollector collector, Bits acceptDocs) throws IOException {
            if (!this.queryCancellation.isEnabled()) {
                this.in.searchNearestVectors(field, target, collector, acceptDocs);
                return;
            }
            this.in.searchNearestVectors(field, target, collector, (Bits)new TimeOutCheckingBits(acceptDocs));
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String field) throws IOException {
            FloatVectorValues vectorValues = this.in.getFloatVectorValues(field);
            if (vectorValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitableFloatVectorValues(vectorValues, this.queryCancellation) : vectorValues;
        }

        @Override
        public void searchNearestVectors(String field, float[] target, KnnCollector collector, Bits acceptDocs) throws IOException {
            if (!this.queryCancellation.isEnabled()) {
                this.in.searchNearestVectors(field, target, collector, acceptDocs);
                return;
            }
            this.in.searchNearestVectors(field, target, collector, (Bits)new TimeOutCheckingBits(acceptDocs));
        }

        private class TimeOutCheckingBits
        implements Bits {
            private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 10;
            private final Bits updatedAcceptDocs;
            private int calls;

            TimeOutCheckingBits(Bits acceptDocs) {
                this.updatedAcceptDocs = acceptDocs == null ? new Bits.MatchAllBits(ExitableLeafReader.this.maxDoc()) : acceptDocs;
            }

            @Override
            public boolean get(int index) {
                if (this.calls++ % 10 == 0) {
                    ExitableLeafReader.this.queryCancellation.checkCancelled();
                }
                return this.updatedAcceptDocs.get(index);
            }

            @Override
            public int length() {
                return this.updatedAcceptDocs.length();
            }
        }
    }
}

