/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.InternalCardinality;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GlobalOrdCardinalityAggregator
extends NumericMetricsAggregator.SingleValue {
    private static final int MAX_FIELD_CARDINALITY_FOR_DYNAMIC_PRUNING = 1024;
    private static final int MAX_TERMS_FOR_DYNAMIC_PRUNING = 128;
    private final ValuesSource.Bytes.WithOrdinals valuesSource;
    private final String field;
    private final BigArrays bigArrays;
    private final int maxOrd;
    private final int precision;
    private int dynamicPruningAttempts;
    private int dynamicPruningSuccess;
    private int bruteForce;
    private int noData;
    @Nullable
    private HyperLogLogPlusPlus counts;
    private ObjectArray<BitArray> visitedOrds;
    private SortedSetDocValues values;

    public GlobalOrdCardinalityAggregator(String name, ValuesSource.Bytes.WithOrdinals valuesSource, String field, int precision, int maxOrd, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSource;
        this.field = field;
        this.precision = precision;
        this.maxOrd = maxOrd;
        this.bigArrays = context.bigArrays();
        this.visitedOrds = this.bigArrays.newObjectArray(1L);
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.field != null && !this.valuesSource.needsScores() && this.maxOrd <= 1024) {
            return ScoreMode.TOP_DOCS;
        }
        if (this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(final AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        this.values = this.valuesSource.globalOrdinalsValues(aggCtx.getLeafReaderContext());
        if (this.parent == null && this.field != null) {
            final Terms indexTerms = aggCtx.getLeafReaderContext().reader().terms(this.field);
            if (indexTerms != null) {
                BitArray bits = this.visitedOrds.get(0L);
                final int numNonVisitedOrds = this.maxOrd - (bits == null ? 0 : (int)bits.cardinality());
                if (this.maxOrd <= 1024 || numNonVisitedOrds <= 128) {
                    ++this.dynamicPruningAttempts;
                    return new LeafBucketCollector(){
                        final SortedSetDocValues docValues;
                        final BitArray bits;
                        final CompetitiveIterator competitiveIterator;
                        {
                            this.docValues = GlobalOrdCardinalityAggregator.this.values;
                            GlobalOrdCardinalityAggregator.this.visitedOrds = GlobalOrdCardinalityAggregator.this.bigArrays.grow(GlobalOrdCardinalityAggregator.this.visitedOrds, 1L);
                            BitArray bits = GlobalOrdCardinalityAggregator.this.visitedOrds.get(0L);
                            if (bits == null) {
                                bits = new BitArray(GlobalOrdCardinalityAggregator.this.maxOrd, GlobalOrdCardinalityAggregator.this.bigArrays);
                                GlobalOrdCardinalityAggregator.this.visitedOrds.set(0L, bits);
                            }
                            this.bits = bits;
                            SortedSetDocValues docsWithField = GlobalOrdCardinalityAggregator.this.valuesSource.ordinalsValues(aggCtx.getLeafReaderContext());
                            this.competitiveIterator = new CompetitiveIterator(numNonVisitedOrds, bits, indexTerms, docsWithField);
                            if (numNonVisitedOrds <= 128) {
                                this.competitiveIterator.startPruning();
                            }
                        }

                        @Override
                        public void collect(int doc, long bucketOrd) throws IOException {
                            if (this.docValues.advanceExact(doc)) {
                                long ord = this.docValues.nextOrd();
                                while (ord != -1L) {
                                    if (!this.bits.getAndSet(ord)) {
                                        this.competitiveIterator.onVisitedOrdinal(ord);
                                    }
                                    ord = this.docValues.nextOrd();
                                }
                            }
                        }

                        @Override
                        public CompetitiveIterator competitiveIterator() {
                            return this.competitiveIterator;
                        }
                    };
                }
            } else {
                FieldInfo fi = aggCtx.getLeafReaderContext().reader().getFieldInfos().fieldInfo(this.field);
                if (fi != null && fi.getIndexOptions() != IndexOptions.NONE) {
                    ++this.noData;
                    return LeafBucketCollector.NO_OP_COLLECTOR;
                }
            }
        }
        ++this.bruteForce;
        return new LeafBucketCollector(){
            final SortedSetDocValues docValues;
            {
                this.docValues = GlobalOrdCardinalityAggregator.this.values;
            }

            @Override
            public void collect(int doc, long bucketOrd) throws IOException {
                GlobalOrdCardinalityAggregator.this.visitedOrds = GlobalOrdCardinalityAggregator.this.bigArrays.grow(GlobalOrdCardinalityAggregator.this.visitedOrds, bucketOrd + 1L);
                BitArray bits = GlobalOrdCardinalityAggregator.this.visitedOrds.get(bucketOrd);
                if (bits == null) {
                    bits = new BitArray(GlobalOrdCardinalityAggregator.this.maxOrd, GlobalOrdCardinalityAggregator.this.bigArrays);
                    GlobalOrdCardinalityAggregator.this.visitedOrds.set(bucketOrd, bits);
                }
                if (this.docValues.advanceExact(doc)) {
                    long ord = this.docValues.nextOrd();
                    while (ord != -1L) {
                        bits.set((int)ord);
                        ord = this.docValues.nextOrd();
                    }
                }
            }
        };
    }

    @Override
    protected void doPostCollection() throws IOException {
        this.counts = new HyperLogLogPlusPlus(this.precision, this.bigArrays, this.visitedOrds.size());
        try (LongArray hashes = this.bigArrays.newLongArray(this.maxOrd, false);){
            try (BitArray allVisitedOrds = new BitArray(this.maxOrd, this.bigArrays);){
                for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                    BitArray bits = this.visitedOrds.get(bucket);
                    if (bits == null) continue;
                    allVisitedOrds.or(bits);
                }
                MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
                long ord = allVisitedOrds.nextSetBit(0L);
                while (ord < Long.MAX_VALUE) {
                    BytesRef value = this.values.lookupOrd(ord);
                    MurmurHash3.hash128(value.bytes, value.offset, value.length, 0L, hash);
                    hashes.set(ord, hash.h1);
                    ord = ord + 1L < (long)this.maxOrd ? allVisitedOrds.nextSetBit(ord + 1L) : Long.MAX_VALUE;
                }
            }
            for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                try (BitArray bits = this.visitedOrds.get(bucket);){
                    if (bits == null) continue;
                    this.visitedOrds.set(bucket, null);
                    long ord = bits.nextSetBit(0L);
                    while (ord < Long.MAX_VALUE) {
                        this.counts.collect(bucket, hashes.get(ord));
                        ord = ord + 1L < (long)this.maxOrd ? bits.nextSetBit(ord + 1L) : Long.MAX_VALUE;
                    }
                    continue;
                }
            }
            Releasables.close(this.visitedOrds);
            this.visitedOrds = null;
        }
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.counts.cardinality(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.counts == null || owningBucketOrdinal >= this.counts.maxOrd() || this.counts.cardinality(owningBucketOrdinal) == 0L) {
            return this.buildEmptyAggregation();
        }
        AbstractHyperLogLogPlusPlus copy = this.counts.clone(owningBucketOrdinal, BigArrays.NON_RECYCLING_INSTANCE);
        return new InternalCardinality(this.name, copy, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalCardinality(this.name, null, this.metadata());
    }

    @Override
    protected void doClose() {
        if (this.visitedOrds != null) {
            int i = 0;
            while ((long)i < this.visitedOrds.size()) {
                Releasables.close((Releasable)this.visitedOrds.get(i));
                ++i;
            }
        }
        Releasables.close(this.visitedOrds, this.counts);
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("dynamic_pruning_attempted", this.dynamicPruningAttempts);
        add.accept("dynamic_pruning_used", this.dynamicPruningSuccess);
        add.accept("brute_force_used", this.bruteForce);
        add.accept("skipped_due_to_no_data", this.noData);
    }

    private class CompetitiveIterator
    extends DocIdSetIterator {
        private final BitArray visitedOrds;
        private long numNonVisitedOrds;
        private final TermsEnum indexTerms;
        private final DocIdSetIterator docsWithField;
        private Map<Long, PostingsEnum> nonVisitedOrds;
        private PriorityQueue<PostingsEnum> nonVisitedPostings;
        private int doc = -1;

        CompetitiveIterator(int numNonVisitedOrds, BitArray visitedOrds, Terms indexTerms, DocIdSetIterator docsWithField) throws IOException {
            this.visitedOrds = visitedOrds;
            this.numNonVisitedOrds = numNonVisitedOrds;
            this.indexTerms = Objects.requireNonNull(indexTerms).iterator();
            this.docsWithField = docsWithField;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            if (this.nonVisitedPostings == null) {
                this.doc = this.docsWithField.advance(target);
                return this.doc;
            }
            if (this.nonVisitedPostings.size() == 0) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            PostingsEnum top = this.nonVisitedPostings.top();
            while (top.docID() < target) {
                top.advance(target);
                top = this.nonVisitedPostings.updateTop();
            }
            this.doc = top.docID();
            return this.doc;
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        void startPruning() throws IOException {
            ++GlobalOrdCardinalityAggregator.this.dynamicPruningSuccess;
            this.nonVisitedOrds = new HashMap<Long, PostingsEnum>();
            for (long ord = 0L; ord < (long)GlobalOrdCardinalityAggregator.this.maxOrd; ++ord) {
                BytesRef term;
                if (this.visitedOrds.get(ord) || !this.indexTerms.seekExact(term = GlobalOrdCardinalityAggregator.this.values.lookupOrd(ord))) continue;
                this.nonVisitedOrds.put(ord, this.indexTerms.postings(null, 0));
            }
            this.nonVisitedPostings = new PriorityQueue<PostingsEnum>(this.nonVisitedOrds.size()){

                @Override
                protected boolean lessThan(PostingsEnum a, PostingsEnum b) {
                    return a.docID() < b.docID();
                }
            };
            for (PostingsEnum pe : this.nonVisitedOrds.values()) {
                this.nonVisitedPostings.add(pe);
            }
        }

        void onVisitedOrdinal(long ordinal) throws IOException {
            --this.numNonVisitedOrds;
            if (this.nonVisitedOrds == null) {
                if (this.numNonVisitedOrds <= 128L) {
                    this.startPruning();
                }
            } else if (this.nonVisitedOrds.remove(ordinal) != null) {
                this.nonVisitedPostings.clear();
                for (PostingsEnum pe : this.nonVisitedOrds.values()) {
                    this.nonVisitedPostings.add(pe);
                }
            }
        }
    }
}

