/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.ESSloppyMath;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.xcontent.XContentParser;

public final class GeoTileUtils {
    private static final double PI_DIV_2 = 1.5707963267948966;
    private static final double PI_TIMES_2 = Math.PI * 2;
    private static final double PI_TIMES_4 = Math.PI * 4;
    private static final int MAX_TILES_FULL_PRECISION = 0x100000;
    static final double LUCENE_LAT_RES = 4.190951585769653E-8;
    public static final int MAX_ZOOM = 29;
    public static final double LATITUDE_MASK = 85.0511287798066;
    public static final int ENCODED_LATITUDE_MASK = GeoEncodingUtils.encodeLatitude(85.0511287798066);
    public static final int ENCODED_NEGATIVE_LATITUDE_MASK = GeoEncodingUtils.encodeLatitude(-85.0511287798066);
    public static final double NORMALIZED_LATITUDE_MASK = GeoEncodingUtils.decodeLatitude(ENCODED_LATITUDE_MASK);
    public static final double NORMALIZED_NEGATIVE_LATITUDE_MASK = GeoEncodingUtils.decodeLatitude(ENCODED_NEGATIVE_LATITUDE_MASK);
    private static final int ZOOM_SHIFT = 58;
    private static final long X_Y_VALUE_MASK = 0x1FFFFFFFL;

    private GeoTileUtils() {
    }

    static int parsePrecision(XContentParser parser) throws IOException, ElasticsearchParseException {
        Object node = parser.currentToken().equals((Object)XContentParser.Token.VALUE_NUMBER) ? Integer.valueOf(parser.intValue()) : parser.text();
        return XContentMapValues.nodeIntegerValue(node);
    }

    public static int checkPrecisionRange(int precision) {
        if (precision < 0 || precision > 29) {
            throw new IllegalArgumentException("Invalid geotile_grid precision of " + precision + ". Must be between 0 and 29.");
        }
        return precision;
    }

    public static int getXTile(double longitude, int tiles) {
        if (longitude == -180.0) {
            return 0;
        }
        double xTile = (GeoUtils.normalizeLon(longitude) + 180.0) / 360.0 * (double)tiles;
        return Math.max(0, Math.min(tiles - 1, (int)Math.floor(xTile)));
    }

    public static int getYTile(double latitude, int tiles) {
        double latSin = SloppyMath.cos(1.5707963267948966 - Math.toRadians(GeoUtils.normalizeLat(latitude)));
        double yTile = (0.5 - ESSloppyMath.log((1.0 + latSin) / (1.0 - latSin)) / (Math.PI * 4)) * (double)tiles;
        return Math.max(0, Math.min(tiles - 1, (int)Math.floor(yTile)));
    }

    public static long longEncode(double longitude, double latitude, int precision) {
        int tiles = 1 << GeoTileUtils.checkPrecisionRange(precision);
        return GeoTileUtils.longEncodeTiles(precision, GeoTileUtils.getXTile(longitude, tiles), GeoTileUtils.getYTile(latitude, tiles));
    }

    public static long longEncode(String hashAsString) {
        int[] parsed = GeoTileUtils.parseHash(hashAsString);
        return GeoTileUtils.longEncodeTiles(parsed[0], parsed[1], parsed[2]);
    }

    public static long longEncodeTiles(int precision, int xTile, int yTile) {
        return (long)precision << 58 | (long)xTile << 29 | (long)yTile;
    }

    private static int[] parseHash(long hash) {
        return new int[]{(int)(hash >>> 58), (int)(hash >>> 29 & 0x1FFFFFFFL), (int)(hash & 0x1FFFFFFFL)};
    }

    public static int[] parseHash(String hashAsString) {
        String[] parts = hashAsString.split("/", 4);
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid geotile_grid hash string of " + hashAsString + ". Must be three integers in a form \"zoom/x/y\".");
        }
        try {
            return new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])};
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid geotile_grid hash string of " + hashAsString + ". Must be three integers in a form \"zoom/x/y\".", e);
        }
    }

    public static String stringEncode(long hash) {
        int[] res = GeoTileUtils.parseHash(hash);
        GeoTileUtils.validateZXY(res[0], res[1], res[2]);
        return res[0] + "/" + res[1] + "/" + res[2];
    }

    static GeoPoint hashToGeoPoint(long hash) {
        int[] res = GeoTileUtils.parseHash(hash);
        return GeoTileUtils.zxyToGeoPoint(res[0], res[1], res[2]);
    }

    static GeoPoint keyToGeoPoint(String hashAsString) {
        int[] hashAsInts = GeoTileUtils.parseHash(hashAsString);
        return GeoTileUtils.zxyToGeoPoint(hashAsInts[0], hashAsInts[1], hashAsInts[2]);
    }

    public static Rectangle toBoundingBox(long hash) {
        int[] hashAsInts = GeoTileUtils.parseHash(hash);
        return GeoTileUtils.toBoundingBox(hashAsInts[1], hashAsInts[2], hashAsInts[0]);
    }

    public static Rectangle toBoundingBox(String hash) {
        int[] hashAsInts = GeoTileUtils.parseHash(hash);
        return GeoTileUtils.toBoundingBox(hashAsInts[1], hashAsInts[2], hashAsInts[0]);
    }

    public static Rectangle toBoundingBox(int xTile, int yTile, int precision) {
        int tiles = GeoTileUtils.validateZXY(precision, xTile, yTile);
        return new Rectangle(GeoTileUtils.tileToLon(xTile, tiles), GeoTileUtils.tileToLon(xTile + 1, tiles), GeoTileUtils.tileToLat(yTile, tiles), GeoTileUtils.tileToLat(yTile + 1, tiles));
    }

    public static double tileToLon(int xTile, int tiles) {
        return GeoTileUtils.tileToLon((double)xTile, (double)tiles);
    }

    private static double tileToLon(double xTile, double tiles) {
        return xTile / tiles * 360.0 - 180.0;
    }

    public static double tileToLat(int yTile, int tiles) {
        int computedYTile;
        double qLat;
        double lat = GeoTileUtils.tileToLat((double)yTile, tiles);
        if (tiles < 0x100000 || yTile == 0 || yTile == tiles) {
            return lat;
        }
        return GeoTileUtils.findBoundaryPoint(qLat, computedYTile, tiles, (computedYTile = GeoTileUtils.getYTile(qLat = GeoUtils.quantizeLat(lat), tiles)) == yTile ? 4.190951585769653E-8 : -4.190951585769653E-8);
    }

    private static double findBoundaryPoint(double qLat, int yTile, int tiles, double step) {
        double nextQLat = qLat + step;
        int nextYTile = GeoTileUtils.getYTile(nextQLat, tiles);
        if (yTile != nextYTile) {
            return step > 0.0 ? qLat : nextQLat;
        }
        return GeoTileUtils.findBoundaryPoint(nextQLat, nextYTile, tiles, step);
    }

    private static double tileToLat(double yTile, int tiles) {
        double n = Math.PI - Math.PI * 2 * yTile / (double)tiles;
        return Math.toDegrees(ESSloppyMath.atan(ESSloppyMath.sinh(n)));
    }

    private static int validateZXY(int zoom, int xTile, int yTile) {
        int tiles = 1 << GeoTileUtils.checkPrecisionRange(zoom);
        if (xTile < 0 || yTile < 0 || xTile >= tiles || yTile >= tiles) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Zoom/X/Y combination is not valid: %d/%d/%d", zoom, xTile, yTile));
        }
        return tiles;
    }

    private static GeoPoint zxyToGeoPoint(int zoom, int xTile, int yTile) {
        int tiles = GeoTileUtils.validateZXY(zoom, xTile, yTile);
        return new GeoPoint(GeoTileUtils.tileToLat((double)yTile + 0.5, tiles), GeoTileUtils.tileToLon((double)xTile + 0.5, (double)tiles));
    }
}

