/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;

public final class AggregatorsReducer
implements Releasable {
    private final Map<String, AggregatorReducer> aggByName = new HashMap<String, AggregatorReducer>();
    private final AggregationReduceContext context;
    private final int size;

    public AggregatorsReducer(AggregationReduceContext context, int size) {
        this.context = context;
        this.size = size;
    }

    public void accept(InternalAggregations aggregations) {
        for (InternalAggregation aggregation : aggregations) {
            AggregatorReducer reducer = this.aggByName.computeIfAbsent(aggregation.getName(), k -> aggregation.getReducer(this.context.forAgg(aggregation.getName()), this.size));
            reducer.accept(aggregation);
        }
    }

    public InternalAggregations get() {
        return InternalAggregations.from(this.aggByName.values().stream().map(AggregatorReducer::get).toList());
    }

    @Override
    public void close() {
        Releasables.close(this.aggByName.values());
    }
}

