/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import org.elasticsearch.script.mustache.MultiSearchTemplateResponse;
import org.elasticsearch.script.mustache.MustachePlugin;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.script.mustache.TransportSearchTemplateAction;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.usage.UsageService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class TransportMultiSearchTemplateAction
extends HandledTransportAction<MultiSearchTemplateRequest, MultiSearchTemplateResponse> {
    private static final Logger logger = LogManager.getLogger(TransportMultiSearchTemplateAction.class);
    private final ScriptService scriptService;
    private final NamedXContentRegistry xContentRegistry;
    private final Predicate<NodeFeature> clusterSupportsFeature;
    private final NodeClient client;
    private final SearchUsageHolder searchUsageHolder;

    @Inject
    public TransportMultiSearchTemplateAction(TransportService transportService, ActionFilters actionFilters, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NodeClient client, UsageService usageService, ClusterService clusterService, FeatureService featureService) {
        super(MustachePlugin.MULTI_SEARCH_TEMPLATE_ACTION.name(), transportService, actionFilters, MultiSearchTemplateRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.clusterSupportsFeature = f -> {
            ClusterState state = clusterService.state();
            return state.clusterRecovered() && featureService.clusterHasFeature(state, (NodeFeature)f);
        };
        this.client = client;
        this.searchUsageHolder = usageService.getSearchUsageHolder();
    }

    @Override
    protected void doExecute(Task task, MultiSearchTemplateRequest request, ActionListener<MultiSearchTemplateResponse> listener) {
        ArrayList<Integer> originalSlots = new ArrayList<Integer>();
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        multiSearchRequest.indicesOptions(request.indicesOptions());
        if (request.maxConcurrentSearchRequests() != 0) {
            multiSearchRequest.maxConcurrentSearchRequests(request.maxConcurrentSearchRequests());
        }
        MultiSearchTemplateResponse.Item[] items = new MultiSearchTemplateResponse.Item[request.requests().size()];
        for (int i = 0; i < items.length; ++i) {
            SearchRequest searchRequest;
            SearchTemplateRequest searchTemplateRequest = request.requests().get(i);
            SearchTemplateResponse searchTemplateResponse = new SearchTemplateResponse();
            try {
                searchRequest = TransportSearchTemplateAction.convert(searchTemplateRequest, searchTemplateResponse, this.scriptService, this.xContentRegistry, this.clusterSupportsFeature, this.searchUsageHolder);
            }
            catch (Exception e) {
                searchTemplateResponse.decRef();
                items[i] = new MultiSearchTemplateResponse.Item(null, e);
                if (ExceptionsHelper.status(e).getStatus() < 500 || ExceptionsHelper.isNodeOrShardUnavailableTypeException(e)) continue;
                logger.warn("MultiSearchTemplate convert failure", (Throwable)e);
                continue;
            }
            items[i] = new MultiSearchTemplateResponse.Item(searchTemplateResponse, null);
            if (searchRequest == null) continue;
            multiSearchRequest.add(searchRequest);
            originalSlots.add(i);
        }
        this.client.multiSearch(multiSearchRequest, listener.delegateFailureAndWrap((l, r) -> {
            for (int i = 0; i < r.getResponses().length; ++i) {
                MultiSearchResponse.Item item = r.getResponses()[i];
                int originalSlot = (Integer)originalSlots.get(i);
                if (item.isFailure()) {
                    MultiSearchTemplateResponse.Item existing = items[originalSlot];
                    if (existing.getResponse() != null) {
                        existing.getResponse().decRef();
                    }
                    items[originalSlot] = new MultiSearchTemplateResponse.Item(null, item.getFailure());
                    continue;
                }
                items[originalSlot].getResponse().setResponse(item.getResponse());
                item.getResponse().incRef();
            }
            ActionListener.respondAndRelease(l, new MultiSearchTemplateResponse(items, r.getTook().millis()));
        }));
    }
}

