/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public abstract class RestResizeHandler
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestResizeHandler.class);

    RestResizeHandler() {
    }

    @Override
    public abstract String getName();

    abstract ResizeType getResizeType();

    @Override
    public final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.getRestApiVersion() == RestApiVersion.V_7 && request.hasParam("copy_settings")) {
            deprecationLogger.compatibleCritical("copy_settings", "parameter [copy_settings] is deprecated and will be removed in 8.0.0", new Object[0]);
            String rawCopySettings = request.param("copy_settings");
            boolean copySettings = Booleans.parseBoolean(rawCopySettings);
            if (!copySettings) {
                throw new IllegalArgumentException("parameter [copy_settings] can not be explicitly set to [false]");
            }
        }
        ResizeRequest resizeRequest = new ResizeRequest(request.param("target"), request.param("index"));
        resizeRequest.setResizeType(this.getResizeType());
        request.applyContentParser(resizeRequest::fromXContent);
        resizeRequest.timeout(request.paramAsTime("timeout", resizeRequest.timeout()));
        resizeRequest.masterNodeTimeout(request.paramAsTime("master_timeout", resizeRequest.masterNodeTimeout()));
        resizeRequest.setWaitForActiveShards(ActiveShardCount.parseString(request.param("wait_for_active_shards")));
        return channel -> client.admin().indices().resizeIndex(resizeRequest, new RestToXContentListener<CreateIndexResponse>((RestChannel)channel));
    }

    public static class RestCloneIndexAction
    extends RestResizeHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_clone/{target}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_clone/{target}"));
        }

        @Override
        public String getName() {
            return "clone_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.CLONE;
        }
    }

    public static class RestSplitIndexAction
    extends RestResizeHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_split/{target}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_split/{target}"));
        }

        @Override
        public String getName() {
            return "split_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.SPLIT;
        }
    }

    public static class RestShrinkIndexAction
    extends RestResizeHandler {
        @Override
        public List<RestHandler.Route> routes() {
            return List.of(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_shrink/{target}"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_shrink/{target}"));
        }

        @Override
        public String getName() {
            return "shrink_index_action";
        }

        @Override
        protected ResizeType getResizeType() {
            return ResizeType.SHRINK;
        }
    }
}

